/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.openapi.impl.jaxrs2;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.openapi.impl.core.util.AnnotationsUtils;
import com.ibm.ws.microprofile.openapi.impl.model.media.ContentImpl;
import com.ibm.ws.microprofile.openapi.impl.model.media.MediaTypeImpl;
import com.ibm.ws.microprofile.openapi.impl.model.parameters.RequestBodyImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.microprofile.openapi.annotations.media.Encoding;
import org.eclipse.microprofile.openapi.annotations.media.ExampleObject;
import org.eclipse.microprofile.openapi.annotations.parameters.RequestBody;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.examples.Example;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OperationParser {
    static final long serialVersionUID = -2285650994751933404L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static Optional<org.eclipse.microprofile.openapi.models.parameters.RequestBody> getRequestBody(RequestBody requestBody, Consumes classConsumes, Consumes methodConsumes, Components components) {
        if (requestBody == null) {
            return Optional.empty();
        }
        RequestBodyImpl requestBodyObject = new RequestBodyImpl();
        boolean isEmpty = true;
        if (StringUtils.isNotBlank((CharSequence)requestBody.ref())) {
            requestBodyObject.setRef(requestBody.ref());
            isEmpty = false;
        }
        if (StringUtils.isNotBlank((CharSequence)requestBody.description())) {
            requestBodyObject.setDescription(requestBody.description());
            isEmpty = false;
        }
        if (requestBody.required()) {
            requestBodyObject.setRequired(Boolean.valueOf(requestBody.required()));
            isEmpty = false;
        }
        if (isEmpty) {
            return Optional.empty();
        }
        OperationParser.getContent(requestBody.content(), classConsumes == null ? new String[]{} : classConsumes.value(), methodConsumes == null ? new String[]{} : methodConsumes.value(), components).ifPresent(arg_0 -> ((org.eclipse.microprofile.openapi.models.parameters.RequestBody)requestBodyObject).setContent(arg_0));
        return Optional.of(requestBodyObject);
    }

    public static Optional<APIResponses> getApiResponses(APIResponse[] responses, Produces classProduces, Produces methodProduces, Components components) {
        return AnnotationsUtils.getApiResponses(responses, classProduces, methodProduces, components, true);
    }

    @FFDCIgnore(value={SecurityException.class, NoSuchMethodException.class})
    public static Optional<Content> getContent(org.eclipse.microprofile.openapi.annotations.media.Content[] annotationContents, String[] classTypes, String[] methodTypes, Components components) {
        if (annotationContents == null) {
            return Optional.empty();
        }
        ContentImpl content = new ContentImpl();
        for (org.eclipse.microprofile.openapi.annotations.media.Content annotationContent : annotationContents) {
            Encoding[] encodings;
            ExampleObject[] examples;
            MediaTypeImpl mediaType = new MediaTypeImpl();
            OperationParser.getSchema(annotationContent, components).ifPresent(arg_0 -> ((MediaType)mediaType).setSchema(arg_0));
            for (ExampleObject example : examples = annotationContent.examples()) {
                AnnotationsUtils.getExample(example).ifPresent(arg_0 -> OperationParser.lambda$getContent$0((MediaType)mediaType, example, arg_0));
            }
            Method getExampleMethod = null;
            try {
                getExampleMethod = annotationContent.getClass().getMethod("example", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (getExampleMethod != null) {
                try {
                    String example = (String)getExampleMethod.invoke((Object)annotationContent, new Object[0]);
                    if (example != null && !example.isEmpty()) {
                        mediaType.example((Object)example);
                    }
                }
                catch (IllegalAccessException example) {
                    FFDCFilter.processException((Throwable)example, (String)"com.ibm.ws.microprofile.openapi.impl.jaxrs2.OperationParser", (String)"101", null, (Object[])new Object[]{annotationContents, classTypes, methodTypes, components});
                }
                catch (IllegalArgumentException example) {
                    FFDCFilter.processException((Throwable)example, (String)"com.ibm.ws.microprofile.openapi.impl.jaxrs2.OperationParser", (String)"102", null, (Object[])new Object[]{annotationContents, classTypes, methodTypes, components});
                }
                catch (InvocationTargetException example) {
                    FFDCFilter.processException((Throwable)example, (String)"com.ibm.ws.microprofile.openapi.impl.jaxrs2.OperationParser", (String)"103", null, (Object[])new Object[]{annotationContents, classTypes, methodTypes, components});
                }
            }
            for (Encoding encoding : encodings = annotationContent.encoding()) {
                AnnotationsUtils.addEncodingToMediaType((MediaType)mediaType, encoding);
            }
            if (StringUtils.isNotBlank((CharSequence)annotationContent.mediaType())) {
                content.addMediaType(annotationContent.mediaType(), (MediaType)mediaType);
                continue;
            }
            AnnotationsUtils.applyTypes(classTypes, methodTypes, (Content)content, (MediaType)mediaType);
        }
        if (content.size() == 0) {
            return Optional.empty();
        }
        return Optional.of(content);
    }

    public static Optional<? extends Schema> getSchema(org.eclipse.microprofile.openapi.annotations.media.Content annotationContent, Components components) {
        return AnnotationsUtils.getSchema(annotationContent.schema(), components);
    }

    private static /* synthetic */ void lambda$getContent$0(MediaType mediaType, ExampleObject example, Example exampleObject) {
        mediaType.addExample(AnnotationsUtils.getNameOfReferenceableItem(example), exampleObject);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.openapi.impl.jaxrs2.OperationParser", OperationParser.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    }
}

