/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ui.internal.rest.v1;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.common.internal.encoder.Base64Coder;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ui.internal.rest.AdminCenterRestHandler;
import com.ibm.ws.ui.internal.rest.CommonJSONRESTHandler;
import com.ibm.ws.ui.internal.rest.exceptions.RESTException;
import com.ibm.ws.ui.internal.rest.v1.V1Constants;
import com.ibm.ws.ui.internal.v1.pojo.DeployToolConfig;
import com.ibm.ws.ui.internal.v1.pojo.DeployToolSummary;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class DeployValidation
extends CommonJSONRESTHandler
implements V1Constants {
    private static final TraceComponent tc = Tr.register(DeployValidation.class);

    public DeployValidation() {
        super("/adminCenter/v1/deployValidation", true, true);
    }

    @Trivial
    private String getUserId(RESTRequest request) {
        return request.getUserPrincipal().getName();
    }

    @Override
    @FFDCIgnore(value={IOException.class})
    public AdminCenterRestHandler.POSTResponse postBase(final RESTRequest request, RESTResponse response) throws RESTException {
        DeployToolConfig deployToolToValidate = this.readJSONPayload(request, DeployToolConfig.class);
        String passwordValidation = "unknown";
        String uid = this.getUserId(request);
        URLConnection conn = null;
        try {
            URL url = AccessController.doPrivileged(new PrivilegedAction<URL>(){

                @Override
                public URL run() {
                    URL url;
                    block2: {
                        String fullURI = request.getCompleteURL();
                        url = null;
                        try {
                            url = new URL(fullURI.substring(0, fullURI.indexOf(request.getURI())) + "/ibm" + "/adminCenter" + "/deploy-1.0/feature");
                        }
                        catch (MalformedURLException mue) {
                            if (!tc.isDebugEnabled()) break block2;
                            Tr.debug((TraceComponent)tc, (String)("Unexpected MalformedURLException: " + mue), (Object[])new Object[0]);
                        }
                    }
                    return url;
                }
            });
            if (url != null) {
                conn = url.openConnection();
                String uidPwd = uid + ":" + deployToolToValidate.getPassword();
                conn.setRequestProperty("Authorization", "Basic " + Base64Coder.base64Encode((String)uidPwd));
                conn.connect();
                conn.getInputStream();
                passwordValidation = "valid";
            }
        }
        catch (IOException ioe) {
            String msg;
            if (ioe.getCause() instanceof ClassNotFoundException && (msg = ioe.getCause().getMessage()).indexOf("com.ibm.websphere.ssl.protocol.SSLSocketFactory") > -1) {
                Tr.error((TraceComponent)tc, (String)"UNSUPPORTED_SSL_SOCKET_FACTORY", (Object[])new Object[]{ioe});
            }
            try {
                if (conn != null && conn instanceof HttpURLConnection) {
                    HttpURLConnection httpURLConnection = (HttpURLConnection)conn;
                    if (httpURLConnection.getResponseCode() == 401) {
                        passwordValidation = "invalid";
                    }
                } else {
                    Tr.error((TraceComponent)tc, (String)"PASSWORD_VALIDATION_EXCEPTION", (Object[])new Object[]{ioe});
                }
            }
            catch (IOException e) {
                Tr.error((TraceComponent)tc, (String)"PASSWORD_VALIDATION_EXCEPTION", (Object[])new Object[]{ioe});
            }
        }
        DeployToolSummary deployValidationSummary = new DeployToolSummary(passwordValidation);
        AdminCenterRestHandler.POSTResponse postResponse = new AdminCenterRestHandler.POSTResponse();
        postResponse.jsonPayload = deployValidationSummary;
        return postResponse;
    }
}

