/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ui.internal.v1.utils;

import org.osgi.framework.Version;

public class SortedBundle
implements Comparable<SortedBundle> {
    private final String symbolicName;
    private final Version version;
    private final String webContextPath;
    private final String primaryEndpointFeatureName;

    public SortedBundle(String symbolicName, Version version, String webContextPath, String primaryEndpointFeatureName) {
        this.symbolicName = symbolicName;
        this.version = version;
        this.webContextPath = webContextPath;
        this.primaryEndpointFeatureName = primaryEndpointFeatureName;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public Version getVersion() {
        return this.version;
    }

    public String getWebContextPath() {
        return this.webContextPath;
    }

    public boolean isUIEndpoint() {
        return this.primaryEndpointFeatureName != null;
    }

    public String getPrimaryEndpointFeatureName() {
        return this.primaryEndpointFeatureName;
    }

    @Override
    public int compareTo(SortedBundle bundleToCompare) {
        int result = this.symbolicName.compareToIgnoreCase(bundleToCompare.getSymbolicName());
        if (result == 0) {
            result = this.version.compareTo(bundleToCompare.version);
        }
        return result;
    }

    public String toString() {
        return "SymbolicName: " + this.symbolicName + " Version: " + this.version + " WebContextPath: " + this.webContextPath + " PrimaryEndpointFeatureName: " + this.primaryEndpointFeatureName;
    }

    public boolean equals(Object obj) {
        boolean result = obj == null ? false : (obj == this ? true : (obj instanceof SortedBundle ? this.compareTo((SortedBundle)obj) == 0 : false));
        return result;
    }

    public int hashCode() {
        int result = 19;
        result = 31 * result + new Integer(this.symbolicName);
        result = 31 * result + new Integer(this.version.toString());
        result = 31 * result + new Integer(this.webContextPath);
        result = 31 * (this.primaryEndpointFeatureName == null ? 3 : new Integer(this.primaryEndpointFeatureName));
        return result;
    }
}

