/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.graphql.metrics.component;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.metrics.cdi23.producer.MetricRegistryFactory;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.smallrye.graphql.api.Context;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.spi.EventingService;
import java.time.Duration;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MetricsService
implements EventingService {
    private static final String PRE = "mp_graphql_";
    private static final String UNDERSCORE = "_";
    private final MetricRegistry metricRegistry = MetricRegistryFactory.getVendorRegistry();
    private final Map<Context, Long> startTimes = Collections.synchronizedMap(new IdentityHashMap());
    static final long serialVersionUID = -4103847356720668141L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public Operation createOperation(Operation operation) {
        String name = this.getName(operation);
        String description = this.getDescription(operation);
        Metadata metadata = Metadata.builder().withName(name).withType(MetricType.SIMPLE_TIMER).withDescription(description).build();
        this.metricRegistry.simpleTimer(metadata);
        return operation;
    }

    public void beforeDataFetch(Context context) {
        this.startTimes.put(context, System.nanoTime());
    }

    public void afterDataFetch(Context context) {
        Long startTime = this.startTimes.remove(context);
        if (startTime != null) {
            long duration = System.nanoTime() - startTime;
            this.metricRegistry.simpleTimer(this.getName(context)).update(Duration.ofNanos(duration));
        }
    }

    public String getConfigKey() {
        return "smallrye.graphql.metrics.enabled";
    }

    private String getName(Context context) {
        return PRE + context.getOperationType().toString() + UNDERSCORE + context.getFieldName();
    }

    private String getName(Operation operation) {
        return PRE + operation.getOperationType().toString() + UNDERSCORE + operation.getName();
    }

    private String getDescription(Operation operation) {
        return "Call statistics for the " + operation.getOperationType().toString().toLowerCase() + " '" + operation.getName() + "'";
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.graphql.metrics.component.MetricsService", MetricsService.class, (String)"GraphQL", null);
    }
}

