/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.utils;

import com.ibm.websphere.logging.WsLevel;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class LogFormatUtils {
    static final String ENTRY = "Entry ";
    static final String EXIT = "Exit ";

    public static String mapLevelToType(LogRecord logRecord) {
        String message;
        Level level = logRecord.getLevel();
        if (level == null) {
            return "Z";
        }
        if (level.getName() == "SystemErr") {
            return "R";
        }
        if (level.getName() == "SystemOut") {
            return "O";
        }
        LevelFormat f = LevelFormat.findFormat(level);
        if (f == null) {
            return "Z";
        }
        if (f.level == Level.FINER && (message = logRecord.getMessage()) != null) {
            if (message.equals(ENTRY) || message.startsWith("ENTRY")) {
                return ">";
            }
            if (message.equals(EXIT) || message.startsWith("RETURN")) {
                return "<";
            }
        }
        return f.marker;
    }

    public static String mapLevelToRawType(LogRecord logRecord) {
        String message;
        Level level = logRecord.getLevel();
        if (level == null) {
            return "***";
        }
        LevelFormat f = LevelFormat.findFormat(level);
        if (f == null) {
            return "***";
        }
        if (f.level == Level.FINER && (message = logRecord.getMessage()) != null) {
            if (message.equals(ENTRY) || message.startsWith("ENTRY")) {
                return "ENTRY";
            }
            if (message.equals(EXIT) || message.startsWith("RETURN")) {
                return "EXIT";
            }
        }
        return level.getName();
    }

    static enum LevelFormat {
        FATAL(WsLevel.FATAL, "F"),
        ERROR(WsLevel.ERROR, "E"),
        WARNING(Level.WARNING, "W"),
        AUDIT(WsLevel.AUDIT, "A"),
        INFO(Level.INFO, "I"),
        CONFIG(Level.CONFIG, "C"),
        DETAIL(WsLevel.DETAIL, "D"),
        EVENT(WsLevel.FINE, "1"),
        FINE(Level.FINE, "1"),
        FINER(Level.FINER, "2"),
        FINEST(Level.FINEST, "3");

        final Level level;
        final int id;
        final String marker;

        private LevelFormat(Level l, String s) {
            this.level = l;
            this.id = l.intValue();
            this.marker = s;
        }

        public static LevelFormat findFormat(Level level) {
            int levelId = level.intValue();
            for (LevelFormat f : LevelFormat.values()) {
                if (level == f.level) {
                    return f;
                }
                if (levelId != f.id) continue;
                return f;
            }
            return null;
        }
    }
}

