/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.messaging.security.beans;

import com.ibm.ws.messaging.security.beans.Permission;
import java.util.HashSet;
import java.util.Set;

public class TemporaryDestinationPermission
extends Permission {
    String prefix = null;

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public void addUserAndGroupsToRole(String[] actionArray, Set<String> users, Set<String> groups) {
        if (this.checkActionArrayHasAllPermission(actionArray)) {
            this.addUsersAndGroupsToAllActions(users, groups);
        } else {
            for (String action : actionArray) {
                if (!this.validateAction(action)) continue;
                if (action.equals("ALL")) {
                    this.addUsersAndGroupsToAllActions(users, groups);
                    continue;
                }
                action = action.trim().toUpperCase();
                HashSet<String> tempUsers = new HashSet<String>();
                HashSet<String> tempGroups = new HashSet<String>();
                tempUsers.addAll(users);
                tempGroups.addAll(groups);
                this.addAllUsersToRole(tempUsers, action);
                this.addAllGroupsToRole(tempGroups, action);
            }
        }
    }

    @Override
    public boolean validateAction(String action) {
        boolean result = false;
        if (action.equals("SEND") || action.equals("RECEIVE") || action.equals("CREATE")) {
            result = true;
        }
        return result;
    }

    @Override
    public void addUsersAndGroupsToAllActions(Set<String> users, Set<String> groups) {
        HashSet<String> tempUsers = new HashSet<String>();
        HashSet<String> tempGroups = new HashSet<String>();
        tempUsers.addAll(users);
        tempGroups.addAll(groups);
        this.addAllUsersToRole(tempUsers, "SEND");
        this.addAllGroupsToRole(tempGroups, "SEND");
        this.addAllUsersToRole(tempUsers, "RECEIVE");
        this.addAllGroupsToRole(tempGroups, "RECEIVE");
        this.addAllUsersToRole(tempUsers, "CREATE");
        this.addAllGroupsToRole(tempGroups, "CREATE");
    }
}

