/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jca.utils.metagen.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jca.utils.metagen.internal.MetaGenInstance;
import com.ibm.ws.jca.utils.xml.ra.RaConnector;
import com.ibm.ws.jca.utils.xml.wlp.ra.WlpIbmuiGroups;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MetaGenConfig {
    private final Map<String, Object> configProps;
    private GenerationMode genMode;
    private String adapterName;
    private String rarPath;
    private String raXmlPath;
    private String wlpRaXmlPath;
    private MetaGenInstance instance;
    private File nlsInputFile;
    private File nlsOutputFile;
    private File metatypeInputFile;
    private File metatypeOutputFile;
    private IbmuiGroupScope ibmuiGroupScope;
    private WlpIbmuiGroups ibmuiGroups;
    private boolean translate = true;
    private boolean useAnnotations = false;
    private ClassLoader rarClassLoader;
    private Container rarContainer;
    private RaConnector raConnector;
    private boolean runtime = false;
    private String moduleName;
    static final long serialVersionUID = -6227620967597469173L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    /*
     * WARNING - void declaration
     */
    public MetaGenConfig(Map<String, Object> configProps) throws FileNotFoundException {
        this.configProps = configProps;
        try {
            Object rarContainer;
            Object raConnector;
            Object useAnnos;
            this.setMetatypeFiles((String)configProps.get("metatype.input.path"), (String)configProps.get("metatype.output.path"));
            this.setGenerationMode((String)configProps.get("mode"));
            this.adapterName = (String)configProps.get("adapter.name");
            this.setNLSFiles((String)configProps.get("nls.input.file"), (String)configProps.get("nls.output.file"));
            Object translate = configProps.get("translate");
            if (translate != null) {
                if (translate instanceof Boolean) {
                    this.translate = (Boolean)translate;
                } else if (translate instanceof String) {
                    this.translate = Boolean.parseBoolean((String)translate);
                }
            }
            if ((useAnnos = configProps.get("use.annotations")) != null) {
                if (useAnnos instanceof Boolean) {
                    this.useAnnotations = (Boolean)useAnnos;
                } else if (useAnnos instanceof String) {
                    this.useAnnotations = Boolean.parseBoolean((String)useAnnos);
                }
            }
            if ((raConnector = configProps.get("rar.dd")) != null) {
                if (raConnector instanceof RaConnector) {
                    this.raConnector = (RaConnector)raConnector;
                    this.runtime = true;
                }
            } else if (this.useAnnotations) {
                this.runtime = true;
            }
            if (this.genMode == GenerationMode.ExplicitMode) {
                this.raXmlPath = (String)configProps.get("ra.xml.path");
                this.wlpRaXmlPath = (String)configProps.get("wlp.ra.xml.path");
            } else if (this.genMode == GenerationMode.RarMode && !this.runtime) {
                this.rarPath = (String)configProps.get("rar.path");
            }
            Object rarCL = configProps.get("rar.classloader");
            if (rarCL != null && rarCL instanceof ClassLoader) {
                this.rarClassLoader = (ClassLoader)rarCL;
            }
            if ((rarContainer = configProps.get("rar.container")) != null && rarContainer instanceof Container) {
                this.rarContainer = (Container)rarContainer;
            }
            this.moduleName = (String)configProps.get("module.name");
            if (this.useAnnotations && this.genMode == GenerationMode.ExplicitMode) {
                throw new IllegalArgumentException("Annotation processing of resource adapters is only available when metatype generation mode is RAR.");
            }
            if (this.genMode == GenerationMode.ExplicitMode) {
                this.instance = new MetaGenInstance(this.adapterName, this.raXmlPath, this.wlpRaXmlPath);
            } else if (this.genMode == GenerationMode.RarMode) {
                this.instance = this.runtime ? new MetaGenInstance(this.adapterName, this.raConnector, this.moduleName) : new MetaGenInstance(this.adapterName, this.rarPath);
            }
        }
        catch (Throwable translate) {
            void e;
            FFDCFilter.processException((Throwable)translate, (String)"com.ibm.ws.jca.utils.metagen.internal.MetaGenConfig", (String)"129", (Object)this, (Object[])new Object[]{configProps});
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new RuntimeException((Throwable)e);
        }
    }

    public <T> T get(String key, T defaultValue) {
        Object value = this.configProps.get(key);
        return (T)(value == null ? defaultValue : value);
    }

    public Container getRarContainer() {
        return this.rarContainer;
    }

    public ClassLoader getRarClassLoader() {
        return this.rarClassLoader;
    }

    public boolean useAnnotations() {
        return this.useAnnotations;
    }

    public boolean isRuntime() {
        return this.runtime;
    }

    public boolean doTranslate() {
        return this.translate;
    }

    public void setIbmuiGroups(WlpIbmuiGroups ibmuiGroups) {
        if (this.ibmuiGroups == null) {
            this.ibmuiGroups = ibmuiGroups;
            String scope = ibmuiGroups.getScope();
            if (scope != null) {
                if (this.ibmuiGroupScope == null) {
                    if (scope.equalsIgnoreCase("global")) {
                        this.ibmuiGroupScope = IbmuiGroupScope.Global;
                    } else if (scope.equalsIgnoreCase("ocd")) {
                        this.ibmuiGroupScope = IbmuiGroupScope.Ocd;
                    }
                } else if (scope.equalsIgnoreCase("global") && this.ibmuiGroupScope == IbmuiGroupScope.Ocd) {
                    this.ibmuiGroupScope = IbmuiGroupScope.Global;
                }
            }
        }
    }

    public WlpIbmuiGroups getIbmuiGroups() {
        return this.ibmuiGroups;
    }

    public boolean isIbmuiGroupScopeGlobal() {
        if (this.ibmuiGroupScope == null) {
            return true;
        }
        return this.ibmuiGroupScope == IbmuiGroupScope.Global;
    }

    public boolean isIbmuiGroupScopeOcd() {
        if (this.ibmuiGroupScope == null) {
            return false;
        }
        return this.ibmuiGroupScope == IbmuiGroupScope.Ocd;
    }

    public MetaGenInstance getInstance() {
        return this.instance;
    }

    private void setGenerationMode(String mode) {
        if (mode == null || (mode = mode.trim()).isEmpty()) {
            throw new IllegalArgumentException("The metatype generator configuration property mode was not set or is empty.");
        }
        if ((mode = mode.toLowerCase()).equals("explicit")) {
            this.genMode = GenerationMode.ExplicitMode;
        } else if (mode.equals("rar")) {
            this.genMode = GenerationMode.RarMode;
        } else {
            throw new IllegalArgumentException("Invalid metatype generation mode: " + mode);
        }
    }

    public GenerationMode getGenerationMode() {
        return this.genMode;
    }

    private void setMetatypeFiles(String inputPath, String outputPath) {
        if (inputPath != null && !(inputPath = inputPath.trim()).isEmpty() && inputPath.endsWith("metatype.xml")) {
            this.metatypeInputFile = new File(inputPath);
        }
        if (outputPath != null) {
            this.metatypeOutputFile = outputPath.endsWith("metatype.xml") ? new File(outputPath) : new File(outputPath + File.separatorChar + "metatype.xml");
        }
    }

    public File getMetatypeOutputFile() {
        return this.metatypeOutputFile;
    }

    public File getMetatypeInputFile() {
        return this.metatypeInputFile;
    }

    private void setNLSFiles(String inputPath, String outputPath) {
        boolean outputRequired = false;
        if (inputPath != null && !(inputPath = inputPath.trim()).isEmpty()) {
            outputRequired = true;
            if (inputPath.endsWith("metatype.properties")) {
                this.nlsInputFile = new File(inputPath);
            } else {
                throw new IllegalArgumentException("Invalid translation file path: " + inputPath);
            }
        }
        if (outputPath == null || (outputPath = outputPath.trim()).isEmpty()) {
            if (outputRequired) {
                throw new IllegalArgumentException("The output translation file path is missing.");
            }
        } else if (outputPath.endsWith("metatype.properties")) {
            this.nlsOutputFile = new File(outputPath);
        } else {
            throw new IllegalArgumentException("Invalid translation file path: " + outputPath);
        }
    }

    public File getNLSInputFile() {
        return this.nlsInputFile;
    }

    public File getNLSOutputFile() {
        return this.nlsOutputFile;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MetaGenConfig{");
        if (this.adapterName != null) {
            sb.append("adapterName='").append(this.adapterName).append("' ");
        }
        if (this.rarPath != null) {
            sb.append("rarPath='").append(this.rarPath).append("' ");
        }
        if (this.raXmlPath != null) {
            sb.append("raXmlPath='").append(this.raXmlPath).append("' ");
        }
        if (this.wlpRaXmlPath != null) {
            sb.append("wlpRaXmlPath='").append(this.wlpRaXmlPath).append("' ");
        }
        if (this.metatypeInputFile != null) {
            sb.append("metatypeInputFile='").append(this.metatypeInputFile.getAbsolutePath()).append("' ");
        }
        if (this.metatypeOutputFile != null) {
            sb.append("metatypeOutputFile='").append(this.metatypeOutputFile.getAbsolutePath()).append("' ");
        }
        if (this.nlsInputFile != null) {
            sb.append("nlsInputFile='").append(this.nlsInputFile.getAbsolutePath()).append("' ");
        }
        sb.append("genMode='").append((Object)this.genMode).append("' ");
        sb.append("translate='").append(this.translate).append("' ");
        sb.append("useAnnotations='").append(this.useAnnotations).append("' ");
        if (this.rarClassLoader != null) {
            sb.append("rarClassLoader='").append(this.rarClassLoader).append("' ");
        }
        if (this.rarContainer != null) {
            sb.append("rarContainer='").append(this.rarContainer).append("' ");
        }
        sb.append('}');
        return sb.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.jca.utils.metagen.internal.MetaGenConfig", MetaGenConfig.class, (String)"rarInstall", (String)"com.ibm.ws.jca.utils.internal.resources.JcaUtilsMessages");
    }

    @Trivial
    public static enum IbmuiGroupScope {
        Global,
        Ocd;

    }

    @Trivial
    public static enum GenerationMode {
        ExplicitMode,
        RarMode;

    }
}

