/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jca.utils.xml.ra;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.jca.utils.xml.ra.RaConfigProperty;
import com.ibm.ws.jca.utils.xml.wlp.ra.WlpRaAdminObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@Trivial
@XmlType(propOrder={"adminObjectInterface", "adminObjectClass", "configProperties"})
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class RaAdminObject {
    private static final TraceComponent tc = Tr.register(RaAdminObject.class, (String)"rarInstall", (String)"com.ibm.ws.jca.utils.internal.resources.JcaUtilsMessages");
    public static final HashMap<String, String> parentPids = new HashMap();
    private String adminObjectInterface;
    private String adminObjectClass;
    @XmlElement(name="config-property")
    private final List<RaConfigProperty> configProperties = new LinkedList<RaConfigProperty>();
    @XmlID
    @XmlAttribute(name="id")
    private String id;
    @XmlTransient
    private String wlp_aliasSuffix;
    @XmlTransient
    private String wlp_adminObjectInterface;
    @XmlTransient
    private String wlp_adminObjectClass;
    @XmlTransient
    private String wlp_nlsKey;
    @XmlTransient
    private String wlp_name;
    @XmlTransient
    private String wlp_description;
    @XmlTransient
    private List<Class<?>> ann_adminObjectInterfaces;
    static final long serialVersionUID = -457329579263612553L;

    public String getName() {
        return this.wlp_name;
    }

    public String getDescription() {
        return this.wlp_description;
    }

    public String getNLSKey() {
        return this.wlp_nlsKey;
    }

    public String getAliasSuffix() {
        return this.wlp_aliasSuffix;
    }

    @XmlElement(name="adminobject-interface", required=true)
    public void setAdminObjectInterface(String adminObjectInterface) {
        this.adminObjectInterface = adminObjectInterface;
    }

    public void setAnnAdminObjectInterfaces(List<Class<?>> interfaces) {
        this.ann_adminObjectInterfaces = interfaces;
    }

    public String getAdminObjectInterface() {
        return this.adminObjectInterface != null ? this.adminObjectInterface : this.wlp_adminObjectInterface;
    }

    public List<Class<?>> getImplementedAdminObjectInterfaces() {
        return this.ann_adminObjectInterfaces;
    }

    public String getMetaAdminObjectInterface() {
        if (this.adminObjectInterface != null) {
            return this.adminObjectInterface;
        }
        if (this.ann_adminObjectInterfaces.isEmpty()) {
            throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"J2CA9925.admobj.interface.missing", (Object[])new Object[]{this.getAdminObjectClass()}));
        }
        if (this.ann_adminObjectInterfaces.size() > 1) {
            throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"J2CA9926.admobj.multiple.interfaces", (Object[])new Object[]{this.getAdminObjectClass()}));
        }
        return this.ann_adminObjectInterfaces.get(0).getName();
    }

    @XmlElement(name="adminobject-class", required=true)
    public void setAdminObjectClass(String adminObjectClass) {
        this.adminObjectClass = adminObjectClass;
    }

    public String getAdminObjectClass() {
        return this.adminObjectClass != null ? this.adminObjectClass : this.wlp_adminObjectClass;
    }

    public List<RaConfigProperty> getConfigProperties() {
        return this.configProperties;
    }

    public String getId() {
        return this.id;
    }

    public RaConfigProperty getConfigPropertyById(String name) {
        for (RaConfigProperty configProperty : this.configProperties) {
            if (!configProperty.getName().equals(name)) continue;
            return configProperty;
        }
        return null;
    }

    public boolean isConfigPropertyAlreadyDefined(String configPropName) {
        RaConfigProperty configProperty = this.getConfigPropertyById(configPropName);
        if (configProperty == null) {
            return false;
        }
        return configProperty.getType() != null;
    }

    public String getParentPid() {
        String parentPid = parentPids.get(this.adminObjectInterface);
        if (parentPid != null) {
            return parentPid;
        }
        return parentPids.get(null);
    }

    public void copyWlpSettings(WlpRaAdminObject adminObject) {
        this.wlp_aliasSuffix = adminObject.getAliasSuffix();
        this.wlp_nlsKey = adminObject.getNLSKey();
        this.wlp_name = adminObject.getName();
        this.wlp_description = adminObject.getDescription();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RaAdminObject{");
        sb.append("adminobject-interface='").append(this.adminObjectInterface);
        sb.append("' adminobject-class='").append(this.adminObjectClass);
        sb.append("'}");
        return sb.toString();
    }

    public boolean useSpecializedConfig() {
        return parentPids.get(this.adminObjectInterface) != null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        parentPids.put("javax.jms.Destination", "com.ibm.ws.jca.jmsDestination");
        parentPids.put("javax.jms.Topic", "com.ibm.ws.jca.jmsTopic");
        parentPids.put("javax.jms.Queue", "com.ibm.ws.jca.jmsQueue");
        parentPids.put(null, "com.ibm.ws.jca.adminObject");
    }
}

