/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml2.binding.decoding.HTTPPostDecoder;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.ws.transport.http.HTTPInTransport;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class Saml20HTTPPostDecoder
extends HTTPPostDecoder {
    private static TraceComponent tc = Tr.register(Saml20HTTPPostDecoder.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    String acsUrl;
    static final long serialVersionUID = -9033482546463186504L;

    public Saml20HTTPPostDecoder(String acsUrl) {
        this.acsUrl = acsUrl;
    }

    protected String getActualReceiverEndpointURI(SAMLMessageContext messageContext) throws MessageDecodingException {
        return this.acsUrl;
    }

    /*
     * WARNING - void declaration
     */
    protected InputStream getBase64DecodedMessage(HTTPInTransport transport) throws MessageDecodingException {
        InputStream inputStream = super.getBase64DecodedMessage(transport);
        if (tc.isDebugEnabled() && inputStream instanceof ByteArrayInputStream) {
            ByteArrayInputStream byteStream = (ByteArrayInputStream)inputStream;
            int iAvailable = byteStream.available();
            if (iAvailable > 0) {
                byte[] bytes = new byte[iAvailable];
                byteStream.read(bytes, 0, iAvailable);
                byteStream.reset();
                try {
                    Tr.debug((TraceComponent)tc, (String)("decoded saml response:" + new String(bytes, "UTF-8")), (Object[])new Object[0]);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    void e;
                    FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.security.saml.impl.Saml20HTTPPostDecoder", (String)"62", (Object)((Object)this), (Object[])new Object[]{transport});
                    Tr.debug((TraceComponent)tc, (String)("decoded saml response failed to converted to a String:" + e), (Object[])new Object[0]);
                }
            } else {
                Tr.debug((TraceComponent)tc, (String)("decoded saml response has bytes count:" + iAvailable), (Object[])new Object[0]);
            }
        }
        return inputStream;
    }
}

