/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jdbc.management.j2ee.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jdbc.management.j2ee.internal.JDBCDataSourceMBeanImpl;
import com.ibm.ws.jdbc.management.j2ee.internal.JDBCDriverMBeanImpl;
import com.ibm.ws.jdbc.management.j2ee.internal.JDBCResourceMBeanImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.library.LibraryChangeListener;
import com.ibm.wsspi.resource.ResourceFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(immediate=true)
public class JDBCMBeanRuntime {
    private static final String TRACE_GROUP = "RRA";
    private static final TraceComponent tc = Tr.register(JDBCMBeanRuntime.class, (String)"RRA");
    private static final String className = "JDBCMBeanRuntime :";
    private static int counterActivate = 0;
    private static int counterDeactivate = 0;
    private static int counterSetDataSource = 0;
    private static int counterSetJdbcDriver = 0;
    private static int counterUnsetDataSource = 0;
    private static int counterUnsetJdbcDriver = 0;
    private static int counterUpdatedDataSource = 0;
    private final ConcurrentHashMap<String, JDBCDataSourceMBeanImpl> dsMBeanList = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, JDBCResourceMBeanImpl> rsMBeanList = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, JDBCDriverMBeanImpl> drMBeanList = new ConcurrentHashMap();
    static final long serialVersionUID = -8412666582011053457L;

    @ManualTrace
    @Activate
    protected void activate(Map<String, Object> properties) {
        String methodName = "activate";
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"activate", (Object[])new Object[]{"Entry Count: " + ++counterActivate});
        }
        if (trace && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"JDBCMBeanRuntime :activate", (Object[])new Object[]{properties});
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"activate", (Object)"Normal Exit");
        }
    }

    @ManualTrace
    @Deactivate
    protected void deactivate(int reason) {
        String methodName = "deactivate";
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"deactivate", (Object[])new Object[]{"Entry Count: " + ++counterDeactivate});
        }
        if (trace && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("JDBCMBeanRuntime :deactivate, reason=" + reason), (Object[])new Object[0]);
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deactivate", (Object)"Normal Exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @ManualTrace
    @Reference(service=ResourceFactory.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(component.name=com.ibm.ws.jdbc.dataSource)")
    protected void setDataSource(ServiceReference<ResourceFactory> ref) {
        String methodName = "setDataSource";
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setDataSource", (Object[])new Object[]{"Entry Count: " + ++counterSetDataSource});
        }
        JDBCMBeanRuntime jDBCMBeanRuntime = this;
        synchronized (jDBCMBeanRuntime) {
            String JDBCDriver;
            BundleContext bndCtx;
            String jndiName;
            String id;
            String jdbcResourcename;
            String name;
            block10: {
                name = (String)ref.getProperty("config.displayId");
                jdbcResourcename = name + "/JDBCResource";
                id = name.contains("]/dataSource[") ? null : (String)ref.getProperty("id");
                jndiName = (String)ref.getProperty("jndiName");
                bndCtx = JDBCMBeanRuntime.getBundleContext(FrameworkUtil.getBundle(this.getClass()));
                JDBCDriver = null;
                try {
                    ServiceReference<?>[] refs2 = JDBCMBeanRuntime.getServiceReferences(bndCtx, "com.ibm.ws.jdbc.internal.JDBCDriverService", (String)ref.getProperty("driver.target"));
                    JDBCDriver = (String)refs2[0].getProperty("id");
                }
                catch (InvalidSyntaxException refs2) {
                    void e;
                    FFDCFilter.processException((Throwable)refs2, (String)"com.ibm.ws.jdbc.management.j2ee.internal.JDBCMBeanRuntime", (String)"125", (Object)this, (Object[])new Object[]{ref});
                    if (!trace || !tc.isDebugEnabled()) break block10;
                    Tr.debug((TraceComponent)tc, (String)("JDBCMBeanRuntime :setDataSource: Unexpected Exception: " + e), (Object[])new Object[0]);
                }
            }
            String J2EEServer = bndCtx.getProperty("wlp.server.name");
            JDBCResourceMBeanImpl rsMBean = this.rsMBeanList.get(jdbcResourcename);
            if (rsMBean == null) {
                rsMBean = new JDBCResourceMBeanImpl(id, jndiName, jdbcResourcename, J2EEServer);
                rsMBean.register(bndCtx);
                JDBCResourceMBeanImpl rsMBeanTemp = this.rsMBeanList.putIfAbsent(rsMBean.getName(), rsMBean);
                if (rsMBeanTemp != null && trace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("JDBCResourceMBean: Unexpected put for the key: " + rsMBean.getName() + " happened in " + className + "setDataSource"), (Object[])new Object[0]);
                }
            }
            String JDBCResource = rsMBean.getName();
            JDBCDataSourceMBeanImpl dsMBean = new JDBCDataSourceMBeanImpl(id, jndiName, name, J2EEServer, JDBCResource, JDBCDriver);
            dsMBean.register(bndCtx);
            JDBCDataSourceMBeanImpl dsMBeanTemp = this.dsMBeanList.putIfAbsent(dsMBean.getName(), dsMBean);
            if (dsMBeanTemp != null && trace && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("JDBCDataSourceMBean: Unexpected put for the key: " + dsMBean.getName() + " happened in " + className + "setDataSource"), (Object[])new Object[0]);
            }
            rsMBean.setDataSourceChild(dsMBean.getName(), dsMBean);
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setDataSource", (Object)"Normal Exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    @Reference(service=LibraryChangeListener.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(component.name=com.ibm.ws.jdbc.jdbcDriver)")
    protected void setJdbcDriver(ServiceReference<LibraryChangeListener> ref) {
        String methodName = "setJdbcDriver";
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setJdbcDriver", (Object[])new Object[]{"Entry Count: " + ++counterSetJdbcDriver});
        }
        JDBCMBeanRuntime jDBCMBeanRuntime = this;
        synchronized (jDBCMBeanRuntime) {
            String name = (String)ref.getProperty("config.displayId");
            String id = name.contains("]/jdbcDriver[") ? null : (String)ref.getProperty("id");
            BundleContext bndCtx = JDBCMBeanRuntime.getBundleContext(FrameworkUtil.getBundle(this.getClass()));
            String J2EEServer = bndCtx.getProperty("wlp.server.name");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("TODO: Need to register mbeans for jdbcDriver id=" + id + " name=" + name), (Object[])new Object[0]);
            }
            JDBCDriverMBeanImpl drMBean = new JDBCDriverMBeanImpl(id, name, J2EEServer);
            drMBean.register(bndCtx);
            JDBCDriverMBeanImpl drMBeanTemp = this.drMBeanList.putIfAbsent(drMBean.getName(), drMBean);
            if (drMBeanTemp != null && trace && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("JDBCDriverMBean: Unexpected put for the key: " + drMBean.getName() + " happened in " + className + "setJdbcDriver"), (Object[])new Object[0]);
            }
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setJdbcDriver", (Object)"Normal Exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    protected void unsetDataSource(ServiceReference<ResourceFactory> ref) {
        String methodName = "unsetDataSource";
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"unsetDataSource", (Object[])new Object[]{"Entry Count: " + ++counterUnsetDataSource});
        }
        JDBCMBeanRuntime jDBCMBeanRuntime = this;
        synchronized (jDBCMBeanRuntime) {
            String name = (String)ref.getProperty("config.displayId");
            JDBCDataSourceMBeanImpl dsMBean = this.dsMBeanList.get(name);
            JDBCResourceMBeanImpl rsMBean = this.rsMBeanList.get(dsMBean.getJDBCResource());
            rsMBean.removeDataSourceChild(dsMBean.getName());
            this.dsMBeanList.remove(dsMBean.getName());
            dsMBean.unregister();
            if (rsMBean.getDataSourceChildrenCount() == 0) {
                this.rsMBeanList.remove(rsMBean.getName());
                rsMBean.unregister();
            }
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"unsetDataSource");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    protected void unsetJdbcDriver(ServiceReference<LibraryChangeListener> ref) {
        String methodName = "unsetJdbcDriver";
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"unsetJdbcDriver", (Object[])new Object[]{"Entry Count: " + ++counterUnsetJdbcDriver});
        }
        JDBCMBeanRuntime jDBCMBeanRuntime = this;
        synchronized (jDBCMBeanRuntime) {
            String name = (String)ref.getProperty("config.displayId");
            JDBCDriverMBeanImpl drMBean = this.drMBeanList.get(name);
            this.drMBeanList.remove(drMBean.getName());
            drMBean.unregister();
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"unsetJdbcDriver");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @ManualTrace
    protected void updatedDataSource(ServiceReference<ResourceFactory> ref) {
        String methodName = "updatedDataSource";
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"updatedDataSource", (Object[])new Object[]{"Entry Count: " + ++counterUpdatedDataSource});
        }
        JDBCMBeanRuntime jDBCMBeanRuntime = this;
        synchronized (jDBCMBeanRuntime) {
            String JDBCDriver;
            BundleContext bndCtx;
            String jndiName;
            String id;
            String jdbcResourcename;
            String name;
            block11: {
                name = (String)ref.getProperty("config.displayId");
                jdbcResourcename = name + "/JDBCResource";
                id = name.contains("]/dataSource[") ? null : (String)ref.getProperty("id");
                jndiName = (String)ref.getProperty("jndiName");
                bndCtx = JDBCMBeanRuntime.getBundleContext(FrameworkUtil.getBundle(this.getClass()));
                JDBCDriver = null;
                try {
                    ServiceReference<?>[] refs2 = JDBCMBeanRuntime.getServiceReferences(bndCtx, "com.ibm.ws.jdbc.internal.JDBCDriverService", (String)ref.getProperty("driver.target"));
                    JDBCDriver = (String)refs2[0].getProperty("id");
                }
                catch (InvalidSyntaxException refs2) {
                    void e;
                    FFDCFilter.processException((Throwable)refs2, (String)"com.ibm.ws.jdbc.management.j2ee.internal.JDBCMBeanRuntime", (String)"282", (Object)this, (Object[])new Object[]{ref});
                    if (!trace || !tc.isDebugEnabled()) break block11;
                    Tr.debug((TraceComponent)tc, (String)("JDBCMBeanRuntime :updatedDataSource: Unexpected Exception: " + e), (Object[])new Object[0]);
                }
            }
            JDBCDataSourceMBeanImpl dsMBeanOld = this.dsMBeanList.get(name);
            JDBCResourceMBeanImpl rsMBeanOld = this.rsMBeanList.get(dsMBeanOld.getJDBCResource());
            rsMBeanOld.removeDataSourceChild(dsMBeanOld.getName());
            this.dsMBeanList.remove(dsMBeanOld.getName());
            dsMBeanOld.unregister();
            if (rsMBeanOld.getDataSourceChildrenCount() == 0) {
                this.rsMBeanList.remove(rsMBeanOld.getName());
                rsMBeanOld.unregister();
            }
            String J2EEServer = bndCtx.getProperty("wlp.server.name");
            JDBCResourceMBeanImpl rsMBeanNew = this.rsMBeanList.get(jdbcResourcename);
            if (rsMBeanNew == null) {
                rsMBeanNew = new JDBCResourceMBeanImpl(id, jndiName, jdbcResourcename, J2EEServer);
                rsMBeanNew.register(bndCtx);
                JDBCResourceMBeanImpl rsMBeanTemp = this.rsMBeanList.putIfAbsent(rsMBeanNew.getName(), rsMBeanNew);
                if (rsMBeanTemp != null && trace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("JDBCResourceMBean: Unexpected put for the key: " + rsMBeanNew.getName() + " happened in " + className + "updatedDataSource"), (Object[])new Object[0]);
                }
            }
            String JDBCResource = rsMBeanNew.getName();
            JDBCDataSourceMBeanImpl dsMBeanNew = new JDBCDataSourceMBeanImpl(id, jndiName, name, J2EEServer, JDBCResource, JDBCDriver);
            dsMBeanNew.register(bndCtx);
            JDBCDataSourceMBeanImpl dsMBeanTemp = this.dsMBeanList.putIfAbsent(dsMBeanNew.getName(), dsMBeanNew);
            if (dsMBeanTemp != null && trace && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("JDBCDataSourceMBean: Unexpected put for the key: " + dsMBeanNew.getName() + " happened in " + className + "updatedDataSource"), (Object[])new Object[0]);
            }
            rsMBeanNew.setDataSourceChild(dsMBeanNew.getName(), dsMBeanNew);
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updatedDataSource", (Object)"Normal Exit");
        }
    }

    private static BundleContext getBundleContext(final Bundle bundle) {
        if (System.getSecurityManager() == null) {
            return bundle.getBundleContext();
        }
        return AccessController.doPrivileged(new PrivilegedAction<BundleContext>(){
            static final long serialVersionUID = -1020738747165700236L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public BundleContext run() {
                return bundle.getBundleContext();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.jdbc.management.j2ee.internal.JDBCMBeanRuntime$1", 1.class, (String)JDBCMBeanRuntime.TRACE_GROUP, null);
            }
        });
    }

    @FFDCIgnore(value={PrivilegedActionException.class})
    private static ServiceReference<?>[] getServiceReferences(final BundleContext bCtx, final String clazz, final String filter) throws InvalidSyntaxException {
        if (System.getSecurityManager() == null) {
            return bCtx.getServiceReferences(clazz, filter);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<ServiceReference<?>[]>(){
                static final long serialVersionUID = -6054131059911261538L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public ServiceReference<?>[] run() throws InvalidSyntaxException {
                    return bCtx.getServiceReferences(clazz, filter);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.jdbc.management.j2ee.internal.JDBCMBeanRuntime$2", 2.class, (String)JDBCMBeanRuntime.TRACE_GROUP, null);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof InvalidSyntaxException) {
                throw (InvalidSyntaxException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }
}

