/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.udpchannel.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.udpchannel.internal.UDPChannel;
import com.ibm.ws.udpchannel.internal.UDPChannelConfiguration;
import com.ibm.ws.udpchannel.internal.UDPConnLink;
import com.ibm.ws.udpchannel.internal.UDPSelectorMonitor;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.channelfw.VirtualConnection;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class UDPNetworkLayer {
    private static final TraceComponent tc = Tr.register(UDPNetworkLayer.class, (String)"UDPChannel", (String)"com.ibm.ws.udpchannel.internal.resources.UDPMessages");
    private UDPChannel udpChannel = null;
    private UDPSelectorMonitor selectorMonitor = null;
    protected DatagramChannel datagramChannel = null;
    private UDPConnLink connLink = null;
    private String localBindAddress = null;
    private String configuredLocalBindAddress = null;
    private int localBindPort = 0;

    protected UDPNetworkLayer(UDPChannel channel, UDPSelectorMonitor selectorMonitor, String localBindAddress, int localPort) {
        this.udpChannel = channel;
        this.selectorMonitor = selectorMonitor;
        this.localBindAddress = localBindAddress;
        this.configuredLocalBindAddress = localBindAddress;
        this.localBindPort = localPort;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Constructor: localBindAddress = " + localBindAddress + " localBindPort = " + localPort), (Object[])new Object[0]);
        }
    }

    protected DatagramSocket initDatagramSocket(VirtualConnection vc) throws IOException {
        DatagramSocket datagramSocket;
        InetSocketAddress address;
        UDPChannelConfiguration channelConfig;
        block24: {
            int size1;
            int size;
            block23: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Create new DatagramSocket: " + vc), (Object[])new Object[0]);
                }
                channelConfig = this.udpChannel.getConfig();
                address = null;
                if (this.localBindAddress != null) {
                    if (this.localBindAddress.equals("*")) {
                        this.localBindAddress = "0.0.0.0";
                    }
                    if ((address = new InetSocketAddress(this.localBindAddress, this.localBindPort)).isUnresolved()) {
                        String displayableHostName = channelConfig.getHostname();
                        if (displayableHostName == null) {
                            displayableHostName = "*";
                        }
                        Tr.error((TraceComponent)tc, (String)"CWUDP0004E", (Object[])new Object[]{channelConfig.getExternalName(), displayableHostName, String.valueOf(channelConfig.getPort())});
                        throw new IOException("local address unresolved");
                    }
                }
                this.datagramChannel = DatagramChannel.open();
                datagramSocket = this.datagramChannel.socket();
                datagramSocket.setReuseAddress(false);
                this.datagramChannel.configureBlocking(false);
                if (channelConfig.getReceiveBufferSize() >= 4 && channelConfig.getReceiveBufferSize() <= 0x1000000) {
                    size = datagramSocket.getReceiveBufferSize();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("setting receive buffer to size " + channelConfig.getReceiveBufferSize()), (Object[])new Object[0]);
                    }
                    try {
                        datagramSocket.setReceiveBufferSize(channelConfig.getReceiveBufferSize());
                        size1 = datagramSocket.getReceiveBufferSize();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && size == size1) {
                            Tr.debug((TraceComponent)tc, (String)"setting receive buffer had no effect, still the same size ", (Object[])new Object[0]);
                        }
                    }
                    catch (SocketException e) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Caught SocketException " + e.getMessage() + " while trying to setReceiveBufferSize to " + channelConfig.getReceiveBufferSize()), (Object[])new Object[0]);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block23;
                        Tr.debug((TraceComponent)tc, (String)("Caught IllegalArgumentException " + e.getMessage() + " while trying to setReceiveBufferSize to " + channelConfig.getReceiveBufferSize()), (Object[])new Object[0]);
                    }
                }
            }
            if (channelConfig.getSendBufferSize() >= 4 && channelConfig.getSendBufferSize() <= 0x1000000) {
                size = datagramSocket.getSendBufferSize();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("setting send buffer to size " + channelConfig.getSendBufferSize()), (Object[])new Object[0]);
                }
                try {
                    datagramSocket.setSendBufferSize(channelConfig.getSendBufferSize());
                    size1 = datagramSocket.getSendBufferSize();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && size == size1) {
                        Tr.debug((TraceComponent)tc, (String)"setting send buffer had no effect, still the same size ", (Object[])new Object[0]);
                    }
                }
                catch (SocketException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Caught SocketException " + e.getMessage() + " while trying to setSendBufferSize to " + channelConfig.getSendBufferSize()), (Object[])new Object[0]);
                    }
                }
                catch (IllegalArgumentException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block24;
                    Tr.debug((TraceComponent)tc, (String)("Caught IllegalArgumentException " + e.getMessage() + " while trying to setSendBufferSize to " + channelConfig.getSendBufferSize()), (Object[])new Object[0]);
                }
            }
        }
        try {
            datagramSocket.bind(address);
            this.selectorMonitor.setChannel(this.datagramChannel, this);
        }
        catch (IOException ioe) {
            String displayableHostName = channelConfig.getHostname();
            if (displayableHostName == null) {
                displayableHostName = "*";
            }
            Tr.error((TraceComponent)tc, (String)"CWUDP0005E", (Object[])new Object[]{channelConfig.getExternalName(), displayableHostName, String.valueOf(channelConfig.getPort())});
            throw new IOException(ioe.getMessage());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"new ServerSocket successfully created", (Object[])new Object[0]);
        }
        return this.datagramChannel.socket();
    }

    public int getListenPort() {
        DatagramSocket datagramSocket = this.datagramChannel.socket();
        int port = this.localBindPort;
        if (datagramSocket != null) {
            port = datagramSocket.getLocalPort();
        }
        return port;
    }

    public DatagramSocket getDatagramSocket() {
        return this.datagramChannel.socket();
    }

    public DatagramChannel getDatagramChannel() {
        return this.datagramChannel;
    }

    public String getConfiguredBindAddress() {
        return this.configuredLocalBindAddress;
    }

    public synchronized int send(WsByteBuffer buffer, SocketAddress remoteAddress) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Sending buffer " + buffer + " to " + ((InetSocketAddress)remoteAddress).getAddress()), (Object[])new Object[0]);
        }
        int numWritten = this.datagramChannel.send(buffer.getWrappedByteBuffer(), remoteAddress);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Bytes written=" + numWritten), (Object[])new Object[0]);
        }
        return numWritten;
    }

    public synchronized SocketAddress receive(WsByteBuffer buffer) throws IOException {
        boolean validated;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"receive", (Object[])new Object[0]);
        }
        SocketAddress returnAddress = null;
        PrivReceive privThread = new PrivReceive(buffer.getWrappedByteBuffer());
        Result res = AccessController.doPrivileged(privThread);
        if (res.ex != null) {
            throw res.ex;
        }
        returnAddress = res.ret;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            if (returnAddress != null) {
                Tr.debug((TraceComponent)tc, (String)("Received buffer " + buffer + " from " + ((InetSocketAddress)returnAddress).getAddress()), (Object[])new Object[0]);
            } else {
                Tr.debug((TraceComponent)tc, (String)("Received buffer " + buffer + " from returnAddress == null"), (Object[])new Object[0]);
            }
        }
        if (returnAddress != null && !(validated = this.getUDPChannel().verifySender(((InetSocketAddress)returnAddress).getAddress()))) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Received buffer from sender not in include list or is in exclude list. " + ((InetSocketAddress)returnAddress).getAddress()), (Object[])new Object[0]);
            }
            returnAddress = null;
            buffer.flip();
            buffer.clear();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"receive");
        }
        return returnAddress;
    }

    public UDPChannel getUDPChannel() {
        return this.udpChannel;
    }

    public synchronized void destroy() {
        block2: {
            try {
                this.datagramChannel.close();
                this.datagramChannel = null;
            }
            catch (IOException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)("Error closing datagram channel " + e), (Object[])new Object[0]);
            }
        }
    }

    public UDPConnLink getConnLink() {
        return this.connLink;
    }

    public void setConnLink(UDPConnLink link) {
        this.connLink = link;
    }

    private class PrivReceive
    implements PrivilegedAction<Result> {
        private ByteBuffer buf = null;

        public PrivReceive(ByteBuffer _buf) {
            this.buf = _buf;
        }

        @Override
        public Result run() {
            Result result = new Result();
            try {
                result.ret = UDPNetworkLayer.this.datagramChannel.receive(this.buf);
                result.ex = null;
            }
            catch (IOException x) {
                result.ex = x;
                result.ret = null;
            }
            return result;
        }
    }

    private static class Result {
        public IOException ex = null;
        public SocketAddress ret = null;

        protected Result() {
        }
    }
}

