/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloading.internal.providers;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.classloading.ClassProvider;
import com.ibm.ws.classloading.LibertyClassLoader;
import com.ibm.ws.classloading.internal.LibertyLoader;
import com.ibm.ws.classloading.internal.providers.Providers;
import com.ibm.ws.classloading.internal.util.BlockingList;
import com.ibm.ws.classloading.internal.util.ElementNotReadyException;
import com.ibm.ws.classloading.internal.util.ElementNotValidException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.classloading.ApiType;
import java.util.Collection;
import java.util.EnumSet;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class GetProviderLoaders
implements BlockingList.Retriever<String, LibertyLoader>,
BlockingList.Listener<String, LibertyLoader> {
    static final TraceComponent tc = Tr.register(GetProviderLoaders.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
    private final String id;
    private final EnumSet<ApiType> apis;
    static final long serialVersionUID = -6734255435448671548L;

    public GetProviderLoaders(String id, EnumSet<ApiType> gwApis) {
        this.id = id;
        this.apis = gwApis;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void listenFor(final String providerId, final BlockingList.Slot<? super LibertyLoader> slot) {
        String filterString = String.format("(&(%s=%s)(id=%s))", "objectClass", ClassProvider.class.getName(), providerId);
        try {
            Filter filter = Providers.bundleContext.createFilter(filterString);
            new ServiceTracker<ClassProvider, Void>(Providers.bundleContext, filter, null){
                static final long serialVersionUID = 1438356040445117018L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @FFDCIgnore(value={ElementNotReadyException.class, ElementNotValidException.class})
                public Void addingService(ServiceReference<ClassProvider> providerRef) {
                    String methodName = "addingService(): ";
                    try {
                        slot.fill(GetProviderLoaders.this.getLoaderFromProvider(providerId, (ServiceReference<ClassProvider>)providerRef));
                        this.close();
                    }
                    catch (ElementNotReadyException butKeepOnListening) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("addingService(): failed to retrieve element but will keep trying. Exception was " + butKeepOnListening), (Object[])new Object[0]);
                        }
                    }
                    catch (ElementNotValidException soStopListening) {
                        slot.delete();
                        this.close();
                    }
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.providers.GetProviderLoaders$1", 1.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
                }
            };
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            FFDCFilter.processException((Throwable)invalidSyntaxException, (String)"com.ibm.ws.classloading.internal.providers.GetProviderLoaders", (String)"76", (Object)this, (Object[])new Object[]{providerId, slot});
            if (tc.isErrorEnabled()) {
                void e;
                Tr.error((TraceComponent)tc, (String)"cls.provider.id.invalid", (Object[])new Object[]{this.id, providerId, e.toString()});
            }
            slot.delete();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public LibertyLoader fetch(String pid) throws ElementNotReadyException, ElementNotValidException {
        Collection refs;
        String filterString;
        String methodName = "fetch(): ";
        if (Providers.bundleContext == null) {
            throw new ElementNotValidException("Cannot retrieve providers outside OSGi framework");
        }
        String filter = filterString = String.format("(id=%s)", pid);
        try {
            refs = Providers.bundleContext.getServiceReferences(ClassProvider.class, filter);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            void e;
            FFDCFilter.processException((Throwable)invalidSyntaxException, (String)"com.ibm.ws.classloading.internal.providers.GetProviderLoaders", (String)"96", (Object)this, (Object[])new Object[]{pid});
            if (tc.isErrorEnabled()) {
                Tr.error((TraceComponent)tc, (String)"cls.provider.id.invalid", (Object[])new Object[]{this.id, pid, e.getMessage()});
            }
            throw new ElementNotValidException("Cannot look up provider because the filter '" + filterString + "' has bad syntax: ", (Throwable)e);
        }
        if (refs.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("fetch(): Could not find provider with id=" + pid), (Object[])new Object[0]);
            }
            throw new ElementNotReadyException("No ClassProvider available with id= " + pid);
        }
        return this.getLoaderFromProvider(pid, (ServiceReference<ClassProvider>)((ServiceReference)refs.iterator().next()));
    }

    private LibertyLoader getLoaderFromProvider(String providerId, ServiceReference<ClassProvider> providerRef) throws ElementNotReadyException, ElementNotValidException {
        String methodName = "getLoaderFromProvider(): ";
        ClassProvider provider = (ClassProvider)Providers.bundleContext.getService(providerRef);
        if (provider == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getLoaderFromProvider(): failed retrieving service - provider went away before it could be retrieved", (Object[])new Object[0]);
            }
            throw new ElementNotReadyException("ClassProvider with id=" + providerId + " disappeared while we were trying to use it");
        }
        LibertyClassLoader lcl = provider.getDelegateLoader();
        if (lcl == null) {
            if (tc.isErrorEnabled()) {
                Tr.error((TraceComponent)tc, (String)"cls.provider.loader.null", (Object[])new Object[]{this.id, providerId, providerRef.getProperty("service.vendor")});
            }
            throw new ElementNotValidException("Provider did not return a classloader on request");
        }
        if (!(lcl instanceof LibertyLoader)) {
            if (tc.isErrorEnabled()) {
                Tr.error((TraceComponent)tc, (String)"cls.provider.loader.unknown", (Object[])new Object[]{this.id, providerId, providerRef.getProperty("service.vendor")});
            }
            throw new ElementNotValidException("Provider returned an unknown loader type: " + lcl.getClass());
        }
        LibertyLoader ll = (LibertyLoader)lcl;
        if (!Providers.checkAPITypesMatch(this.id, this.apis, providerId, ll.getApiTypeVisibility())) {
            throw new ElementNotValidException("Provider API types do not match class loader API types");
        }
        return ll;
    }
}

