/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.plugins;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.ibm.oauth.core.api.error.OidcServerException;
import com.ibm.oauth.core.internal.oauth20.OAuth20Constants;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.error.impl.BrowserAndServerLogMessage;
import com.ibm.ws.security.oauth20.plugins.OidcBaseClient;
import com.ibm.ws.security.oauth20.util.OIDCConstants;
import com.ibm.ws.security.oauth20.util.OidcOAuth20Util;
import com.ibm.ws.security.oauth20.web.AbstractOidcEndpointServices;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OidcBaseClientValidator {
    protected static final String MESSAGE_BUNDLE = "com.ibm.ws.security.oauth20.internal.resources.OAuthMessages";
    private static final String[] illegalChars = new String[]{"<", ">"};
    private final OidcBaseClient client;
    private static TraceComponent tc = Tr.register(OidcBaseClientValidator.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.internal.resources.OAuthMessages");
    static final long serialVersionUID = 6936493922620808400L;

    private OidcBaseClientValidator(OidcBaseClient client) {
        this.client = client.getDeepCopy();
    }

    public static OidcBaseClientValidator getInstance(OidcBaseClient client) {
        return new OidcBaseClientValidator(OidcBaseClientValidator.clientGetClientName(client));
    }

    public static OidcBaseClient clientGetClientName(OidcBaseClient client) {
        try {
            if (client.getClientName() != null) {
                client.setClientName(URLDecoder.decode(client.getClientName(), "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.security.oauth20.plugins.OidcBaseClientValidator", (String)"64", null, (Object[])new Object[]{client});
        }
        return client;
    }

    public OidcBaseClient validateCreateUpdate() throws OidcServerException {
        this.detectIllegalChars();
        this.validateAppType();
        this.validateResponseTypes();
        Set<String> grantTypes = this.validateGrantTypes();
        this.validateResponseAndGrantMatch(grantTypes);
        this.validateRedirectUris();
        this.validateScopes();
        this.validateSujectType();
        this.validateTokenEndpointAuthMethod();
        this.validatePostLogoutRedirectUris();
        this.validatePreAuthorizedScopes();
        this.validateTrustedUriPrefixes();
        this.validateFunctionalUserGroupIds();
        this.validateOutputParameters();
        return this.client;
    }

    private void detectIllegalChars() throws OidcServerException {
        this.detectNonVSCHARCharacters(this.client.getClientId(), "client_id");
        this.detectNonVSCHARCharacters(this.client.getClientSecret(), "client_secret");
        this.detectIllegalCharacters(this.client.getClientId());
        this.detectIllegalCharacters(this.client.getClientSecret());
        this.detectIllegalCharacters(this.client.getRedirectUris());
        this.detectIllegalCharacters(this.client.getClientName());
        this.detectIllegalCharacters(this.client.getPostLogoutRedirectUris());
        this.detectIllegalCharacters(this.client.getPreAuthorizedScope());
        this.detectIllegalCharacters(this.client.getFunctionalUserId());
        this.detectIllegalCharacters(this.client.getFunctionalUserGroupIds());
    }

    void detectNonVSCHARCharacters(@Sensitive String s, String parameterName) throws OidcServerException {
        if (s == null || s.length() == 0) {
            return;
        }
        String badChars = this.getIllegalChars(s, "[ -~]");
        if (badChars != null && !badChars.isEmpty()) {
            BrowserAndServerLogMessage errorMsg = new BrowserAndServerLogMessage(tc, "OAUTH_CLIENT_REGISTRATION_ILLEGAL_CHAR", badChars);
            Tr.error((TraceComponent)tc, (String)errorMsg.getServerErrorMessage(), (Object[])new Object[0]);
            throw new OidcServerException(errorMsg, "invalid_client_metadata", 400);
        }
    }

    String getIllegalChars(@Sensitive String input, String regexAllowableChars) {
        if (input == null || input.length() == 0) {
            return null;
        }
        String badChars = "";
        for (int i = 0; i < input.length(); ++i) {
            String currentChar;
            Pattern vscharRegex = Pattern.compile(regexAllowableChars);
            Matcher matcher = vscharRegex.matcher(currentChar = input.substring(i, i + 1));
            if (matcher.matches()) continue;
            badChars = badChars + currentChar;
        }
        return badChars;
    }

    private void detectIllegalCharacters(@Sensitive String s) throws OidcServerException {
        if (s == null || s.length() == 0) {
            return;
        }
        for (int i = 0; i < illegalChars.length; ++i) {
            if (!s.contains(illegalChars[i])) continue;
            throw new OidcServerException(new BrowserAndServerLogMessage(tc, "OAUTH_CLIENT_REGISTRATION_ILLEGAL_CHAR", illegalChars[i]), "invalid_client_metadata", 400);
        }
    }

    private void detectIllegalCharacters(@Sensitive JsonArray a) throws OidcServerException {
        this.detectIllegalCharacters(a.toString());
    }

    public OidcBaseClient setDefaultsForOmitted() {
        this.setDefaultAppType();
        this.setDefaultResponseType();
        this.setDefaultGrantType();
        this.setDefaultTokenEndpointAuthMethod();
        this.setDefaultJsonArrayForNullUris();
        return this.client;
    }

    protected void setDefaultAppType() {
        String appType = this.client.getApplicationType();
        if (OidcOAuth20Util.isNullEmpty(appType)) {
            this.client.setApplicationType("web");
        }
    }

    protected void setDefaultResponseType() {
        JsonArray responseTypes = this.client.getResponseTypes();
        if (OidcOAuth20Util.isNullEmpty(responseTypes)) {
            this.client.setResponseTypes(OidcOAuth20Util.initJsonArray("code"));
        }
    }

    protected void setDefaultGrantType() {
        JsonArray grantTypes = this.client.getGrantTypes();
        if (OidcOAuth20Util.isNullEmpty(grantTypes)) {
            this.client.setGrantTypes(OidcOAuth20Util.initJsonArray("authorization_code"));
        }
    }

    protected void setDefaultTokenEndpointAuthMethod() {
        String tokenEndpointAuthMethod = this.client.getTokenEndpointAuthMethod();
        if (OidcOAuth20Util.isNullEmpty(tokenEndpointAuthMethod)) {
            this.client.setTokenEndpointAuthMethod("client_secret_basic");
        }
    }

    protected void setDefaultJsonArrayForNullUris() {
        if (this.client.getRedirectUris() == null) {
            this.client.setRedirectUris(new JsonArray());
        }
        if (this.client.getPostLogoutRedirectUris() == null) {
            this.client.setPostLogoutRedirectUris(new JsonArray());
        }
        if (this.client.getTrustedUriPrefixes() == null) {
            this.client.setTrustedUriPrefixes(new JsonArray());
        }
    }

    protected void validateAppType() throws OidcServerException {
        String appType = this.client.getApplicationType();
        if (!(OidcOAuth20Util.isNullEmpty(appType) || appType.equals("native") || appType.equals("web"))) {
            throw new OidcServerException(new BrowserAndServerLogMessage(tc, "OAUTH_CLIENT_REGISTRATION_VALUE_NOT_SUPPORTED", appType, "application_type"), "invalid_client_metadata", 400);
        }
    }

    protected void validateResponseTypes() throws OidcServerException {
        JsonArray responseTypes = this.client.getResponseTypes();
        if (!OidcOAuth20Util.isNullEmpty(responseTypes)) {
            HashSet<String> dupeCheckerSet = new HashSet<String>();
            for (JsonElement response : responseTypes) {
                if (!OIDCConstants.OIDC_SUPP_RESP_TYPES_SET.contains(response.getAsString())) {
                    throw new OidcServerException(new BrowserAndServerLogMessage(tc, "OAUTH_CLIENT_REGISTRATION_VALUE_NOT_SUPPORTED", response.getAsString(), "response_type"), "invalid_client_metadata", 400);
                }
                if (dupeCheckerSet.add(response.getAsString())) continue;
                throw new OidcServerException(new BrowserAndServerLogMessage(tc, "OAUTH_CLIENT_REGISTRATION_VALUE_DUPE", response.getAsString(), "response_type"), "invalid_client_metadata", 400);
            }
        }
    }

    protected Set<String> validateGrantTypes() throws OidcServerException {
        HashSet<String> grantTypeSet = new HashSet<String>();
        JsonArray grantTypes = this.client.getGrantTypes();
        if (!OidcOAuth20Util.isNullEmpty(grantTypes)) {
            for (JsonElement grant : grantTypes) {
                if (!OAuth20Constants.ALL_GRANT_TYPES_SET.contains(grant.getAsString())) {
                    throw new OidcServerException(new BrowserAndServerLogMessage(tc, "OAUTH_CLIENT_REGISTRATION_VALUE_NOT_SUPPORTED", grant.getAsString(), "grant_type"), "invalid_client_metadata", 400);
                }
                if (grantTypeSet.add(grant.getAsString())) continue;
                throw new OidcServerException(new BrowserAndServerLogMessage(tc, "OAUTH_CLIENT_REGISTRATION_VALUE_DUPE", grant.getAsString(), "grant_type"), "invalid_client_metadata", 400);
            }
        }
        return grantTypeSet;
    }

    protected void validateResponseAndGrantMatch(Set<String> grantTypeSet) throws OidcServerException {
        JsonArray responseTypes = this.client.getResponseTypes();
        if (!OidcOAuth20Util.isNullEmpty(responseTypes)) {
            for (JsonElement responseType : responseTypes) {
                if (responseType.getAsString().equals("code") && !grantTypeSet.contains("authorization_code")) {
                    throw new OidcServerException(new BrowserAndServerLogMessage(tc, "OAUTH_CLIENT_REGISTRATION_GRANT_RESPONSE_VALIDATION", responseType.getAsString(), "authorization_code"), "invalid_client_metadata", 400);
                }
                if (!responseType.getAsString().equals("id_token token") && !responseType.getAsString().equals("token id_token") || grantTypeSet.contains("implicit")) continue;
                throw new OidcServerException(new BrowserAndServerLogMessage(tc, "OAUTH_CLIENT_REGISTRATION_GRANT_RESPONSE_VALIDATION", responseType.getAsString(), "implicit"), "invalid_client_metadata", 400);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void validateRedirectUris() throws OidcServerException {
        JsonArray redirectUris = this.client.getRedirectUris();
        if (redirectUris == null) {
            this.client.setRedirectUris(new JsonArray());
            return;
        }
        if (!OidcOAuth20Util.isNullEmpty(redirectUris)) {
            HashSet<String> dupeCheckerSet = new HashSet<String>();
            for (JsonElement redirectUriEle : redirectUris) {
                URI uri;
                String redirectUriString = redirectUriEle.getAsString();
                try {
                    uri = new URI(redirectUriEle.getAsString());
                }
                catch (URISyntaxException uRISyntaxException) {
                    void e;
                    FFDCFilter.processException((Throwable)uRISyntaxException, (String)"com.ibm.ws.security.oauth20.plugins.OidcBaseClientValidator", (String)"491", (Object)this, (Object[])new Object[0]);
                    throw new OidcServerException(new BrowserAndServerLogMessage(tc, "OAUTH_CLIENT_REGISTRATION_VALUE_MALFORMED_URI", redirectUriString, "redirect_uris"), "invalid_redirect_uri", 400, (Throwable)e);
                }
                if ((this.client.getApplicationType() == null || this.client.getApplicationType().equals("web")) && !uri.isAbsolute()) {
                    throw new OidcServerException(new BrowserAndServerLogMessage(tc, "OAUTH_CLIENT_REGISTRATION_VALUE_NOT_ABSOLUTE_URI", redirectUriString, "redirect_uris"), "invalid_redirect_uri", 400);
                }
                if (dupeCheckerSet.add(redirectUriEle.getAsString())) continue;
                throw new OidcServerException(new BrowserAndServerLogMessage(tc, "OAUTH_CLIENT_REGISTRATION_VALUE_DUPE", redirectUriString, "redirect_uris"), "invalid_client_metadata", 400);
            }
        }
    }

    protected void validateScopes() throws OidcServerException {
        if (!OidcOAuth20Util.isNullEmpty(this.client.getScope())) {
            // empty if block
        }
    }

    protected void validateSujectType() throws OidcServerException {
        String subjectType = this.client.getSubjectType();
        if (!OidcOAuth20Util.isNullEmpty(subjectType) && !subjectType.equals("public")) {
            throw new OidcServerException(new BrowserAndServerLogMessage(tc, "OAUTH_CLIENT_REGISTRATION_VALUE_NOT_SUPPORTED", subjectType, "subject_type"), "invalid_client_metadata", 400);
        }
    }

    protected void validateTokenEndpointAuthMethod() throws OidcServerException {
        String tokenEndpointAuthMethod = this.client.getTokenEndpointAuthMethod();
        if (!(OidcOAuth20Util.isNullEmpty(tokenEndpointAuthMethod) || tokenEndpointAuthMethod.equals("client_secret_post") || tokenEndpointAuthMethod.equals("client_secret_basic") || tokenEndpointAuthMethod.equals("none"))) {
            throw new OidcServerException(new BrowserAndServerLogMessage(tc, "OAUTH_CLIENT_REGISTRATION_VALUE_NOT_SUPPORTED", tokenEndpointAuthMethod, "token_endpoint_auth_method"), "invalid_client_metadata", 400);
        }
    }

    protected void validatePostLogoutRedirectUris() throws OidcServerException {
        JsonArray postLogoutRedirectUris = this.client.getPostLogoutRedirectUris();
        if (postLogoutRedirectUris == null) {
            this.client.setPostLogoutRedirectUris(new JsonArray());
            return;
        }
        this.validateUris(postLogoutRedirectUris, "post_logout_redirect_uris");
    }

    protected void validatePreAuthorizedScopes() throws OidcServerException {
    }

    protected void validateTrustedUriPrefixes() throws OidcServerException {
        JsonArray trustedUriPrefixes = this.client.getTrustedUriPrefixes();
        if (trustedUriPrefixes == null) {
            this.client.setTrustedUriPrefixes(new JsonArray());
            return;
        }
        this.validateUris(trustedUriPrefixes, "trusted_uri_prefixes");
        this.client.setTrustedUriPrefixes(AbstractOidcEndpointServices.getSlashTerminated(trustedUriPrefixes));
    }

    protected void validateFunctionalUserGroupIds() throws OidcServerException {
        JsonArray functionalUserGroupIds = this.client.getFunctionalUserGroupIds();
        if (functionalUserGroupIds == null) {
            this.client.setFunctionalUserGroupIds(new JsonArray());
            return;
        }
        HashSet<String> dupeCheckerSet = new HashSet<String>();
        for (JsonElement groupIdEle : functionalUserGroupIds) {
            String groupIdString = groupIdEle.getAsString();
            if (dupeCheckerSet.add(groupIdString)) continue;
            throw new OidcServerException(new BrowserAndServerLogMessage(tc, "OAUTH_CLIENT_REGISTRATION_VALUE_DUPE", groupIdString, "functional_user_groupIds"), "invalid_client_metadata", 400);
        }
    }

    protected void validateOutputParameters() throws OidcServerException {
        if (this.client.getClientIdIssuedAt() != 0L) {
            throw new OidcServerException(new BrowserAndServerLogMessage(tc, "OAUTH_CLIENT_REGISTRATION_VALUE_OUT_NOT_ALLOWED", "client_id_issued_at"), "invalid_client_metadata", 400);
        }
        if (this.client.getClientSecretExpiresAt() != 0L) {
            throw new OidcServerException(new BrowserAndServerLogMessage(tc, "OAUTH_CLIENT_REGISTRATION_VALUE_OUT_NOT_ALLOWED", "client_secret_expires_at"), "invalid_client_metadata", 400);
        }
        if (this.client.getRegistrationClientUri() != null && !this.client.getRegistrationClientUri().isEmpty()) {
            throw new OidcServerException(new BrowserAndServerLogMessage(tc, "OAUTH_CLIENT_REGISTRATION_VALUE_OUT_NOT_ALLOWED", "registration_client_uri"), "invalid_client_metadata", 400);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void validateUris(JsonArray uris, String clientMetadataField) throws OidcServerException {
        if (!OidcOAuth20Util.isNullEmpty(uris)) {
            HashSet<String> dupeCheckerSet = new HashSet<String>();
            for (JsonElement uriEle : uris) {
                URI uri;
                String uriString = uriEle.getAsString();
                try {
                    uri = new URI(uriString);
                }
                catch (URISyntaxException uRISyntaxException) {
                    void e;
                    FFDCFilter.processException((Throwable)uRISyntaxException, (String)"com.ibm.ws.security.oauth20.plugins.OidcBaseClientValidator", (String)"642", (Object)this, (Object[])new Object[]{uris, clientMetadataField});
                    throw new OidcServerException(new BrowserAndServerLogMessage(tc, "OAUTH_CLIENT_REGISTRATION_VALUE_MALFORMED_URI", uriString, clientMetadataField), "invalid_client_metadata", 400, (Throwable)e);
                }
                if (!uri.isAbsolute()) {
                    throw new OidcServerException(new BrowserAndServerLogMessage(tc, "OAUTH_CLIENT_REGISTRATION_VALUE_NOT_ABSOLUTE_URI", uriString, clientMetadataField), "invalid_client_metadata", 400);
                }
                if (dupeCheckerSet.add(uriString)) continue;
                throw new OidcServerException(new BrowserAndServerLogMessage(tc, "OAUTH_CLIENT_REGISTRATION_VALUE_DUPE", uriString, clientMetadataField), "invalid_client_metadata", 400);
            }
        }
    }
}

