/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.plugins.db;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;

public interface DetectDatabaseType {
    public DBType getDbType();

    public DBType getDbType(String var1);

    @InjectedFFDC
    public static class DetectionUtils {
        private static final String CLSNAME = DetectDatabaseType.class.getName();
        private static final Logger logger = Logger.getLogger(CLSNAME);
        static final long serialVersionUID = 7492774772758526694L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static DBType detectDbType(Connection conn) {
            boolean FINER = logger.isLoggable(Level.FINER);
            if (conn == null) {
                if (!FINER) return DBType.UNKNOWN;
                logger.finer("Connection is null, dbtype UNKNOWN");
                return DBType.UNKNOWN;
            }
            try {
                DatabaseMetaData dbm = conn.getMetaData();
                if (dbm == null) {
                    if (!FINER) return DBType.UNKNOWN;
                    logger.finer("DB MetaInfo is null, dbtype UNKNOWN");
                    return DBType.UNKNOWN;
                }
                String driverName = dbm.getDriverName();
                if (FINER) {
                    logger.finer("DB driver name is: " + driverName);
                }
                if (driverName == null) {
                    if (!FINER) return DBType.DB2;
                    logger.finer("DB MetaInfo is null, dbtype UNKNOWN");
                    return DBType.DB2;
                }
                if ((driverName = driverName.toUpperCase()).startsWith("CLOUDSCAPE")) {
                    if (!FINER) return DBType.CLOUDSCAPE;
                    logger.finer("DB driver name reports CLOUDSCAPE");
                    return DBType.CLOUDSCAPE;
                }
                if (driverName.startsWith("IBM")) {
                    String productName = dbm.getDatabaseProductName();
                    if (productName == null) {
                        return DBType.DB2;
                    }
                    if (!(productName = productName.toUpperCase()).startsWith("CLOUDSCAPE")) return DBType.DB2;
                    return DBType.CLOUDSCAPE;
                }
                if (driverName.startsWith("ORACLE")) {
                    return DBType.ORACLE;
                }
                if (driverName.contains("DERBY")) {
                    return DBType.DERBY;
                }
                if (driverName.contains("POSTGRESQL")) {
                    return DBType.POSTGRESQL;
                }
                try (Statement stmt = null;){
                    stmt = conn.createStatement(1003, 1007);
                    stmt.execute("select @@version as ver");
                    ResultSet rs = stmt.getResultSet();
                    if (!rs.next()) return DBType.UNKNOWN;
                    String s = rs.getString("ver");
                    if (s == null) return DBType.UNKNOWN;
                    if (!s.toLowerCase().startsWith("microsoft")) return DBType.UNKNOWN;
                    DBType dBType = DBType.MSSQL;
                    return dBType;
                }
            }
            catch (SQLException dbm) {
                FFDCFilter.processException((Throwable)dbm, (String)"com.ibm.ws.security.oauth20.plugins.db.DetectDatabaseType$DetectionUtils", (String)"178", null, (Object[])new Object[]{conn});
                if (!FINER) return DBType.UNKNOWN;
                logger.finer("Exception thrown during DB detection, return type UNKNOWN");
                return DBType.UNKNOWN;
            }
        }
    }

    public static enum DBType {
        DB2(true, true),
        CLOUDSCAPE(false, true),
        ORACLE(false, true),
        MSSQL(true, true),
        DERBY(false, true),
        POSTGRESQL(false, false),
        UNKNOWN(false, true);

        private final boolean sqlLimitSupported;
        private final boolean clobSupported;

        private DBType(boolean sqlLimitSupported, boolean clobSupported) {
            this.sqlLimitSupported = sqlLimitSupported;
            this.clobSupported = clobSupported;
        }

        public final boolean isSqlLimitSupported() {
            return this.sqlLimitSupported;
        }

        public final boolean isClobSupported() {
            return this.clobSupported;
        }
    }
}

