/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.kerberos.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.kernel.LibertyProcess;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.kerberos.Krb5HelperJdk;
import com.ibm.ws.security.kerberos.internal.KerberosExtConfig;
import com.ibm.ws.security.s4u2proxy.KerberosExtService;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={KerberosExtService.class}, name="KerberosExtService", immediate=true, configurationPid={"com.ibm.ws.security.s4u2proxy.KerberosExtService"}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.vendor=IBM"})
public class KerberosExtServiceImpl
implements KerberosExtService {
    private static final TraceComponent tc = Tr.register(KerberosExtServiceImpl.class, (String)"Kerberos", (String)"com.ibm.ws.security.kerberos.internal.resources.KerberosMessages");
    static final String KEY_KRB5_HELPER_JDK = "Krb5HelperJdk";
    private KerberosExtConfig kerberosExtConfig = null;
    private Krb5HelperJdk krb5HelperJdk = null;
    static final long serialVersionUID = -5321888757327624544L;

    @Reference(policy=ReferencePolicy.STATIC, target="(java.specification.version>=1.8)")
    protected void setProcess(LibertyProcess process) {
    }

    @Reference(service=Krb5HelperJdk.class, name="Krb5HelperJdk", policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setKrb5HelperJdk(Krb5HelperJdk krb5HelperJdk) {
        this.krb5HelperJdk = krb5HelperJdk;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("The Krb5HelperJdk service with class name " + this.krb5HelperJdk.getClass().getSimpleName() + " has been activated"), (Object[])new Object[0]);
        }
    }

    protected void unsetKrb5HelperJdk(Krb5HelperJdk krb5HelperJdk) {
        if (this.krb5HelperJdk == krb5HelperJdk) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The Krb5HelperJdk service with class name " + this.krb5HelperJdk.getClass().getSimpleName() + " has been deactivated"), (Object[])new Object[0]);
            }
            this.krb5HelperJdk = null;
        }
    }

    @Activate
    protected void activate(ComponentContext cc, Map<String, Object> props) {
        this.kerberosExtConfig = new KerberosExtConfig(props);
    }

    @Modified
    protected void modified(Map<String, Object> props) {
        this.kerberosExtConfig = new KerberosExtConfig(props);
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
    }

    public GSSCredential getDelegateGSSCredUsingS4U2self(String upn, String targetServiceSpn, Oid gssNameType, int gssCredUsage, String delegateServiceSpn, Subject delegateServiceSubject) throws GSSException {
        if (this.krb5HelperJdk != null) {
            return this.krb5HelperJdk.getDelegateGSSCredUsingS4U2self(upn, targetServiceSpn, gssNameType, gssCredUsage, delegateServiceSpn, delegateServiceSubject);
        }
        return null;
    }

    public GSSCredential getDelegateGSSCredUsingS4U2proxy(String userPrincipalName, GSSContext delegateGSSContext, String delegateServiceSpn) throws GSSException {
        if (this.krb5HelperJdk != null) {
            return this.krb5HelperJdk.getDelegateGSSCredUsingS4U2proxy(userPrincipalName, delegateGSSContext, delegateServiceSpn);
        }
        return null;
    }

    public Subject doKerberosLogin(String delegateSpn, String krb5Keytab) throws LoginException {
        if (this.krb5HelperJdk != null) {
            return this.krb5HelperJdk.doKerberosLogin(null, delegateSpn, krb5Keytab);
        }
        return null;
    }

    public boolean isS4U2selfEnable() {
        return this.kerberosExtConfig != null ? this.kerberosExtConfig.isS4U2selfEnable() : false;
    }

    public boolean isS4U2proxyEnable() {
        return this.kerberosExtConfig != null ? this.kerberosExtConfig.isS4U2proxyEnable() : false;
    }
}

