/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsf.container.cdi;

import javax.faces.context.FacesContext;

public class FacesUrlTransformer {
    private static final String HTTP_PROTOCOL_URL_PREFIX = "http://";
    private static final String HTTPS_PROTOCOL_URL_PREFIX = "https://";
    private static final String QUERY_STRING_DELIMITER = "?";
    private static final String PARAMETER_PAIR_DELIMITER = "&";
    private static final String PARAMETER_PAIR_DELIMITER_ENCODED = ";";
    private static final String PARAMETER_ASSIGNMENT_OPERATOR = "=";
    private String url;
    private final FacesContext context;

    public FacesUrlTransformer(String url, FacesContext facesContext) {
        this.url = url;
        this.context = facesContext;
    }

    public FacesUrlTransformer appendConversationIdIfNecessary(String cidParameterName, String cid) {
        this.url = FacesUrlTransformer.appendParameterIfNeeded(this.url, cidParameterName, cid);
        return this;
    }

    private static String appendParameterIfNeeded(String url, String parameterName, String parameterValue) {
        int queryStringIndex = url.indexOf(QUERY_STRING_DELIMITER);
        if (queryStringIndex < 0 || FacesUrlTransformer.isCidParamAbsent(url, parameterName, queryStringIndex)) {
            StringBuilder builder = new StringBuilder(url);
            if (queryStringIndex < 0) {
                builder.append(QUERY_STRING_DELIMITER);
            } else {
                builder.append(PARAMETER_PAIR_DELIMITER);
            }
            builder.append(parameterName).append(PARAMETER_ASSIGNMENT_OPERATOR);
            if (parameterValue != null) {
                builder.append(parameterValue);
            }
            return builder.toString();
        }
        return url;
    }

    private static boolean isCidParamAbsent(String url, String parameterName, int queryStringIndex) {
        return url.indexOf(QUERY_STRING_DELIMITER + parameterName + PARAMETER_ASSIGNMENT_OPERATOR, queryStringIndex) < 0 && url.indexOf(PARAMETER_PAIR_DELIMITER + parameterName + PARAMETER_ASSIGNMENT_OPERATOR, queryStringIndex) < 0 && url.indexOf(PARAMETER_PAIR_DELIMITER_ENCODED + parameterName + PARAMETER_ASSIGNMENT_OPERATOR, queryStringIndex) < 0;
    }

    public String getUrl() {
        return this.url;
    }

    public FacesUrlTransformer toRedirectViewId() {
        String requestPath = this.context.getExternalContext().getRequestContextPath();
        if (this.isUrlAbsolute()) {
            this.url = this.url.substring(this.url.indexOf(requestPath) + requestPath.length());
        } else if (this.url.startsWith(requestPath)) {
            this.url = this.url.substring(requestPath.length());
        }
        return this;
    }

    public FacesUrlTransformer toActionUrl() {
        String actionUrl = this.context.getApplication().getViewHandler().getActionURL(this.context, this.url);
        int queryStringIndex = this.url.indexOf(QUERY_STRING_DELIMITER);
        if (queryStringIndex < 0) {
            this.url = actionUrl;
        } else {
            String actionQueryParameters;
            String queryParameters = this.url.substring(queryStringIndex + 1);
            int actionQueryStringIndex = actionUrl.indexOf(QUERY_STRING_DELIMITER);
            this.url = actionQueryStringIndex < 0 ? actionUrl + QUERY_STRING_DELIMITER + queryParameters : (queryParameters.startsWith(actionQueryParameters = actionUrl.substring(actionQueryStringIndex + 1)) ? actionUrl.substring(0, actionQueryStringIndex) + QUERY_STRING_DELIMITER + queryParameters : actionUrl + PARAMETER_PAIR_DELIMITER + queryParameters);
        }
        return this;
    }

    public String encode() {
        return this.context.getExternalContext().encodeActionURL(this.url);
    }

    private boolean isUrlAbsolute() {
        return this.url.startsWith(HTTP_PROTOCOL_URL_PREFIX) || this.url.startsWith(HTTPS_PROTOCOL_URL_PREFIX);
    }
}

