/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.social.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.social.SslRefInfo;
import com.ibm.ws.security.social.error.SocialLoginException;
import com.ibm.ws.ssl.KeyStoreService;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.ssl.SSLSupport;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.crypto.SecretKey;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SslRefInfoImpl
implements SslRefInfo {
    public static final TraceComponent tc = Tr.register(SslRefInfoImpl.class, (String)"SOCIAL", (String)"com.ibm.ws.security.social.resources.SocialMessages");
    SSLSupport sslSupport = null;
    String sslRef = null;
    JSSEHelper jsseHelper = null;
    String sslKeyStoreName = null;
    String sslTrustStoreName = null;
    private String keyAliasName = null;
    AtomicServiceReference<KeyStoreService> keyStoreServiceRef = null;
    static final long serialVersionUID = -6158462534266804505L;

    public SslRefInfoImpl(SSLSupport sslSupport, AtomicServiceReference<KeyStoreService> keyStoreServiceRef, String sslRef, String keyAliasName) {
        this.sslSupport = sslSupport;
        this.sslRef = sslRef;
        this.keyStoreServiceRef = keyStoreServiceRef;
        this.keyAliasName = keyAliasName;
    }

    @Override
    public String getTrustStoreName() throws SocialLoginException {
        if (this.sslTrustStoreName == null) {
            this.init();
        }
        return this.sslTrustStoreName;
    }

    @Override
    public String getKeyStoreName() throws SocialLoginException {
        if (this.sslKeyStoreName == null) {
            this.init();
        }
        return this.sslKeyStoreName;
    }

    /*
     * WARNING - void declaration
     */
    void init() throws SocialLoginException {
        if (this.sslSupport != null) {
            Properties sslProps = null;
            this.jsseHelper = this.sslSupport.getJSSEHelper();
            if (this.jsseHelper != null) {
                try {
                    if (this.sslRef != null) {
                        sslProps = this.jsseHelper.getProperties(this.sslRef);
                    } else {
                        HashMap<String, String> connectionInfo = new HashMap<String, String>();
                        connectionInfo.put("com.ibm.ssl.direction", "inbound");
                        sslProps = this.jsseHelper.getProperties(null, connectionInfo, null, true);
                    }
                }
                catch (SSLException connectionInfo) {
                    void e;
                    FFDCFilter.processException((Throwable)connectionInfo, (String)"com.ibm.ws.security.social.internal.SslRefInfoImpl", (String)"88", (Object)this, (Object[])new Object[0]);
                    throw new SocialLoginException("ERROR_LOADING_SSL_PROPS", (Exception)e, new Object[]{e.getLocalizedMessage()});
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("sslConfig (" + this.sslRef + ") get: " + sslProps), (Object[])new Object[0]);
                }
                if (sslProps != null) {
                    this.sslKeyStoreName = sslProps.getProperty("com.ibm.ssl.keyStoreName");
                    this.sslTrustStoreName = sslProps.getProperty("com.ibm.ssl.trustStoreName");
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("sslTrustStoreName: " + this.sslTrustStoreName), (Object[])new Object[0]);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HashMap<String, PublicKey> getPublicKeys() throws SocialLoginException {
        if (this.jsseHelper == null) {
            this.init();
        }
        HashMap<String, PublicKey> publicKeys = new HashMap<String, PublicKey>();
        if (this.sslTrustStoreName != null) {
            KeyStoreService keyStoreService = (KeyStoreService)this.keyStoreServiceRef.getService();
            if (keyStoreService == null) {
                throw new SocialLoginException("KEYSTORE_SERVICE_NOT_FOUND", null, new Object[0]);
            }
            Collection names = null;
            try {
                names = keyStoreService.getTrustedCertEntriesInKeyStore(this.sslTrustStoreName);
            }
            catch (KeyStoreException keyStoreException) {
                void e;
                FFDCFilter.processException((Throwable)keyStoreException, (String)"com.ibm.ws.security.social.internal.SslRefInfoImpl", (String)"126", (Object)this, (Object[])new Object[0]);
                throw new SocialLoginException("ERROR_LOADING_KEYSTORE_CERTIFICATES", (Exception)e, new Object[]{this.sslTrustStoreName, e.getLocalizedMessage()});
            }
            for (String aliasName : names) {
                PublicKey publicKey = null;
                try {
                    publicKey = keyStoreService.getCertificateFromKeyStore(this.sslTrustStoreName, aliasName).getPublicKey();
                }
                catch (GeneralSecurityException generalSecurityException) {
                    void e;
                    FFDCFilter.processException((Throwable)generalSecurityException, (String)"com.ibm.ws.security.social.internal.SslRefInfoImpl", (String)"135", (Object)this, (Object[])new Object[0]);
                    throw new SocialLoginException("ERROR_LOADING_CERTIFICATE", (Exception)e, new Object[]{aliasName, this.sslTrustStoreName, e.getLocalizedMessage()});
                }
                publicKeys.put(aliasName, publicKey);
            }
        }
        return publicKeys;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @FFDCIgnore(value={SocialLoginException.class})
    public PublicKey getPublicKey() throws SocialLoginException {
        if (this.jsseHelper == null) {
            this.init();
        }
        if (this.sslKeyStoreName != null) {
            if (this.keyAliasName != null && !this.keyAliasName.trim().isEmpty()) {
                KeyStoreService keyStoreService = (KeyStoreService)this.keyStoreServiceRef.getService();
                if (keyStoreService == null) {
                    throw new SocialLoginException("KEYSTORE_SERVICE_NOT_FOUND", null, new Object[0]);
                }
                try {
                    return keyStoreService.getCertificateFromKeyStore(this.sslKeyStoreName, this.keyAliasName).getPublicKey();
                }
                catch (GeneralSecurityException generalSecurityException) {
                    void e;
                    FFDCFilter.processException((Throwable)generalSecurityException, (String)"com.ibm.ws.security.social.internal.SslRefInfoImpl", (String)"161", (Object)this, (Object[])new Object[0]);
                    throw new SocialLoginException("ERROR_LOADING_CERTIFICATE", (Exception)e, new Object[]{this.keyAliasName, this.sslTrustStoreName, e.getLocalizedMessage()});
                }
            }
            Iterator<Map.Entry<String, PublicKey>> publicKeysIterator = null;
            try {
                publicKeysIterator = this.getPublicKeys().entrySet().iterator();
            }
            catch (SocialLoginException e) {
                throw new SocialLoginException("ERROR_LOADING_GETTING_PUBLIC_KEYS", e, new Object[]{this.keyAliasName, this.sslTrustStoreName, e.getLocalizedMessage()});
            }
            if (publicKeysIterator.hasNext()) {
                return publicKeysIterator.next().getValue();
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PrivateKey getPrivateKey() throws SocialLoginException {
        if (this.jsseHelper == null) {
            this.init();
        }
        if (this.sslKeyStoreName != null) {
            KeyStoreService keyStoreService = (KeyStoreService)this.keyStoreServiceRef.getService();
            if (keyStoreService == null) {
                throw new SocialLoginException("KEYSTORE_SERVICE_NOT_FOUND", null, new Object[0]);
            }
            if (this.keyAliasName != null && !this.keyAliasName.trim().isEmpty()) {
                try {
                    return keyStoreService.getPrivateKeyFromKeyStore(this.sslKeyStoreName, this.keyAliasName, null);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    void e;
                    FFDCFilter.processException((Throwable)generalSecurityException, (String)"com.ibm.ws.security.social.internal.SslRefInfoImpl", (String)"195", (Object)this, (Object[])new Object[0]);
                    throw new SocialLoginException("ERROR_LOADING_SPECIFIC_PRIVATE_KEY", (Exception)e, new Object[]{this.keyAliasName, this.sslKeyStoreName, e.getLocalizedMessage()});
                }
            }
            try {
                return keyStoreService.getPrivateKeyFromKeyStore(this.sslKeyStoreName);
            }
            catch (GeneralSecurityException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.social.internal.SslRefInfoImpl", (String)"202", (Object)this, (Object[])new Object[0]);
                throw new SocialLoginException("ERROR_LOADING_PRIVATE_KEY", e, new Object[]{this.sslKeyStoreName, e.getLocalizedMessage()});
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SecretKey getSecretKey() throws SocialLoginException {
        if (this.jsseHelper == null) {
            this.init();
        }
        if (this.sslKeyStoreName != null && this.keyAliasName != null && !this.keyAliasName.trim().isEmpty()) {
            KeyStoreService keyStoreService = (KeyStoreService)this.keyStoreServiceRef.getService();
            if (keyStoreService == null) {
                throw new SocialLoginException("KEYSTORE_SERVICE_NOT_FOUND", null, new Object[0]);
            }
            try {
                return keyStoreService.getSecretKeyFromKeyStore(this.sslKeyStoreName, this.keyAliasName, null);
            }
            catch (GeneralSecurityException generalSecurityException) {
                void e;
                FFDCFilter.processException((Throwable)generalSecurityException, (String)"com.ibm.ws.security.social.internal.SslRefInfoImpl", (String)"224", (Object)this, (Object[])new Object[0]);
                throw new SocialLoginException("ERROR_LOADING_SECRET_KEY", (Exception)e, new Object[]{this.keyAliasName, this.sslKeyStoreName, e.getLocalizedMessage()});
            }
        }
        return null;
    }
}

