/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.featureUtility;

import com.ibm.websphere.crypto.InvalidPasswordDecodingException;
import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.crypto.UnsupportedCryptoAlgorithmException;
import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.featureUtility.props.FeatureUtilityProperties;
import com.ibm.ws.install.internal.InstallKernelMap;
import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.InstallUtils;
import com.ibm.ws.install.internal.LicenseUpgradeUtility;
import com.ibm.ws.install.internal.ProgressBar;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FeatureUtility {
    private final InstallKernelMap map;
    private File fromDir;
    private final List<File> esaFiles;
    private final Boolean noCache;
    private final Boolean licenseAccepted;
    private final List<String> featuresToInstall;
    private final List<String> additionalJsons;
    private static String openLibertyVersion;
    private static String openLibertyEdition;
    private final Logger logger = InstallLogUtils.getInstallLogger();
    private ProgressBar progressBar = ProgressBar.getInstance();
    private Map<String, String> featureToExt;
    private static final String OPEN_LIBERTY_PRODUCT_ID = "io.openliberty";
    private static final String WEBSPHERE_LIBERTY_GROUP_ID = "com.ibm.websphere.appserver.features";
    private static final String BETA_EDITION = "EARLY_ACCESS";
    private static String to;
    private boolean isInstallServerFeature = false;

    private FeatureUtility(FeatureUtilityBuilder builder) throws IOException, InstallException {
        boolean isOpenLiberty;
        openLibertyVersion = this.getLibertyVersion();
        if (openLibertyEdition.equals(BETA_EDITION)) {
            throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getMessage("ERROR_BETA_EDITION_NOT_SUPPORTED", new Object[0]));
        }
        this.additionalJsons = builder.additionalJsons;
        to = builder.to;
        this.fromDir = builder.fromDir;
        ArrayList<String> rawFeatures = new ArrayList<String>(builder.featuresToInstall);
        Map<String, Set<String>> jsonsAndFeatures = this.getJsonsAndFeatures(rawFeatures);
        this.featuresToInstall = new ArrayList<String>((Collection)jsonsAndFeatures.get("features"));
        Set<String> jsonsList = jsonsAndFeatures.get("jsons");
        HashSet<String> jsonsRequired = new HashSet<String>();
        for (String groupId : jsonsList) {
            jsonsRequired.add(String.format("%s:%s:%s", groupId, "features", openLibertyVersion));
        }
        jsonsRequired.addAll(Arrays.asList(String.format("io.openliberty.features:features:%s", openLibertyVersion)));
        this.esaFiles = builder.esaFiles;
        this.noCache = builder.noCache;
        this.licenseAccepted = builder.licenseAccepted;
        this.featureToExt = new HashMap<String, String>();
        this.map = new InstallKernelMap();
        this.info(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_INITIALIZING", new Object[0]));
        this.map.put((Object)"req.ol.json.coord", (Object)"io.openliberty.features");
        Map envMap = (Map)this.map.get((Object)"environment.variable.map");
        if (envMap == null) {
            throw new InstallException((String)this.map.get((Object)"action.error.message"));
        }
        this.fine("Environment variables: ");
        Set envMapKeys = envMap.keySet();
        for (Object key : envMapKeys) {
            if (((String)key).equals("FEATURE_REPO_PASSWORD")) {
                this.fine("FEATURE_REPO_PASSWORD: *********");
                continue;
            }
            if (((String)key).equals("FEATURE_LOCAL_REPO") && envMap.get("FEATURE_LOCAL_REPO") != null) {
                File local_repo;
                this.fine((String)key + ": " + envMap.get(key));
                this.fromDir = local_repo = new File((String)envMap.get("FEATURE_LOCAL_REPO"));
                continue;
            }
            this.fine((String)key + ": " + envMap.get(key));
        }
        this.map.put((Object)"json.provided", (Object)false);
        this.overrideEnvMapWithProperties();
        this.fine("additional jsons: " + this.additionalJsons);
        if (this.additionalJsons != null && !this.additionalJsons.isEmpty()) {
            jsonsRequired.addAll(this.additionalJsons);
            if (!this.additionalJsons.contains(String.format("com.ibm.websphere.appserver.features:features:%s", openLibertyVersion))) {
                jsonsRequired.add(String.format("com.ibm.websphere.appserver.features:features:%s", openLibertyVersion));
            }
            this.map.put((Object)"json.provided", (Object)true);
        }
        if (!(isOpenLiberty = ((Boolean)this.map.get((Object)"is.open.liberty")).booleanValue())) {
            jsonsRequired.add(String.format("com.ibm.websphere.appserver.features:features:%s", openLibertyVersion));
        } else {
            for (String s : jsonsRequired) {
                if (!s.contains(WEBSPHERE_LIBERTY_GROUP_ID) || this.additionalJsons != null && !this.additionalJsons.isEmpty()) continue;
                throw new InstallException("Incorrectly tried to install a websphere liberty feature onto open liberty");
            }
        }
        if (this.noCache != null && this.noCache.booleanValue()) {
            this.fine("Features installed from the remote repository will not be cached locally");
        }
        this.map.put((Object)"cleanup.needed", (Object)this.noCache);
        List<File> jsonPaths = this.getJsonFiles(this.fromDir, jsonsRequired);
        this.updateProgress(this.progressBar.getMethodIncrement("fetchJsons"));
        this.fine("Finished finding jsons");
        this.initializeMap(jsonPaths);
        this.updateProgress(this.progressBar.getMethodIncrement("initializeMap"));
        this.fine("Initialized install kernel map");
    }

    public void setFeatureToExt(Map<String, String> featureToExt) {
        this.featureToExt = featureToExt;
    }

    public void setIsInstallServerFeature(boolean isInstallServerFeature) {
        this.isInstallServerFeature = isInstallServerFeature;
    }

    private void initializeMap(List<File> jsonPaths) throws IOException {
        this.map.put((Object)"is.feature.utility", (Object)true);
        this.map.put((Object)"runtime.install.dir", (Object)Utils.getInstallDir());
        this.map.put((Object)"target.user.directory", (Object)new File(Utils.getInstallDir(), "usr"));
        this.map.put((Object)"install.local.esa", (Object)true);
        this.map.put((Object)"single.json.file", jsonPaths);
        if (this.featuresToInstall != null) {
            this.map.put((Object)"features.to.resolve", this.featuresToInstall);
        }
        if (this.esaFiles != null && !this.esaFiles.isEmpty()) {
            this.map.put((Object)"individual.esas", this.esaFiles);
            this.map.put((Object)"install.individual.esas", (Object)true);
        }
        this.map.put((Object)"license.accept", (Object)this.licenseAccepted);
        this.map.get((Object)"install.kernel.init.code");
    }

    private void overrideEnvMapWithProperties() throws InstallException {
        if (!FeatureUtilityProperties.didLoadProperties()) {
            this.logger.fine("No featureUtility.properties detected.");
            return;
        }
        HashMap<String, Object> overrideMap = new HashMap<String, Object>();
        this.logger.fine("Overriding the environment variables using featureUtility.properties");
        String host = FeatureUtilityProperties.getProxyHost();
        String port = FeatureUtilityProperties.getProxyPort();
        String username = FeatureUtilityProperties.getProxyUser();
        String password = FeatureUtilityProperties.getProxyPassword();
        String protocol = null;
        if (host != null && !host.isEmpty()) {
            protocol = host.toLowerCase().startsWith("https://") ? "https" : "http";
        }
        if (protocol != null && !protocol.isEmpty()) {
            if (port == null || port.isEmpty()) {
                throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_PROXY_PORT_MISSING", new Object[0]), 24);
            }
            overrideMap.put(protocol + ".proxyHost", host);
            overrideMap.put(protocol + ".proxyPort", port);
            String decodedPwd = password;
            if (decodedPwd != null && !decodedPwd.isEmpty()) {
                try {
                    decodedPwd = PasswordUtil.decode((String)password);
                }
                catch (InvalidPasswordDecodingException ipde) {
                    decodedPwd = password;
                    this.logger.log(Level.FINE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("LOG_PASSWORD_NOT_ENCODED_PROXY", new Object[]{host + ":" + port}) + InstallUtils.NEWLINE);
                }
                catch (UnsupportedCryptoAlgorithmException ucae) {
                    throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_PROXY_PWD_CRYPTO_UNSUPPORTED", new Object[0]), (Throwable)ucae, 21);
                }
            }
            overrideMap.put(protocol + ".proxyUser", username);
            overrideMap.put(protocol + ".proxyPassword", decodedPwd);
        }
        if (FeatureUtilityProperties.getFeatureLocalRepo() != null) {
            overrideMap.put("FEATURE_LOCAL_REPO", FeatureUtilityProperties.getFeatureLocalRepo());
            this.fromDir = new File(FeatureUtilityProperties.getFeatureLocalRepo());
        }
        if (!FeatureUtilityProperties.isUsingDefaultRepo()) {
            overrideMap.put("FEATURE_UTILITY_MAVEN_REPOSITORIES", FeatureUtilityProperties.getMirrorRepositories());
        }
        if (FeatureUtilityProperties.bomIdsRequired()) {
            List<String> boms = FeatureUtilityProperties.getBomIds();
            for (String bom : boms) {
                String[] bomSplit = bom.split(":");
                if (bomSplit.length != 3) {
                    throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getMessage("ERROR_INVALID_FEATURE_BOM_COORDINATE", new Object[]{bom}));
                }
                String groupId = bomSplit[0];
                String artifactId = "features";
                String version = bomSplit[2];
                this.additionalJsons.add(String.format("%s:%s:%s", groupId, artifactId, version));
                this.map.put((Object)"json.provided", (Object)true);
            }
        }
        this.map.put((Object)"override.environment.variables", overrideMap);
    }

    private Map<String, Set<String>> getJsonsAndFeatures(List<String> featureNames) throws IOException, InstallException {
        HashMap<String, Set<String>> jsonsAndFeatures = new HashMap<String, Set<String>>();
        HashSet<String> jsonsRequired = new HashSet<String>();
        HashSet<String> featuresRequired = new HashSet<String>();
        String openLibertyVersion = this.getLibertyVersion();
        String packaging = null;
        for (String feature : featureNames) {
            String version;
            String artifactId;
            String groupId;
            String[] mavenCoords = feature.split(":");
            switch (mavenCoords.length) {
                case 1: {
                    groupId = "io.openliberty.features";
                    artifactId = mavenCoords[0];
                    version = openLibertyVersion;
                    packaging = "esa";
                    break;
                }
                case 2: {
                    groupId = mavenCoords[0];
                    artifactId = mavenCoords[1];
                    version = openLibertyVersion;
                    packaging = "esa";
                    break;
                }
                case 3: {
                    groupId = mavenCoords[0];
                    artifactId = mavenCoords[1];
                    version = mavenCoords[2];
                    packaging = "esa";
                    break;
                }
                case 4: {
                    groupId = mavenCoords[0];
                    artifactId = mavenCoords[1];
                    version = mavenCoords[2];
                    packaging = mavenCoords[3];
                    break;
                }
                default: {
                    throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getMessage("ERROR_MAVEN_COORDINATE_INVALID", new Object[]{feature}));
                }
            }
            this.verifyMavenCoordinate(feature, groupId, artifactId, version, packaging);
            jsonsRequired.add(groupId);
            featuresRequired.add(artifactId);
        }
        jsonsAndFeatures.put("jsons", jsonsRequired);
        jsonsAndFeatures.put("features", featuresRequired);
        return jsonsAndFeatures;
    }

    private void verifyMavenCoordinate(String feature, String groupId, String artifactId, String version, String packaging) throws IOException, InstallException {
        if (groupId.isEmpty() || artifactId.isEmpty() || version.isEmpty() || packaging.isEmpty()) {
            throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getMessage("ERROR_MAVEN_COORDINATE_INVALID", new Object[]{feature}));
        }
        String openLibertyVersion = this.getLibertyVersion();
        if (!version.equals(openLibertyVersion)) {
            throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getMessage("ERROR_MAVEN_COORDINATE_WRONG_VERSION", new Object[]{feature, openLibertyVersion}));
        }
        if (!"esa".equals(packaging)) {
            throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getMessage("ERROR_MAVEN_COORDINATE_WRONG_PACKAGING", new Object[]{feature}));
        }
    }

    private String getLibertyVersion() throws IOException, InstallException {
        if (openLibertyVersion != null) {
            return openLibertyVersion;
        }
        if (openLibertyEdition != null) {
            return openLibertyEdition;
        }
        File propertiesFile = new File(Utils.getInstallDir(), "lib/versions/openliberty.properties");
        String openLibertyVersion = null;
        String openLibertyEdition = null;
        Properties properties = new Properties();
        try (FileInputStream input = new FileInputStream(propertiesFile);){
            properties.load(input);
            String productId = properties.getProperty("com.ibm.websphere.productId");
            String productVersion = properties.getProperty("com.ibm.websphere.productVersion");
            String productEdition = properties.getProperty("com.ibm.websphere.productEdition");
            if (productId.equals(OPEN_LIBERTY_PRODUCT_ID)) {
                openLibertyVersion = productVersion;
                openLibertyEdition = productEdition;
            }
        }
        if (openLibertyVersion == null || openLibertyEdition == null) {
            throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getMessage("ERROR_COULD_NOT_DETERMINE_RUNTIME_PROPERTIES_FILE", new Object[]{propertiesFile.getAbsolutePath()}));
        }
        FeatureUtility.openLibertyVersion = openLibertyVersion;
        FeatureUtility.openLibertyEdition = openLibertyEdition;
        return openLibertyVersion;
    }

    public Set<String> findFeatures() {
        String query = String.join((CharSequence)" ", this.featuresToInstall);
        this.map.put((Object)"action.find", (Object)query);
        Set features = (Set)this.map.get((Object)"action.result");
        if (features.isEmpty()) {
            this.info(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getMessage("MSG_NO_FEATURES_FOUND", new Object[0]));
        } else {
            for (String feature : features) {
                this.info(feature);
            }
        }
        return features;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installFeatures() throws InstallException, IOException {
        this.info(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_RESOLVING", new Object[0]));
        if (this.fromDir != null) {
            this.map.put((Object)"from.repo", (Object)this.fromDir.toString());
        }
        this.map.put((Object)"is.install.server.feature", (Object)this.isInstallServerFeature);
        Collection resolvedFeatures = (Collection)this.map.get((Object)"action.result");
        this.checkResolvedFeatures(resolvedFeatures);
        boolean upgraded = (Boolean)this.map.get((Object)"upgrade.complete");
        List causedUpgrade = (List)this.map.get((Object)"caused.upgrade");
        if (upgraded) {
            LicenseUpgradeUtility luu = new LicenseUpgradeUtility.LicenseUpgradeUtilityBuilder().setFeatures(this.featuresToInstall).setAcceptLicense(this.licenseAccepted).build();
            boolean isLicenseAccepted = false;
            try {
                isLicenseAccepted = luu.handleLicenses(this.featureFormat(causedUpgrade));
            }
            catch (InstallException e) {
                this.map.get((Object)"cleanup.upgrade");
                throw e;
            }
            if (!isLicenseAccepted) {
                this.map.get((Object)"cleanup.upgrade");
                throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_LICENSES_NOT_ACCEPTED", new Object[0]));
            }
            luu.handleOLLicense();
        }
        this.updateProgress(this.progressBar.getMethodIncrement("resolvedFeatures"));
        this.info(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_PREPARING_ASSETS", new Object[0]));
        List<File> artifacts = this.fromDir != null ? this.downloadFeaturesFrom(resolvedFeatures, this.fromDir) : this.downloadFeatureEsas((List)resolvedFeatures);
        this.updateProgress(this.progressBar.getMethodIncrement("downloadArtifacts"));
        this.info(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_STARTING_INSTALL", new Object[0]));
        ArrayList actionReturnResult = new ArrayList();
        try {
            double increment = this.progressBar.getMethodIncrement("installFeatures") / (double)artifacts.size();
            for (File esaFile : artifacts) {
                String featureName = this.extractFeature(esaFile.getName());
                this.fine(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_INSTALLING", new Object[]{featureName}));
                this.map.put((Object)"license.accept", (Object)true);
                this.map.put((Object)"action.install", (Object)esaFile);
                String ext = this.featureToExt.get(featureName);
                if (to != null) {
                    this.map.put((Object)"to.extension", (Object)to);
                    this.fine("Installing to extension: " + to);
                }
                if (ext != null && ext != "") {
                    this.map.put((Object)"to.extension", (Object)ext);
                    this.fine("Installing to extension from server.xml: " + ext);
                }
                this.map.get((Object)"action.result");
                if (this.map.get((Object)"action.error.message") != null) {
                    this.fine("action.exception.stacktrace: " + this.map.get((Object)"action.error.stacktrace"));
                    String exceptionMessage = (String)this.map.get((Object)"action.error.message");
                    throw new InstallException(exceptionMessage);
                }
                List currentReturnResult = (List)this.map.get((Object)"action.install.result");
                if (currentReturnResult != null) {
                    if (!currentReturnResult.isEmpty()) {
                        actionReturnResult.addAll((Collection)this.map.get((Object)"action.install.result"));
                        this.updateProgress(increment);
                        this.info(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("LOG_INSTALLED_FEATURE", new Object[]{currentReturnResult.get(0)}).replace("CWWKF1304I: ", ""));
                    } else {
                        this.updateProgress(increment);
                        this.progressBar.manuallyUpdate();
                    }
                }
                this.map.put((Object)"to.extension", (Object)"usr");
            }
            this.info(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("TOOL_FEATURES_INSTALLATION_COMPLETED", new Object[0]));
        }
        finally {
            this.cleanUp();
        }
    }

    private String featureFormat(List<String> causedUpgrade) {
        if (causedUpgrade.size() == 1) {
            return causedUpgrade.get(0);
        }
        if (causedUpgrade.size() == 2) {
            return causedUpgrade.get(0) + " and " + causedUpgrade.get(1);
        }
        if (causedUpgrade.size() > 2) {
            String result = "";
            for (String str : causedUpgrade) {
                if (causedUpgrade.indexOf(str) == 0) {
                    result = result + causedUpgrade.get(0);
                    continue;
                }
                if (causedUpgrade.indexOf(str) < causedUpgrade.size() - 1) {
                    result = result + ", " + causedUpgrade.get(causedUpgrade.indexOf(str));
                    continue;
                }
                result = result + ", and " + causedUpgrade.get(causedUpgrade.indexOf(str));
            }
            return result;
        }
        return null;
    }

    private void checkResolvedFeatures(Collection<String> resolvedFeatures) throws InstallException {
        if (resolvedFeatures == null) {
            throw new InstallException((String)this.map.get((Object)"action.error.message"));
        }
        if (resolvedFeatures.isEmpty()) {
            String exceptionMessage = (String)this.map.get((Object)"action.error.message");
            if (exceptionMessage == null) {
                throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ALREADY_INSTALLED", new Object[]{this.map.get((Object)"features.to.resolve")}));
            }
            if (exceptionMessage.contains("CWWKF1250I")) {
                throw new InstallException(exceptionMessage);
            }
            throw new InstallException(exceptionMessage);
        }
    }

    private List<File> downloadFeaturesFrom(Collection<String> resolvedFeatures, File fromDir) throws InstallException {
        this.map.put((Object)"from.repo", (Object)fromDir.toString());
        return this.downloadFeatureEsas(resolvedFeatures);
    }

    private List<File> downloadFeatureEsas(Collection<String> resolvedFeatures) throws InstallException {
        this.map.put((Object)"download.artifact.list", resolvedFeatures);
        boolean singleArtifactInstall = false;
        this.map.put((Object)"download.individual.artifact", (Object)singleArtifactInstall);
        List result = (List)this.map.get((Object)"download.result");
        if (this.map.get((Object)"action.error.message") != null) {
            this.fine("action.exception.stacktrace: " + this.map.get((Object)"action.error.stacktrace"));
            String exceptionMessage = (String)this.map.get((Object)"action.error.message");
            throw new InstallException(exceptionMessage);
        }
        return result;
    }

    public List<String> resolveFeatures(boolean isShortNames) throws InstallException {
        this.map.put((Object)"download.location", (Object)this.fromDir.toString());
        ArrayList<String> shortNames = new ArrayList<String>();
        if (!isShortNames) {
            this.info("Preparing assets for installation. This process might take several minutes to complete.");
            this.info("Resolving features...");
            for (String mavenCoord : this.featuresToInstall) {
                shortNames.add(mavenCoord.split(":")[1]);
            }
            this.featuresToInstall.clear();
            this.featuresToInstall.addAll(shortNames);
        }
        if (this.featuresToInstall != null) {
            this.map.put((Object)"features.to.resolve", this.featuresToInstall);
        }
        List resolvedFeatures = (List)this.map.get((Object)"action.result");
        this.checkResolvedFeatures(resolvedFeatures);
        if (!isShortNames) {
            this.updateProgress(this.progressBar.getMethodIncrement("resolveArtifact"));
            this.info("Features resolved.");
        }
        return resolvedFeatures;
    }

    public void downloadFeatures(List<String> resolvedFeatures) throws InstallException {
        this.info("Starting Download...");
        this.downloadFeaturesFrom(resolvedFeatures, this.fromDir);
        this.info("\n");
        this.info("All assets were successfully downloaded.");
    }

    private String extractFeature(String filename) {
        return filename.replaceFirst("(-\\d\\d\\.\\d\\.\\d\\.\\d\\.esa)", "");
    }

    public List<File> getJsonFiles(File fromDir, Set<String> jsonsRequired) throws InstallException {
        if (jsonsRequired.isEmpty()) {
            throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getMessage("ERROR_FEATURES_LIST_INVALID", new Object[0]));
        }
        ArrayList<File> jsonFiles = new ArrayList<File>();
        if (fromDir != null) {
            this.map.put((Object)"download.location", (Object)fromDir.toString());
        }
        this.fine("JSONs required: " + jsonsRequired.toString());
        jsonFiles.addAll(this.map.getLocalJsonFiles(jsonsRequired));
        List foundJsons = (List)this.map.get((Object)"locally.present.jsons");
        this.fine("Found the following jsons locally: " + jsonFiles);
        if (jsonFiles.isEmpty() || jsonFiles.size() != jsonsRequired.size()) {
            this.fine("Could not find all json files from local directories, now downloading from Maven..");
            jsonsRequired.removeAll(foundJsons);
            jsonFiles.addAll(this.map.getJsonsFromMavenCentral(jsonsRequired));
            if (this.map.get((Object)"action.error.message") != null) {
                this.fine("action.exception.stacktrace: " + this.map.get((Object)"action.error.stacktrace"));
                String exceptionMessage = (String)this.map.get((Object)"action.error.message");
                throw new InstallException(exceptionMessage);
            }
        }
        return jsonFiles;
    }

    private void cleanUp() throws IOException {
        String tempStr = (String)this.map.get((Object)"cleanup.temp.location");
        Boolean cleanupNeeded = (Boolean)this.map.get((Object)"cleanup.needed");
        boolean deleted = true;
        if (cleanupNeeded != null && cleanupNeeded.booleanValue()) {
            File temp = new File(tempStr);
            this.fine("Cleaning directory: " + tempStr);
            deleted = this.deleteFolder(temp);
        }
        this.updateProgress(this.progressBar.getMethodIncrement("cleanUp"));
        this.progressBar.manuallyUpdate();
        if (deleted) {
            this.fine(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("MSG_CLEANUP_SUCCESS", new Object[0]));
        } else {
            this.severe(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("LOG_CANNOT_CLOSE_OBJECT", new Object[0]));
        }
    }

    private boolean deleteFolder(File file) throws IOException {
        Path path = file.toPath();
        if (!path.toFile().exists()) {
            return true;
        }
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
        return !file.exists();
    }

    private File getM2Cache() {
        return Paths.get(System.getProperty("user.home"), ".m2", "repository", "").toFile();
    }

    private void updateProgress(double increment) {
        this.progressBar.updateProgress(increment);
    }

    private void info(String msg) {
        this.logger.info(msg);
    }

    private void fine(String msg) {
        this.logger.fine(msg);
    }

    private void severe(String msg) {
        this.logger.severe(msg);
    }

    public static List<String> getMissingArtifactsFromFolder(List<String> artifacts, String location, boolean isShortName) throws IOException, InstallException {
        ArrayList<String> result = new ArrayList<String>();
        for (String id : artifacts) {
            Path featurePath;
            String groupId;
            if (isShortName) {
                groupId = "io.openliberty.features";
                File groupDir = new File(location, groupId.replace(".", "/"));
                if (!groupDir.exists()) {
                    result.add(id);
                    continue;
                }
                String featureEsa = id + "-" + openLibertyVersion + ".esa";
                featurePath = Paths.get(groupDir.getAbsolutePath().toString(), id, openLibertyVersion, featureEsa);
            } else {
                groupId = id.split(":")[0];
                String featureName = id.split(":")[1];
                File groupDir = new File(location, groupId.replace(".", "/"));
                if (!groupDir.exists()) {
                    result.add(id);
                    continue;
                }
                String featureEsa = featureName + "-" + openLibertyVersion + ".esa";
                featurePath = Paths.get(groupDir.getAbsolutePath().toString(), featureName, openLibertyVersion, featureEsa);
            }
            if (Files.isRegularFile(featurePath, new LinkOption[0])) continue;
            result.add(id);
        }
        return result;
    }

    public List<String> getMavenCoords(List<String> artifactShortNames) {
        ArrayList<String> result = new ArrayList<String>();
        for (String shortName : artifactShortNames) {
            result.add("io.openliberty.feature:" + shortName + ":" + openLibertyVersion);
        }
        return result;
    }

    public static class FeatureUtilityBuilder {
        File fromDir;
        Collection<String> featuresToInstall;
        List<String> additionalJsons;
        List<File> esaFiles;
        boolean noCache;
        boolean licenseAccepted;
        String to;

        public FeatureUtilityBuilder setFromDir(String fromDir) {
            this.fromDir = fromDir != null ? new File(fromDir) : null;
            return this;
        }

        public FeatureUtilityBuilder setEsaFiles(List<File> esaFiles) {
            this.esaFiles = esaFiles;
            return this;
        }

        public FeatureUtilityBuilder setNoCache(Boolean noCache) {
            this.noCache = noCache;
            return this;
        }

        public FeatureUtilityBuilder setlicenseAccepted(Boolean licenseAccepted) {
            this.licenseAccepted = licenseAccepted;
            return this;
        }

        public FeatureUtilityBuilder setFeaturesToInstall(Collection<String> featuresToInstall) {
            this.featuresToInstall = featuresToInstall;
            return this;
        }

        public FeatureUtilityBuilder setAdditionalJsons(List<String> additionalJsons) {
            this.additionalJsons = additionalJsons;
            return this;
        }

        public FeatureUtilityBuilder setTo(String to) {
            this.to = to;
            return this;
        }

        public FeatureUtility build() throws IOException, InstallException {
            return new FeatureUtility(this);
        }
    }
}

