/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.typesafe.impl.reflection;

import io.smallrye.graphql.client.typesafe.api.GraphQlClientException;
import io.smallrye.graphql.client.typesafe.impl.reflection.ConstructionInfo;
import io.smallrye.graphql.client.typesafe.impl.reflection.FieldInfo;
import io.smallrye.graphql.client.typesafe.impl.reflection.MethodInfo;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.microprofile.graphql.NonNull;

public class TypeInfo {
    private final TypeInfo container;
    private final Type type;
    private final AnnotatedType[] annotatedArgs;
    private TypeInfo itemType;
    private Class<?> rawType;

    public static TypeInfo of(Type type) {
        return new TypeInfo(null, type);
    }

    TypeInfo(TypeInfo container, Type type) {
        this(container, type, new AnnotatedType[0]);
    }

    TypeInfo(TypeInfo container, Type type, AnnotatedType[] annotatedArgs) {
        this.container = container;
        this.type = Objects.requireNonNull(type);
        this.annotatedArgs = annotatedArgs;
    }

    public String toString() {
        return (this.type instanceof Class ? ((Class)this.type).getName() : this.type) + (this.container == null ? "" : " in " + this.container);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeInfo that = (TypeInfo)o;
        return this.type.equals(that.type);
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public String getTypeName() {
        if (this.type instanceof TypeVariable) {
            return this.resolveTypeVariable().getTypeName();
        }
        return this.type.getTypeName();
    }

    private Class<?> resolveTypeVariable() {
        ParameterizedType parameterizedType = (ParameterizedType)this.container.type;
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        return (Class)actualTypeArguments[0];
    }

    public String getPackage() {
        return ((Class)this.type).getPackage().getName();
    }

    public boolean isCollection() {
        return this.ifClass(Class::isArray) || Collection.class.isAssignableFrom(this.getRawType());
    }

    private boolean ifClass(Predicate<Class<?>> predicate) {
        return this.type instanceof Class && predicate.test((Class)this.type);
    }

    public Stream<FieldInfo> fields() {
        return this.fields(this.getRawType());
    }

    private Stream<FieldInfo> fields(Class<?> rawType) {
        return rawType == null ? Stream.of(new FieldInfo[0]) : Stream.concat(this.fields(rawType.getSuperclass()), Stream.of(this.getDeclaredFields(rawType)).filter(this::isGraphQlField).map(field -> new FieldInfo(this, (Field)field)));
    }

    private Field[] getDeclaredFields(Class<?> type) {
        if (System.getSecurityManager() == null) {
            return type.getDeclaredFields();
        }
        return AccessController.doPrivileged(type::getDeclaredFields);
    }

    private boolean isGraphQlField(Field field) {
        return !Modifier.isStatic(field.getModifiers()) && !Modifier.isTransient(field.getModifiers());
    }

    public boolean isOptional() {
        return Optional.class.equals(this.getRawType());
    }

    public boolean isScalar() {
        return this.isPrimitive() || Number.class.isAssignableFrom(this.getRawType()) || this.isEnum() || CharSequence.class.isAssignableFrom(this.getRawType()) || Character.class.equals(this.getRawType()) || Date.class.equals(this.getRawType()) || this.scalarConstructor().isPresent();
    }

    public boolean isPrimitive() {
        return this.getRawType().isPrimitive();
    }

    public boolean isEnum() {
        return this.ifClass(Class::isEnum);
    }

    public Optional<ConstructionInfo> scalarConstructor() {
        return Stream.of(this.getRawType().getMethods()).filter(this::isStaticStringConstructor).findFirst().map(ConstructionInfo::new);
    }

    private boolean isStaticStringConstructor(Method method) {
        return this.isStaticConstructorMethodNamed(method, "of") || this.isStaticConstructorMethodNamed(method, "valueOf") || this.isStaticConstructorMethodNamed(method, "parse");
    }

    private boolean isStaticConstructorMethodNamed(Method method, String name) {
        return method.getName().equals(name) && Modifier.isStatic(method.getModifiers()) && method.getReturnType().equals(this.type) && this.hasOneStringParameter(method);
    }

    private boolean hasOneStringParameter(Executable executable) {
        return executable.getParameterCount() == 1 && CharSequence.class.isAssignableFrom(executable.getParameterTypes()[0]);
    }

    public String stringValue(Object value) {
        if (Date.class.equals(this.getRawType())) {
            return ((Date)value).toInstant().toString();
        }
        return value.toString().replace("\"", "\\\"").replace("\n", "\\n");
    }

    public Object newInstance() {
        try {
            Constructor<?> noArgsConstructor = this.getDeclaredConstructor(this.getRawType());
            noArgsConstructor.setAccessible(true);
            return noArgsConstructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("can't instantiate " + this.type, e);
        }
    }

    private Constructor<?> getDeclaredConstructor(Class<?> type) throws NoSuchMethodException {
        if (System.getSecurityManager() == null) {
            return type.getDeclaredConstructor(new Class[0]);
        }
        try {
            return AccessController.doPrivileged(() -> type.getDeclaredConstructor(new Class[0]));
        }
        catch (PrivilegedActionException pae) {
            if (pae.getCause() instanceof NoSuchMethodException) {
                throw (NoSuchMethodException)pae.getCause();
            }
            throw new RuntimeException(pae.getCause());
        }
    }

    public boolean isNonNull() {
        if (this.ifClass(c -> c.isAnnotationPresent(NonNull.class))) {
            return true;
        }
        if (!this.container.isCollection()) {
            return false;
        }
        AnnotatedType annotatedArg = this.container.annotatedArgs[0];
        return annotatedArg.isAnnotationPresent(NonNull.class);
    }

    public Class<?> getRawType() {
        if (this.rawType == null) {
            this.rawType = this.raw(this.type);
        }
        return this.rawType;
    }

    public TypeInfo getItemType() {
        assert (this.isCollection() || this.isOptional());
        if (this.itemType == null) {
            this.itemType = new TypeInfo(this, this.computeItemType());
        }
        return this.itemType;
    }

    private Type computeItemType() {
        if (this.type instanceof ParameterizedType) {
            return ((ParameterizedType)this.type).getActualTypeArguments()[0];
        }
        return ((Class)this.type).getComponentType();
    }

    private Class<?> raw(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return this.raw(((ParameterizedType)type).getRawType());
        }
        if (type instanceof TypeVariable) {
            return this.resolveTypeVariable();
        }
        throw new GraphQlClientException("unsupported reflection type " + type.getClass());
    }

    public Optional<MethodInfo> getMethod(String name, Class<?> ... args) {
        return this.getDeclaredMethod((Class)this.type, name, args).map(x$0 -> MethodInfo.of(x$0, new Object[0]));
    }

    private Optional<Method> getDeclaredMethod(Class<?> type, String name, Class<?> ... args) {
        try {
            if (System.getSecurityManager() == null) {
                return Optional.of(type.getDeclaredMethod(name, args));
            }
            return Optional.of(AccessController.doPrivileged(() -> type.getDeclaredMethod(name, args)));
        }
        catch (NoSuchMethodException e) {
            return Optional.empty();
        }
        catch (PrivilegedActionException pae) {
            if (pae.getCause() instanceof NoSuchMethodException) {
                return Optional.empty();
            }
            throw new RuntimeException(pae.getCause());
        }
    }

    public boolean isNestedIn(TypeInfo that) {
        return this.enclosingTypes().anyMatch(that::equals);
    }

    public Stream<TypeInfo> enclosingTypes() {
        Stream.Builder<TypeInfo> builder = Stream.builder();
        for (Class<?> enclosing = this.getRawType(); enclosing != null; enclosing = enclosing.getEnclosingClass()) {
            builder.accept(TypeInfo.of(enclosing));
        }
        return builder.build();
    }
}

