/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.batchloader;

import io.smallrye.graphql.api.Context;
import io.smallrye.graphql.bootstrap.Config;
import io.smallrye.graphql.execution.context.SmallRyeContext;
import io.smallrye.graphql.execution.datafetcher.helper.ReflectionHelper;
import io.smallrye.graphql.execution.event.EventEmitter;
import io.smallrye.graphql.schema.model.Operation;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.dataloader.BatchLoaderEnvironment;
import org.dataloader.BatchLoaderWithContext;

public class SourceBatchLoader
implements BatchLoaderWithContext<Object, Object> {
    private final ReflectionHelper reflectionHelper;
    private final EventEmitter eventEmitter;

    public SourceBatchLoader(Operation operation, Config config) {
        this.eventEmitter = new EventEmitter(config);
        this.reflectionHelper = new ReflectionHelper(operation, this.eventEmitter);
    }

    public CompletionStage<List<Object>> load(List<Object> keys, BatchLoaderEnvironment ble) {
        final Context context = SmallRyeContext.getContext();
        final Object[] arguments = this.getArguments(keys, ble);
        final ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        return CompletableFuture.supplyAsync(() -> {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<List<Object>>(){

                    @Override
                    public List<Object> run() {
                        ClassLoader originalTccl = Thread.currentThread().getContextClassLoader();
                        Thread.currentThread().setContextClassLoader(tccl);
                        try {
                            List list = SourceBatchLoader.this.doSourceListCall(arguments, context);
                            return list;
                        }
                        finally {
                            if (originalTccl != null) {
                                Thread.currentThread().setContextClassLoader(tccl);
                            }
                        }
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private List<Object> doSourceListCall(Object[] arguments, Context context) {
        SmallRyeContext.register(context.getRequest());
        try {
            return (List)this.reflectionHelper.invoke(arguments);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private Object[] getArguments(List<Object> keys, BatchLoaderEnvironment ble) {
        ArrayList<Object> arguments = new ArrayList<Object>();
        arguments.add(keys);
        List keyContextsList = ble.getKeyContextsList();
        if (keyContextsList != null && !keyContextsList.isEmpty()) {
            Object[] otherArguments = (Object[])keyContextsList.get(0);
            arguments.addAll(Arrays.asList(otherArguments));
        }
        return arguments.toArray();
    }
}

