/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.impl;

import com.ibm.tx.jta.impl.TransactionImpl;
import com.ibm.tx.util.ConcurrentHashSet;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;

public class LocalTIDTable {
    private static TransactionImpl[] noTxns = new TransactionImpl[0];
    protected static final ConcurrentHashMap<Integer, TransactionImpl> localTIDMap = new ConcurrentHashMap(256, 0.75f, ConcurrentHashSet.getNumCHBuckets());
    private static int _baseSeed = (int)System.currentTimeMillis();
    private static final TraceComponent tc = Tr.register(LocalTIDTable.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");

    public static int getLocalTID(TransactionImpl tran) {
        int currSeed;
        int id;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getLocalTID", (Object[])new Object[]{tran});
        }
        do {
            ++_baseSeed;
        } while ((id = ++_baseSeed << _baseSeed - currSeed & Integer.MAX_VALUE) <= 0 || localTIDMap.putIfAbsent(id, tran) != null);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getLocalTID", (Object)id);
        }
        return id;
    }

    public static void removeLocalTID(int localTID) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeLocalTID", (Object[])new Object[]{localTID});
        }
        localTIDMap.remove(localTID);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeLocalTID");
        }
    }

    public static TransactionImpl[] getAllTransactions() {
        Collection<TransactionImpl> txns;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAllTransactions", (Object[])new Object[0]);
        }
        if ((txns = localTIDMap.values()) != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getAllTransactions", txns);
            }
            return txns.toArray(noTxns);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAllTransactions", (Object)noTxns);
        }
        return noTxns;
    }

    public static void clear() {
        localTIDMap.clear();
    }
}

