/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.impl;

import com.ibm.tx.jta.impl.FailureScopeController;
import com.ibm.tx.jta.impl.PartnerLogData;
import com.ibm.tx.jta.impl.RecoveryManager;
import com.ibm.tx.jta.impl.RecoveryWrapper;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.spi.DistributedRecoveryLog;
import com.ibm.ws.recoverylog.spi.RecoveryLog;
import java.util.ArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.transaction.xa.Xid;

public class PartnerLogTable {
    private static final TraceComponent tc = Tr.register(PartnerLogTable.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    protected final ArrayList<PartnerLogData> _partnerLogTable;
    protected final FailureScopeController _failureScopeController;
    private final ReentrantReadWriteLock _pltLock = new ReentrantReadWriteLock();
    private final Lock _pltReadLock = this._pltLock.readLock();
    private final Lock _pltWriteLock = this._pltLock.writeLock();

    public PartnerLogTable(FailureScopeController failureScopeController) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"PartnerLogTable", (Object[])new Object[]{failureScopeController});
        }
        this._partnerLogTable = new ArrayList();
        this._failureScopeController = failureScopeController;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"PartnerLogTable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartnerLogData getEntry(int index) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getEntry", (Object[])new Object[]{index});
        }
        this._pltReadLock.lock();
        try {
            PartnerLogData entry = this._partnerLogTable.get(index - 1);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getEntry", (Object)entry);
            }
            PartnerLogData partnerLogData = entry;
            return partnerLogData;
        }
        catch (IndexOutOfBoundsException ioobe) {
            FFDCFilter.processException((Throwable)ioobe, (String)"com.ibm.ws.Transaction.JTA.PartnerLogTable.getEntry", (String)"122", (Object)this);
        }
        finally {
            this._pltReadLock.unlock();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getEntry", null);
        }
        return null;
    }

    public void addEntry(PartnerLogData logData) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addEntry", (Object[])new Object[]{logData});
        }
        this._pltWriteLock.lock();
        try {
            this.addPartnerEntry(logData);
        }
        finally {
            this._pltWriteLock.unlock();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addEntry");
        }
    }

    protected void addPartnerEntry(PartnerLogData logData) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addPartnerEntry", (Object[])new Object[]{logData});
        }
        int result = this._partnerLogTable.size();
        this._partnerLogTable.add(result, logData);
        logData.setIndex(result + 1);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addPartnerEntry", (Object)(result + 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartnerLogData findEntry(long recoveryId) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"findEntry", (Object[])new Object[]{recoveryId});
        }
        this._pltWriteLock.lock();
        try {
            for (PartnerLogData pld : this._partnerLogTable) {
                if (recoveryId != pld.getRecoveryId()) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"findEntry", (Object)pld);
                }
                PartnerLogData partnerLogData = pld;
                return partnerLogData;
            }
        }
        finally {
            this._pltWriteLock.unlock();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findEntry", null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartnerLogData findEntry(RecoveryWrapper rw) {
        PartnerLogData entry;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"findEntry", (Object[])new Object[]{rw});
        }
        this._pltWriteLock.lock();
        try {
            for (PartnerLogData pld : this._partnerLogTable) {
                RecoveryWrapper nextWrapper = pld.getLogData();
                if (!rw.isSameAs(nextWrapper)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Found entry in table", (Object[])new Object[0]);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"findEntry", (Object)pld.getIndex());
                }
                PartnerLogData partnerLogData = pld;
                return partnerLogData;
            }
            entry = rw.container(this._failureScopeController);
            this.addPartnerEntry(entry);
        }
        finally {
            this._pltWriteLock.unlock();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findEntry", (Object)entry);
        }
        return entry;
    }

    public void terminate() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"terminate", (Object[])new Object[0]);
        }
        for (PartnerLogData pld : this._partnerLogTable) {
            pld.terminate();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"terminate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"shutdown", (Object[])new Object[0]);
        }
        boolean result = false;
        RecoveryLog partnerLog = this._failureScopeController.getPartnerLog();
        this._pltWriteLock.lock();
        try {
            for (PartnerLogData pld : this._partnerLogTable) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"processing: ", (Object[])new Object[]{pld});
                }
                if (pld.getRecovered()) {
                    if (!pld._loggedToDisk || partnerLog == null) continue;
                    try {
                        partnerLog.removeRecoverableUnit(pld.getRecoveryId());
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.Transaction.JTA.PartnerLogTable.shutdown", (String)"364");
                        Tr.error((TraceComponent)tc, (String)"WTRN0000_ERR_INT_ERROR", (Object[])new Object[]{"shutdown", "com.ibm.ws.Transaction.JTA.PartnerLog", e});
                        Tr.event((TraceComponent)tc, (String)"XAResources log - removeRecoverableUnit failed:", (Object[])new Object[]{e});
                        result = true;
                    }
                    continue;
                }
                if (!pld._loggedToDisk && partnerLog != null) {
                    Tr.warning((TraceComponent)tc, (String)"WTRN0039_SERIALIZE_FAILED", (Object[])new Object[0]);
                    continue;
                }
                result = true;
            }
        }
        finally {
            this._pltWriteLock.unlock();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"shutdown", (Object)result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearUnused() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"clearUnused", (Object[])new Object[0]);
        }
        RecoveryLog partnerLog = this._failureScopeController.getPartnerLog();
        this._pltWriteLock.lock();
        try {
            boolean cleared = false;
            for (PartnerLogData pld : this._partnerLogTable) {
                cleared |= pld.clearIfNotInUse();
            }
            try {
                if (cleared) {
                    ((DistributedRecoveryLog)partnerLog).keypoint();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            this._pltWriteLock.unlock();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"clearUnused");
        }
    }

    public boolean recover(RecoveryManager recoveryManager, ClassLoader cl, Xid[] xids) {
        boolean success = true;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recover", (Object[])new Object[]{this, this._failureScopeController.serverName()});
        }
        int restartEpoch = recoveryManager.getCurrentEpoch();
        byte[] cruuid = recoveryManager.getApplId();
        for (PartnerLogData pld : this._partnerLogTable) {
            if (!pld.recover(cl, xids, null, cruuid, restartEpoch)) {
                success = false;
            }
            if (!recoveryManager.shutdownInProgress()) continue;
            success = false;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recover", (Object)success);
        }
        return success;
    }

    public void merge(PartnerLogTable incoming) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"merge", (Object[])new Object[]{incoming});
        }
        if (incoming != null) {
            int i;
            PartnerLogData[] incomingItems = incoming.toArray();
            if (incomingItems != null) {
                for (i = 0; i < incomingItems.length - 1; ++i) {
                    RecoveryWrapper thisWrapper;
                    if (incomingItems[i].getRecovered() || (thisWrapper = incomingItems[i].getLogData()) == null) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"processing thisWrapper: ", (Object[])new Object[]{incomingItems[i]});
                    }
                    for (int k = i + 1; k < incomingItems.length; ++k) {
                        RecoveryWrapper nextWrapper;
                        if (!incomingItems[k].getRecovered() || (nextWrapper = incomingItems[k].getLogData()) == null || !thisWrapper.isSameAs(nextWrapper)) continue;
                        incomingItems[k].setRecovered(false);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)"processing isSameAs: ", (Object[])new Object[]{incomingItems[k]});
                    }
                }
            }
            if (incomingItems != null) {
                for (i = 0; i < incomingItems.length; ++i) {
                    this.addEntry(incomingItems[i]);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"merge");
        }
    }

    private PartnerLogData[] toArray() {
        this._pltWriteLock.lock();
        try {
            PartnerLogData[] result = new PartnerLogData[this._partnerLogTable.size()];
            PartnerLogData[] partnerLogDataArray = this._partnerLogTable.toArray(result);
            return partnerLogDataArray;
        }
        finally {
            this._pltWriteLock.unlock();
        }
    }
}

