/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.Assert;
import graphql.Internal;
import graphql.PublicApi;
import graphql.language.AbstractNode;
import graphql.language.Argument;
import graphql.language.Comment;
import graphql.language.Directive;
import graphql.language.DirectivesContainer;
import graphql.language.IgnoredChars;
import graphql.language.NamedNode;
import graphql.language.Node;
import graphql.language.NodeBuilder;
import graphql.language.NodeChildrenContainer;
import graphql.language.NodeUtil;
import graphql.language.NodeVisitor;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.language.SelectionSetContainer;
import graphql.language.SourceLocation;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

@PublicApi
public class Field
extends AbstractNode<Field>
implements Selection<Field>,
SelectionSetContainer<Field>,
DirectivesContainer<Field>,
NamedNode<Field> {
    private final String name;
    private final String alias;
    private final List<Argument> arguments;
    private final List<Directive> directives;
    private final SelectionSet selectionSet;
    public static final String CHILD_ARGUMENTS = "arguments";
    public static final String CHILD_DIRECTIVES = "directives";
    public static final String CHILD_SELECTION_SET = "selectionSet";

    @Internal
    protected Field(String name, String alias, List<Argument> arguments, List<Directive> directives, SelectionSet selectionSet, SourceLocation sourceLocation, List<Comment> comments, IgnoredChars ignoredChars, Map<String, String> additionalData) {
        super(sourceLocation, comments, ignoredChars, additionalData);
        this.name = name;
        this.alias = alias;
        this.arguments = arguments;
        this.directives = directives;
        this.selectionSet = selectionSet;
    }

    public Field(String name) {
        this(name, null, new ArrayList<Argument>(), new ArrayList<Directive>(), null, null, new ArrayList<Comment>(), IgnoredChars.EMPTY, Collections.emptyMap());
    }

    public Field(String name, List<Argument> arguments) {
        this(name, null, arguments, new ArrayList<Directive>(), null, null, new ArrayList<Comment>(), IgnoredChars.EMPTY, Collections.emptyMap());
    }

    public Field(String name, List<Argument> arguments, SelectionSet selectionSet) {
        this(name, null, arguments, new ArrayList<Directive>(), selectionSet, null, new ArrayList<Comment>(), IgnoredChars.EMPTY, Collections.emptyMap());
    }

    public Field(String name, SelectionSet selectionSet) {
        this(name, null, new ArrayList<Argument>(), new ArrayList<Directive>(), selectionSet, null, new ArrayList<Comment>(), IgnoredChars.EMPTY, Collections.emptyMap());
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.addAll(this.arguments);
        result.addAll(this.directives);
        if (this.selectionSet != null) {
            result.add(this.selectionSet);
        }
        return result;
    }

    @Override
    public NodeChildrenContainer getNamedChildren() {
        return NodeChildrenContainer.newNodeChildrenContainer().children(CHILD_ARGUMENTS, this.arguments).children(CHILD_DIRECTIVES, this.directives).child(CHILD_SELECTION_SET, this.selectionSet).build();
    }

    @Override
    public Field withNewChildren(NodeChildrenContainer newChildren) {
        return this.transform(builder -> builder.arguments(newChildren.getChildren(CHILD_ARGUMENTS)).directives(newChildren.getChildren(CHILD_DIRECTIVES)).selectionSet((SelectionSet)newChildren.getChildOrNull(CHILD_SELECTION_SET)));
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public List<Argument> getArguments() {
        return Collections.unmodifiableList(this.arguments);
    }

    @Override
    public List<Directive> getDirectives() {
        return Collections.unmodifiableList(this.directives);
    }

    @Override
    public SelectionSet getSelectionSet() {
        return this.selectionSet;
    }

    @Override
    public boolean isEqualTo(Node o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Field that = (Field)o;
        return NodeUtil.isEqualTo(this.name, that.name) && NodeUtil.isEqualTo(this.alias, that.alias);
    }

    @Override
    public Field deepCopy() {
        return new Field(this.name, this.alias, this.deepCopy(this.arguments), this.deepCopy(this.directives), this.deepCopy(this.selectionSet), this.getSourceLocation(), this.getComments(), this.getIgnoredChars(), this.getAdditionalData());
    }

    public String toString() {
        return "Field{name='" + this.name + '\'' + ", alias='" + this.alias + '\'' + ", arguments=" + this.arguments + ", directives=" + this.directives + ", selectionSet=" + this.selectionSet + '}';
    }

    @Override
    public TraversalControl accept(TraverserContext<Node> context, NodeVisitor visitor) {
        return visitor.visitField(this, context);
    }

    public static Builder newField() {
        return new Builder();
    }

    public static Builder newField(String name) {
        return new Builder().name(name);
    }

    public static Builder newField(String name, SelectionSet selectionSet) {
        return new Builder().name(name).selectionSet(selectionSet);
    }

    public Field transform(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public static final class Builder
    implements NodeBuilder {
        private SourceLocation sourceLocation;
        private List<Comment> comments = new ArrayList<Comment>();
        private String name;
        private String alias;
        private List<Argument> arguments = new ArrayList<Argument>();
        private List<Directive> directives = new ArrayList<Directive>();
        private SelectionSet selectionSet;
        private IgnoredChars ignoredChars = IgnoredChars.EMPTY;
        private Map<String, String> additionalData = new LinkedHashMap<String, String>();

        private Builder() {
        }

        private Builder(Field existing) {
            this.sourceLocation = existing.getSourceLocation();
            this.comments = existing.getComments();
            this.name = existing.getName();
            this.alias = existing.getAlias();
            this.arguments = existing.getArguments();
            this.directives = existing.getDirectives();
            this.selectionSet = existing.getSelectionSet();
            this.ignoredChars = existing.getIgnoredChars();
            this.additionalData = new LinkedHashMap<String, String>(existing.getAdditionalData());
        }

        @Override
        public Builder sourceLocation(SourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
            return this;
        }

        @Override
        public Builder comments(List<Comment> comments) {
            this.comments = comments;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public Builder arguments(List<Argument> arguments) {
            this.arguments = arguments;
            return this;
        }

        public Builder directives(List<Directive> directives) {
            this.directives = directives;
            return this;
        }

        public Builder selectionSet(SelectionSet selectionSet) {
            this.selectionSet = selectionSet;
            return this;
        }

        @Override
        public Builder ignoredChars(IgnoredChars ignoredChars) {
            this.ignoredChars = ignoredChars;
            return this;
        }

        @Override
        public Builder additionalData(Map<String, String> additionalData) {
            this.additionalData = Assert.assertNotNull(additionalData);
            return this;
        }

        @Override
        public Builder additionalData(String key, String value) {
            this.additionalData.put(key, value);
            return this;
        }

        public Field build() {
            return new Field(this.name, this.alias, this.arguments, this.directives, this.selectionSet, this.sourceLocation, this.comments, this.ignoredChars, this.additionalData);
        }
    }
}

