/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.grpc.internal.monitor;

import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.openliberty.grpc.internal.monitor.GrpcMethod;
import io.openliberty.grpc.internal.monitor.GrpcMonitoringServerCall;
import io.openliberty.grpc.internal.monitor.GrpcMonitoringServerCallListener;
import io.openliberty.grpc.internal.monitor.GrpcServerStatsMonitor;
import io.openliberty.grpc.server.monitor.GrpcMonitoringServerInterceptorService;
import java.time.Clock;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@Component(service={GrpcMonitoringServerInterceptorService.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true)
public class GrpcMonitoringServerInterceptorServiceImpl
implements GrpcMonitoringServerInterceptorService {
    public ServerInterceptor createInterceptor(String serviceName, String appName) {
        return new GrpcMonitoringServerInterceptor(serviceName, appName);
    }

    private class GrpcMonitoringServerInterceptor
    implements ServerInterceptor {
        private String serviceName;
        private String appName;
        private final Clock clock;

        public GrpcMonitoringServerInterceptor(String serviceName, String appName) {
            this.serviceName = serviceName;
            this.appName = appName;
            this.clock = Clock.systemDefaultZone();
        }

        public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
            MethodDescriptor methodDescriptor = call.getMethodDescriptor();
            GrpcMethod grpcMethod = GrpcMethod.of(methodDescriptor);
            GrpcServerStatsMonitor metrics = new GrpcServerStatsMonitor(this.appName, this.serviceName);
            GrpcMonitoringServerCall<ReqT, RespT> monitoringCall = new GrpcMonitoringServerCall<ReqT, RespT>(call, this.clock, grpcMethod, metrics);
            return new GrpcMonitoringServerCallListener(next.startCall(monitoringCall, headers), metrics, grpcMethod);
        }
    }
}

