/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.config.cdi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.config.interfaces.WebSphereConfig;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.InjectionPoint;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ConfigProducer {
    private static final TraceComponent tc = Tr.register(ConfigProducer.class, (String)"APPCONFIG", (String)"com.ibm.ws.microprofile.config.cdi.resources.ConfigCDI");
    static final long serialVersionUID = -387498351140878752L;

    public static Object newValue(Config config, InjectionPoint injectionPoint) {
        Type ipType = injectionPoint.getType();
        ConfigProperty qualifier = ConfigProducer.getConfigPropertyAnnotation(injectionPoint);
        String defaultValue = qualifier.defaultValue();
        String propertyName = ConfigProducer.getPropertyName(injectionPoint, qualifier);
        Object value = ConfigProducer.newValue(config, propertyName, defaultValue, ipType);
        return value;
    }

    public static Object newValue(Config config, String propertyName, String defaultValue, Type type) {
        Object value = null;
        Type propertyType = type;
        boolean optional = false;
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            Type rType = pType.getRawType();
            boolean bl = optional = rType == Optional.class;
            if (optional) {
                propertyType = pType.getActualTypeArguments()[0];
            }
        }
        WebSphereConfig wConfig = (WebSphereConfig)config;
        value = "org.eclipse.microprofile.config.configproperty.unconfigureddvalue".equals(defaultValue) ? wConfig.getValue(propertyName, propertyType, optional) : wConfig.getValue(propertyName, propertyType, defaultValue);
        if (optional) {
            value = Optional.ofNullable(value);
        }
        return value;
    }

    static ConfigProperty getConfigPropertyAnnotation(InjectionPoint injectionPoint) {
        ConfigProperty configProperty = null;
        Set qualifiers = injectionPoint.getQualifiers();
        if (qualifiers != null) {
            for (Annotation qualifier : qualifiers) {
                if (!qualifier.annotationType().equals(ConfigProperty.class)) continue;
                configProperty = (ConfigProperty)qualifier;
                break;
            }
        }
        return configProperty;
    }

    static String getPropertyName(InjectionPoint injectionPoint, ConfigProperty qualifier) {
        if (qualifier == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getPropertyName", (Object[])new Object[]{"Unsupported InjectionPoint: " + injectionPoint});
            }
            throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"unable.to.determine.injection.name.CWMCG5002E", (Object[])new Object[]{injectionPoint}));
        }
        String propertyName = qualifier.name();
        if (propertyName.equals("")) {
            Annotated annotated = injectionPoint.getAnnotated();
            if (annotated instanceof AnnotatedField) {
                AnnotatedField field = (AnnotatedField)annotated;
                propertyName = ConfigProducer.getDefaultPropertyName(field);
            } else if (annotated instanceof AnnotatedParameter) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"getPropertyName", (Object[])new Object[]{"Unsupported InjectionPoint: " + injectionPoint});
                }
                throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"unable.to.determine.injection.name.CWMCG5002E", (Object[])new Object[]{injectionPoint}));
            }
        }
        return propertyName;
    }

    static Object getDefaultValue(Config config, ConfigProperty qualifier, Class<?> type) {
        String defaultValue = qualifier.defaultValue();
        Object value = null;
        if (!"org.eclipse.microprofile.config.configproperty.unconfigureddvalue".equals(defaultValue)) {
            WebSphereConfig wConfig = (WebSphereConfig)config;
            value = wConfig.convertValue(defaultValue, type);
        }
        return value;
    }

    static String getDefaultPropertyName(AnnotatedField<?> field) {
        String className = field.getDeclaringType().getJavaClass().getCanonicalName();
        String fieldName = field.getJavaMember().getName();
        return className + "." + fieldName;
    }

    static String lowerCaseInitialLetter(String string) {
        return string != null && string.length() >= 1 ? string.substring(0, 1).toLowerCase() + string.substring(1) : "";
    }
}

