/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.util.Date;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.ext.RuntimeDelegate;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.utils.HttpUtils;

public class NewCookieHeaderProvider
implements RuntimeDelegate.HeaderDelegate<NewCookie> {
    private static final String VERSION = "Version";
    private static final String PATH = "Path";
    private static final String DOMAIN = "Domain";
    private static final String MAX_AGE = "Max-Age";
    private static final String COMMENT = "Comment";
    private static final String SECURE = "Secure";
    private static final String EXPIRES = "Expires";
    private static final String HTTP_ONLY = "HttpOnly";
    private static final String TSPECIALS_PATH = "\"()<>@,;:\\[]?={} \t";
    private static final String TSPECIALS_ALL = "\"()<>@,;:\\[]?={} \t/";
    private static final String DOUBLE_QUOTE = "\"";

    public NewCookie fromString(String c) {
        String[] tokens;
        if (c == null) {
            throw new IllegalArgumentException("SetCookie value can not be null");
        }
        String name = null;
        String value = null;
        String path = null;
        String domain = null;
        String comment = null;
        int maxAge = -1;
        boolean isSecure = false;
        Date expires = null;
        boolean httpOnly = false;
        int version = 1;
        for (String token : tokens = StringUtils.split(c, ";")) {
            String paramValue;
            String theToken = token.trim();
            int sepIndex = theToken.indexOf(61);
            String paramName = sepIndex != -1 ? theToken.substring(0, sepIndex) : theToken;
            String string = paramValue = sepIndex == -1 || sepIndex == theToken.length() - 1 ? null : theToken.substring(sepIndex + 1);
            if (paramValue != null) {
                paramValue = NewCookieHeaderProvider.stripQuotes(paramValue);
            }
            if (paramName.equalsIgnoreCase(MAX_AGE)) {
                maxAge = Integer.parseInt(paramValue);
                continue;
            }
            if (paramName.equalsIgnoreCase(PATH)) {
                path = paramValue;
                continue;
            }
            if (paramName.equalsIgnoreCase(DOMAIN)) {
                domain = paramValue;
                continue;
            }
            if (paramName.equalsIgnoreCase(COMMENT)) {
                comment = paramValue;
                continue;
            }
            if (paramName.equalsIgnoreCase(SECURE)) {
                isSecure = true;
                continue;
            }
            if (paramName.equalsIgnoreCase(EXPIRES)) {
                expires = HttpUtils.getHttpDate(paramValue);
                continue;
            }
            if (paramName.equalsIgnoreCase(HTTP_ONLY)) {
                httpOnly = true;
                continue;
            }
            if (paramName.equalsIgnoreCase(VERSION)) {
                version = Integer.parseInt(paramValue);
                continue;
            }
            if (paramValue == null) continue;
            name = paramName;
            value = paramValue;
        }
        if (name == null || value == null) {
            throw new IllegalArgumentException("Set-Cookie is malformed : " + c);
        }
        return new NewCookie(name, value, path, domain, version, comment, maxAge, expires, isSecure, httpOnly);
    }

    public String toString(NewCookie value) {
        if (null == value) {
            throw new NullPointerException("Null cookie input");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(value.getName()).append('=').append(NewCookieHeaderProvider.maybeQuoteAll(value.getValue()));
        if (value.getComment() != null) {
            sb.append(';').append(COMMENT).append('=').append(NewCookieHeaderProvider.maybeQuoteAll(value.getComment()));
        }
        if (value.getDomain() != null) {
            sb.append(';').append(DOMAIN).append('=').append(NewCookieHeaderProvider.maybeQuoteAll(value.getDomain()));
        }
        if (value.getMaxAge() != -1) {
            sb.append(';').append(MAX_AGE).append('=').append(value.getMaxAge());
        }
        if (value.getPath() != null) {
            sb.append(';').append(PATH).append('=').append(NewCookieHeaderProvider.maybeQuotePath(value.getPath()));
        }
        if (value.getExpiry() != null) {
            sb.append(';').append(EXPIRES).append('=').append(HttpUtils.toHttpDate(value.getExpiry()));
        }
        if (value.isSecure()) {
            sb.append(';').append(SECURE);
        }
        if (value.isHttpOnly()) {
            sb.append(';').append(HTTP_ONLY);
        }
        sb.append(';').append(VERSION).append('=').append(value.getVersion());
        return sb.toString();
    }

    static String maybeQuote(String tSpecials, String value) {
        if (NewCookieHeaderProvider.needsQuote(tSpecials, value)) {
            StringBuilder buff = new StringBuilder();
            buff.append('\"');
            if (value != null) {
                buff.append(value);
            }
            buff.append('\"');
            return buff.toString();
        }
        return value == null ? "" : value;
    }

    static String maybeQuoteAll(String value) {
        return NewCookieHeaderProvider.maybeQuote(TSPECIALS_ALL, value);
    }

    static String maybeQuotePath(String value) {
        return NewCookieHeaderProvider.maybeQuote(TSPECIALS_PATH, value);
    }

    static boolean needsQuote(String tSpecials, String value) {
        if (null == value) {
            return true;
        }
        int len = value.length();
        if (0 == len) {
            return true;
        }
        if ('\"' == value.charAt(0) && '\"' == value.charAt(len - 1)) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c >= ' ' && c < '\u007f' && tSpecials.indexOf(c) == -1) continue;
            return true;
        }
        return false;
    }

    static String stripQuotes(String paramValue) {
        if (paramValue.startsWith(DOUBLE_QUOTE) && paramValue.endsWith(DOUBLE_QUOTE) && paramValue.length() > 1) {
            paramValue = paramValue.substring(1, paramValue.length() - 1);
        }
        return paramValue;
    }
}

