/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.faulttolerance30.internal.metrics.integration;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.kernel.service.util.SecureAction;
import com.ibm.ws.microprofile.faulttolerance.spi.BulkheadPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.CircuitBreakerPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.FallbackPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.MetricRecorder;
import com.ibm.ws.microprofile.faulttolerance.spi.MetricRecorderProvider;
import com.ibm.ws.microprofile.faulttolerance.spi.RetryPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.TimeoutPolicy;
import com.ibm.ws.microprofile.faulttolerance.utils.DummyMetricRecorder;
import com.ibm.ws.microprofile.metrics.impl.SharedMetricRegistries;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.faulttolerance30.internal.metrics.integration.MetricRecorder30Impl;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(name="com.ibm.ws.microprofile.faulttolerance.metrics.integration.MetricRecorderProviderImpl", service={MetricRecorderProvider.class}, configurationPolicy=ConfigurationPolicy.IGNORE)
public class MetricRecorderProvider30Impl
implements MetricRecorderProvider {
    private static final SecureAction secureAction;
    private final ReentrantReadWriteLock metricsEnabledCacheLock = new ReentrantReadWriteLock();
    private final Map<ClassLoader, Boolean> metricsEnabledCache = new WeakHashMap<ClassLoader, Boolean>();
    private static final String CONFIG_METRICS_ENABLED = "MP_Fault_Tolerance_Metrics_Enabled";
    @Reference
    protected SharedMetricRegistries sharedRegistries;
    private final WeakHashMap<Method, MetricRecorder> recorders = new WeakHashMap();
    static final long serialVersionUID = -1083358088091148858L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetricRecorder getMetricRecorder(Method method, RetryPolicy retryPolicy, CircuitBreakerPolicy circuitBreakerPolicy, TimeoutPolicy timeoutPolicy, BulkheadPolicy bulkheadPolicy, FallbackPolicy fallbackPolicy, MetricRecorderProvider.AsyncType isAsync) {
        WeakHashMap<Method, MetricRecorder> weakHashMap = this.recorders;
        synchronized (weakHashMap) {
            MetricRecorder recorder = this.recorders.get(method);
            if (recorder == null) {
                recorder = this.createNewRecorder(method, retryPolicy, circuitBreakerPolicy, timeoutPolicy, bulkheadPolicy, fallbackPolicy, isAsync);
                this.recorders.put(method, recorder);
            }
            return recorder;
        }
    }

    private MetricRecorder createNewRecorder(Method method, RetryPolicy retryPolicy, CircuitBreakerPolicy circuitBreakerPolicy, TimeoutPolicy timeoutPolicy, BulkheadPolicy bulkheadPolicy, FallbackPolicy fallbackPolicy, MetricRecorderProvider.AsyncType isAsync) {
        if (this.isMetricsEnabled(method.getDeclaringClass())) {
            MetricRegistry registry = this.sharedRegistries.getOrCreate(MetricRegistry.Type.BASE.getName());
            return new MetricRecorder30Impl(this.getMetricName(method), registry, retryPolicy, circuitBreakerPolicy, timeoutPolicy, bulkheadPolicy, fallbackPolicy, isAsync);
        }
        return DummyMetricRecorder.get();
    }

    private String getMetricName(Method method) {
        String name = method.getDeclaringClass().getCanonicalName() + "." + method.getName();
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isMetricsEnabled(Class<?> clazz) {
        Boolean metricsEnabled;
        block7: {
            ClassLoader cl = secureAction.getClassLoader(clazz);
            metricsEnabled = null;
            this.metricsEnabledCacheLock.readLock().lock();
            try {
                metricsEnabled = this.metricsEnabledCache.get(cl);
                if (metricsEnabled != null) break block7;
                this.metricsEnabledCacheLock.readLock().unlock();
                this.metricsEnabledCacheLock.writeLock().lock();
                try {
                    metricsEnabled = this.metricsEnabledCache.get(cl);
                    if (metricsEnabled == null) {
                        Config mpConfig = ConfigProvider.getConfig((ClassLoader)cl);
                        metricsEnabled = mpConfig.getOptionalValue(CONFIG_METRICS_ENABLED, Boolean.class).orElse(Boolean.TRUE);
                    }
                    this.metricsEnabledCacheLock.readLock().lock();
                }
                finally {
                    this.metricsEnabledCacheLock.writeLock().unlock();
                }
            }
            finally {
                this.metricsEnabledCacheLock.readLock().unlock();
            }
        }
        return metricsEnabled;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.faulttolerance30.internal.metrics.integration.MetricRecorderProvider30Impl", MetricRecorderProvider30Impl.class, (String)"FAULTTOLERANCE", null);
        secureAction = (SecureAction)AccessController.doPrivileged(SecureAction.get());
    }
}

