/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.clients.common;

import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.structures.BoundedHashMap;
import com.ibm.ws.security.openidconnect.client.jose4j.util.Jose4jUtil;
import com.ibm.ws.security.openidconnect.clients.common.BadPostRequestException;
import com.ibm.ws.security.openidconnect.clients.common.ConvergedClientConfig;
import com.ibm.ws.security.openidconnect.clients.common.OIDCClientAuthenticatorUtil;
import com.ibm.ws.security.openidconnect.clients.common.OidcClientHttpUtil;
import com.ibm.ws.security.openidconnect.clients.common.OidcClientRequest;
import com.ibm.ws.security.openidconnect.clients.common.OidcClientUtil;
import com.ibm.ws.security.openidconnect.clients.common.UserInfoHelper;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.ProviderAuthenticationResult;
import com.ibm.wsspi.ssl.SSLSupport;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class AuthorizationCodeHandler {
    private static final TraceComponent tc = Tr.register(AuthorizationCodeHandler.class, (String)"OPENIDCONNECT", (String)"com.ibm.ws.security.openidconnect.clients.common.resources.OidcClientMessages");
    private OidcClientUtil oidcClientUtil = this.getOidcClientUtil();
    private OIDCClientAuthenticatorUtil authenticatorUtil = this.getOIDCClientAuthenticatorUtil();
    private SSLSupport sslSupport = null;
    private Jose4jUtil jose4jUtil = null;
    private static Map<String, Object> usedAuthCodes = Collections.synchronizedMap(new BoundedHashMap(20));
    static final long serialVersionUID = -8589386350564248365L;

    public AuthorizationCodeHandler(SSLSupport sslsupt) {
        this.sslSupport = sslsupt;
        this.jose4jUtil = this.getJose4jUtil(this.sslSupport);
    }

    protected OidcClientUtil getOidcClientUtil() {
        return new OidcClientUtil();
    }

    protected OIDCClientAuthenticatorUtil getOIDCClientAuthenticatorUtil() {
        return new OIDCClientAuthenticatorUtil();
    }

    protected Jose4jUtil getJose4jUtil(SSLSupport sslSupport) {
        return new Jose4jUtil(sslSupport);
    }

    /*
     * WARNING - void declaration
     */
    public ProviderAuthenticationResult handleAuthorizationCode(HttpServletRequest req, HttpServletResponse res, String authzCode, String responseState, ConvergedClientConfig clientConfig) {
        String clientId = clientConfig.getClientId();
        OidcClientRequest oidcClientRequest = (OidcClientRequest)req.getAttribute("com.ibm.wsspi.security.oidc.client.request");
        ProviderAuthenticationResult oidcResult = null;
        oidcResult = this.authenticatorUtil.verifyResponseState(req, res, responseState, clientConfig);
        if (oidcResult != null) {
            return oidcResult;
        }
        if (!OIDCClientAuthenticatorUtil.checkHttpsRequirement(clientConfig, clientConfig.getTokenEndpointUrl())) {
            Tr.error((TraceComponent)tc, (String)"OIDC_CLIENT_URL_PROTOCOL_NOT_HTTPS", (Object[])new Object[]{clientConfig.getTokenEndpointUrl()});
            oidcResult = new ProviderAuthenticationResult(AuthResult.SEND_401, 401);
            return oidcResult;
        }
        String redirect_url = this.authenticatorUtil.setRedirectUrlIfNotDefined(req, clientConfig);
        if (!OIDCClientAuthenticatorUtil.checkHttpsRequirement(clientConfig, redirect_url)) {
            Tr.error((TraceComponent)tc, (String)"OIDC_CLIENT_URL_PROTOCOL_NOT_HTTPS", (Object[])new Object[]{redirect_url});
            oidcResult = new ProviderAuthenticationResult(AuthResult.SEND_401, 401);
            return oidcResult;
        }
        SSLSocketFactory sslSocketFactory = null;
        try {
            boolean throwExc = clientConfig.getTokenEndpointUrl() != null && clientConfig.getTokenEndpointUrl().startsWith("https");
            sslSocketFactory = new OidcClientHttpUtil().getSSLSocketFactory(clientConfig, this.sslSupport, throwExc, false);
        }
        catch (SSLException throwExc) {
            void e;
            FFDCFilter.processException((Throwable)throwExc, (String)"com.ibm.ws.security.openidconnect.clients.common.AuthorizationCodeHandler", (String)"101", (Object)this, (Object[])new Object[]{req, res, authzCode, responseState, clientConfig});
            Tr.error((TraceComponent)tc, (String)"OIDC_CLIENT_HTTPS_WITH_SSLCONTEXT_NULL", (Object[])new Object[]{e, clientConfig.getClientId()});
            return new ProviderAuthenticationResult(AuthResult.SEND_401, 401);
        }
        try {
            String url = clientConfig.getTokenEndpointUrl();
            if (url == null || url.length() == 0) {
                throw new MalformedURLException("MalformedURLException");
            }
            HashMap<String, String> tokens = this.oidcClientUtil.getTokensFromAuthzCode(url, clientId, clientConfig.getClientSecret(), redirect_url, authzCode, clientConfig.getGrantType(), sslSocketFactory, clientConfig.isHostNameVerificationEnabled(), clientConfig.getTokenEndpointAuthMethod(), OIDCClientAuthenticatorUtil.getResources(clientConfig), clientConfig.getTokenRequestParams(), clientConfig.getUseSystemPropertiesForHttpClientConnections());
            oidcClientRequest.setTokenType("ID Token");
            oidcResult = this.jose4jUtil.createResultWithJose4J(responseState, tokens, clientConfig, oidcClientRequest);
            new UserInfoHelper(clientConfig, this.sslSupport).getUserInfoIfPossible(oidcResult, tokens, sslSocketFactory, oidcClientRequest);
            this.addAuthCodeToUsedList(authzCode);
        }
        catch (BadPostRequestException url) {
            void e;
            FFDCFilter.processException((Throwable)url, (String)"com.ibm.ws.security.openidconnect.clients.common.AuthorizationCodeHandler", (String)"136", (Object)this, (Object[])new Object[]{req, res, authzCode, responseState, clientConfig});
            Tr.error((TraceComponent)tc, (String)"OIDC_CLIENT_TOKEN_REQUEST_FAILURE", (Object[])new Object[]{e.getErrorMessage(), clientId, clientConfig.getTokenEndpointUrl()});
            this.sendErrorJSON(res, e.getStatusCode(), "invalid_request", e.getErrorMessage());
            oidcResult = new ProviderAuthenticationResult(AuthResult.FAILURE, e.getStatusCode());
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.openidconnect.clients.common.AuthorizationCodeHandler", (String)"140", (Object)this, (Object[])new Object[]{req, res, authzCode, responseState, clientConfig});
            Tr.error((TraceComponent)tc, (String)"OIDC_CLIENT_TOKEN_REQUEST_FAILURE", (Object[])new Object[]{e.getLocalizedMessage(), clientId, clientConfig.getTokenEndpointUrl()});
            oidcResult = new ProviderAuthenticationResult(AuthResult.SEND_401, 401);
        }
        return oidcResult;
    }

    /*
     * WARNING - void declaration
     */
    private void sendErrorJSON(HttpServletResponse response, int statusCode, String errorCode, String errorDescription) {
        block8: {
            String error = "error";
            String error_description = "error_description";
            try {
                if (errorCode != null) {
                    response.setStatus(statusCode);
                    response.setHeader("Content-Type", "application/json;charset=UTF-8");
                    JSONObject responseJSON = new JSONObject();
                    responseJSON.put((Object)"error", (Object)errorCode);
                    if (errorDescription != null) {
                        responseJSON.put((Object)"error_description", (Object)errorDescription);
                    }
                    PrintWriter pw = response.getWriter();
                    pw.write(responseJSON.toString());
                    pw.flush();
                } else {
                    response.sendError(statusCode);
                }
            }
            catch (IOException responseJSON) {
                FFDCFilter.processException((Throwable)responseJSON, (String)"com.ibm.ws.security.openidconnect.clients.common.AuthorizationCodeHandler", (String)"169", (Object)this, (Object[])new Object[]{response, statusCode, errorCode, errorDescription});
                if (tc.isDebugEnabled()) {
                    void e;
                    Tr.debug((TraceComponent)tc, (String)"Internal error sending error message", (Object[])new Object[]{e});
                }
                try {
                    response.sendError(500);
                }
                catch (IOException pw) {
                    void ioe;
                    FFDCFilter.processException((Throwable)pw, (String)"com.ibm.ws.security.openidconnect.clients.common.AuthorizationCodeHandler", (String)"174", (Object)this, (Object[])new Object[]{response, statusCode, errorCode, errorDescription});
                    if (!tc.isDebugEnabled()) break block8;
                    Tr.debug((TraceComponent)tc, (String)"yet another internal error, give up", (Object[])new Object[]{ioe});
                }
            }
        }
    }

    boolean isAuthCodeReused(String authzCode) {
        return usedAuthCodes.containsKey(authzCode);
    }

    void addAuthCodeToUsedList(String authzCode) {
        usedAuthCodes.put(authzCode, null);
    }
}

