/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.resolver;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.websphere.sip.resolver.DomainResolverListener;
import com.ibm.websphere.sip.resolver.exception.SipURIResolveException;
import com.ibm.ws.sip.container.events.EventsDispatcher;
import com.ibm.ws.sip.container.properties.PropertiesStore;
import com.ibm.ws.sip.stack.internalapi.NaptrRequestListener;
import com.ibm.wsspi.sip.channel.resolver.SIPUri;
import com.ibm.wsspi.sip.channel.resolver.SipURILookup;
import com.ibm.wsspi.sip.channel.resolver.SipURILookupCallback;
import com.ibm.wsspi.sip.channel.resolver.SipURILookupException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipURI;

public class SipURILookupCallbackImpl
implements SipURILookupCallback {
    private static final LogMgr c_logger = Log.get(SipURILookupCallbackImpl.class);
    private SipURI _sipUri;
    private List<SipURI> _results;
    private boolean _hasResults;
    private boolean _fixTransports;
    private final Object _syncObj;
    private final DomainResolverListener _listener;
    private final NaptrRequestListener _stackListener;
    private final SipSession _sipSession;
    private SipURILookupException _exception;

    public SipURILookupCallbackImpl() {
        this._listener = null;
        this._sipSession = null;
        this._stackListener = null;
        this._syncObj = new Object();
    }

    public SipURILookupCallbackImpl(SipURI sipUri, boolean fixTransports, DomainResolverListener listener, SipSession sipSession) {
        this._stackListener = null;
        this._syncObj = null;
        this._sipUri = sipUri;
        this._listener = listener;
        this._results = null;
        this._sipSession = sipSession;
        this._fixTransports = fixTransports;
    }

    public SipURILookupCallbackImpl(NaptrRequestListener listener, boolean fixTransports) {
        this._listener = null;
        this._syncObj = null;
        this._sipUri = null;
        this._stackListener = listener;
        this._results = null;
        this._sipSession = null;
        this._fixTransports = fixTransports;
    }

    public void init(SipURI sipUri, boolean fixTransports) {
        this.reset();
        this._sipUri = sipUri;
        this._fixTransports = fixTransports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForResults() throws InterruptedException {
        if (this._syncObj != null) {
            Object object = this._syncObj;
            synchronized (object) {
                if (!this._hasResults) {
                    this._syncObj.wait();
                }
            }
        }
    }

    public void reset() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "reset", "Reset called.");
        }
        this._exception = null;
        this._results = null;
        this._hasResults = false;
        this._sipUri = null;
        this._fixTransports = false;
    }

    @Override
    public void complete(SipURILookup request) {
        this.complete(request, false);
    }

    public void complete(SipURILookup request, boolean isOnCurrentThread) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "complete", "Success response received.");
        }
        if (this._stackListener != null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "complete", "Dispatching stack success response");
            }
            List response = (List)request.getAnswer().clone();
            if (this._fixTransports) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "complete", "fixing result set transport");
                }
                for (SIPUri sipUri : response) {
                    sipUri.setScheme("sip");
                    sipUri.setTransport("tls");
                }
            }
            this._stackListener.handleResolve(response);
        } else {
            this._results = this.convertResults(request.getAnswer());
            this.notifyWaitingThreads();
            if (this._listener != null) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "complete", "Dispatching success response");
                }
                EventsDispatcher.uriLookupComplete(this._listener, this._sipSession, this._sipUri, this._results, isOnCurrentThread);
            }
        }
    }

    private final List<SipURI> convertResults(List<SIPUri> response) {
        if (c_logger.isTraceDebugEnabled()) {
            int num = response != null ? response.size() : 0;
            c_logger.traceDebug(this, "convertResults", "Received " + num + " results.");
        }
        if (response == null || response.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SipURI> result = new ArrayList<SipURI>(response.size());
        for (SIPUri sipUri : response) {
            String ttl;
            SipURI tempUri = (SipURI)this._sipUri.clone();
            tempUri.setHost(sipUri.getHost());
            tempUri.setPort(sipUri.getPortInt());
            String additionalParameters = sipUri.getAdditionalParms();
            if (PropertiesStore.getInstance().getProperties().getBoolean("addTtl") && (ttl = this.getIBMTTL(additionalParameters)) != null) {
                tempUri.setParameter("ibmttl", ttl);
            }
            if (this._fixTransports) {
                sipUri.setScheme("sip");
                sipUri.setTransport("tls");
            }
            if (sipUri.getTransport() != null) {
                tempUri.setTransportParam(sipUri.getTransport());
            } else {
                tempUri.removeParameter("transport");
            }
            result.add(tempUri);
        }
        return result;
    }

    private String getIBMTTL(String additionalParameters) {
        int idx;
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "getIBMTTL", (Object)additionalParameters);
        }
        String ttl = null;
        if (additionalParameters != null && additionalParameters.length() > 1 && (idx = additionalParameters.indexOf("ibmttl")) > -1) {
            String[] ttlArray;
            int idx2 = (additionalParameters = additionalParameters.substring(idx)).indexOf(";");
            if (idx2 > -1) {
                additionalParameters = additionalParameters.substring(0, idx2);
            }
            if ((ttlArray = additionalParameters.split("=")).length == 2) {
                ttl = ttlArray[1].trim();
            }
        }
        if (ttl != null) {
            String[] ttlSplit = ttl.split("_");
            long ttlTime = Long.parseLong(ttlSplit[0]);
            long ttlDate = Long.parseLong(ttlSplit[1]);
            long ttlOffset = (System.currentTimeMillis() - ttlDate) / 1000L;
            long ttlSec = Math.max(0L, ttlTime - ttlOffset);
            ttl = String.valueOf(ttlSec);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit((Object)this, "getIBMTTL", ttl);
        }
        return ttl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWaitingThreads() {
        if (this._syncObj != null) {
            Object object = this._syncObj;
            synchronized (object) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "notifyWaitingThreads", "Results ready.");
                }
                this._hasResults = true;
                this._syncObj.notify();
            }
        }
    }

    public boolean hasResults() {
        return this._hasResults;
    }

    public List<SipURI> getResults() throws SipURIResolveException {
        if (!this._hasResults) {
            throw new SipURIResolveException("Results not ready.");
        }
        return this._results;
    }

    @Override
    public void error(SipURILookup request, SipURILookupException exception) {
        this.error(request, exception, false);
    }

    public void error(SipURILookup request, SipURILookupException exception, boolean isOnCurrentThread) {
        this._exception = exception;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "error", "Received exception " + exception);
            if (exception != null) {
                exception.printStackTrace();
            }
        }
        this.notifyWaitingThreads();
        if (this._listener != null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "error", "Dispatching error response");
            }
            EventsDispatcher.uriLookupError(this._listener, this._sipSession, this._sipUri, exception, isOnCurrentThread);
        }
        if (this._stackListener != null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "error", "Dispatching error response");
            }
            this._stackListener.error(exception);
        }
    }

    public SipURILookupException getErrorException() {
        return this._exception;
    }

    public boolean isErrorResponse() {
        return this._exception != null;
    }
}

