/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsat.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jaxws.wsat.Constants;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsat.cxf.utils.WSATCXFUtils;
import com.ibm.ws.wsat.service.Protocol;
import com.ibm.ws.wsat.utils.ProtocolServiceWrapper;
import com.ibm.ws.wsat.utils.WSATOSGIService;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.Names;
import org.w3c.dom.Element;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WSATControlUtil {
    private static WSATControlUtil instance = null;
    private static final TraceComponent tc = Tr.register(WSATControlUtil.class, (String)"WSAT", null);
    static final long serialVersionUID = -1848900205875919908L;

    private WSATControlUtil() {
    }

    public static WSATControlUtil getInstance() {
        if (instance == null) {
            instance = new WSATControlUtil();
        }
        return instance;
    }

    public String trace(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    public Map<String, String> getPropertiesMap(List<Header> list) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Header h : list) {
            Element ele = (Element)h.getObject();
            QName name = this.createQNameFromElement(ele);
            if (name == null || name.getNamespaceURI() == null || ele.getFirstChild() == null) continue;
            if (Constants.WS_WSAT_CTX_REF.getLocalPart().equals(name.getLocalPart()) && Constants.WS_WSAT_CTX_REF.getNamespaceURI().equals(name.getNamespaceURI())) {
                map.put(Constants.WS_WSAT_CTX_REF.getLocalPart(), ele.getFirstChild().getNodeValue());
                continue;
            }
            if (Constants.WS_WSAT_PART_REF.getLocalPart().equals(name.getLocalPart()) && Constants.WS_WSAT_PART_REF.getNamespaceURI().equals(name.getNamespaceURI())) {
                map.put(Constants.WS_WSAT_PART_REF.getLocalPart(), ele.getFirstChild().getNodeValue());
                continue;
            }
            if (Names.WSA_FAULTTO_QNAME.getLocalPart().equals(name.getLocalPart()) && Names.WSA_FAULTTO_QNAME.getNamespaceURI().equals(name.getNamespaceURI())) {
                map.put(Names.WSA_FAULTTO_QNAME.getLocalPart(), ele.getFirstChild().getFirstChild().getNodeValue());
                continue;
            }
            if (!Names.WSA_REPLYTO_QNAME.getLocalPart().equals(name.getLocalPart()) || !Names.WSA_REPLYTO_QNAME.getNamespaceURI().equals(name.getNamespaceURI())) continue;
            map.put(Names.WSA_REPLYTO_QNAME.getLocalPart(), ele.getFirstChild().getFirstChild().getNodeValue());
        }
        return map;
    }

    public ProtocolServiceWrapper getService(WrappedMessageContext wmc) {
        List headers = CastUtils.cast((List)((List)wmc.getWrappedMessage().get((Object)Header.HEADER_LIST)));
        ArrayList<Header> migration = new ArrayList<Header>();
        Map<String, String> wsatProperties = WSATControlUtil.getInstance().getPropertiesMap(headers);
        String ctxID = wsatProperties.get(Constants.WS_WSAT_CTX_REF.getLocalPart());
        String partID = wsatProperties.get(Constants.WS_WSAT_PART_REF.getLocalPart());
        Object addressProp = wmc.get((Object)"javax.xml.ws.addressing.context.inbound");
        EndpointReferenceType replyTo = WSATCXFUtils.getReplyTo((Object)addressProp);
        EndpointReferenceType faultTo = WSATCXFUtils.getFaultTo((Object)addressProp);
        EndpointReferenceType from = WSATCXFUtils.getFrom((Object)addressProp);
        for (Header h : headers) {
            Element ele = (Element)h.getObject();
            QName name = WSATControlUtil.getInstance().createQNameFromElement(ele);
            if ("http://www.w3.org/2005/08/addressing".equals(name.getNamespaceURI())) continue;
            migration.add(h);
        }
        if (faultTo == null) {
            faultTo = replyTo;
        }
        Protocol service = WSATOSGIService.getInstance().getProtocolService();
        return new ProtocolServiceWrapper().setFaultTo(faultTo).setReplyTo(replyTo).setFrom(from).setService(service).setTxID(ctxID).setPartID(partID).setMigrationHeaders(migration).setNextStepEPR(replyTo);
    }

    public boolean checkProtocolId(String protocolId) {
        return protocolId.endsWith("http://docs.oasis-open.org/ws-tx/wsat/2006/06/Durable2PC");
    }

    public QName createQNameFromElement(Element ele) {
        if (ele.getLocalName() == null) {
            return null;
        }
        if (ele.getNamespaceURI() == null && ele.getPrefix() == null) {
            return new QName(ele.getLocalName());
        }
        if (ele.getNamespaceURI() != null) {
            if (ele.getPrefix() == null) {
                return new QName(ele.getNamespaceURI(), ele.getLocalName());
            }
            return new QName(ele.getNamespaceURI(), ele.getLocalName(), ele.getPrefix());
        }
        return null;
    }
}

