/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.dispatcher.internal.channel;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.http.channel.h2internal.H2InboundLink;
import com.ibm.ws.http.channel.internal.HttpChannelConfig;
import com.ibm.ws.http.channel.internal.inbound.HttpInboundChannel;
import com.ibm.ws.http.channel.internal.inbound.HttpInboundLink;
import com.ibm.ws.http.channel.internal.inbound.HttpInboundServiceContextImpl;
import com.ibm.ws.http.channel.internal.outbound.HttpOutputStreamImpl;
import com.ibm.ws.http.dispatcher.classify.DecoratedExecutorThread;
import com.ibm.ws.http.dispatcher.internal.HttpDispatcher;
import com.ibm.ws.http.dispatcher.internal.channel.HttpDispatcherChannel;
import com.ibm.ws.http.dispatcher.internal.channel.HttpRequestImpl;
import com.ibm.ws.http.dispatcher.internal.channel.HttpResponseImpl;
import com.ibm.ws.http.dispatcher.internal.channel.SSLContextImpl;
import com.ibm.ws.http.dispatcher.internal.channel.WelcomePageHelper;
import com.ibm.ws.http.internal.VirtualHostImpl;
import com.ibm.ws.http.internal.VirtualHostMap;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transport.access.TransportConnectionAccess;
import com.ibm.wsspi.channelfw.ConnectionLink;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.channelfw.base.InboundApplicationLink;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.http.EncodingUtils;
import com.ibm.wsspi.http.HttpDateFormat;
import com.ibm.wsspi.http.HttpOutputStream;
import com.ibm.wsspi.http.HttpRequest;
import com.ibm.wsspi.http.HttpResponse;
import com.ibm.wsspi.http.SSLContext;
import com.ibm.wsspi.http.URLEscapingUtils;
import com.ibm.wsspi.http.WorkClassifier;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import com.ibm.wsspi.http.channel.values.ConnectionValues;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import com.ibm.wsspi.http.channel.values.StatusCodes;
import com.ibm.wsspi.http.ee7.HttpInboundConnectionExtended;
import com.ibm.wsspi.http.ee8.Http2InboundConnection;
import com.ibm.wsspi.tcpchannel.TCPConnectionContext;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HttpDispatcherLink
extends InboundApplicationLink
implements HttpInboundConnectionExtended,
VirtualHostMap.RequestHelper,
Http2InboundConnection {
    private static final TraceComponent tc = Tr.register(HttpDispatcherLink.class, (String[])new String[]{"HttpDispatcher", "HttpTransport"}, (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages", (String)"com.ibm.ws.http.dispatcher.internal.channel.HttpDispatcherLink");
    public static final String LINK_ID = "HttpDispatcherLink";
    private HttpDispatcherChannel myChannel = null;
    private HttpRequestImpl request = null;
    private HttpResponseImpl response = null;
    private SSLContext sslinfo = null;
    private HttpInboundServiceContextImpl isc = null;
    private InetAddress remoteAddress = null;
    private String localCanonicalHostName = null;
    private String localHostAlias = null;
    private String remoteContextAddress;
    private volatile boolean linkIsReady = false;
    private volatile UsePrivateHeaders usePrivateHeaders = UsePrivateHeaders.unknown;
    private volatile int configUpdate = 0;
    private final Object WebConnCanCloseSync = new Object();
    private boolean WebConnCanClose = true;
    private final String h2InitError = "com.ibm.ws.transport.http.http2InitError";
    static final long serialVersionUID = 3992369639131680692L;

    public void init(VirtualConnection inVC, HttpDispatcherChannel channel) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("New conn: vc=" + inVC), (Object[])new Object[0]);
        }
        super.init(inVC);
        inVC.getStateMap().put(LINK_ID, this);
        this.myChannel = channel;
        this.request = new HttpRequestImpl(HttpDispatcher.useEE7Streams());
        this.response = new HttpResponseImpl(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(VirtualConnection conn, Exception e) {
        String toClose;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Close called , vc ->" + this.vc + " hc: " + this.hashCode()), (Object[])new Object[0]);
        }
        if (this.vc == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Connection must be already closed since vc is null", (Object[])new Object[0]);
            }
            return;
        }
        String closeNonUpgraded = (String)this.vc.getStateMap().get("CloseNonUpgradedStreams");
        if (closeNonUpgraded != null && closeNonUpgraded.equalsIgnoreCase("true")) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"close streams from HttpDispatcherLink.close", (Object[])new Object[0]);
            }
            Exception errorinClosing = this.closeStreams();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Error closing in streams" + errorinClosing), (Object[])new Object[0]);
            }
            this.vc.getStateMap().put("CloseNonUpgradedStreams", "CLOSED_NON_UPGRADED_STREAMS");
            return;
        }
        String upgradedListener = (String)this.vc.getStateMap().get("UpgradedListener");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("upgradedListener ->" + upgradedListener), (Object[])new Object[0]);
        }
        if (upgradedListener != null && upgradedListener.equalsIgnoreCase("true")) {
            boolean closeCalledFromWebConnection = false;
            HttpDispatcherLink httpDispatcherLink = this;
            synchronized (httpDispatcherLink) {
                String fromWebConnection = (String)this.vc.getStateMap().get("CloseUpgradedWebConnection");
                if (fromWebConnection != null && fromWebConnection.equalsIgnoreCase("true")) {
                    closeCalledFromWebConnection = true;
                    this.vc.getStateMap().put("CloseUpgradedWebConnection", "false");
                }
            }
            if (!closeCalledFromWebConnection) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Connection Not to be closed here because Servlet Upgrade.", (Object[])new Object[0]);
                }
                return;
            }
        } else if (upgradedListener == null && (toClose = (String)this.vc.getStateMap().get("UpgradedWebConnectionNeedsClose")) != null && toClose.compareToIgnoreCase("true") == 0) {
            Object object = this.WebConnCanCloseSync;
            synchronized (object) {
                if (this.WebConnCanClose) {
                    this.WebConnCanClose = false;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Upgraded Web Connection closing Dispatcher Link", (Object[])new Object[0]);
                    }
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Upgraded Web Connection already called close; returning", (Object[])new Object[0]);
                    }
                    return;
                }
            }
        }
        if (!this.myChannel.getStop0Called()) {
            try {
                super.close(conn, e);
            }
            finally {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"decrement active connection count", (Object[])new Object[0]);
                }
                this.myChannel.decrementActiveConns();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void destroy(Exception e) {
        Object webConnectionObject;
        String upgraded;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Destroy with exc=" + e), (Object[])new Object[0]);
        }
        this.linkIsReady = false;
        VirtualConnection vc = this.getVC();
        if (vc != null && (upgraded = (String)vc.getStateMap().get("UpgradedConnection")) != null && upgraded.compareToIgnoreCase("true") == 0 && (webConnectionObject = vc.getStateMap().get("UpgradedWebConnectionObject")) != null) {
            if (webConnectionObject instanceof TransportConnectionAccess) {
                TransportConnectionAccess tWebConn = (TransportConnectionAccess)webConnectionObject;
                try {
                    tWebConn.close();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.http.dispatcher.internal.channel.HttpDispatcherLink", (String)"277", (Object)this, (Object[])new Object[]{e});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        void webConnectionCloseException;
                        Tr.debug((TraceComponent)tc, (String)"Failed to close WebConnection {0}", (Object[])new Object[]{webConnectionCloseException});
                    }
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"call application destroy if not done yet", (Object[])new Object[0]);
            }
        }
        super.destroy();
        this.isc = null;
        this.remoteAddress = null;
        this.request = null;
        this.response = null;
        this.sslinfo = null;
    }

    @ManualTrace
    public void directHttp2Ready() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("directHttp2Ready entry: " + this), (Object[])new Object[0]);
        }
        H2InboundLink h2link = new H2InboundLink(this.getHttpInboundLink2().getChannel(), this.vc, this.getTCPConnectionContext());
        h2link.reinit(this.getTCPConnectionContext(), this.vc, h2link);
        h2link.handleHTTP2DirectConnect(h2link);
        this.setDeviceLink(h2link);
        h2link.processRead(this.vc, this.getTCPConnectionContext().getReadInterface());
    }

    @FFDCIgnore(value={Throwable.class})
    public void ready(VirtualConnection inVC) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Received HTTP connection: " + inVC + " hc: " + this.hashCode()), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)"increment active connection count", (Object[])new Object[0]);
        }
        this.myChannel.incrementActiveConns();
        this.init(inVC);
        this.isc = (HttpInboundServiceContextImpl)this.getDeviceLink().getChannelAccessor();
        this.remoteAddress = this.isc.getRemoteAddr();
        if (this.getHttpInboundLink2().isDirectHttp2Link(inVC)) {
            this.directHttp2Ready();
            return;
        }
        this.response.init(this.isc);
        this.linkIsReady = true;
        ExecutorService executorService = HttpDispatcher.getExecutorService();
        if (null == executorService) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Missing executor service", (Object[])new Object[0]);
            }
            this.sendResponse(StatusCodes.UNAVAILABLE, null, false);
            return;
        }
        this.request.init(this.isc);
        VirtualHostImpl vhost = VirtualHostMap.findVirtualHost(this.myChannel.getEndpointPid(), this);
        if (vhost == null) {
            String url = this.isc.getRequest().getRequestURI();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                String alias = this.getLocalHostAlias();
                Tr.debug((TraceComponent)tc, (String)("No virtual host found for this alias: " + alias), (Object[])new Object[0]);
            }
            this.send404Message(url);
            return;
        }
        Runnable handler = null;
        try {
            handler = vhost.discriminate(this);
            if (handler == null) {
                InputStream landingPageStream = this.getLandingPageStream();
                if (landingPageStream != null) {
                    this.displayLandingPage(landingPageStream);
                } else {
                    String url = this.isc.getRequest().getRequestURI();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        String alias = this.getLocalHostAlias();
                        Tr.debug((TraceComponent)tc, (String)("The URI was not associated with the virtual host " + vhost.getName()), (Object[])new Object[]{alias, url});
                    }
                    this.send404Message(url);
                }
            } else {
                this.wrapHandlerAndExecute(handler);
            }
        }
        catch (Throwable t) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Exception during dispatch; " + t), (Object[])new Object[0]);
            }
            if (t instanceof Exception) {
                this.sendResponse(StatusCodes.INTERNAL_ERROR, (Exception)t, true);
            }
            this.sendResponse(StatusCodes.INTERNAL_ERROR, new Exception("Dispatch error", t), true);
        }
    }

    private void wrapHandlerAndExecute(Runnable handler) {
        TaskWrapper taskWrapper = new TaskWrapper(handler, this);
        WorkClassifier workClassifier = HttpDispatcher.getWorkClassifier();
        if (workClassifier != null) {
            Executor classifyExecutor = workClassifier.classify(this.request, this);
            if (classifyExecutor != null) {
                taskWrapper.setClassifiedExecutor(classifyExecutor);
                classifyExecutor.execute(taskWrapper);
            } else {
                taskWrapper.run();
            }
        } else {
            taskWrapper.run();
        }
    }

    @Override
    public TCPConnectionContext getTCPConnectionContext() {
        TCPConnectionContext tcc = null;
        if (this.isc != null) {
            tcc = this.isc.getTSC();
        }
        return tcc;
    }

    @Override
    public VirtualConnection getVC() {
        if (this.isc != null) {
            return this.isc.getVC();
        }
        return null;
    }

    @Override
    public ConnectionLink getHttpInboundDeviceLink() {
        if (this.isc != null && this.isc.getLink() != null) {
            return this.isc.getLink().getDeviceLink();
        }
        return null;
    }

    @Override
    public ConnectionLink getHttpInboundLink() {
        if (this.isc != null) {
            return this.isc.getLink();
        }
        return null;
    }

    @Override
    public ConnectionLink getHttpDispatcherLink() {
        return this;
    }

    private InputStream getLandingPageStream() {
        if (!HttpDispatcher.isWelcomePageEnabled().booleanValue()) {
            return null;
        }
        String theURI = this.isc.getRequest().getRequestURI();
        return WelcomePageHelper.getWelcomePageStream(theURI);
    }

    private InputStream getNotFoundStream() {
        if (!HttpDispatcher.isWelcomePageEnabled().booleanValue()) {
            return null;
        }
        return WelcomePageHelper.getNotFoundStream();
    }

    private void displayLandingPage(InputStream in) throws IOException {
        this.displayPage(in, StatusCodes.OK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayPage(InputStream inputStream, StatusCodes status) throws IOException {
        HttpOutputStreamImpl body = this.response.getBody();
        try {
            if (this.exists(inputStream)) {
                int len;
                String theURI = this.isc.getRequest().getRequestURI();
                if (status == StatusCodes.OK && !theURI.endsWith(".html")) {
                    this.response.setHeader(HttpHeaderKeys.HDR_CACHE_CONTROL.getName(), "max-age=604800");
                }
                byte[] buffer = new byte[4096];
                while ((len = inputStream.read(buffer)) > 0) {
                    ((OutputStream)body).write(buffer, 0, len);
                }
            }
        }
        finally {
            this.tryToCloseStream(inputStream);
        }
        this.sendResponse(status, null, null, false);
    }

    @FFDCIgnore(value={Throwable.class})
    private void send404Message(String url) {
        int difference;
        String s = HttpDispatcher.getContextRootNotFoundMessage();
        boolean addAddress = false;
        if (s == null || s.isEmpty()) {
            if (HttpDispatcher.isWelcomePageEnabled().booleanValue()) {
                InputStream notFoundPage = this.getNotFoundStream();
                try {
                    this.displayPage(notFoundPage, StatusCodes.NOT_FOUND);
                }
                catch (Throwable t) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Exception displaying error page; " + t), (Object[])new Object[0]);
                    }
                    if (t instanceof Exception) {
                        this.sendResponse(StatusCodes.INTERNAL_ERROR, (Exception)t, true);
                    }
                    this.sendResponse(StatusCodes.INTERNAL_ERROR, new Exception("Error page", t), true);
                }
                return;
            }
            String safeUrl = URLEscapingUtils.toSafeString(url);
            s = Tr.formatMessage((TraceComponent)tc, (String)"Missing.App.Or.Context.Root.No.Error.Code", (Object[])new Object[]{safeUrl});
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("send error with following string: " + s), (Object[])new Object[0]);
        }
        if (s != null && HttpDispatcher.padContextRootNotFoundMessage() && (difference = 513 - s.length()) > 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("404 message is not 512 so pad it. Length = " + s.length()), (Object[])new Object[0]);
            }
            StringBuffer sb = new StringBuffer(s);
            String beginComment = " <!--A comment to allow the error page to be greater than 512 bytes:";
            difference -= beginComment.length();
            String endComment = "--!> ";
            sb.append(beginComment);
            for (int i = 0; i < difference; i += 50) {
                sb.append("12345678901234567890123456789012345678901234567890");
            }
            sb.append(endComment);
            s = sb.toString();
        }
        this.sendResponse(StatusCodes.NOT_FOUND, s, null, addAddress);
    }

    private void sendResponse(StatusCodes code, Exception failure, boolean addAddress) {
        this.sendResponse(code, null, failure, addAddress);
    }

    @FFDCIgnore(value={IOException.class})
    private void sendResponse(StatusCodes code, String detail, Exception failure, boolean addAddress) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Sending HTTP response: " + code), (Object[])new Object[0]);
        }
        HttpInboundServiceContextImpl finalSc = this.isc;
        HttpResponseImpl finalResponse = this.response;
        if (finalSc == null || finalResponse == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unable to send response, isc= " + finalSc + ", response=" + finalResponse), (Object[])new Object[0]);
            }
            return;
        }
        HttpRequestMessage rqMsg = finalSc.getRequest();
        HttpResponseMessage rsMsg = finalSc.getResponse();
        this.setResponseProperties(rqMsg, rsMsg, code);
        HttpOutputStreamImpl body = finalResponse.getBody();
        if (code.isBodyAllowed() && !((HttpOutputStream)body).hasBufferedContent()) {
            try {
                byte[][] bits = new byte[][]{"<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">".getBytes(), "<html><head><title>".getBytes(), "</title></head><body><h1>".getBytes(), "</h1><p>".getBytes(), "</p><hr /><address>".getBytes(), "</address></body></html>".getBytes(), "</p></body></html>".getBytes()};
                byte[] at = " at ".getBytes();
                byte[] port = " port ".getBytes();
                ((OutputStream)body).write(bits[0]);
                ((OutputStream)body).write(bits[1]);
                byte[] msg = code.getStatusWithPhrase();
                ((OutputStream)body).write(msg);
                ((OutputStream)body).write(bits[2]);
                msg = code.getDefaultPhraseBytes();
                ((OutputStream)body).write(msg);
                ((OutputStream)body).write(bits[3]);
                if (detail != null) {
                    msg = detail.getBytes();
                    ((OutputStream)body).write(msg);
                }
                if (addAddress) {
                    ((OutputStream)body).write(bits[4]);
                    HttpChannelConfig cfg = finalSc.getHttpConfig();
                    byte[] name = cfg.getServerHeaderValue();
                    if (!cfg.removeServerHeader() && name != null) {
                        ((OutputStream)body).write(name);
                        ((OutputStream)body).write(at);
                    }
                    msg = HttpDispatcherLink.encodeDataString(this.getRequestedHost()).getBytes();
                    ((OutputStream)body).write(msg);
                    ((OutputStream)body).write(port);
                    ((OutputStream)body).write(Integer.toString(this.getRequestedPort()).getBytes());
                    ((OutputStream)body).write(bits[5]);
                } else {
                    ((OutputStream)body).write(bits[6]);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.finish(failure);
    }

    void setResponseProperties(HttpRequestMessage rqMsg, HttpResponseMessage rMsg, StatusCodes code) {
        if (rMsg.getHeader(HttpHeaderKeys.HDR_HSTS).asString() == null) {
            String htsHeader;
            String scheme = rqMsg.getScheme();
            String string = htsHeader = "https".equalsIgnoreCase(scheme) ? HttpDispatcher.getHSTS() : null;
            if (htsHeader != null) {
                rMsg.setHeader((HeaderKeys)HttpHeaderKeys.HDR_HSTS, htsHeader);
            }
        }
        rMsg.setStatusCode(code);
        rMsg.setConnection(ConnectionValues.CLOSE);
        rMsg.setCharset(Charset.forName("UTF-8"));
        rMsg.setHeader("Content-Type", "text/html; charset=UTF-8");
    }

    @Override
    public String getRequestedHost() {
        String pluginHost;
        if (this.useTrustedHeaders() && (pluginHost = this.request.getHeader(HttpHeaderKeys.HDR_$WSSN.getName())) != null) {
            return pluginHost;
        }
        String host = this.request.getVirtualHost();
        if (host == null) {
            return "localhost";
        }
        return host;
    }

    @Override
    public int getRequestedPort() {
        String pluginPort;
        if (this.useTrustedHeaders() && (pluginPort = this.request.getHeader(HttpHeaderKeys.HDR_$WSSP.getName())) != null) {
            return Integer.parseInt(pluginPort);
        }
        int port = this.request.getVirtualPort();
        if (port > 0) {
            return port;
        }
        String scheme = this.getRemoteProto();
        if (scheme == null && this.isc != null && !this.isc.useForwardedHeaders()) {
            scheme = this.getTrustedHeader(HttpHeaderKeys.HDR_X_FORWARDED_PROTO.getName());
        }
        if (scheme == null && this.request.getHeader(HttpHeaderKeys.HDR_HOST.getName()) != null) {
            scheme = this.request.getScheme();
        }
        if ("http".equals(scheme)) {
            return 80;
        }
        if ("https".equals(scheme)) {
            return 443;
        }
        return this.getLocalPort();
    }

    @Override
    public boolean useTrustedHeaders() {
        UsePrivateHeaders useHeaders = this.usePrivateHeaders;
        int lastUpdate = HttpDispatcher.getConfigUpdate();
        if ((useHeaders == UsePrivateHeaders.unknown || this.configUpdate != lastUpdate) && this.remoteAddress != null) {
            useHeaders = this.usePrivateHeaders = UsePrivateHeaders.set(HttpDispatcher.usePrivateHeaders(this.remoteAddress));
            this.configUpdate = lastUpdate;
        }
        return useHeaders.asBoolean();
    }

    @Override
    public String getTrustedHeader(String headerName) {
        if (this.useTrustedHeaders() && this.request != null) {
            return this.request.getHeader(headerName);
        }
        return null;
    }

    @Override
    public String getLocalHostAddress() {
        return this.isc.getLocalAddr().getHostAddress();
    }

    @Override
    public String getLocalHostAlias() {
        String alias = this.localHostAlias;
        if (alias == null) {
            alias = this.localHostAlias = this.getRequestedHost() + ":" + this.getRequestedPort();
        }
        return alias;
    }

    @Override
    public String getLocalHostName(boolean canonical) {
        String hostName = null;
        if (canonical) {
            hostName = this.localCanonicalHostName;
            if (hostName == null) {
                this.localCanonicalHostName = hostName = this.internalGetHostName(true);
            }
        } else {
            hostName = this.internalGetHostName(false);
        }
        return hostName;
    }

    private String internalGetHostName(final boolean canonical) {
        final HttpInboundServiceContextImpl finalSc = this.isc;
        return AccessController.doPrivileged(new PrivilegedAction<String>(){
            static final long serialVersionUID = -2892128341662403934L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String run() {
                if (canonical) {
                    return finalSc.getLocalAddr().getCanonicalHostName();
                }
                return finalSc.getLocalAddr().getHostName();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class, (String[])new String[]{"HttpDispatcher", "HttpTransport"}, (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages", (String)"com.ibm.ws.http.dispatcher.internal.channel.HttpDispatcherLink$1");
            }
        });
    }

    @Override
    public int getLocalPort() {
        return this.isc.getLocalPort();
    }

    @Override
    public String getRemoteHostAddress() {
        String remoteAddr = null;
        if (this.isc != null && this.isc.useForwardedHeaders()) {
            remoteAddr = this.isc.getForwardedRemoteAddress();
        }
        if (remoteAddr == null) {
            remoteAddr = this.getTrustedHeader(HttpHeaderKeys.HDR_$WSRA.getName());
            if (remoteAddr != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("getRemoteHostAddress isTrusted --> true, addr --> " + remoteAddr), (Object[])new Object[0]);
                }
            } else {
                remoteAddr = this.contextRemoteHostAddress();
            }
        }
        return remoteAddr;
    }

    private String contextRemoteHostAddress() {
        HttpInboundServiceContextImpl finalSc;
        String remoteAddr = this.remoteContextAddress;
        if (remoteAddr == null && (finalSc = this.isc) != null) {
            remoteAddr = this.remoteContextAddress = finalSc.getRemoteAddr().getHostAddress();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getRemoteAddr addr --> " + remoteAddr), (Object[])new Object[0]);
            }
        }
        return remoteAddr;
    }

    @Override
    public String getRemoteHostName(final boolean canonical) {
        String remoteHost = null;
        final HttpInboundServiceContextImpl finalSc = this.isc;
        if (finalSc != null && finalSc.useForwardedHeaders()) {
            remoteHost = finalSc.getForwardedRemoteHost();
        }
        if (remoteHost == null) {
            remoteHost = this.getTrustedHeader(HttpHeaderKeys.HDR_$WSRH.getName());
            if (remoteHost != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("getRemoteHost isTrusted --> true, host --> " + remoteHost), (Object[])new Object[0]);
                }
            } else {
                remoteHost = AccessController.doPrivileged(new PrivilegedAction<String>(){
                    static final long serialVersionUID = -5897722172110745537L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public String run() {
                        if (canonical) {
                            return finalSc.getRemoteAddr().getCanonicalHostName();
                        }
                        return finalSc.getRemoteAddr().getHostName();
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(2.class, (String[])new String[]{"HttpDispatcher", "HttpTransport"}, (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages", (String)"com.ibm.ws.http.dispatcher.internal.channel.HttpDispatcherLink$2");
                    }
                });
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("getRemoteHost host --> " + remoteHost), (Object[])new Object[0]);
                }
            }
        }
        return remoteHost;
    }

    @Override
    public int getRemotePort() {
        if (this.isc != null && this.isc.useForwardedHeaders() && this.isc.getForwardedRemotePort() != -1) {
            return this.isc.getForwardedRemotePort();
        }
        return this.isc.getRemotePort();
    }

    @Override
    public HttpRequest getRequest() {
        return this.request;
    }

    @Override
    public HttpResponse getResponse() {
        return this.response;
    }

    @Override
    public SSLContext getSSLContext() {
        if (this.sslinfo == null && this.isc != null && this.isc.getSSLContext() != null) {
            this.sslinfo = new SSLContextImpl(this.isc.getSSLContext());
        }
        return this.sslinfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish(Exception e) {
        HttpInboundServiceContextImpl finalSc = this.isc;
        Exception error = e;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Finishing conn; " + finalSc + " error=" + e), (Object[])new Object[0]);
        }
        if (this.vc != null) {
            String webconn = (String)this.vc.getStateMap().get("CloseNonUpgradedStreams");
            if (webconn != null && webconn.equalsIgnoreCase("CLOSED_NON_UPGRADED_STREAMS")) {
                this.vc.getStateMap().put("CloseNonUpgradedStreams", "null");
            } else {
                Object object = this.WebConnCanCloseSync;
                synchronized (object) {
                    if (this.WebConnCanClose) {
                        error = this.closeStreams();
                    }
                }
            }
        } else {
            Object object = this.WebConnCanCloseSync;
            synchronized (object) {
                if (this.WebConnCanClose) {
                    error = this.closeStreams();
                }
            }
        }
        this.close(this.getVirtualConnection(), error);
    }

    private static String encodeDataString(String iString) {
        if (iString == null) {
            return "";
        }
        int strLen = iString.length();
        if (strLen < 1) {
            return iString;
        }
        StringBuffer retString = new StringBuffer(strLen * 2);
        block12: for (int i = 0; i < strLen; ++i) {
            switch (iString.charAt(i)) {
                case '<': {
                    retString.append("&lt;");
                    continue block12;
                }
                case '>': {
                    retString.append("&gt;");
                    continue block12;
                }
                case '&': {
                    retString.append("&amp;");
                    continue block12;
                }
                case '\"': {
                    retString.append("&quot;");
                    continue block12;
                }
                case '+': {
                    retString.append("&#43;");
                    continue block12;
                }
                case '(': {
                    retString.append("&#40;");
                    continue block12;
                }
                case ')': {
                    retString.append("&#41;");
                    continue block12;
                }
                case '\'': {
                    retString.append("&#39;");
                    continue block12;
                }
                case '%': {
                    retString.append("&#37;");
                    continue block12;
                }
                case ';': {
                    retString.append("&#59;");
                    continue block12;
                }
                default: {
                    retString.append(iString.charAt(i));
                }
            }
        }
        return retString.toString();
    }

    private Exception closeStreams() {
        HttpRequestImpl finalRequest = this.request;
        HttpResponseImpl finalResponse = this.response;
        Exception error = null;
        if (finalRequest != null) {
            error = this.tryToCloseStream(finalRequest.getBody());
        }
        if (finalResponse != null) {
            Exception ex = this.tryToCloseStream(finalResponse.getBody());
            if (null == error) {
                error = ex;
            }
        }
        return error;
    }

    @Override
    public HttpDateFormat getDateFormatter() {
        return HttpDispatcher.getDateFormatter();
    }

    @Override
    public EncodingUtils getEncodingUtils() {
        return HttpDispatcher.getEncodingUtils();
    }

    @Trivial
    @FFDCIgnore(value={IOException.class})
    private boolean exists(InputStream inputStream) {
        try {
            return inputStream.available() > 0;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Trivial
    @FFDCIgnore(value={IOException.class})
    private Exception tryToCloseStream(Closeable closeStream) {
        if (closeStream != null) {
            try {
                closeStream.close();
            }
            catch (IOException ioe) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Error closing stream; " + ioe), (Object[])new Object[0]);
                }
                return ioe;
            }
        }
        return null;
    }

    @Override
    public boolean isHTTP2UpgradeRequest(Map<String, String> headers, boolean checkEnabledOnly) {
        if (this.isc != null) {
            if (checkEnabledOnly) {
                return this.isc.isHttp2Enabled();
            }
            HttpInboundLink link = this.isc.getLink();
            if (link != null) {
                return link.isHTTP2UpgradeRequest(headers);
            }
        }
        return false;
    }

    @Override
    public boolean handleHTTP2UpgradeRequest(Map<String, String> http2Settings) {
        VirtualConnection vc;
        HttpInboundLink link = this.isc.getLink();
        HttpInboundChannel channel = link.getChannel();
        H2InboundLink h2Link = new H2InboundLink(channel, vc = link.getVirtualConnection(), this.getTCPConnectionContext());
        boolean upgraded = h2Link.handleHTTP2UpgradeRequest(http2Settings, link);
        if (!upgraded) {
            return false;
        }
        h2Link.startAsyncRead(true);
        boolean rc = h2Link.getStream(1).waitForConnectionInit();
        if (!rc) {
            vc.getStateMap().put("com.ibm.ws.transport.http.http2InitError", true);
        }
        return rc;
    }

    public HttpInboundLink getHttpInboundLink2() {
        if (this.isc != null) {
            return this.isc.getLink();
        }
        return null;
    }

    @Override
    public String getRemoteProto() {
        if (this.isc != null && this.isc.useForwardedHeaders()) {
            return this.isc.getForwardedRemoteProto();
        }
        return null;
    }

    @Override
    public boolean useForwardedHeaders() {
        if (this.isc != null) {
            return this.isc.useForwardedHeaders();
        }
        return false;
    }

    public void setSuppressZeroByteChunk(boolean suppress0ByteChunk) {
        if (this.isc != null) {
            this.isc.setSuppress0ByteChunk(suppress0ByteChunk);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Failed to set isc zero byte chunk because isc is null", (Object[])new Object[0]);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class TaskWrapper
    implements Runnable {
        private final Runnable runnable;
        private final HttpDispatcherLink ic;
        private Executor classifiedExecutor;
        static final long serialVersionUID = 2989690679377838424L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public TaskWrapper(Runnable run, HttpDispatcherLink inboundConnection) {
            this.runnable = run;
            this.ic = inboundConnection;
            this.classifiedExecutor = null;
        }

        public void setClassifiedExecutor(Executor classifiedExecutor) {
            this.classifiedExecutor = classifiedExecutor;
        }

        @Override
        @FFDCIgnore(value={Throwable.class})
        public void run() {
            try {
                if (this.classifiedExecutor != null) {
                    DecoratedExecutorThread.setExecutor(this.classifiedExecutor);
                }
                this.runnable.run();
            }
            catch (Throwable t) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Unhandled exception during dispatch (bad container); " + t), (Object[])new Object[0]);
                    Tr.event((TraceComponent)tc, (String)("stack trace: \n" + t.getStackTrace().toString()), (Object[])new Object[0]);
                }
                if (this.ic.linkIsReady) {
                    if (t instanceof Exception) {
                        this.ic.sendResponse(StatusCodes.INTERNAL_ERROR, (Exception)t, true);
                    } else {
                        this.ic.sendResponse(StatusCodes.INTERNAL_ERROR, new Exception("Dispatch error", t), true);
                    }
                }
            }
            finally {
                if (this.classifiedExecutor != null) {
                    DecoratedExecutorThread.removeExecutor();
                }
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(TaskWrapper.class, (String[])new String[]{"HttpDispatcher", "HttpTransport"}, (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages", (String)"com.ibm.ws.http.dispatcher.internal.channel.HttpDispatcherLink$TaskWrapper");
        }
    }

    private static enum UsePrivateHeaders {
        unknown(true),
        yes(true),
        no(false);

        private final boolean enabled;

        static UsePrivateHeaders set(boolean useHeaders) {
            if (useHeaders) {
                return yes;
            }
            return no;
        }

        private UsePrivateHeaders(boolean enabled) {
            this.enabled = enabled;
        }

        boolean asBoolean() {
            return this.enabled;
        }
    }
}

