/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.request.interrupt.internal;

import com.ibm.websphere.interrupt.InterruptObject;
import com.ibm.websphere.interrupt.InterruptRegistrationException;
import com.ibm.websphere.interrupt.InterruptibleThreadInfrastructure;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.request.interrupt.InterruptibleRequestLifecycle;
import com.ibm.ws.request.interrupt.internal.InterruptibleThreadObject;
import com.ibm.ws.request.interrupt.status.InterruptibleThreadObjectOdiStatus;
import com.ibm.ws.request.interrupt.status.InterruptibleThreadObjectStatus;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleComponent;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleContext;
import com.ibm.wsspi.application.lifecycle.ApplicationRecycleCoordinator;
import com.ibm.wsspi.logging.Introspector;
import com.ibm.wsspi.resource.ResourceFactory;
import com.ibm.wsspi.resource.ResourceInfo;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Deactivate;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class InterruptibleThreadInfrastructureImpl
implements InterruptibleThreadInfrastructure,
InterruptibleRequestLifecycle,
ResourceFactory,
ApplicationRecycleComponent,
Introspector {
    private static final TraceComponent tc = Tr.register(InterruptibleThreadInfrastructureImpl.class, (String)"requestInterrupt");
    private static final String APP_RECYCLE_SERVICE = "appRecycleCoordinator";
    private final Set<String> applications = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<Thread, InterruptibleThreadObject> threadMap = Collections.synchronizedMap(new WeakHashMap());
    private volatile boolean hasStopped = false;
    private ScheduledExecutorService scheduledExecutor = null;
    private Class<?> _interruptibleIOContextClass = null;
    private Class<?> _interruptibleLockContextClass = null;
    static final long serialVersionUID = -5740635936347652411L;

    protected void setAppRecycleCoordinator(ServiceReference<ApplicationRecycleCoordinator> coordRef) {
    }

    protected void unsetAppRecycleCoordinator(ServiceReference<ApplicationRecycleCoordinator> coordRef) {
    }

    protected void setScheduledExecutor(ScheduledExecutorService scheduledExecutor) {
        this.scheduledExecutor = scheduledExecutor;
    }

    protected void unsetScheduledExecutor(ScheduledExecutorService scheduledExecutor) {
        this.scheduledExecutor = null;
    }

    @Activate
    @FFDCIgnore(value={ClassNotFoundException.class})
    protected void activate(ComponentContext context) {
        block5: {
            ClassLoader scl;
            block4: {
                scl = ClassLoader.getSystemClassLoader();
                try {
                    this._interruptibleIOContextClass = Class.forName("com.ibm.jvm.InterruptibleIOContext", true, scl);
                }
                catch (ClassNotFoundException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                    Tr.debug((TraceComponent)tc, (String)"ClassNotFoundException encountered when issuing Class.forName for com.ibm.jvm.InterruptibleIOContext", (Object[])new Object[0]);
                }
            }
            try {
                this._interruptibleLockContextClass = Class.forName("com.ibm.jvm.InterruptibleLockContext", true, scl);
            }
            catch (ClassNotFoundException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)"ClassNotFoundException encountered when issuing Class.forName for com.ibm.jvm.InterruptibleLockContext", (Object[])new Object[0]);
            }
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        this.hasStopped = true;
        if (!this.applications.isEmpty()) {
            ApplicationRecycleCoordinator appCoord = (ApplicationRecycleCoordinator)context.locateService(APP_RECYCLE_SERVICE);
            HashSet<String> members = new HashSet<String>(this.applications);
            this.applications.removeAll(members);
            appCoord.recycleApplications(members);
        }
        this._interruptibleIOContextClass = null;
        this._interruptibleLockContextClass = null;
    }

    /*
     * WARNING - void declaration
     */
    public void register(InterruptObject odi) throws InterruptRegistrationException {
        Thread myThread = Thread.currentThread();
        InterruptibleThreadObject io = this.threadMap.get(myThread);
        if (io == null || !io.isReady()) {
            throw new InterruptRegistrationException("This thread was not set up to register an InterruptObject");
        }
        try {
            io.register(odi);
        }
        catch (Throwable throwable) {
            void t;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.request.interrupt.internal.InterruptibleThreadInfrastructureImpl", (String)"188", (Object)this, (Object[])new Object[]{odi});
            throw new InterruptRegistrationException("An error occurred during register", (Throwable)t);
        }
    }

    public void deregister(InterruptObject odi) {
        Thread myThread = Thread.currentThread();
        InterruptibleThreadObject io = this.threadMap.get(myThread);
        if (io != null && io.isReady()) {
            io.deregister(odi);
        }
    }

    public boolean isODISupported() {
        Thread myThread = Thread.currentThread();
        InterruptibleThreadObject io = this.threadMap.get(myThread);
        boolean supported = false;
        if (io != null) {
            supported = io.isReady();
        }
        return supported;
    }

    @Override
    public void newRequestEntry(String requestId) {
        Thread myThread = Thread.currentThread();
        InterruptibleThreadObject io = this.threadMap.get(myThread);
        if (io == null) {
            io = new InterruptibleThreadObject(this._interruptibleIOContextClass, this._interruptibleLockContextClass);
            this.threadMap.put(myThread, io);
        }
        io.clear(true, requestId);
    }

    @Override
    public void completedRequestExit(String requestId) {
        Thread myThread = Thread.currentThread();
        InterruptibleThreadObject io = this.threadMap.get(myThread);
        if (io == null) {
            throw new IllegalStateException("This thread was not set up to register an InterruptObject");
        }
        io.clear(false, requestId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hungRequestDetected(String requestId, long threadId) {
        Thread hungThread = null;
        Map<Thread, InterruptibleThreadObject> map = this.threadMap;
        synchronized (map) {
            for (Thread t : this.threadMap.keySet()) {
                if (t.getId() != threadId) continue;
                hungThread = t;
                break;
            }
        }
        if (hungThread != null) {
            InterruptibleThreadObject odiStack = this.threadMap.get(hungThread);
            odiStack.interruptCurrentRequest(requestId, this.scheduledExecutor);
        } else {
            IllegalArgumentException iae = new IllegalArgumentException("Thread ID " + threadId + " was not set up for request interrupts.");
            FFDCFilter.processException((Throwable)iae, (String)this.getClass().getName(), (String)"204", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InterruptibleThreadObjectStatus> getStatusArray() {
        ArrayList<InterruptibleThreadObjectStatus> statusArray = new ArrayList<InterruptibleThreadObjectStatus>();
        Map<Thread, InterruptibleThreadObject> map = this.threadMap;
        synchronized (map) {
            for (Thread t : this.threadMap.keySet()) {
                InterruptibleThreadObject ito = this.threadMap.get(t);
                InterruptibleThreadObjectStatus itoStatus = ito.getStatus();
                if (itoStatus == null) continue;
                statusArray.add(itoStatus);
            }
        }
        return statusArray;
    }

    public Object createResource(ResourceInfo info) throws Exception {
        ComponentMetaData cData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        if (cData != null) {
            this.applications.add(cData.getJ2EEName().getApplication());
        }
        return this;
    }

    public ApplicationRecycleContext getContext() {
        return null;
    }

    public Set<String> getDependentApplications() {
        HashSet<String> members = new HashSet<String>(this.applications);
        this.applications.removeAll(members);
        return members;
    }

    public boolean hasStopped() {
        return this.hasStopped;
    }

    public String getIntrospectorName() {
        return "InterruptibleThreadIntrospector";
    }

    public String getIntrospectorDescription() {
        return "Introspect the interrupt objects that are on each thread";
    }

    public void introspect(PrintWriter out) throws Exception {
        List<InterruptibleThreadObjectStatus> itos = this.getStatusArray();
        if (!itos.isEmpty()) {
            for (InterruptibleThreadObjectStatus cur : itos) {
                if (cur == null) continue;
                long curThreadId = cur.getThreadId();
                String requestId = cur.getRequestId();
                String dispatchTime = cur.getDispatchTimeString();
                Boolean interrupted = cur.getInterrupted();
                Boolean givenUp = cur.getGivenUp();
                out.println(" ");
                out.println("Information for thread " + curThreadId);
                out.println("  Request id    " + requestId);
                out.println("  Dispatch time " + dispatchTime);
                out.println("  Interrupted   " + interrupted);
                out.println("  Given up      " + givenUp);
                out.println("  ODIs ");
                List<InterruptibleThreadObjectOdiStatus> odis = cur.getOdiStatus();
                for (InterruptibleThreadObjectOdiStatus curOdi : odis) {
                    String curName = curOdi.getName();
                    int curPos = curOdi.getPosition();
                    String objectDetails = curOdi.getDetails();
                    Boolean queried = curOdi.getQueried();
                    out.println("    " + curName + "  position: " + curPos + "  queried: " + queried + "  details: " + objectDetails);
                }
            }
        }
    }
}

