/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.social.error;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.social.error.ErrorHandler;
import com.ibm.wsspi.security.tai.TAIResult;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ErrorHandlerImpl
implements ErrorHandler {
    private static final TraceComponent tc = Tr.register(ErrorHandlerImpl.class, (String)"SOCIAL", (String)"com.ibm.ws.security.social.resources.SocialMessages");
    static final long serialVersionUID = 2652308920207990669L;

    public static ErrorHandler getInstance() {
        return new ErrorHandlerImpl();
    }

    @Override
    public void handleErrorResponse(HttpServletResponse response) {
        this.handleErrorResponse(response, 401);
    }

    @Override
    public TAIResult handleErrorResponse(HttpServletResponse response, TAIResult result) {
        this.handleErrorResponse(response, this.getTaiResultStatus(result));
        return result;
    }

    int getTaiResultStatus(TAIResult result) {
        if (result != null) {
            return result.getStatus();
        }
        return 403;
    }

    @Override
    public void handleErrorResponse(HttpServletResponse response, int httpErrorCode) {
        if (!response.isCommitted()) {
            response.setStatus(httpErrorCode);
        }
        String errorHeader = "HTTP Error 403 - Forbidden";
        if (httpErrorCode != 403) {
            errorHeader = "HTTP Error " + httpErrorCode;
        }
        String errorMessage = Tr.formatMessage((TraceComponent)tc, (String)"SOCIAL_LOGIN_FRONT_END_ERROR", (Object[])new Object[0]);
        this.writeErrorHtml(response, errorHeader, errorMessage);
    }

    /*
     * WARNING - void declaration
     */
    protected void writeErrorHtml(HttpServletResponse response, String errorHeader, String errorMessage) {
        block2: {
            StringBuffer sb = new StringBuffer();
            sb.append("<html>");
            sb.append("<head>");
            sb.append("<meta http-equiv=\"Pragma\" content=\"no-cache\"/>");
            sb.append("<title>");
            sb.append("HTTP Error Message");
            sb.append("</title>");
            sb.append(this.createCssContentString());
            sb.append("</head>");
            sb.append("<body>");
            sb.append("<div class=\"wrapper\"></div>");
            sb.append("<div id=\"top\"></div>");
            sb.append("<div id=\"top-middle\"></div>");
            sb.append("<div class=\"container\">");
            sb.append("<h1>");
            sb.append(errorHeader);
            sb.append("</h1>");
            sb.append("<span class=\"error\">");
            sb.append("Error: " + errorMessage);
            sb.append("</span>");
            sb.append("</div>");
            sb.append("<div id=\"bottom-middle\"></div>");
            sb.append("<div id=\"bottom\"></div>");
            sb.append("</div>");
            sb.append("</body>");
            sb.append("</html>");
            try {
                PrintWriter out = response.getWriter();
                out.println(sb.toString());
                out.flush();
            }
            catch (IOException out) {
                void e;
                FFDCFilter.processException((Throwable)out, (String)"com.ibm.ws.security.social.error.ErrorHandlerImpl", (String)"107", (Object)this, (Object[])new Object[]{response, errorHeader, errorMessage});
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)("Failed to obtain writer for response to write exception: " + e), (Object[])new Object[0]);
            }
        }
    }

    protected String createCssContentString() {
        StringBuilder css = new StringBuilder();
        css.append("<style>");
        css.append("body {");
        css.append("background-color: #152935;");
        css.append("font-family: serif;");
        css.append("margin: 0;");
        css.append("}\n");
        css.append("#top, #bottom {");
        css.append("padding: 20px;");
        css.append("}\n");
        css.append("");
        css.append("#top-middle, #bottom-middle {");
        css.append("background-color: #001428;");
        css.append("padding: 10px;");
        css.append("}\n");
        css.append("");
        css.append(".container {");
        css.append("background-color: white;");
        css.append("padding: 20px 50px;");
        css.append("}\n");
        css.append(".error {");
        css.append("color: red;");
        css.append("font-weight: bold;");
        css.append("}\n");
        css.append("</style>");
        return css.toString();
    }
}

