/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.social.tai;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.WebTrustAssociationException;
import com.ibm.websphere.security.WebTrustAssociationFailedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.openidconnect.clients.common.ConvergedClientConfig;
import com.ibm.ws.security.openidconnect.clients.common.OidcSessionInfo;
import com.ibm.ws.security.openidconnect.clients.common.OidcSessionUtils;
import com.ibm.ws.security.social.SocialLoginConfig;
import com.ibm.ws.security.social.error.SocialLoginException;
import com.ibm.ws.security.social.internal.OidcLoginConfigImpl;
import com.ibm.ws.security.social.internal.utils.SocialTaiRequest;
import com.ibm.ws.security.social.tai.TAIRequestHelper;
import com.ibm.ws.security.social.tai.TAIWebUtils;
import com.ibm.wsspi.security.tai.TAIResult;
import com.ibm.wsspi.security.tai.TrustAssociationInterceptor;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SocialLoginSessionInvalidatorTAI
implements TrustAssociationInterceptor {
    public static final TraceComponent tc = Tr.register(SocialLoginSessionInvalidatorTAI.class, (String)"SOCIAL", (String)"com.ibm.ws.security.social.resources.SocialMessages");
    TAIWebUtils taiWebUtils = new TAIWebUtils();
    TAIRequestHelper taiRequestHelper = new TAIRequestHelper();
    private static boolean issuedBetaMessage = false;
    static final long serialVersionUID = 158611120959314266L;

    @Activate
    protected void activate(ComponentContext cc, Map<String, Object> props) {
    }

    @Modified
    protected void modified(ComponentContext cc, Map<String, Object> props) {
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
    }

    public boolean isTargetInterceptor(HttpServletRequest req) throws WebTrustAssociationException {
        if (!this.isRunningBetaMode()) {
            return false;
        }
        SocialTaiRequest socialTaiRequest = this.taiRequestHelper.createSocialTaiRequestAndSetRequestAttribute(req);
        this.taiRequestHelper.requestShouldBeHandledByTAI(req, socialTaiRequest);
        this.logoutIfSessionInvalidated(req);
        return false;
    }

    boolean isRunningBetaMode() {
        if (!ProductInfo.getBetaEdition()) {
            return false;
        }
        if (!issuedBetaMessage) {
            Tr.info((TraceComponent)tc, (String)("BETA: A beta method has been invoked for the class " + this.getClass().getName() + " for the first time."), (Object[])new Object[0]);
            issuedBetaMessage = !issuedBetaMessage;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void logoutIfSessionInvalidated(HttpServletRequest request) {
        SocialTaiRequest socialTaiRequest = (SocialTaiRequest)request.getAttribute("SocialTaiRequest");
        if (socialTaiRequest == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Request is missing SocialTaiRequest attribute.", (Object[])new Object[0]);
            }
            return;
        }
        SocialLoginConfig clientConfig = null;
        try {
            clientConfig = socialTaiRequest.getTheOnlySocialLoginConfig();
        }
        catch (SocialLoginException socialLoginException) {
            FFDCFilter.processException((Throwable)socialLoginException, (String)"com.ibm.ws.security.social.tai.SocialLoginSessionInvalidatorTAI", (String)"118", (Object)this, (Object[])new Object[]{request});
            if (tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)("A unique social login config wasn't found for this request. Exception was " + e.getMessage()), (Object[])new Object[0]);
            }
            return;
        }
        if (clientConfig == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Client config for request could not be found. An error must have occurred initializing this request.", (Object[])new Object[0]);
            }
            return;
        }
        if (!(clientConfig instanceof ConvergedClientConfig)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Client config not an instance of ConvergedClientConfig.", (Object[])new Object[0]);
            }
            return;
        }
        OidcSessionInfo sessionInfo = OidcSessionInfo.getSessionInfo((HttpServletRequest)request, (ConvergedClientConfig)((ConvergedClientConfig)clientConfig));
        if (sessionInfo == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Session info could not be retrieved from client cookies.", (Object[])new Object[0]);
            }
            return;
        }
        if (clientConfig instanceof OidcLoginConfigImpl) {
            OidcSessionUtils.logoutIfSessionInvalidated((HttpServletRequest)request, (OidcSessionInfo)sessionInfo, (ConvergedClientConfig)((OidcLoginConfigImpl)clientConfig));
        }
    }

    public TAIResult negotiateValidateandEstablishTrust(HttpServletRequest request, HttpServletResponse response) {
        return null;
    }

    public int initialize(Properties props) throws WebTrustAssociationFailedException {
        return 0;
    }

    public String getVersion() {
        return null;
    }

    public String getType() {
        return null;
    }

    public void cleanup() {
    }
}

