/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.pkce;

import com.ibm.oauth.core.api.error.oauth20.InvalidGrantException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20MissingParameterException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.pkce.ProofKeyForCodeExchangeMethod;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ProofKeyForCodeExchange {
    private static final TraceComponent tc = Tr.register(ProofKeyForCodeExchange.class, (String)"OAUTH20", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    public static final int CODE_VERIFIER_MIN_LENGTH = 43;
    public static final int CODE_VERIFIER_MAX_LENGTH = 128;
    static final long serialVersionUID = 5800061217924329224L;

    @FFDCIgnore(value={NoSuchAlgorithmException.class})
    public static String generateCodeVerifier() {
        SecureRandom random;
        try {
            random = SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException e) {
            random = new SecureRandom();
        }
        byte[] verifierBytes = new byte[32];
        random.nextBytes(verifierBytes);
        String codeVerifier = new String(Base64.getUrlEncoder().encode(verifierBytes));
        codeVerifier = codeVerifier.replaceAll("[=]+$", "");
        return codeVerifier;
    }

    public static void verifyCodeChallenge(String codeVerifier, String codeChallenge, String codeChallengeMethod) throws OAuth20MissingParameterException, InvalidGrantException {
        if (codeVerifier == null) {
            throw new OAuth20MissingParameterException("security.oauth20.error.missing.parameter", "code_verifier", null);
        }
        if (!ProofKeyForCodeExchange.isCodeVerifierLengthAcceptable(codeVerifier)) {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"security.oauth20.pkce.codeverifier.length.error", (Object[])new Object[]{codeVerifier.length()});
            throw new InvalidGrantException(message, null);
        }
        ProofKeyForCodeExchangeMethod pkceMethod = ProofKeyForCodeExchangeMethod.getInstance(codeChallengeMethod);
        if (pkceMethod == null) {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"security.oauth20.pkce.invalid.method.error", (Object[])new Object[]{codeChallengeMethod});
            throw new InvalidGrantException(message, null);
        }
        pkceMethod.validate(codeVerifier, codeChallenge);
    }

    static boolean isCodeVerifierLengthAcceptable(String codeVerifier) {
        return codeVerifier != null && codeVerifier.length() >= 43 && codeVerifier.length() <= 128;
    }
}

