/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.se.logging;

import java.io.Serializable;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.weld.environment.logging.WeldEnvironmentLogger;
import org.jboss.weld.environment.se.logging.WeldSELogger;
import org.jboss.weld.exceptions.IllegalArgumentException;

public class WeldSELogger_$logger
extends DelegatingBasicLogger
implements WeldSELogger,
WeldEnvironmentLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = WeldSELogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public WeldSELogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String weldContainerAlreadyRunning$str() {
        return "WELD-ENV-002000: Weld SE container {0} is already running!";
    }

    @Override
    public final IllegalStateException weldContainerAlreadyRunning(Object id) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.weldContainerAlreadyRunning$str(), id));
        WeldSELogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private String _formatMessage(String format, Object ... args) {
        MessageFormat formatter = new MessageFormat(format, this.getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new FieldPosition(0)).toString();
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    @Override
    public final void weldContainerShutdown(Object id) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.weldContainerShutdown$str(), id);
    }

    protected String weldContainerShutdown$str() {
        return "WELD-ENV-002001: Weld SE container {0} shut down";
    }

    protected String weldContainerAlreadyShutDown$str() {
        return "WELD-ENV-002002: Weld SE container {0} was already shut down";
    }

    @Override
    public final IllegalStateException weldContainerAlreadyShutDown(Object id) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.weldContainerAlreadyShutDown$str(), id));
        WeldSELogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void weldContainerInitialized(Object id) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.weldContainerInitialized$str(), id);
    }

    protected String weldContainerInitialized$str() {
        return "WELD-ENV-002003: Weld SE container {0} initialized";
    }

    @Override
    public final void scanningPackage(Object packageName, Object resource) {
        this.log.logv(FQCN, Logger.Level.DEBUG, null, this.scanningPackage$str(), packageName, resource);
    }

    protected String scanningPackage$str() {
        return "WELD-ENV-002004: Scanning package {0}, class resource: {1}";
    }

    @Override
    public final void packageNotFound(Object packageName) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.packageNotFound$str(), packageName);
    }

    protected String packageNotFound$str() {
        return "WELD-ENV-002005: Package intended for scanning was not found: {0}";
    }

    @Override
    public final void multipleContainersRunning(Object ids) {
        this.log.logv(FQCN, Logger.Level.INFO, null, this.multipleContainersRunning$str(), ids);
    }

    protected String multipleContainersRunning$str() {
        return "WELD-ENV-002006: Multiple containers running - CDI.current() may not work properly: {0}";
    }

    @Override
    public final void resourceUrlProtocolNotSupported(Object resource) {
        this.log.logv(FQCN, Logger.Level.DEBUG, null, this.resourceUrlProtocolNotSupported$str(), resource);
    }

    protected String resourceUrlProtocolNotSupported$str() {
        return "WELD-ENV-002007: Resource URL procotol not supported: {0}";
    }

    @Override
    public final void beanClassDeployedInMultipleBeanArchives(Object beanClass, Object bdas) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.beanClassDeployedInMultipleBeanArchives$str(), beanClass, bdas);
    }

    protected String beanClassDeployedInMultipleBeanArchives$str() {
        return "WELD-ENV-002008: Bean class {0} found in multiple bean archives - this may result in incorrect behavior: {1}";
    }

    protected String weldContainerCannotBeInitializedNoBeanArchivesFound$str() {
        return "WELD-ENV-002009: Weld SE container cannot be initialized - no bean archives found";
    }

    @Override
    public final IllegalStateException weldContainerCannotBeInitializedNoBeanArchivesFound() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.weldContainerCannotBeInitializedNoBeanArchivesFound$str(), new Object[0]));
        WeldSELogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String observedTypeNotContonainerLifecycleEventType$str() {
        return "WELD-ENV-002010: The observed type {0} is not a container lifecycle event type";
    }

    @Override
    public final IllegalArgumentException observedTypeNotContonainerLifecycleEventType(Object type) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.observedTypeNotContonainerLifecycleEventType$str(), type));
        WeldSELogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String observedTypeDoesNotMatchContonainerLifecycleEventType$str() {
        return "WELD-ENV-002011: The observed type {0} does not match the container lifecycle event type {1}";
    }

    @Override
    public final IllegalArgumentException observedTypeDoesNotMatchContonainerLifecycleEventType(Object type, Object eventType) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.observedTypeDoesNotMatchContonainerLifecycleEventType$str(), type, eventType));
        WeldSELogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String containerLifecycleObserverNotInitialized$str() {
        return "WELD-ENV-002012: The container lifecycle observer is not properly initialized: {0}";
    }

    @Override
    public final IllegalStateException containerLifecycleObserverNotInitialized(Object info) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.containerLifecycleObserverNotInitialized$str(), info));
        WeldSELogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String weldContainerDeploymentNotValidated$str() {
        return "WELD-ENV-002014: Weld SE container with id {0} has not yet validated the deployment - methods for programmatic lookup cannot be used";
    }

    @Override
    public final IllegalStateException weldContainerDeploymentNotValidated(Object id) {
        IllegalStateException result = new IllegalStateException(this._formatMessage(this.weldContainerDeploymentNotValidated$str(), id));
        WeldSELogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String beanArchiveWithModeNone$str() {
        return "WELD-ENV-002015: Bean discovery mode NONE is not a valid option for Weld SE deployment archive - Weld SE container with id {0}.";
    }

    @Override
    public final IllegalArgumentException beanArchiveWithModeNone(Object id) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.beanArchiveWithModeNone$str(), id));
        WeldSELogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String zeroOrMoreThanOneContainerRunning$str() {
        return "WELD-ENV-002016: Zero or more than one container is running - WeldContainer.current() cannot determine the current container.";
    }

    @Override
    public final IllegalStateException zeroOrMoreThanOneContainerRunning() {
        IllegalStateException result = new IllegalStateException(this.zeroOrMoreThanOneContainerRunning$str());
        WeldSELogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unexpectedValueForAdditionalBeanDefiningAnnotations$str() {
        return "WELD-ENV-002017: Unexpected value for parameter 'org.jboss.weld.se.additionalBeanDefiningAnnotations'. Expected java.util.Collection but found {0}. ";
    }

    @Override
    public final IllegalArgumentException unexpectedValueForAdditionalBeanDefiningAnnotations(Class clazz) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.unexpectedValueForAdditionalBeanDefiningAnnotations$str(), clazz));
        WeldSELogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void unexpectedItemsInValueCollection(Class clazz) {
        this.log.logv(FQCN, Logger.Level.WARN, null, this.unexpectedItemsInValueCollection$str(), (Object)clazz);
    }

    protected String unexpectedItemsInValueCollection$str() {
        return "WELD-ENV-002018: Skipping registration of additional bean defining annotation via `org.jboss.weld.se.additionalBeanDefiningAnnotations`. Only values of type Class<? extends Annotation> are valid. Found: {0}";
    }

    protected String failedToLoadClass$str() {
        return "WELD-ENV-002019: Failed to parse the following string as additional bean defining annotation: {0}. The exception was: {1}";
    }

    @Override
    public final IllegalArgumentException failedToLoadClass(String className, String exception) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.failedToLoadClass$str(), className, exception));
        WeldSELogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    public final void catchingDebug(Throwable arg0) {
        this.log.logf(FQCN, Logger.Level.DEBUG, arg0, this.catchingDebug$str(), new Object[0]);
    }

    protected String catchingDebug$str() {
        return "Catching";
    }

    public final void catchingTrace(Throwable arg0) {
        this.log.logf(FQCN, Logger.Level.TRACE, arg0, this.catchingTrace$str(), new Object[0]);
    }

    protected String catchingTrace$str() {
        return "Catching";
    }
}

