/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmispec.util;

import java.rmi.RMISecurityManager;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.apache.yoko.osgi.ProviderLocator;

public class UtilLoader {
    static final Logger logger = Logger.getLogger(UtilLoader.class.getName());
    private static final SecMan SEC_MAN = UtilLoader.doPriv(SecMan::new);
    private static final ClassLoader MY_LOADER = UtilLoader.doPriv(UtilLoader.class::getClassLoader);
    private static final Function<Class, ClassLoader> GET_LOADER = type -> UtilLoader.doPriv(type::getClassLoader);

    public static <T> Class<T> loadServiceClass(String delegateName, String delegateKey) throws ClassNotFoundException {
        return ProviderLocator.getServiceClass((String)delegateKey, null, null).map(Optional::of).orElseGet(() -> UtilLoader.loadClass0(delegateName, null)).orElse(null);
    }

    public static <T> Optional<Class<T>> loadDelegateClass(String name, ClassLoader loader) {
        try {
            return Optional.of(ProviderLocator.loadClass((String)name, null, (ClassLoader)loader));
        }
        catch (ClassNotFoundException ignored) {
            return UtilLoader.loadClass0(name, loader);
        }
    }

    private static <T> Optional<Class<T>> loadClass0(String name, ClassLoader loader) {
        Stream<ClassLoader> loadersFromStack = Stream.of(SEC_MAN.getClassContext()).skip(1L).map(GET_LOADER).filter(Predicate.isEqual(MY_LOADER).negate()).filter(Objects::nonNull).peek(ldr -> logger.fine("Trying stack loader: " + ldr));
        Stream<ClassLoader> loaderOfThisClass = Stream.of(MY_LOADER).filter(Objects::nonNull).peek(ldr -> logger.fine("Trying util loader: " + ldr));
        Stream<ClassLoader> loaderFromContext = Stream.of(loader).map(l -> l == null ? UtilLoader.doPriv(Thread.currentThread()::getContextClassLoader) : l).filter(Objects::nonNull).peek(ldr -> logger.fine("Trying supplied/context loader: " + ldr));
        Function<ClassLoader, Class> loadClass = ldr -> {
            try {
                return ldr.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                logger.log(Level.FINER, "Loader says " + e.getMessage(), e);
                return null;
            }
        };
        return Stream.of(loadersFromStack, loaderOfThisClass, loaderFromContext).flatMap(s -> s).map(loadClass).filter(Objects::nonNull).findFirst();
    }

    private static <T> T doPriv(PrivilegedAction<T> action) {
        return AccessController.doPrivileged(action);
    }

    static class SecMan
    extends RMISecurityManager {
        SecMan() {
        }

        public Class[] getClassContext() {
            return super.getClassContext();
        }
    }
}

