/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcpchannel.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.tcpchannel.internal.ChannelSelector;
import com.ibm.ws.tcpchannel.internal.ConnectionManager;
import com.ibm.ws.tcpchannel.internal.TCPFactoryConfiguration;
import com.ibm.ws.tcpchannel.internal.WorkQueueManager;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;

public class ConnectChannelSelector
extends ChannelSelector {
    private static final TraceComponent tc = Tr.register(ConnectChannelSelector.class, (String)"TCPChannel", (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages");
    protected WorkQueueManager wqm;
    private final int countIndex;
    private final int channelType;

    public ConnectChannelSelector(WorkQueueManager _wqm, int _index, int _channelType) throws IOException {
        super(false);
        this.wqm = _wqm;
        this.countIndex = _index;
        this.channelType = _channelType;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Created Connect selector: " + this), (Object[])new Object[0]);
        }
    }

    public ConnectChannelSelector(WorkQueueManager _wqm, int _index, int _channelType, boolean _startImmediately) throws IOException {
        super(false, _startImmediately);
        this.wqm = _wqm;
        this.countIndex = _index;
        this.channelType = _channelType;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Created Connect selector: " + this), (Object[])new Object[0]);
        }
    }

    @Override
    protected void updateSelector() {
        Queue<Object> work = this.getWorkQueue();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("updateSelector - processing " + work.size() + " items"), (Object[])new Object[0]);
        }
        ConnectionManager.ConnectInfo ci = null;
        while (!work.isEmpty()) {
            ci = (ConnectionManager.ConnectInfo)work.remove();
            try {
                ci.channel.register(this.selector, 8, ci);
                if (ci.timeout != -1) {
                    ci.nextTimeoutTime = System.currentTimeMillis() + (long)ci.timeout;
                    if (ci.nextTimeoutTime < this.nextTimeoutTime) {
                        this.nextTimeoutTime = ci.nextTimeoutTime;
                    }
                }
                this.updateCount();
            }
            catch (ClosedChannelException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)("SocketChannel connect failed, " + e + " local: " + ci.ioSocket.getSocket().getLocalSocketAddress() + " remote: " + ci.ioSocket.getSocket().getRemoteSocketAddress()), (Object[])new Object[0]);
                }
                ci.setError(e);
                if (this.wqm.dispatchConnect(ci)) continue;
                this.addWork(ci);
            }
        }
        if (ci != null) {
            this.waitingToQuit = false;
            this.quit = false;
        }
    }

    @Override
    protected void updateCount() {
        int selectorCount = this.selector.keys().size();
        if (selectorCount == 0 && this.countIndex != 0) {
            this.wqm.updateCount(this.countIndex, -2, this.channelType);
        } else {
            this.waitingToQuit = false;
            this.wqm.updateCount(this.countIndex, selectorCount, this.channelType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void channelSelectorClose() {
        Object object = this.wqm.shutdownSync;
        synchronized (object) {
            try {
                this.selector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.wqm.updateCount(this.countIndex, -1, this.channelType);
        }
    }

    @Override
    protected boolean performRequest() {
        boolean cancelledDone = false;
        Set<SelectionKey> keySet = this.selector.selectedKeys();
        Iterator<SelectionKey> selectedIterator = keySet.iterator();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("performRequest - processing " + keySet.size() + " items"), (Object[])new Object[0]);
        }
        while (selectedIterator.hasNext()) {
            SelectionKey selectedKey = selectedIterator.next();
            selectedIterator.remove();
            ConnectionManager.ConnectInfo connectInfo = (ConnectionManager.ConnectInfo)selectedKey.attachment();
            connectInfo.setFinish();
            if (!this.wqm.dispatchConnect(connectInfo)) continue;
            selectedKey.cancel();
            cancelledDone = true;
        }
        return cancelledDone;
    }

    @Override
    protected void checkForTimeouts() {
        if (this.currentTime < this.nextTimeoutTime) {
            return;
        }
        Set<SelectionKey> selectorKeys = this.selector.keys();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("checkForTimeouts - checking " + selectorKeys.size() + " keys for timeouts"), (Object[])new Object[0]);
        }
        if (selectorKeys.isEmpty()) {
            if (this.countIndex != 0) {
                if (this.waitingToQuit) {
                    this.quit = true;
                } else {
                    this.wqm.updateCount(this.countIndex, -2, this.channelType);
                    this.waitingToQuit = true;
                    this.nextTimeoutTime = this.currentTime + TCPFactoryConfiguration.getChannelSelectorWaitToTerminate();
                }
            } else {
                this.nextTimeoutTime = this.currentTime + TCPFactoryConfiguration.getChannelSelectorIdleTimeout();
            }
        } else {
            this.waitingToQuit = false;
            this.nextTimeoutTime = this.currentTime + TCPFactoryConfiguration.getChannelSelectorIdleTimeout();
            for (SelectionKey key : selectorKeys) {
                try {
                    if (0 == key.interestOps()) continue;
                    ConnectionManager.ConnectInfo ci = (ConnectionManager.ConnectInfo)key.attachment();
                    if (ci.timeout == -1) continue;
                    if (ci.nextTimeoutTime <= this.currentTime) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            Tr.event((Object)this, (TraceComponent)tc, (String)("Inactivity timeout on connect operation for channel" + ci.ioSocket.getChannel()), (Object[])new Object[0]);
                        }
                        InetSocketAddress iaRemote = ci.remoteAddress;
                        InetSocketAddress iaLocal = ci.localAddress;
                        SocketTimeoutException e = new SocketTimeoutException("Socket operation timed out before it could be completed. local=" + iaLocal + " remote=" + iaRemote);
                        ci.setError(e);
                        if (!this.wqm.dispatchConnect(ci)) continue;
                        key.cancel();
                        ci.ioSocket.close();
                        continue;
                    }
                    if (ci.nextTimeoutTime >= this.nextTimeoutTime) continue;
                    this.nextTimeoutTime = ci.nextTimeoutTime;
                }
                catch (CancelledKeyException cke) {}
            }
        }
    }
}

