/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.contextpropagation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.context.ContainerContextProvider;
import com.ibm.ws.microprofile.context.DeferredClearedContext;
import com.ibm.ws.microprofile.contextpropagation.ContextManagerProviderImpl;
import com.ibm.ws.microprofile.contextpropagation.ContextOp;
import com.ibm.ws.microprofile.contextpropagation.ContextSnapshotProxy;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.threadcontext.ThreadContext;
import com.ibm.wsspi.threadcontext.ThreadContextDescriptor;
import java.io.IOException;
import java.io.NotSerializableException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.microprofile.context.spi.ThreadContextProvider;
import org.eclipse.microprofile.context.spi.ThreadContextSnapshot;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class ThreadContextDescriptorImpl
implements ThreadContextDescriptor {
    private static final TraceComponent tc = Tr.register(ThreadContextDescriptorImpl.class, (String)"concurrent", (String)"com.ibm.ws.microprofile.context.resources.CWWKCMessages");
    private final Map<String, String> EMPTY_MAP = Collections.emptyMap();
    private final ContextManagerProviderImpl cmProvider;
    private final ArrayList<ThreadContext> contextSnapshots = new ArrayList();
    private final String metadataIdentifier;
    static final long serialVersionUID = 2411782069374894201L;

    ThreadContextDescriptorImpl(ContextManagerProviderImpl cmProvider, LinkedHashMap<ThreadContextProvider, ContextOp> configPerProvider) {
        this.cmProvider = cmProvider;
        ComponentMetaData cData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        this.metadataIdentifier = cData == null ? null : cmProvider.metadataIdentifierService.getMetaDataIdentifier((MetaData)cData);
        for (Map.Entry<ThreadContextProvider, ContextOp> entry : configPerProvider.entrySet()) {
            ThreadContextProvider provider = entry.getKey();
            if (provider instanceof ContainerContextProvider) {
                ((ContainerContextProvider)provider).addContextSnapshot(entry.getValue(), this.contextSnapshots);
                continue;
            }
            ThreadContextSnapshot contextSnapshot = entry.getValue() == ContextOp.CLEARED ? provider.clearedContext(this.EMPTY_MAP) : provider.currentContext(this.EMPTY_MAP);
            this.contextSnapshots.add(new ContextSnapshotProxy(contextSnapshot));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    public ThreadContextDescriptor clone() {
        try {
            return (ThreadContextDescriptorImpl)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            void x;
            FFDCFilter.processException((Throwable)cloneNotSupportedException, (String)"com.ibm.ws.microprofile.contextpropagation.ThreadContextDescriptorImpl", (String)"86", (Object)this, (Object[])new Object[0]);
            throw new RuntimeException((Throwable)x);
        }
    }

    @Trivial
    public Map<String, String> getExecutionProperties() {
        return this.EMPTY_MAP;
    }

    public boolean isSerializable() {
        return false;
    }

    @Trivial
    public byte[] serialize() throws IOException {
        throw new NotSerializableException();
    }

    @Trivial
    public void set(String providerName, ThreadContext context) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    public ArrayList<ThreadContext> taskStarting() throws RejectedExecutionException {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (this.metadataIdentifier != null && this.cmProvider.metadataIdentifierService.getMetaData(this.metadataIdentifier) == null) {
            com.ibm.ws.context.service.serializable.ThreadContextDescriptorImpl.notAvailable((String)this.metadataIdentifier, (String)"");
        }
        ArrayList<ThreadContext> contextAppliedToThread = new ArrayList<ThreadContext>(this.contextSnapshots.size());
        try {
            for (ThreadContext contextSnapshot : this.contextSnapshots) {
                contextSnapshot = contextSnapshot.clone();
                contextSnapshot.taskStarting();
                contextAppliedToThread.add(contextSnapshot);
                if (!trace || !tc.isDebugEnabled()) continue;
                if (contextSnapshot instanceof DeferredClearedContext) {
                    ThreadContext clearedContextController = ((DeferredClearedContext)contextSnapshot).clearedContextController;
                    if (clearedContextController == null) continue;
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("cleared context " + clearedContextController), (Object[])new Object[0]);
                    continue;
                }
                Tr.debug((Object)this, (TraceComponent)tc, (String)("applied context " + ThreadContextDescriptorImpl.toString(contextSnapshot)), (Object[])new Object[0]);
            }
        }
        catch (Error | RuntimeException throwable) {
            void x;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.microprofile.contextpropagation.ThreadContextDescriptorImpl", (String)"151", (Object)this, (Object[])new Object[0]);
            for (int c = contextAppliedToThread.size() - 1; c >= 0; --c) {
                try {
                    ThreadContext appliedContext = contextAppliedToThread.get(c);
                    if (trace && tc.isDebugEnabled()) {
                        if (appliedContext instanceof DeferredClearedContext) {
                            ThreadContext clearedContextController = ((DeferredClearedContext)appliedContext).clearedContextController;
                            if (clearedContextController != null) {
                                Tr.debug((Object)this, (TraceComponent)tc, (String)("restore context " + clearedContextController), (Object[])new Object[0]);
                            }
                        } else {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)("restore context " + ThreadContextDescriptorImpl.toString(appliedContext)), (Object[])new Object[0]);
                        }
                    }
                    appliedContext.taskStopping();
                    continue;
                }
                catch (Throwable throwable2) {
                    FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.microprofile.contextpropagation.ThreadContextDescriptorImpl", (String)"166", (Object)this, (Object[])new Object[0]);
                }
            }
            throw x;
        }
        return contextAppliedToThread;
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    public void taskStopping(ArrayList<ThreadContext> contextAppliedToThread) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        Throwable failure = null;
        for (int c = contextAppliedToThread.size() - 1; c >= 0; --c) {
            try {
                ThreadContext appliedContext = contextAppliedToThread.get(c);
                if (trace && tc.isDebugEnabled()) {
                    if (appliedContext instanceof DeferredClearedContext) {
                        ThreadContext clearedContextController = ((DeferredClearedContext)appliedContext).clearedContextController;
                        if (clearedContextController != null) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)("restore context " + clearedContextController), (Object[])new Object[0]);
                        }
                    } else {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("restore context " + ThreadContextDescriptorImpl.toString(appliedContext)), (Object[])new Object[0]);
                    }
                }
                appliedContext.taskStopping();
                continue;
            }
            catch (Throwable appliedContext) {
                void x;
                FFDCFilter.processException((Throwable)appliedContext, (String)"com.ibm.ws.microprofile.contextpropagation.ThreadContextDescriptorImpl", (String)"199", (Object)this, (Object[])new Object[]{contextAppliedToThread});
                if (failure != null) continue;
                failure = x;
            }
        }
        if (failure != null) {
            if (failure instanceof RuntimeException) {
                throw (RuntimeException)failure;
            }
            if (failure instanceof Error) {
                throw (Error)failure;
            }
            throw new RuntimeException(failure);
        }
    }

    @Trivial
    private static String toString(ThreadContext c) {
        if (c == null) {
            return null;
        }
        String s = c.toString();
        if (s.indexOf(64) < 0) {
            s = c.getClass().getSimpleName() + '@' + Integer.toHexString(System.identityHashCode(c)) + ':' + s;
        }
        return s;
    }
}

