/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsoc;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.transport.access.TransportConnectionAccess;
import com.ibm.ws.wsoc.EndpointManager;
import com.ibm.ws.wsoc.LinkRead;
import com.ibm.ws.wsoc.LinkWrite;
import com.ibm.ws.wsoc.MessageWriter;
import com.ibm.ws.wsoc.OpcodeType;
import com.ibm.ws.wsoc.ParametersOfInterest;
import com.ibm.ws.wsoc.ServiceManager;
import com.ibm.ws.wsoc.SessionIdleTimeout;
import com.ibm.ws.wsoc.SessionImpl;
import com.ibm.ws.wsoc.WsocReadCallback;
import com.ibm.ws.wsoc.WsocWriteCallback;
import com.ibm.ws.wsoc.external.SessionExt;
import com.ibm.ws.wsoc.injection.InjectionProvider;
import com.ibm.ws.wsoc.injection.InjectionProvider12;
import com.ibm.ws.wsoc.injection.InjectionThings;
import com.ibm.ws.wsoc.util.Utils;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.bytebuffer.WsByteBufferPoolManager;
import com.ibm.wsspi.channelfw.ConnectionLink;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.tcpchannel.TCPConnectionContext;
import com.ibm.wsspi.tcpchannel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPReadRequestContext;
import com.ibm.wsspi.tcpchannel.TCPWriteRequestContext;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.Set;
import javax.servlet.http.HttpSession;
import javax.websocket.CloseReason;
import javax.websocket.EncodeException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.SendHandler;
import javax.websocket.Session;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WsocConnLink {
    private static final TraceComponent tc = Tr.register(WsocConnLink.class, (String)"websockets", (String)"com.ibm.ws.wsoc.internal.resources.WebSockets");
    public LINK_STATUS linkStatus = LINK_STATUS.IO_NOT_OK;
    public READ_LINK_STATUS readLinkStatus = READ_LINK_STATUS.READ_NOT_OK;
    public WRITE_LINK_STATUS writeLinkStatus = WRITE_LINK_STATUS.WRITE_NOT_OK;
    private CLOSE_FRAME_STATE closeFrameState = CLOSE_FRAME_STATE.NOT_SET;
    private final int closeFrameReadTimeout = 30000;
    private final int WAIT_ON_WRITE_TO_CLOSE = 5500;
    private final int WAIT_ON_READ_TO_CLOSE = 8500;
    public Object linkSync = new Object(){
        static final long serialVersionUID = 2374407620509092400L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.wsoc.WsocConnLink$1", 1.class, (String)"websockets", (String)"com.ibm.ws.wsoc.internal.resources.WebSockets");
        }
    };
    public boolean readNotifyTriggered = false;
    public boolean writeNotifyTriggered = false;
    private Endpoint appEndPoint = null;
    private SessionExt wsocSession = null;
    private VirtualConnection vConnection = null;
    private TCPConnectionContext tcpConnection = null;
    private ConnectionLink deviceConnLink = null;
    private TCPReadRequestContext tcpReadContext = null;
    private WsocReadCallback wrc = null;
    private LinkRead linkRead = null;
    private LinkWrite linkWrite = null;
    private EndpointManager endpointManager = null;
    private ParametersOfInterest things = null;
    boolean readWrite = false;
    private final Object SyncReadPushPop = new Object();
    private int readPush = 0;
    private final Object SyncWritePushPop = new Object();
    private int writePush = 0;
    WsByteBuffer writeBufferToRelease = null;
    private static final int READ_BUFFER_SIZE = 8192;
    CloseReason idleTimeoutCloseReason = null;
    static final long serialVersionUID = -6446060597702781046L;

    public void initialize(Endpoint ep, EndpointConfig epc, SessionExt ses, TransportConnectionAccess access, boolean clientSide) {
        this.appEndPoint = ep;
        this.wsocSession = ses;
        this.tcpConnection = access.getTCPConnectionContext();
        this.deviceConnLink = access.getDeviceConnLink();
        this.vConnection = access.getVirtualConnection();
        TCPWriteRequestContext tcpWriteContext = this.tcpConnection.getWriteInterface();
        this.tcpReadContext = this.tcpConnection.getReadInterface();
        this.linkWrite = new LinkWrite();
        this.linkRead = new LinkRead();
        this.wrc = new WsocReadCallback();
        this.wrc.setConnLinkCallback(this);
        if (clientSide) {
            this.linkWrite.initialize(tcpWriteContext, epc, this, true);
            this.linkRead.initialize(this.tcpReadContext, epc, ep, this, false);
        } else {
            this.linkWrite.initialize(tcpWriteContext, epc, this, false);
            this.linkRead.initialize(this.tcpReadContext, epc, ep, this, true);
        }
    }

    public void setParametersOfInterest(ParametersOfInterest value) {
        this.things = value;
    }

    public ParametersOfInterest getParametersOfInterest() {
        return this.things;
    }

    public WsocWriteCallback getWriteCallback() {
        WsocWriteCallback wwc = new WsocWriteCallback();
        wwc.setConnLinkCallback(this);
        return wwc;
    }

    public WsocReadCallback getReadCallback() {
        WsocReadCallback wrc = new WsocReadCallback();
        wrc.setConnLinkCallback(this);
        return wrc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OK_TO_READ okToStartRead() {
        Object object = this.linkSync;
        synchronized (object) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("link status: " + (Object)((Object)this.linkStatus) + " read link status is: " + (Object)((Object)this.readLinkStatus) + " closeFrameState: " + (Object)((Object)this.closeFrameState)), (Object[])new Object[0]);
            }
            if (this.linkStatus == LINK_STATUS.IO_OK && (this.readLinkStatus == READ_LINK_STATUS.OK_TO_READ || this.readLinkStatus == READ_LINK_STATUS.ON_READ_THREAD)) {
                this.readLinkStatus = READ_LINK_STATUS.BEFORE_READ_ON_WIRE;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("readLinkStatus: " + (Object)((Object)this.readLinkStatus)), (Object[])new Object[0]);
                }
                if (this.closeFrameState == CLOSE_FRAME_STATE.ANTICIPATING) {
                    return OK_TO_READ.OK_CLOSE_FRAME_TIMEOUT;
                }
                return OK_TO_READ.OK_NO_TIMEOUT;
            }
            if (this.readLinkStatus == READ_LINK_STATUS.CLOSE_REQUESTED && (this.linkStatus == LINK_STATUS.LOCAL_CLOSING || this.closeFrameState == CLOSE_FRAME_STATE.ANTICIPATING) || (this.readLinkStatus == READ_LINK_STATUS.OK_TO_READ || this.readLinkStatus == READ_LINK_STATUS.ON_READ_THREAD) && this.linkStatus == LINK_STATUS.LOCAL_CLOSING && this.closeFrameState == CLOSE_FRAME_STATE.ANTICIPATING || this.readLinkStatus == READ_LINK_STATUS.ON_READ_THREAD && this.linkStatus == LINK_STATUS.LOCAL_CLOSING && this.closeFrameState == CLOSE_FRAME_STATE.NOT_SET) {
                this.readLinkStatus = READ_LINK_STATUS.BEFORE_READ_ON_WIRE;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("readLinkStatus: " + (Object)((Object)this.readLinkStatus)), (Object[])new Object[0]);
                }
                return OK_TO_READ.OK_CLOSE_FRAME_TIMEOUT;
            }
            return OK_TO_READ.NOT_OK;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @FFDCIgnore(value={InterruptedException.class})
    public RETURN_STATUS okToWrite(boolean okToWait, boolean calledFromClose, boolean calledFromPong) {
        var4_4 = this.linkSync;
        synchronized (var4_4) {
            block5: while (true) {
                if (WsocConnLink.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)WsocConnLink.tc, (String)("okToWrite entry WsocConnLink: " + this.hashCode() + " linkStatus: " + (Object)this.linkStatus + " writeLinkStatus: " + (Object)this.writeLinkStatus), (Object[])new Object[0]);
                }
                if (calledFromClose) {
                    if (this.linkStatus == LINK_STATUS.LOCAL_CLOSING && this.writeLinkStatus == WRITE_LINK_STATUS.OK_TO_WRITE) {
                        this.writeLinkStatus = calledFromPong != false ? WRITE_LINK_STATUS.WRITING_PONG : WRITE_LINK_STATUS.WRITING;
                        return RETURN_STATUS.OK;
                    }
                    if (this.linkStatus == LINK_STATUS.IO_NOT_OK) {
                        return RETURN_STATUS.IO_NOT_OK;
                    }
                } else {
                    if (this.linkStatus == LINK_STATUS.IO_OK && this.writeLinkStatus == WRITE_LINK_STATUS.OK_TO_WRITE) {
                        this.writeLinkStatus = calledFromPong != false ? WRITE_LINK_STATUS.WRITING_PONG : WRITE_LINK_STATUS.WRITING;
                        return RETURN_STATUS.OK;
                    }
                    if (this.linkStatus == LINK_STATUS.IO_NOT_OK || this.linkStatus == LINK_STATUS.LOCAL_CLOSING) {
                        return RETURN_STATUS.IO_NOT_OK;
                    }
                }
                if (!okToWait && this.writeLinkStatus != WRITE_LINK_STATUS.WRITING_PONG) break;
                try {
                    if (WsocConnLink.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)WsocConnLink.tc, (String)"writeSync.wait()", (Object[])new Object[0]);
                    }
                    this.writeNotifyTriggered = false;
                    if (calledFromClose) {
                        if (WsocConnLink.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)WsocConnLink.tc, (String)("okToWrite WsocConnLink: " + this.hashCode() + " linkSync.wait(...)"), (Object[])new Object[0]);
                        }
                        this.linkSync.wait(5500L);
                        if (this.linkStatus == LINK_STATUS.LOCAL_CLOSING || this.linkStatus == LINK_STATUS.IO_OK) {
                            return RETURN_STATUS.OK;
                        }
                        return RETURN_STATUS.IO_NOT_OK;
                    }
                    while (true) {
                        if (this.writeNotifyTriggered) continue block5;
                        if (WsocConnLink.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)WsocConnLink.tc, (String)("okToWrite WsocConnLink: " + this.hashCode() + " linkSync.wait()"), (Object[])new Object[0]);
                        }
                        this.linkSync.wait();
                    }
                }
                catch (InterruptedException e) {
                    if (WsocConnLink.tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)WsocConnLink.tc, (String)"unexpected InterruptedException", (Object[])new Object[0]);
                    }
                    if (calledFromClose) ** break;
                    continue;
                    return RETURN_STATUS.OK;
                }
                break;
            }
            if (this.writeLinkStatus == WRITE_LINK_STATUS.WRITING) {
                return RETURN_STATUS.WRITE_IN_PROGRESS;
            }
            if (WsocConnLink.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)WsocConnLink.tc, (String)"unexpected link status", (Object[])new Object[0]);
            }
            return RETURN_STATUS.IO_NOT_OK;
        }
    }

    @FFDCIgnore(value={InterruptedException.class})
    public void waitToClose() {
        Object object = this.linkSync;
        synchronized (object) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("waitToClose entry WsocConnLink: " + this.hashCode() + " linkStatus: " + (Object)((Object)this.linkStatus) + " writeLinkStatus: " + (Object)((Object)this.writeLinkStatus)), (Object[])new Object[0]);
            }
            block5: while (true) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("linkStatus: " + (Object)((Object)this.linkStatus) + "  writeLinkStatus: " + (Object)((Object)this.writeLinkStatus)), (Object[])new Object[0]);
                }
                if (this.writeLinkStatus != WRITE_LINK_STATUS.WRITING && this.writeLinkStatus != WRITE_LINK_STATUS.WRITING_PONG) {
                    return;
                }
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"linkSync.wait()", (Object[])new Object[0]);
                    }
                    this.writeNotifyTriggered = false;
                    while (true) {
                        if (this.writeNotifyTriggered) continue block5;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("waitToClose WsocConnLink: " + this.hashCode() + " linkSync.wait() "), (Object[])new Object[0]);
                        }
                        this.linkSync.wait();
                    }
                }
                catch (InterruptedException e) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"unexpected InterruptedException", (Object[])new Object[0]);
                    continue;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public READ_LINK_STATUS signalReadComplete() {
        Object object = this.linkSync;
        synchronized (object) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("readLinkStatus: " + (Object)((Object)this.readLinkStatus)), (Object[])new Object[0]);
            }
            if (this.readLinkStatus == READ_LINK_STATUS.CLOSE_REQUESTED || this.readLinkStatus == READ_LINK_STATUS.CLOSE_REQUESTED_FROM_IDLE_TIMEOUT) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"linkSync.notify()", (Object[])new Object[0]);
                }
                if (this.readLinkStatus == READ_LINK_STATUS.CLOSE_REQUESTED_FROM_IDLE_TIMEOUT) {
                    this.readLinkStatus = READ_LINK_STATUS.OK_TO_READ;
                }
                this.readNotifyTriggered = true;
                this.linkSync.notifyAll();
            }
            if (this.readLinkStatus != READ_LINK_STATUS.CLOSE_REQUESTED) {
                this.readLinkStatus = READ_LINK_STATUS.OK_TO_READ;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("readLinkStatus: " + (Object)((Object)this.readLinkStatus)), (Object[])new Object[0]);
                }
            }
            return this.readLinkStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processReadErrorComplete(IOException ioe) {
        boolean closeFromHere = false;
        String s = null;
        Object object = this.linkSync;
        synchronized (object) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("processReadErrorComplete: readLinkStatus: " + (Object)((Object)this.readLinkStatus) + " closeFrameState: " + (Object)((Object)this.closeFrameState)), (Object[])new Object[0]);
            }
            if (this.closeFrameState == CLOSE_FRAME_STATE.ANTICIPATING) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"processReadErrorComplete :closeframe: closing connection on timeout on reading for a close frame", (Object[])new Object[0]);
                }
                this.linkStatus = LINK_STATUS.CLOSED;
                this.closeFrameState = CLOSE_FRAME_STATE.RECEIVED;
                this.deviceConnLink.close(this.vConnection, null);
                return false;
            }
            if (ioe instanceof SocketTimeoutException && (this.readLinkStatus == READ_LINK_STATUS.CLOSE_REQUESTED || this.readLinkStatus == READ_LINK_STATUS.CLOSE_REQUESTED_FROM_IDLE_TIMEOUT)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"processReadErrorComplete :closeframe: received timeout.  notify waiting threads", (Object[])new Object[0]);
                }
                this.closeFrameState = CLOSE_FRAME_STATE.ANTICIPATING;
                this.readLinkStatus = READ_LINK_STATUS.CLOSE_REQUESTED;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"linkSync.notify()", (Object[])new Object[0]);
                }
                this.readNotifyTriggered = true;
                this.linkSync.notifyAll();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"processReadErrorComplete :closeframe: reading for a close frame", (Object[])new Object[0]);
                }
                return true;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"linkSync.notify() from unexpected error", (Object[])new Object[0]);
            }
            this.readNotifyTriggered = true;
            this.linkSync.notifyAll();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("linkStatus: " + (Object)((Object)this.getLinkStatus()) + " readLinkStatus: " + (Object)((Object)this.readLinkStatus)), (Object[])new Object[0]);
            }
            if (this.getLinkStatus() != LINK_STATUS.CLOSED && this.getLinkStatus() != LINK_STATUS.LOCAL_CLOSING) {
                if (ioe != null) {
                    s = ioe.getMessage();
                }
                closeFromHere = true;
            }
        }
        if (closeFromHere) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"processReadErrorComplete :closeframe: got and unexpected error, so send a close frame and close the connection", (Object[])new Object[0]);
            }
            this.callOnClose(s, (CloseReason.CloseCode)CloseReason.CloseCodes.UNEXPECTED_CONDITION);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalNotReading() {
        Object object = this.linkSync;
        synchronized (object) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("readLinkStatus: " + (Object)((Object)this.readLinkStatus)), (Object[])new Object[0]);
            }
            if (this.readLinkStatus != READ_LINK_STATUS.CLOSE_REQUESTED) {
                this.readLinkStatus = READ_LINK_STATUS.OK_TO_READ;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("readLinkStatus: " + (Object)((Object)this.readLinkStatus)), (Object[])new Object[0]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalNotWriting() {
        Object object = this.linkSync;
        synchronized (object) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("signalNotWriting WsocConnLink: " + this.hashCode()), (Object[])new Object[0]);
            }
            this.writeLinkStatus = WRITE_LINK_STATUS.OK_TO_WRITE;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("signalNotWriting WsocConnLink: " + this.hashCode() + " linkSync.notifyAll()"), (Object[])new Object[0]);
            }
            this.writeNotifyTriggered = true;
            this.linkSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean signalLocalClose() {
        Object object = this.linkSync;
        synchronized (object) {
            LINK_STATUS x = this.getLinkStatus();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("signalLocalClose WsocConnLink: " + this.hashCode() + " entry linkStatus: " + (Object)((Object)x)), (Object[])new Object[0]);
            }
            if (x == LINK_STATUS.CLOSED || x == LINK_STATUS.LOCAL_CLOSING || x == LINK_STATUS.IO_NOT_OK) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Close has been called while a previous close/destroy is in progress. Link Status: " + (Object)((Object)this.getLinkStatus())), (Object[])new Object[0]);
                }
                return true;
            }
            this.linkStatus = LINK_STATUS.LOCAL_CLOSING;
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean signalClose() {
        boolean rc = false;
        Object object = this.linkSync;
        synchronized (object) {
            LINK_STATUS x = this.getLinkStatus();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("signalClosed WsocConnLink: " + this.hashCode() + " entry linkStatus: " + (Object)((Object)x)), (Object[])new Object[0]);
            }
            if (x == LINK_STATUS.CLOSED || x == LINK_STATUS.LOCAL_CLOSING || x == LINK_STATUS.IO_NOT_OK) {
                rc = true;
            }
            this.linkStatus = LINK_STATUS.CLOSED;
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLinkStatusesToOK() {
        Object object = this.linkSync;
        synchronized (object) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("setLinkStatusesToOK WsocConnLink: " + this.hashCode()), (Object[])new Object[0]);
            }
            this.linkStatus = LINK_STATUS.IO_OK;
            this.readLinkStatus = READ_LINK_STATUS.OK_TO_READ;
            this.writeLinkStatus = WRITE_LINK_STATUS.OK_TO_WRITE;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("readLinkStatus: " + (Object)((Object)this.readLinkStatus)), (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLinkStatusToNotOK() {
        Object object = this.linkSync;
        synchronized (object) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("setLinkStatusToNotOK WsocConnLink: " + this.hashCode()), (Object[])new Object[0]);
            }
            this.linkStatus = LINK_STATUS.IO_NOT_OK;
            this.readLinkStatus = READ_LINK_STATUS.READ_NOT_OK;
            this.writeLinkStatus = WRITE_LINK_STATUS.WRITE_NOT_OK;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LINK_STATUS getLinkStatus() {
        Object object = this.linkSync;
        synchronized (object) {
            return this.linkStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReadLinkStatus(READ_LINK_STATUS newStatus) {
        Object object = this.linkSync;
        synchronized (object) {
            this.readLinkStatus = newStatus;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("readLinkStatus: " + (Object)((Object)this.readLinkStatus)), (Object[])new Object[0]);
            }
        }
    }

    public CLOSE_FRAME_STATE getCloseFrameState() {
        return this.closeFrameState;
    }

    public boolean anticipatingCloseFrame() {
        return this.closeFrameState == CLOSE_FRAME_STATE.ANTICIPATING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReadLinkStatusAndCloseFrameState(READ_LINK_STATUS newStatus, CLOSE_FRAME_STATE newState) {
        Object object = this.linkSync;
        synchronized (object) {
            this.readLinkStatus = newStatus;
            this.closeFrameState = newState;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("readLinkStatus: " + (Object)((Object)this.readLinkStatus) + " closeFrameState: " + (Object)((Object)this.closeFrameState)), (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={IOException.class})
    protected void close(CloseReason cr, boolean needToCloseSession, boolean cleanupRead) {
        block21: {
            boolean closedAlready = false;
            closedAlready = this.signalClose();
            try {
                if (!closedAlready) {
                    this.appEndPoint.onClose((Session)this.wsocSession, cr);
                }
                if (needToCloseSession && this.wsocSession != null) {
                    this.wsocSession.getSessionImpl().close(cr, false);
                }
                this.removeSession();
                if (cleanupRead && this.linkRead != null) {
                    this.linkRead.resetReader();
                }
                if (closedAlready) break block21;
            }
            catch (Throwable throwable) {
                block22: {
                    if (needToCloseSession && this.wsocSession != null) {
                        this.wsocSession.getSessionImpl().close(cr, false);
                    }
                    this.removeSession();
                    if (cleanupRead && this.linkRead != null) {
                        this.linkRead.resetReader();
                    }
                    if (!closedAlready) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("close reason phrase is: " + cr.getReasonPhrase()), (Object[])new Object[0]);
                        }
                        int closeValue = cr.getCloseCode().getCode();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("close reason code is: " + closeValue), (Object[])new Object[0]);
                        }
                        byte[] reasonBytes = cr.getReasonPhrase().getBytes(Utils.UTF8_CHARSET);
                        int len = reasonBytes.length;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("close reason len is: " + len), (Object[])new Object[0]);
                        }
                        byte[] closeData = new byte[len + 2];
                        closeData[0] = (byte)(closeValue >> 8 & 0xFF);
                        closeData[1] = (byte)(closeValue & 0xFF);
                        System.arraycopy(reasonBytes, 0, closeData, 2, len);
                        try {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("close :closeframe: sending close frame. readLinkStatus: " + (Object)((Object)this.readLinkStatus)), (Object[])new Object[0]);
                            }
                            this.linkWrite.writeBuffer(this.getBufferManager().wrap(closeData), OpcodeType.CONNECTION_CLOSE, MessageWriter.WRITE_TYPE.SYNC, null, 0);
                        }
                        catch (IOException x) {
                            if (!tc.isDebugEnabled()) break block22;
                            Tr.debug((TraceComponent)tc, (String)("Caught IOException: " + x.getMessage()), (Object[])new Object[0]);
                        }
                    }
                }
                this.deviceConnLink.close(this.vConnection, null);
                throw throwable;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("close reason phrase is: " + cr.getReasonPhrase()), (Object[])new Object[0]);
            }
            int closeValue = cr.getCloseCode().getCode();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("close reason code is: " + closeValue), (Object[])new Object[0]);
            }
            byte[] reasonBytes = cr.getReasonPhrase().getBytes(Utils.UTF8_CHARSET);
            int len = reasonBytes.length;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("close reason len is: " + len), (Object[])new Object[0]);
            }
            byte[] closeData = new byte[len + 2];
            closeData[0] = (byte)(closeValue >> 8 & 0xFF);
            closeData[1] = (byte)(closeValue & 0xFF);
            System.arraycopy(reasonBytes, 0, closeData, 2, len);
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("close :closeframe: sending close frame. readLinkStatus: " + (Object)((Object)this.readLinkStatus)), (Object[])new Object[0]);
                }
                this.linkWrite.writeBuffer(this.getBufferManager().wrap(closeData), OpcodeType.CONNECTION_CLOSE, MessageWriter.WRITE_TYPE.SYNC, null, 0);
            }
            catch (IOException x) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Caught IOException: " + x.getMessage()), (Object[])new Object[0]);
                }
            }
        }
        this.deviceConnLink.close(this.vConnection, null);
    }

    private void removeSession() {
        if (this.endpointManager != null) {
            this.endpointManager.removeSession(this.appEndPoint, this.wsocSession);
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Endpoint manager was unexpectedly null", (Object[])new Object[0]);
        }
    }

    public void incomingCloseConnection(CloseReason cr) {
        if (this.getLinkStatus() == LINK_STATUS.LOCAL_CLOSING) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Client has responded to outgoing close request, closing connection", (Object[])new Object[0]);
            }
            this.waitToClose();
            this.signalClose();
            this.deviceConnLink.close(this.vConnection, null);
        } else {
            this.waitToClose();
            this.close(cr, true, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @FFDCIgnore(value={InterruptedException.class})
    public boolean finishReadBeforeIdleClose() {
        Object object = this.linkSync;
        synchronized (object) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("readLinkStatus: " + (Object)((Object)this.readLinkStatus)), (Object[])new Object[0]);
            }
            if (this.readLinkStatus == READ_LINK_STATUS.READ_ON_WIRE) {
                this.readLinkStatus = READ_LINK_STATUS.CLOSE_REQUESTED_FROM_IDLE_TIMEOUT;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("readLinkStatus: " + (Object)((Object)this.readLinkStatus)), (Object[])new Object[0]);
                }
                this.readNotifyTriggered = false;
                this.linkRead.cancelRead();
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"linkSync.wait(). waiting on read to clear.", (Object[])new Object[0]);
                    }
                    while (!this.readNotifyTriggered) {
                        this.linkSync.wait(8500L);
                    }
                    if (this.readLinkStatus != READ_LINK_STATUS.CLOSE_REQUESTED_FROM_IDLE_TIMEOUT && this.closeFrameState != CLOSE_FRAME_STATE.ANTICIPATING) return false;
                    return true;
                }
                catch (InterruptedException e) {
                    if (!tc.isDebugEnabled()) return false;
                    Tr.debug((TraceComponent)tc, (String)"InterruptedException during close waiting for callback complete or error", (Object[])new Object[0]);
                }
            } else {
                if (this.readLinkStatus != READ_LINK_STATUS.ON_READ_THREAD) return false;
                Object object2 = this.linkSync;
                synchronized (object2) {
                    this.closeFrameState = CLOSE_FRAME_STATE.ANTICIPATING;
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={InterruptedException.class})
    public void finishReadBeforeClose(SessionIdleTimeout sit) {
        if (sit != null) {
            sit.cleanup();
        }
        if (this.checkIfClosingAlready() || this.linkStatus == LINK_STATUS.IO_NOT_OK) {
            return;
        }
        int loopCounter = 0;
        int loopMsecWait = 100;
        int loopMax = 3000 / loopMsecWait;
        boolean done = false;
        while (!done && loopCounter < loopMax) {
            ++loopCounter;
            Object object = this.linkSync;
            synchronized (object) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("readLinkStatus: " + (Object)((Object)this.readLinkStatus)), (Object[])new Object[0]);
                }
                if (this.readLinkStatus == READ_LINK_STATUS.ON_READ_THREAD) {
                    this.readLinkStatus = READ_LINK_STATUS.CLOSE_REQUESTED;
                    this.closeFrameState = CLOSE_FRAME_STATE.ANTICIPATING;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("readLinkStatus: " + (Object)((Object)this.readLinkStatus)), (Object[])new Object[0]);
                    }
                    return;
                }
                if (this.readLinkStatus == READ_LINK_STATUS.READ_ON_WIRE) {
                    block17: {
                        this.readLinkStatus = READ_LINK_STATUS.CLOSE_REQUESTED;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("readLinkStatus: " + (Object)((Object)this.readLinkStatus)), (Object[])new Object[0]);
                        }
                        try {
                            this.readNotifyTriggered = false;
                            this.linkRead.cancelRead();
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"linkSync.wait(WAIT_ON_READ_TO_CLOSE).  waiting on Read to clear", (Object[])new Object[0]);
                            }
                            this.linkSync.wait(8500L);
                            if (!this.readNotifyTriggered && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"linkSync.wait() timed out, continue closing", (Object[])new Object[0]);
                            }
                            done = true;
                        }
                        catch (InterruptedException e) {
                            if (!tc.isDebugEnabled()) break block17;
                            Tr.debug((TraceComponent)tc, (String)"InterruptedException during close waiting for callback complete or error", (Object[])new Object[0]);
                        }
                    }
                    return;
                }
            }
            try {
                Thread.sleep(loopMsecWait);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void closeUsingSession(CloseReason cr, boolean readForCloseFrame, boolean rightToDeviceLink) {
        if (this.wsocSession != null && !rightToDeviceLink) {
            this.wsocSession.getSessionImpl().close(cr, true);
        }
        if (!readForCloseFrame || rightToDeviceLink) {
            this.linkStatus = LINK_STATUS.CLOSED;
            this.deviceConnLink.close(this.vConnection, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void outgoingCloseConnection(CloseReason cr) {
        if (this.signalLocalClose()) {
            return;
        }
        CloseReason updatedCr = new CloseReason(cr.getCloseCode(), cr.getReasonPhrase());
        try {
            this.appEndPoint.onClose((Session)this.wsocSession, cr);
            this.removeSession();
        }
        catch (Throwable throwable) {
            this.removeSession();
            int closeValue = updatedCr.getCloseCode().getCode();
            byte[] reasonBytes = cr.getReasonPhrase().getBytes(Utils.UTF8_CHARSET);
            int len = reasonBytes.length;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("close reason len is: " + len), (Object[])new Object[0]);
            }
            byte[] closeData = new byte[len + 2];
            closeData[0] = (byte)(closeValue >> 8 & 0xFF);
            closeData[1] = (byte)(closeValue & 0xFF);
            System.arraycopy(reasonBytes, 0, closeData, 2, len);
            RETURN_STATUS status = this.okToWrite(true, true, false);
            if (status == RETURN_STATUS.OK) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("outgoingCloseConnection :closeframe: sending close frame. readLinkStatus: " + (Object)((Object)this.readLinkStatus)), (Object[])new Object[0]);
                    }
                    this.linkWrite.writeBuffer(this.getBufferManager().wrap(closeData), OpcodeType.CONNECTION_CLOSE, MessageWriter.WRITE_TYPE.SYNC, null, 5500);
                    this.signalNotWriting();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.wsoc.WsocConnLink", (String)"895", (Object)this, (Object[])new Object[]{cr});
                    if (tc.isDebugEnabled()) {
                        void x;
                        Tr.debug((TraceComponent)tc, (String)("Caught Exception: " + x.getMessage()), (Object[])new Object[0]);
                    }
                    this.signalNotWriting();
                    if (this.getLinkStatus() == LINK_STATUS.LOCAL_CLOSING && (this.readLinkStatus == READ_LINK_STATUS.CLOSE_REQUESTED || this.readLinkStatus == READ_LINK_STATUS.ON_READ_THREAD)) {
                        this.deviceConnLink.close(this.vConnection, null);
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"could not perform write due to status", (Object[])new Object[0]);
            }
            throw throwable;
        }
        int closeValue = updatedCr.getCloseCode().getCode();
        byte[] reasonBytes = cr.getReasonPhrase().getBytes(Utils.UTF8_CHARSET);
        int len = reasonBytes.length;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("close reason len is: " + len), (Object[])new Object[0]);
        }
        byte[] closeData = new byte[len + 2];
        closeData[0] = (byte)(closeValue >> 8 & 0xFF);
        closeData[1] = (byte)(closeValue & 0xFF);
        System.arraycopy(reasonBytes, 0, closeData, 2, len);
        RETURN_STATUS status = this.okToWrite(true, true, false);
        if (status == RETURN_STATUS.OK) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("outgoingCloseConnection :closeframe: sending close frame. readLinkStatus: " + (Object)((Object)this.readLinkStatus)), (Object[])new Object[0]);
                }
                this.linkWrite.writeBuffer(this.getBufferManager().wrap(closeData), OpcodeType.CONNECTION_CLOSE, MessageWriter.WRITE_TYPE.SYNC, null, 5500);
                this.signalNotWriting();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.wsoc.WsocConnLink", (String)"895", (Object)this, (Object[])new Object[]{cr});
                if (tc.isDebugEnabled()) {
                    void x;
                    Tr.debug((TraceComponent)tc, (String)("Caught Exception: " + x.getMessage()), (Object[])new Object[0]);
                }
                this.signalNotWriting();
                if (this.getLinkStatus() == LINK_STATUS.LOCAL_CLOSING && (this.readLinkStatus == READ_LINK_STATUS.CLOSE_REQUESTED || this.readLinkStatus == READ_LINK_STATUS.ON_READ_THREAD)) {
                    this.deviceConnLink.close(this.vConnection, null);
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"could not perform write due to status", (Object[])new Object[0]);
        }
    }

    public void setEndpointManager(EndpointManager x) {
        this.endpointManager = x;
    }

    public EndpointManager getEndpointManager() {
        return this.endpointManager;
    }

    public void destroy(Exception e) {
        this.setLinkStatusToNotOK();
        this.linkRead.destroy(e);
        this.linkWrite.destroy(e);
    }

    public WsByteBufferPoolManager getBufferManager() {
        return ServiceManager.getBufferPoolManager();
    }

    public void startReading() {
        this.startAsyncRead(this.tcpReadContext);
    }

    public void processDataThenStartRead(WsByteBuffer remainingBuf) {
        remainingBuf.position(remainingBuf.limit());
        this.tcpReadContext.setBuffer(remainingBuf);
        this.processRead(this.tcpReadContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAsyncRead(TCPReadRequestContext rrc) {
        OK_TO_READ ok = this.okToStartRead();
        if (ok != OK_TO_READ.NOT_OK) {
            int timeout = -1;
            WsByteBufferPoolManager mgr = this.getBufferManager();
            WsByteBuffer buf = mgr.allocate(8192);
            rrc.setBuffer(buf);
            boolean forceQueue = true;
            int numBytes = 1;
            if (ok == OK_TO_READ.OK_CLOSE_FRAME_TIMEOUT) {
                timeout = 30000;
            }
            Object object = this.linkSync;
            synchronized (object) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("readLinkStatus: " + (Object)((Object)this.readLinkStatus)), (Object[])new Object[0]);
                }
                if (this.readLinkStatus == READ_LINK_STATUS.BEFORE_READ_ON_WIRE || this.readLinkStatus == READ_LINK_STATUS.OK_TO_READ) {
                    this.readLinkStatus = READ_LINK_STATUS.READ_ON_WIRE;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("readLinkStatus: " + (Object)((Object)this.readLinkStatus)), (Object[])new Object[0]);
                    }
                    rrc.read((long)numBytes, (TCPReadCompletedCallback)this.wrc, forceQueue, timeout);
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"could not continue to read due to status", (Object[])new Object[0]);
        }
    }

    public void processRead(TCPReadRequestContext rrc) {
        boolean moreToProcess = true;
        while (moreToProcess) {
            moreToProcess = this.linkRead.processRead(rrc, this.appEndPoint);
            rrc.setBuffer(null);
        }
        this.startAsyncRead(rrc);
        this.readWrite = true;
    }

    public void addMessageHandler(MessageHandler handler) throws IllegalStateException {
        this.linkRead.addMessageHandler(handler);
    }

    public <T> void addMessageHandler(Class<T> clazz, MessageHandler.Whole<T> handler) {
        this.linkRead.addMessageHandler(clazz, handler);
    }

    public <T> void addMessageHandler(Class<T> clazz, MessageHandler.Partial<T> handler) {
        this.linkRead.addMessageHandler(clazz, handler);
    }

    public Set<MessageHandler> getMessageHandlers() {
        return this.linkRead.getMessageHandlers();
    }

    public void removeMessageHandler(MessageHandler handler) {
        this.linkRead.removeMessageHandler(handler);
    }

    /*
     * WARNING - void declaration
     */
    public RETURN_STATUS writeBuffer(@Sensitive WsByteBuffer buffer, OpcodeType ot, MessageWriter.WRITE_TYPE writeType, SendHandler handler, int timeout, boolean wait, boolean fromPong) {
        RETURN_STATUS status = this.okToWrite(wait, false, fromPong);
        if (status == RETURN_STATUS.OK) {
            try {
                this.writeBufferToRelease = writeType == MessageWriter.WRITE_TYPE.ASYNC ? buffer : null;
                this.linkWrite.writeBuffer(buffer, ot, writeType, handler, timeout);
            }
            catch (IOException iOException) {
                void x;
                Object[] objectArray = new Object[7];
                objectArray[0] = "<sensitive com.ibm.wsspi.bytebuffer.WsByteBuffer>";
                objectArray[1] = ot;
                objectArray[2] = writeType;
                objectArray[3] = handler;
                objectArray[4] = timeout;
                objectArray[5] = wait;
                objectArray[6] = fromPong;
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.wsoc.WsocConnLink", (String)"1039", (Object)this, (Object[])objectArray);
                if (this.writeBufferToRelease != null) {
                    this.writeBufferToRelease.release();
                    this.writeBufferToRelease = null;
                }
                this.callOnError((Throwable)x);
            }
            catch (RuntimeException x) {
                void up;
                Object[] objectArray = new Object[7];
                objectArray[0] = "<sensitive com.ibm.wsspi.bytebuffer.WsByteBuffer>";
                objectArray[1] = ot;
                objectArray[2] = writeType;
                objectArray[3] = handler;
                objectArray[4] = timeout;
                objectArray[5] = wait;
                objectArray[6] = fromPong;
                FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.wsoc.WsocConnLink", (String)"1045", (Object)this, (Object[])objectArray);
                if (this.writeBufferToRelease != null) {
                    this.writeBufferToRelease.release();
                    this.writeBufferToRelease = null;
                }
                throw up;
            }
            if (writeType == MessageWriter.WRITE_TYPE.SYNC) {
                this.signalNotWriting();
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"could not perform write due to status", (Object[])new Object[0]);
        }
        return status;
    }

    public RETURN_STATUS writeBufferForBasicRemoteSync(@Sensitive WsByteBuffer buffer, OpcodeType ot, int timeout, boolean wait) throws IOException {
        RETURN_STATUS status = this.okToWrite(wait, false, false);
        if (status == RETURN_STATUS.OK) {
            this.linkWrite.writeBuffer(buffer, ot, MessageWriter.WRITE_TYPE.SYNC, null, timeout);
            this.signalNotWriting();
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"could not perform write due to status", (Object[])new Object[0]);
        }
        return status;
    }

    public RETURN_STATUS writeObject(@Sensitive Object objectToWrite, MessageWriter.WRITE_TYPE writeType, SendHandler handler) {
        return this.writeObject(objectToWrite, writeType, handler, false);
    }

    public RETURN_STATUS writeObjectBasicRemoteSync(@Sensitive Object objectToWrite) throws EncodeException, IOException {
        return this.writeObjectBasicRemoteSync(objectToWrite, MessageWriter.WRITE_TYPE.SYNC, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RETURN_STATUS writeObjectBasicRemoteSync(@Sensitive Object objectToWrite, MessageWriter.WRITE_TYPE writeType, boolean fromOnMessage) throws EncodeException, IOException {
        boolean waitIfNeeded = false;
        RETURN_STATUS status = this.okToWrite(waitIfNeeded, false, false);
        if (status == RETURN_STATUS.OK) {
            try {
                this.linkWrite.writeObject(objectToWrite, writeType, null, fromOnMessage);
            }
            finally {
                this.signalNotWriting();
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"could not perform write due to status", (Object[])new Object[0]);
        }
        return status;
    }

    @FFDCIgnore(value={Throwable.class})
    public RETURN_STATUS writeObject(@Sensitive Object objectToWrite, MessageWriter.WRITE_TYPE writeType, SendHandler handler, boolean fromOnMessage) {
        RETURN_STATUS status;
        boolean waitIfNeeded = false;
        if (fromOnMessage) {
            waitIfNeeded = true;
        }
        if ((status = this.okToWrite(waitIfNeeded, false, false)) == RETURN_STATUS.OK) {
            try {
                this.linkWrite.writeObject(objectToWrite, writeType, handler, fromOnMessage);
            }
            catch (Throwable e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("caught Exception: " + e), (Object[])new Object[0]);
                }
                if (writeType == MessageWriter.WRITE_TYPE.ASYNC) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Unexpectedly Caught IOException on Async Write code path: " + e), (Object[])new Object[0]);
                    }
                    this.signalNotWriting();
                    this.linkWrite.processError(null, e);
                }
                this.callOnError(e);
            }
            if (writeType == MessageWriter.WRITE_TYPE.SYNC) {
                this.signalNotWriting();
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"could not perform write due to status", (Object[])new Object[0]);
        }
        return status;
    }

    public boolean cancelWriteBufferAsync() {
        return this.linkWrite.cancelWriteBufferAsync();
    }

    public void processWrite(TCPWriteRequestContext wsc) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("processWrite WsocConnLink: " + this.hashCode()), (Object[])new Object[0]);
        }
        this.linkWrite.frameCleanup();
        if (this.writeBufferToRelease != null) {
            this.writeBufferToRelease.release();
            this.writeBufferToRelease = null;
        }
        this.signalNotWriting();
        this.linkWrite.processWrite(wsc);
        this.readWrite = true;
    }

    public void processWriteError(TCPWriteRequestContext wsc, IOException ioe) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("processWriteError WsocConnLink: " + this.hashCode()), (Object[])new Object[0]);
        }
        if (this.writeBufferToRelease != null) {
            this.writeBufferToRelease.release();
            this.writeBufferToRelease = null;
        }
        this.signalNotWriting();
        this.linkWrite.processError(wsc, ioe);
    }

    public Session getWsocSession() {
        return this.wsocSession;
    }

    protected void callOnError(Throwable throwable) {
        this.callOnError(throwable, false);
    }

    protected void callOnError(Throwable throwable, boolean whileReading) {
        this.signalNotWriting();
        if (whileReading) {
            this.setReadLinkStatus(READ_LINK_STATUS.ON_READ_THREAD);
        }
        this.appEndPoint.onError((Session)this.wsocSession, throwable);
    }

    protected void callOnClose(String reasonPhrase, CloseReason.CloseCode closeCode) {
        boolean cleanupRead = false;
        if (this.checkIfClosingAlready()) {
            return;
        }
        reasonPhrase = Utils.truncateCloseReason(reasonPhrase);
        CloseReason closeReason = new CloseReason(closeCode, reasonPhrase);
        if (this.readLinkStatus == READ_LINK_STATUS.OK_TO_READ) {
            cleanupRead = true;
        }
        this.close(closeReason, true, cleanupRead);
    }

    public Endpoint getEndpoint() {
        return this.appEndPoint;
    }

    public boolean isReadWrite() {
        return this.readWrite;
    }

    public void setReadWrite(boolean readWrite) {
        this.readWrite = readWrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitReadPush() {
        Object object = this.SyncReadPushPop;
        synchronized (object) {
            while (this.readPush != 0) {
                try {
                    this.SyncReadPushPop.wait();
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.wsoc.WsocConnLink", (String)"1245", (Object)this, (Object[])new Object[0]);
                }
            }
            this.readPush = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyReadPush() {
        Object object = this.SyncReadPushPop;
        synchronized (object) {
            this.readPush = 0;
            this.SyncReadPushPop.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitWritePush() {
        Object object = this.SyncWritePushPop;
        synchronized (object) {
            while (this.writePush != 0) {
                try {
                    this.SyncWritePushPop.wait();
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.wsoc.WsocConnLink", (String)"1265", (Object)this, (Object[])new Object[0]);
                }
            }
            this.writePush = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyWritePush() {
        Object object = this.SyncWritePushPop;
        synchronized (object) {
            this.writePush = 0;
            this.SyncWritePushPop.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkIfClosingAlready() {
        Object object = this.linkSync;
        synchronized (object) {
            LINK_STATUS x = this.getLinkStatus();
            if (x == LINK_STATUS.CLOSED || x == LINK_STATUS.LOCAL_CLOSING || x == LINK_STATUS.IO_NOT_OK) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Close has been called while a previous close/destroy is in progress. Link Status: " + (Object)((Object)this.getLinkStatus())), (Object[])new Object[0]);
                }
                return true;
            }
            return false;
        }
    }

    public long getDefaultAsyncSendTimeout() {
        SessionImpl si;
        if (this.wsocSession != null && (si = this.wsocSession.getSessionImpl()) != null) {
            return si.getDefaultAsyncSendTimeout();
        }
        return 0L;
    }

    public int getMaxTextMessageBufferSize() {
        SessionImpl si;
        if (this.wsocSession != null && (si = this.wsocSession.getSessionImpl()) != null) {
            return si.getMaxTextMessageBufferSize();
        }
        return -1;
    }

    public int getMaxBinaryMessageBufferSize() {
        SessionImpl si;
        if (this.wsocSession != null && (si = this.wsocSession.getSessionImpl()) != null) {
            return si.getMaxBinaryMessageBufferSize();
        }
        return -1;
    }

    protected InjectionThings pushContexts() {
        InjectionProvider12 ip12;
        ComponentMetaData cmd;
        boolean appActivateResult = false;
        ComponentMetaDataAccessorImpl cmdai = null;
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.things.getTccl());
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("set class loader to: " + this.things.getTccl()), (Object[])new Object[0]);
        }
        if ((cmd = this.things.getCmd()) != null) {
            cmdai = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor();
            cmdai.beginContext(cmd);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("begin Context with CMD of: " + cmd), (Object[])new Object[0]);
            }
        }
        if ((ip12 = ServiceManager.getInjectionProvider12()) == null) {
            InjectionProvider ip = ServiceManager.getInjectionProvider();
            if (ip != null) {
                HttpSession httpSession = this.things.getHttpSession();
                appActivateResult = ip.activateAppContext(cmd);
                if (httpSession != null) {
                    ip.startSesContext(httpSession);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("thread ID: " + Thread.currentThread().getId() + "Session ID: " + httpSession.getId()), (Object[])new Object[0]);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Attempted to use sessions scope when there was no valid HttpSession, guess the HttpSession expired?", (Object[])new Object[0]);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"InjectionProvider was null", (Object[])new Object[0]);
            }
        }
        InjectionThings it = new InjectionThings();
        it.setAppActivateResult(appActivateResult);
        it.setOriginalCL(originalCL);
        return it;
    }

    protected void popContexts(InjectionThings it) {
        ComponentMetaDataAccessorImpl cmdai;
        InjectionProvider ip;
        InjectionProvider12 ip12 = ServiceManager.getInjectionProvider12();
        if (ip12 == null && (ip = ServiceManager.getInjectionProvider()) != null) {
            HttpSession httpSession;
            if (it.getAppActivateResult()) {
                ip.deActivateAppContext();
            }
            if ((httpSession = this.things.getHttpSession()) != null) {
                ip.deActivateSesContext();
            }
        }
        if ((cmdai = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor()) != null) {
            cmdai.endContext();
        }
        Thread.currentThread().setContextClassLoader(it.getOriginalCL());
    }

    public static enum DATA_TYPE {
        BINARY,
        TEXT,
        PING,
        PONG,
        CLOSE,
        UNKNOWN;

    }

    @Trivial
    public static enum OK_TO_READ {
        NOT_OK,
        OK_NO_TIMEOUT,
        OK_CLOSE_FRAME_TIMEOUT;

    }

    @Trivial
    public static enum RETURN_STATUS {
        OK,
        READ_IN_PROGRESS,
        WRITE_IN_PROGRESS,
        IO_NOT_OK,
        CLOSE;

    }

    @Trivial
    public static enum CLOSE_FRAME_STATE {
        NOT_SET,
        ANTICIPATING,
        RECEIVED;

    }

    @Trivial
    public static enum WRITE_LINK_STATUS {
        OK_TO_WRITE,
        WRITING,
        WRITING_PONG,
        WRITE_NOT_OK;

    }

    @Trivial
    public static enum READ_LINK_STATUS {
        OK_TO_READ,
        BEFORE_READ_ON_WIRE,
        READ_ON_WIRE,
        CLOSE_REQUESTED,
        CLOSE_REQUESTED_FROM_IDLE_TIMEOUT,
        ON_READ_THREAD,
        READ_NOT_OK;

    }

    @Trivial
    public static enum LINK_STATUS {
        IO_OK,
        IO_NOT_OK,
        LOCAL_CLOSING,
        CLOSED;

    }
}

