/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.org.jboss.resteasy.common.component;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import jakarta.decorator.Decorator;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.WithAnnotations;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.ext.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.jboss.resteasy.cdi.ResteasyCdiExtension;
import org.jboss.resteasy.cdi.i18n.LogMessages;
import org.jboss.resteasy.cdi.i18n.Messages;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class LibertyResteasyCdiExtension
extends ResteasyCdiExtension
implements Extension {
    private static final String JAVAX_EJB_STATELESS = "jakarta.ejb.Stateless";
    private static final String JAVAX_EJB_SINGLETON = "jakarta.ejb.Singleton";
    static final long serialVersionUID = -3411226577408209338L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private boolean isSessionBean(AnnotatedType<?> annotatedType) {
        for (Annotation annotation : annotatedType.getAnnotations()) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (!annotationType.getName().equals(JAVAX_EJB_STATELESS) && !annotationType.getName().equals(JAVAX_EJB_SINGLETON)) continue;
            LogMessages.LOGGER.debug(Messages.MESSAGES.beanIsSLSBOrSingleton(annotatedType.getJavaClass()));
            return true;
        }
        return false;
    }

    @Override
    public <T> void observeResources(@WithAnnotations(value={Path.class}) @Observes ProcessAnnotatedType<T> event, BeanManager beanManager) {
        AnnotatedType annotatedType = event.getAnnotatedType();
        Class javaClass = annotatedType.getJavaClass();
        if (!(javaClass.isInterface() || this.isSessionBean(annotatedType) || annotatedType.isAnnotationPresent(Decorator.class))) {
            LogMessages.LOGGER.debug(Messages.MESSAGES.discoveredCDIBeanJaxRsResource(annotatedType.getJavaClass().getCanonicalName()));
            if (Application.class.isAssignableFrom(javaClass)) {
                event.setAnnotatedType(this.wrapAnnotatedType(annotatedType, applicationScopedLiteral));
            }
            this.getResources().add(javaClass);
        }
    }

    @Override
    public <T> void observeProviders(@WithAnnotations(value={Provider.class}) @Observes ProcessAnnotatedType<T> event, BeanManager beanManager) {
        AnnotatedType annotatedType = event.getAnnotatedType();
        if (!(annotatedType.getJavaClass().isInterface() || this.isSessionBean(annotatedType) || this.isUnproxyableClass(annotatedType.getJavaClass()))) {
            LogMessages.LOGGER.debug(Messages.MESSAGES.discoveredCDIBeanJaxRsProvider(annotatedType.getJavaClass().getCanonicalName()));
            event.setAnnotatedType(this.wrapAnnotatedType(annotatedType, applicationScopedLiteral));
            this.getProviders().add(annotatedType.getJavaClass());
        }
    }

    private boolean isUnproxyableClass(Class<?> clazz) {
        return Modifier.isFinal(clazz.getModifiers()) || this.hasNonPrivateNonStaticFinalMethod(clazz) || this.hasNoNonPrivateNoArgsConstructor(clazz);
    }

    private boolean hasNonPrivateNonStaticFinalMethod(Class<?> type) {
        for (Class<?> clazz = type; clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Method method : clazz.getDeclaredMethods()) {
                int modifiers = method.getModifiers();
                if (!Modifier.isFinal(modifiers) || Modifier.isPrivate(modifiers) || Modifier.isStatic(modifiers)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasNoNonPrivateNoArgsConstructor(Class<?> clazz) {
        Constructor<?> constructor;
        try {
            constructor = clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException exception) {
            return true;
        }
        return Modifier.isPrivate(constructor.getModifiers());
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.org.jboss.resteasy.common.component.LibertyResteasyCdiExtension", LibertyResteasyCdiExtension.class, (String)"RESTfulWS", (String)"io.openliberty.org.jboss.resteasy.common.nls.RESTfulWSServer");
    }
}

