/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.servlet;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.grpc.InternalLogId;
import io.grpc.Status;
import io.grpc.servlet.ServletServerStream;
import jakarta.annotation.CheckReturnValue;
import jakarta.annotation.Nullable;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletOutputStream;
import java.io.IOException;
import java.time.Duration;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;

@Trivial
final class AsyncServletOutputStreamWriter {
    private static final Logger logger = Logger.getLogger(AsyncServletOutputStreamWriter.class.getName());
    private final AtomicReference<WriteState> writeState = new AtomicReference<WriteState>(WriteState.DEFAULT);
    private final ServletOutputStream outputStream;
    private final ServletServerStream.ServletTransportState transportState;
    private final InternalLogId logId;
    private final ActionItem flushAction;
    private final ActionItem completeAction;
    private final Queue<ActionItem> writeChain = new ConcurrentLinkedQueue<ActionItem>();
    @Nullable
    private volatile Thread parkingThread;

    AsyncServletOutputStreamWriter(AsyncContext asyncContext, ServletOutputStream outputStream, ServletServerStream.ServletTransportState transportState, InternalLogId logId) {
        this.outputStream = outputStream;
        this.transportState = transportState;
        this.logId = logId;
        this.flushAction = () -> {
            logger.log(Level.FINEST, "[{0}] flushBuffer", logId);
            asyncContext.getResponse().flushBuffer();
        };
        this.completeAction = () -> {
            logger.log(Level.FINE, "[{0}] call is completing", logId);
            transportState.runOnTransportThread(() -> {
                transportState.complete();
                asyncContext.complete();
                logger.log(Level.FINE, "[{0}] call completed", logId);
            });
        };
    }

    void writeBytes(byte[] bytes, int numBytes) throws IOException {
        this.runOrBufferActionItem(() -> {
            this.outputStream.write(bytes, 0, numBytes);
            this.transportState.runOnTransportThread(() -> this.transportState.onSentBytes(numBytes));
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "[{0}] outbound data: length = {1}, bytes = {2}", new Object[]{this.logId, numBytes, ServletServerStream.toHexString(bytes, numBytes)});
            }
        });
    }

    void flush() throws IOException {
        this.runOrBufferActionItem(this.flushAction);
    }

    void complete() {
        try {
            this.runOrBufferActionItem(this.completeAction);
        }
        catch (IOException e) {
            throw Status.fromThrowable((Throwable)e).asRuntimeException();
        }
    }

    void onWritePossible() throws IOException {
        logger.log(Level.FINEST, "[{0}] onWritePossible: ENTRY. The servlet output stream becomes ready", this.logId);
        this.assureReadyAndEmptyFalse();
        while (this.outputStream.isReady()) {
            WriteState curState = this.writeState.get();
            ActionItem actionItem = this.writeChain.poll();
            if (actionItem != null) {
                actionItem.run();
                continue;
            }
            if (!this.writeState.compareAndSet(curState, curState.withReadyAndEmpty(true))) continue;
            logger.log(Level.FINEST, "[{0}] onWritePossible: EXIT. All data available now is sent out and the servlet output stream is still ready", this.logId);
            return;
        }
        logger.log(Level.FINEST, "[{0}] onWritePossible: EXIT. The servlet output stream becomes not ready", this.logId);
    }

    private void runOrBufferActionItem(ActionItem actionItem) throws IOException {
        WriteState curState = this.writeState.get();
        if (curState.readyAndEmpty && this.outputStream.isReady()) {
            actionItem.run();
            if (!this.outputStream.isReady()) {
                logger.log(Level.FINEST, "[{0}] the servlet output stream becomes not ready", this.logId);
                boolean successful = this.writeState.compareAndSet(curState, curState.withReadyAndEmpty(false));
                assert (successful);
                LockSupport.unpark(this.parkingThread);
            }
        } else {
            this.writeChain.offer(actionItem);
            if (!this.writeState.compareAndSet(curState, curState.newItemBuffered())) {
                assert (this.writeState.get().readyAndEmpty);
                ActionItem lastItem = this.writeChain.poll();
                if (lastItem != null) {
                    assert (lastItem == actionItem);
                    this.runOrBufferActionItem(lastItem);
                }
            }
        }
    }

    private void assureReadyAndEmptyFalse() {
        while (this.writeState.get().readyAndEmpty) {
            this.parkingThread = Thread.currentThread();
            LockSupport.parkNanos(Duration.ofSeconds(1L).toNanos());
        }
        this.parkingThread = null;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static final class WriteState {
        static final WriteState DEFAULT;
        final boolean readyAndEmpty;
        static final long serialVersionUID = 7019747342075452151L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        WriteState(boolean readyAndEmpty) {
            this.readyAndEmpty = readyAndEmpty;
        }

        @CheckReturnValue
        WriteState withReadyAndEmpty(boolean readyAndEmpty) {
            return new WriteState(readyAndEmpty);
        }

        @CheckReturnValue
        WriteState newItemBuffered() {
            return new WriteState(false);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.grpc.servlet.AsyncServletOutputStreamWriter$WriteState", WriteState.class, (String)"GRPC", (String)"io.openliberty.grpc.internal.resources.grpcmessages");
            DEFAULT = new WriteState(false);
        }
    }

    @FunctionalInterface
    private static interface ActionItem {
        public void run() throws IOException;
    }
}

