/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.FailureScopeManager;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.InvalidRecoverableUnitSectionException;
import com.ibm.ws.recoverylog.spi.Lock;
import com.ibm.ws.recoverylog.spi.LogCorruptedException;
import com.ibm.ws.recoverylog.spi.LogCursor;
import com.ibm.ws.recoverylog.spi.LogCursorImpl;
import com.ibm.ws.recoverylog.spi.LogHandle;
import com.ibm.ws.recoverylog.spi.MultiScopeRecoveryLog;
import com.ibm.ws.recoverylog.spi.NoSharedLockException;
import com.ibm.ws.recoverylog.spi.ReadableLogRecord;
import com.ibm.ws.recoverylog.spi.RecoverableUnit;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSection;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSectionExistsException;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSectionImpl;
import com.ibm.ws.recoverylog.spi.WriteableLogRecord;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class RecoverableUnitImpl
implements RecoverableUnit {
    private static final TraceComponent tc = Tr.register(RecoverableUnitImpl.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    protected static final short RECORDTYPENORMAL = 1;
    protected static final short RECORDTYPEDELETED = 2;
    private static final int END_OF_SECTIONS = -1;
    private static final int RECORD_HEADER_SIZE = 18;
    private static final int REMOVAL_HEADER_SIZE = 14;
    private static final int TOTAL_HEADER_SIZE = 42;
    private static final int LOCK_REQUEST_ID_RUI_CREATESECTION = 8;
    private static final int LOCK_REQUEST_ID_RUI_WRITESECTIONS = 9;
    private static final int LOCK_REQUEST_ID_RUI_WRITESECTION = 10;
    private static final int LOCK_REQUEST_ID_RUI_FORCESECTIONS = 11;
    private final long _identity;
    private final HashMap<Integer, RecoverableUnitSection> _recoverableUnitSections;
    private boolean _storedOnDisk;
    private final LogHandle _logHandle;
    private final Lock _controlLock;
    private int _storageMode = 1;
    private int _unwrittenDataSize;
    private int _totalDataSize;
    private final MultiScopeRecoveryLog _recLog;
    private final byte[] _deflatedFailureScope;
    private final FailureScope _failureScope;
    private final int _recordHeaderSize;
    private final int _removalHeaderSize;
    private final int _totalHeaderSize;
    private final String _serverName;
    private final String _clientName;
    private final int _clientVersion;
    private final String _logName;
    private final int _logIdentifier;
    private String _traceId;
    private boolean _payloadAdded = false;
    static final long serialVersionUID = 8551891454932087507L;

    @ManualTrace
    private RecoverableUnitImpl(MultiScopeRecoveryLog recLog, long identity, FailureScope failureScope, LogHandle logHandle, int storageMode, Lock controlLock, boolean recovered) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"RecoverableUnitImpl", (Object[])new Object[]{recLog, identity, failureScope, logHandle, storageMode, controlLock, recovered});
        }
        this._deflatedFailureScope = FailureScopeManager.toByteArray(failureScope);
        this._failureScope = failureScope;
        this._identity = identity;
        this._logHandle = logHandle;
        this._controlLock = controlLock;
        this._recLog = recLog;
        this._storageMode = storageMode;
        this._recordHeaderSize = 18 + this._deflatedFailureScope.length;
        this._removalHeaderSize = 14 + this._deflatedFailureScope.length;
        this._totalHeaderSize = 42 + this._deflatedFailureScope.length;
        this._recoverableUnitSections = new HashMap();
        this._serverName = recLog.serverName();
        this._clientName = recLog.clientName();
        this._clientVersion = recLog.clientVersion();
        this._logName = recLog.logName();
        this._logIdentifier = recLog.logIdentifier();
        this._recLog.addRecoverableUnit(this, recovered);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"RecoverableUnitImpl", (Object)this);
        }
    }

    RecoverableUnitImpl(MultiScopeRecoveryLog recLog, long identity, FailureScope failureScope, LogHandle logHandle, int storageMode, Lock controlLock) {
        this(recLog, identity, failureScope, logHandle, storageMode, controlLock, false);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"RecoverableUnitImpl", (Object[])new Object[]{recLog, identity, failureScope, logHandle, storageMode, controlLock, this});
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    RecoverableUnitImpl(MultiScopeRecoveryLog recLog, long identity, FailureScope failureScope, LogHandle logHandle, int storageMode, Lock controlLock, ReadableLogRecord record) throws InternalLogException, LogCorruptedException {
        this(recLog, identity, failureScope, logHandle, storageMode, controlLock, true);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"RecoverableUnitImpl", (Object[])new Object[]{recLog, identity, failureScope, logHandle, storageMode, controlLock, record});
        }
        try {
            this.recover(record);
        }
        catch (LogCorruptedException logCorruptedException) {
            void lce;
            FFDCFilter.processException((Throwable)logCorruptedException, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl", (String)"341", (Object)this, (Object[])new Object[]{recLog, identity, failureScope, logHandle, storageMode, controlLock, record});
            FFDCFilter.processException((Throwable)lce, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.RecoverableUnitImpl", (String)"290", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"RecoverableUnitImpl", (Object)lce);
            }
            throw lce;
        }
        catch (InternalLogException lce) {
            void ile;
            FFDCFilter.processException((Throwable)lce, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl", (String)"346", (Object)this, (Object[])new Object[]{recLog, identity, failureScope, logHandle, storageMode, controlLock, record});
            FFDCFilter.processException((Throwable)ile, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.RecoverableUnitImpl", (String)"296", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"RecoverableUnitImpl", (Object)ile);
            }
            throw ile;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"RecoverableUnitImpl", (Object)this);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    public RecoverableUnitSection createSection(int identity, boolean singleData) throws RecoverableUnitSectionExistsException, InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createSection", (Object[])new Object[]{this, identity, singleData});
        }
        if (this._recLog.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createSection", (Object)this);
            }
            throw new InternalLogException(null);
        }
        Integer sectionId = identity;
        RecoverableUnitSectionImpl recoverableUnitSection = null;
        this._controlLock.getSharedLock(8);
        if (!this._recoverableUnitSections.containsKey(sectionId)) {
            recoverableUnitSection = new RecoverableUnitSectionImpl(this._recLog, this, this._identity, identity, this._controlLock, this._logHandle, this._storageMode, singleData);
            this._recoverableUnitSections.put(sectionId, recoverableUnitSection);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("RecoverableUnitImpl '" + this._identity + "' created a new RecoverableUnitSection with identity '" + identity + "'"), (Object[])new Object[0]);
            }
        } else {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("RecoverableUnitImpl '" + this._identity + "' was unable to create a RecoverableUnitSection with id '" + identity + "' as it already exists"), (Object[])new Object[0]);
            }
            try {
                this._controlLock.releaseSharedLock(8);
            }
            catch (NoSharedLockException noSharedLockException) {
                void exc;
                FFDCFilter.processException((Throwable)noSharedLockException, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl", (String)"408", (Object)this, (Object[])new Object[]{identity, singleData});
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.createSection", (String)"212", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"createSection", (Object)"InternalLogException");
                }
                throw new InternalLogException((Throwable)exc);
            }
            catch (Throwable exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl", (String)"413", (Object)this, (Object[])new Object[]{identity, singleData});
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.createSection", (String)"218", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"createSection", (Object)"InternalLogException");
                }
                throw new InternalLogException(exc);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createSection", (Object)"RecoverableUnitSectionExistsException");
            }
            throw new RecoverableUnitSectionExistsException(null);
        }
        try {
            this._controlLock.releaseSharedLock(8);
        }
        catch (NoSharedLockException exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl", (String)"427", (Object)this, (Object[])new Object[]{identity, singleData});
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.createSection", (String)"232", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createSection", (Object)"InternalLogException");
            }
            throw new InternalLogException(exc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createSection", (Object)recoverableUnitSection);
        }
        return recoverableUnitSection;
    }

    @Override
    @ManualTrace
    public void removeSection(int identity) throws InvalidRecoverableUnitSectionException, InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeSection", (Object[])new Object[]{this, identity});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeSection", (Object)"UnsupportedOperationException");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @ManualTrace
    public RecoverableUnitSection lookupSection(int identity) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"lookupSection", (Object[])new Object[]{this, identity});
        }
        RecoverableUnitSection recoverableUnitSection = this._recoverableUnitSections.get(identity);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"lookupSection", (Object)recoverableUnitSection);
        }
        return recoverableUnitSection;
    }

    @Override
    public void writeSections() throws InternalLogException {
        this.writeSections(false);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @ManualTrace
    void writeSections(boolean rewriteRequired) throws InternalLogException {
        if (RecoverableUnitImpl.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)RecoverableUnitImpl.tc, (String)"writeSections", (Object[])new Object[]{this, rewriteRequired});
        }
        if (this._recLog.failed()) {
            if (RecoverableUnitImpl.tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)RecoverableUnitImpl.tc, (String)"writeSections", (Object)"InternalLogException");
            }
            throw new InternalLogException(null);
        }
        if (this._logHandle == null) {
            if (RecoverableUnitImpl.tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)RecoverableUnitImpl.tc, (String)"writeSections", (Object)"InternalLogException");
            }
            throw new InternalLogException(null);
        }
        this._controlLock.getSharedLock(9);
        if (this._unwrittenDataSize > 0 || rewriteRequired && this._totalDataSize > 0) {
            try {
                if (RecoverableUnitImpl.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)RecoverableUnitImpl.tc, (String)("Writing recoverable unit '" + this._identity + "'"), (Object[])new Object[0]);
                }
                if (RecoverableUnitImpl.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)RecoverableUnitImpl.tc, (String)("Unwritten data size = " + this._unwrittenDataSize + " total data size = " + this._totalDataSize), (Object[])new Object[0]);
                }
                requiredRecordSize = this._recordHeaderSize;
                requiredRecordSize = rewriteRequired ? (requiredRecordSize += this._totalDataSize) : (requiredRecordSize += this._unwrittenDataSize);
                logRecord = this._logHandle.getWriteableLogRecord(requiredRecordSize);
                if (logRecord == null) ** GOTO lbl84
                this.writeRecordHeader(logRecord, (short)1);
                for (RecoverableUnitSectionImpl section : this._recoverableUnitSections.values()) {
                    section.format(rewriteRequired, logRecord);
                }
                logRecord.putInt(-1);
                logRecord.close();
                this._storedOnDisk = true;
                this._logHandle.writeLogRecord(logRecord);
            }
            catch (IOException requiredRecordSize) {
                FFDCFilter.processException((Throwable)requiredRecordSize, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl", (String)"689", (Object)this, (Object[])new Object[]{rewriteRequired});
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.writeSections", (String)"383", (Object)this);
                if (RecoverableUnitImpl.tc.isEventEnabled()) {
                    Tr.event((TraceComponent)RecoverableUnitImpl.tc, (String)"An unexpected error IO occurred whilst formatting the recovery log buffer", (Object[])new Object[]{exc});
                }
                this._recLog.markFailed((Throwable)exc);
                try {
                    this._controlLock.releaseSharedLock(9);
                }
                catch (Throwable logRecord) {
                    FFDCFilter.processException((Throwable)logRecord, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl", (String)"698", (Object)this, (Object[])new Object[]{rewriteRequired});
                    FFDCFilter.processException((Throwable)exc2, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.writeSections", (String)"392", (Object)this);
                    if (RecoverableUnitImpl.tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)RecoverableUnitImpl.tc, (String)"writeSections", (Object)"InternalLogException");
                    }
                    throw new InternalLogException((Throwable)exc2);
                }
                if (RecoverableUnitImpl.tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)RecoverableUnitImpl.tc, (String)"writeSections", (Object)"InternalLogException");
                }
                throw new InternalLogException((Throwable)exc);
            }
            catch (InternalLogException exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl", (String)"708", (Object)this, (Object[])new Object[]{rewriteRequired});
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.writeSections", (String)"587", (Object)this);
                if (RecoverableUnitImpl.tc.isEventEnabled()) {
                    Tr.event((TraceComponent)RecoverableUnitImpl.tc, (String)"An InternalLogException exception occured whilst formatting the recovery log buffer", (Object[])new Object[]{exc});
                }
                this._recLog.markFailed(exc);
                try {
                    this._controlLock.releaseSharedLock(9);
                }
                catch (Throwable exc2) {
                    FFDCFilter.processException((Throwable)exc2, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl", (String)"717", (Object)this, (Object[])new Object[]{rewriteRequired});
                    FFDCFilter.processException((Throwable)exc2, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.writeSections", (String)"392", (Object)this);
                }
                if (RecoverableUnitImpl.tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)RecoverableUnitImpl.tc, (String)"writeSections", (Object)exc);
                }
                throw exc;
            }
            catch (Throwable exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl", (String)"727", (Object)this, (Object[])new Object[]{rewriteRequired});
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.writeSections", (String)"402", (Object)this);
                if (RecoverableUnitImpl.tc.isEventEnabled()) {
                    Tr.event((TraceComponent)RecoverableUnitImpl.tc, (String)"An unexpected error occurred whilst formatting the recovery log buffer", (Object[])new Object[]{exc});
                }
                this._recLog.markFailed(exc);
                try {
                    this._controlLock.releaseSharedLock(9);
                }
                catch (Throwable exc2) {
                    FFDCFilter.processException((Throwable)exc2, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl", (String)"736", (Object)this, (Object[])new Object[]{rewriteRequired});
                    FFDCFilter.processException((Throwable)exc2, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.writeSections", (String)"411", (Object)this);
                    if (RecoverableUnitImpl.tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)RecoverableUnitImpl.tc, (String)"writeSections", (Object)"InternalLogException");
                    }
                    throw new InternalLogException(exc2);
                }
                if (RecoverableUnitImpl.tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)RecoverableUnitImpl.tc, (String)"writeSections", (Object)"InternalLogException");
                }
                throw new InternalLogException(exc);
            }
        } else if (RecoverableUnitImpl.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)RecoverableUnitImpl.tc, (String)"RecoverableUnitImpl has no RecoverableUnitSections that need to be added to the disk record", (Object[])new Object[0]);
        }
lbl84:
        // 5 sources

        try {
            this._controlLock.releaseSharedLock(9);
        }
        catch (NoSharedLockException exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl", (String)"754", (Object)this, (Object[])new Object[]{rewriteRequired});
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.writeSections", (String)"474", (Object)this);
            if (RecoverableUnitImpl.tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)RecoverableUnitImpl.tc, (String)"writeSections", (Object)"InternalLogException");
            }
            throw new InternalLogException(exc);
        }
        if (RecoverableUnitImpl.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)RecoverableUnitImpl.tc, (String)"writeSections");
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    void writeSection(RecoverableUnitSectionImpl target, int unwrittenDataSize) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"writeSection", (Object[])new Object[]{this, target, unwrittenDataSize});
        }
        if (this._recLog.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"writeSection", (Object)this);
            }
            throw new InternalLogException(null);
        }
        if (this._logHandle == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"writeSection", (Object)"InternalLogException");
            }
            throw new InternalLogException(null);
        }
        this._controlLock.getSharedLock(10);
        try {
            int requiredRecordSize;
            WriteableLogRecord logRecord;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Writing recoverable unit '" + target.identity() + "'"), (Object[])new Object[0]);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unwritten data size = " + unwrittenDataSize), (Object[])new Object[0]);
            }
            if ((logRecord = this._logHandle.getWriteableLogRecord(requiredRecordSize = this._recordHeaderSize + this._unwrittenDataSize)) != null) {
                this.writeRecordHeader(logRecord, (short)1);
                target.format(false, logRecord);
                logRecord.putInt(-1);
                logRecord.close();
                this._storedOnDisk = true;
                this._logHandle.writeLogRecord(logRecord);
            }
        }
        catch (IOException requiredRecordSize) {
            void exc;
            FFDCFilter.processException((Throwable)requiredRecordSize, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl", (String)"857", (Object)this, (Object[])new Object[]{target, unwrittenDataSize});
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.writeSection", (String)"755", (Object)this);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"An unexpected error IO occurred whilst formatting the recovery log buffer", (Object[])new Object[]{exc});
            }
            this._recLog.markFailed((Throwable)exc);
            try {
                this._controlLock.releaseSharedLock(10);
            }
            catch (Throwable logRecord) {
                void exc2;
                FFDCFilter.processException((Throwable)logRecord, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl", (String)"866", (Object)this, (Object[])new Object[]{target, unwrittenDataSize});
                FFDCFilter.processException((Throwable)exc2, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.writeSection", (String)"766", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"writeSection", (Object)"InternalLogException");
                }
                throw new InternalLogException((Throwable)exc2);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"writeSection", (Object)"InternalLogException");
            }
            throw new InternalLogException((Throwable)exc);
        }
        catch (Throwable exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl", (String)"876", (Object)this, (Object[])new Object[]{target, unwrittenDataSize});
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.writeSection", (String)"776", (Object)this);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"An unexpected error occurred whilst formatting the recovery log buffer", (Object[])new Object[]{exc});
            }
            this._recLog.markFailed(exc);
            try {
                this._controlLock.releaseSharedLock(10);
            }
            catch (Throwable exc2) {
                FFDCFilter.processException((Throwable)exc2, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl", (String)"885", (Object)this, (Object[])new Object[]{target, unwrittenDataSize});
                FFDCFilter.processException((Throwable)exc2, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.writeSection", (String)"787", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"writeSection", (Object)"InternalLogException");
                }
                throw new InternalLogException(exc2);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"writeSection", (Object)"InternalLogException");
            }
            throw new InternalLogException(exc);
        }
        try {
            this._controlLock.releaseSharedLock(10);
        }
        catch (NoSharedLockException exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl", (String)"899", (Object)this, (Object[])new Object[]{target, unwrittenDataSize});
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.writeSection", (String)"802", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"writeSection", (Object)"InternalLogException");
            }
            throw new InternalLogException(exc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"writeSection");
        }
    }

    @Override
    public void forceSections() throws InternalLogException {
        this.forceSections(false);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ManualTrace
    void forceSections(boolean rewriteRequired) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"forceSections", (Object[])new Object[]{this, rewriteRequired});
        }
        if (this._recLog.failed()) {
            if (!tc.isEntryEnabled()) throw new InternalLogException(null);
            Tr.exit((TraceComponent)tc, (String)"forceSections", (Object)this);
            throw new InternalLogException(null);
        }
        try {
            this.writeSections(rewriteRequired);
        }
        catch (InternalLogException internalLogException) {
            void exc;
            FFDCFilter.processException((Throwable)internalLogException, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl", (String)"1014", (Object)this, (Object[])new Object[]{rewriteRequired});
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.forceSections", (String)"531", (Object)this);
            if (!tc.isEntryEnabled()) throw exc;
            Tr.exit((TraceComponent)tc, (String)"forceSections", (Object)exc);
            throw exc;
        }
        catch (Throwable exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl", (String)"1019", (Object)this, (Object[])new Object[]{rewriteRequired});
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.forceSections", (String)"537", (Object)this);
            if (!tc.isEntryEnabled()) throw new InternalLogException(exc);
            Tr.exit((TraceComponent)tc, (String)"forceSections", (Object)"InternalLogException");
            throw new InternalLogException(exc);
        }
        this._controlLock.getSharedLock(11);
        try {
            this._logHandle.force();
        }
        catch (InternalLogException exc) {
            try {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl", (String)"1030", (Object)this, (Object[])new Object[]{rewriteRequired});
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.forceSections", (String)"550", (Object)this);
                this._recLog.markFailed(exc);
                if (!tc.isEntryEnabled()) throw exc;
                Tr.exit((TraceComponent)tc, (String)"forceSections", (Object)exc);
                throw exc;
                catch (Throwable exc4333332) {
                    FFDCFilter.processException((Throwable)exc4333332, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl", (String)"1036", (Object)this, (Object[])new Object[]{rewriteRequired});
                    FFDCFilter.processException((Throwable)exc4333332, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.forceSections", (String)"556", (Object)this);
                    this._recLog.markFailed(exc4333332);
                    if (!tc.isEntryEnabled()) throw new InternalLogException(exc4333332);
                    Tr.exit((TraceComponent)tc, (String)"forceSections", (Object)"InternalLogException");
                    throw new InternalLogException(exc4333332);
                }
            }
            catch (Throwable throwable) {
                try {
                    this._controlLock.releaseSharedLock(11);
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    void exc3;
                    FFDCFilter.processException((Throwable)throwable2, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl", (String)"1045", (Object)this, (Object[])new Object[]{rewriteRequired});
                    FFDCFilter.processException((Throwable)exc3, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.forceSections", (String)"568", (Object)this);
                    throw new InternalLogException((Throwable)exc3);
                }
            }
        }
        try {
            this._controlLock.releaseSharedLock(11);
        }
        catch (Throwable exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl", (String)"1045", (Object)this, (Object[])new Object[]{rewriteRequired});
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.forceSections", (String)"568", (Object)this);
            throw new InternalLogException(exc);
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"forceSections");
    }

    @Override
    @ManualTrace
    public LogCursor sections() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sections", (Object[])new Object[]{this});
        }
        Collection<RecoverableUnitSection> recoverableUnitSectionsValues = this._recoverableUnitSections.values();
        LogCursorImpl cursor = new LogCursorImpl(null, recoverableUnitSectionsValues, false, null);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sections", (Object)cursor);
        }
        return cursor;
    }

    @Override
    @ManualTrace
    public long identity() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"identity", (Object[])new Object[]{this});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"identity", (Object)this._identity);
        }
        return this._identity;
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    private void recover(ReadableLogRecord logRecord) throws LogCorruptedException, InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recover", (Object[])new Object[]{this, logRecord});
        }
        if (this._recLog.failed()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recover", (Object)this);
            }
            throw new InternalLogException(null);
        }
        try {
            short recordType = logRecord.getShort();
            if (recordType == 2) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"This is a DELETION record. Deleting RecoverableUnit from map", (Object[])new Object[0]);
                }
                this._recLog.removeRecoverableUnitMapEntries(this._identity);
                this.removeDuringLogRead();
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"This is a NORMAL record. Decoding contents", (Object[])new Object[0]);
                }
                int recoverableUnitSectionIdentity = logRecord.getInt();
                while (recoverableUnitSectionIdentity != -1) {
                    RecoverableUnitSectionImpl recoverableUnitSection;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Recovering RecoverableUnitSection '" + recoverableUnitSectionIdentity + "'"), (Object[])new Object[0]);
                    }
                    logRecord.getShort();
                    boolean singleData = logRecord.getBoolean();
                    if (tc.isDebugEnabled()) {
                        if (singleData) {
                            Tr.debug((TraceComponent)tc, (String)"RecoverableUnitSection can hold only a single data item", (Object[])new Object[0]);
                        } else {
                            Tr.debug((TraceComponent)tc, (String)"RecoverableUnitSection can hold multiple data items", (Object[])new Object[0]);
                        }
                    }
                    if ((recoverableUnitSection = (RecoverableUnitSectionImpl)this._recoverableUnitSections.get(recoverableUnitSectionIdentity)) == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("RecoverableUnitSection " + recoverableUnitSectionIdentity + " has not been encountered before. Creating."), (Object[])new Object[0]);
                        }
                        try {
                            recoverableUnitSection = (RecoverableUnitSectionImpl)this.createSection(recoverableUnitSectionIdentity, singleData);
                        }
                        catch (RecoverableUnitSectionExistsException recoverableUnitSectionExistsException) {
                            void exc;
                            FFDCFilter.processException((Throwable)recoverableUnitSectionExistsException, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl", (String)"1231", (Object)this, (Object[])new Object[]{logRecord});
                            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.recover", (String)"713", (Object)this);
                        }
                        catch (InternalLogException exc) {
                            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl", (String)"1238", (Object)this, (Object[])new Object[]{logRecord});
                            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.recover", (String)"717", (Object)this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"An unexpected exception occured when attempting to create a new RecoverableUnitSection", (Object[])new Object[0]);
                            }
                            throw exc;
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("RecoverableUnitSection " + recoverableUnitSectionIdentity + " has been encountered before."), (Object[])new Object[0]);
                    }
                    recoverableUnitSection.recover(logRecord);
                    this._storedOnDisk = true;
                    recoverableUnitSectionIdentity = logRecord.getInt();
                }
            }
        }
        catch (LogCorruptedException recordType) {
            void exc;
            FFDCFilter.processException((Throwable)recordType, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl", (String)"1263", (Object)this, (Object[])new Object[]{logRecord});
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.recover", (String)"740", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"A LogCorruptedException exception occured reconstructng a RecoverableUnitImpl", (Object[])new Object[0]);
            }
            this._recLog.markFailed((Throwable)exc);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recover", (Object)exc);
            }
            throw exc;
        }
        catch (InternalLogException exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl", (String)"1271", (Object)this, (Object[])new Object[]{logRecord});
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.recover", (String)"747", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"An InternalLogException exception occured reconstructng a RecoverableUnitImpl", (Object[])new Object[0]);
            }
            this._recLog.markFailed(exc);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recover", (Object)exc);
            }
            throw exc;
        }
        catch (Throwable exc) {
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl", (String)"1279", (Object)this, (Object[])new Object[]{logRecord});
            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.recover", (String)"753", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"An exception occured reconstructng a RecoverableUnitImpl", (Object[])new Object[0]);
            }
            this._recLog.markFailed(exc);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recover", (Object)"InternalLogException");
            }
            throw new InternalLogException(exc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recover");
        }
    }

    @ManualTrace
    private void removeDuringLogRead() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeDuringLogRead", (Object[])new Object[]{this, String.valueOf(this._payloadAdded)});
        }
        if (this._payloadAdded) {
            if (this._unwrittenDataSize > 0) {
                this._recLog.payloadDeleted(this._totalDataSize + this._totalHeaderSize, this._unwrittenDataSize + this._totalHeaderSize);
            } else {
                this._recLog.payloadDeleted(this._totalDataSize + this._totalHeaderSize, this._unwrittenDataSize);
            }
        }
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Remove during log read completed for recoverable unit " + this._identity + ". Clear internal state"), (Object[])new Object[0]);
        }
        this._recoverableUnitSections.clear();
        this._totalDataSize = 0;
        this._unwrittenDataSize = 0;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeDuringLogRead", (Object)this);
        }
    }

    /*
     * Unable to fully structure code
     */
    @ManualTrace
    void remove() throws InternalLogException {
        if (RecoverableUnitImpl.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)RecoverableUnitImpl.tc, (String)"remove", (Object[])new Object[]{this});
        }
        if (this._recLog.failed()) {
            if (RecoverableUnitImpl.tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)RecoverableUnitImpl.tc, (String)"remove", (Object)this);
            }
            throw new InternalLogException(null);
        }
        if (this._storedOnDisk) {
            try {
                if (RecoverableUnitImpl.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)RecoverableUnitImpl.tc, (String)("Creating deletion record for recoverable unit '" + this._identity + "'"), (Object[])new Object[0]);
                }
                if ((logRecord = this._logHandle.getWriteableLogRecord(this._removalHeaderSize)) == null) ** GOTO lbl27
                this.writeRecordHeader(logRecord, (short)2);
                logRecord.close();
                this._logHandle.writeLogRecord(logRecord);
            }
            catch (Throwable logRecord) {
                FFDCFilter.processException((Throwable)logRecord, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl", (String)"1391", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.remove", (String)"801", (Object)this);
                if (RecoverableUnitImpl.tc.isEventEnabled()) {
                    Tr.event((TraceComponent)RecoverableUnitImpl.tc, (String)"An unexpected error occurred whilst formatting the recovery log buffer", (Object[])new Object[0]);
                }
                this._recLog.markFailed((Throwable)exc);
                if (RecoverableUnitImpl.tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)RecoverableUnitImpl.tc, (String)"remove", (Object)"InternalLogException");
                }
                throw new InternalLogException((Throwable)exc);
            }
        } else if (RecoverableUnitImpl.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)RecoverableUnitImpl.tc, (String)("Not writing deletion record because RecoverableUnit '" + this._identity + "' is not on disk"), (Object[])new Object[0]);
        }
lbl27:
        // 5 sources

        if (this._unwrittenDataSize > 0) {
            this._recLog.payloadDeleted(this._totalDataSize + this._totalHeaderSize, this._unwrittenDataSize + this._totalHeaderSize);
        } else {
            this._recLog.payloadDeleted(this._totalDataSize + this._totalHeaderSize, this._unwrittenDataSize);
        }
        if (RecoverableUnitImpl.tc.isEventEnabled()) {
            Tr.event((TraceComponent)RecoverableUnitImpl.tc, (String)("Remove completed for recoverable unit " + this._identity + ". Clear internal state"), (Object[])new Object[0]);
        }
        this._recoverableUnitSections.clear();
        this._totalDataSize = 0;
        this._unwrittenDataSize = 0;
        if (RecoverableUnitImpl.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)RecoverableUnitImpl.tc, (String)"remove");
        }
    }

    @ManualTrace
    protected void payloadAdded(int unwrittenPayloadSize, int totalPayloadSize) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"payloadAdded", (Object[])new Object[]{this, unwrittenPayloadSize, totalPayloadSize});
        }
        this._payloadAdded = true;
        int unwrittenRecLogAdjustment = unwrittenPayloadSize;
        int totalRecLogAdjustment = totalPayloadSize;
        if (this._unwrittenDataSize == 0) {
            unwrittenRecLogAdjustment += this._totalHeaderSize;
        }
        if (this._totalDataSize == 0) {
            totalRecLogAdjustment += this._totalHeaderSize;
        }
        this._unwrittenDataSize += unwrittenPayloadSize;
        this._totalDataSize += totalPayloadSize;
        this._recLog.payloadAdded(unwrittenRecLogAdjustment, totalRecLogAdjustment);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("unwrittenDataSize = " + this._unwrittenDataSize + " totalDataSize = " + this._totalDataSize), (Object[])new Object[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"payloadAdded");
        }
    }

    @ManualTrace
    protected void payloadWritten(int payloadSize) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"payloadWritten", (Object[])new Object[]{this, payloadSize});
        }
        this._unwrittenDataSize -= payloadSize;
        if (this._unwrittenDataSize == 0) {
            this._recLog.payloadWritten(payloadSize + this._totalHeaderSize);
        } else {
            this._recLog.payloadWritten(payloadSize);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("unwrittenDataSize = " + this._unwrittenDataSize + " totalDataSize = " + this._totalDataSize), (Object[])new Object[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"payloadWritten");
        }
    }

    @ManualTrace
    protected void payloadDeleted(int totalPayloadSize, int unwrittenPayloadSize) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"payloadDeleted", (Object[])new Object[]{this, totalPayloadSize, unwrittenPayloadSize});
        }
        this._totalDataSize -= totalPayloadSize;
        this._unwrittenDataSize -= unwrittenPayloadSize;
        if (this._unwrittenDataSize == 0 && unwrittenPayloadSize != 0) {
            unwrittenPayloadSize += this._totalHeaderSize;
        }
        if (this._totalDataSize == 0) {
            totalPayloadSize += this._totalHeaderSize;
        }
        this._recLog.payloadDeleted(totalPayloadSize, unwrittenPayloadSize);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("unwrittenDataSize = " + this._unwrittenDataSize + " totalDataSize = " + this._totalDataSize), (Object[])new Object[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"payloadDeleted");
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    protected static void recover(MultiScopeRecoveryLog recoveryLog, ReadableLogRecord record, LogHandle logHandle, int storageMode, Lock controlLock) throws LogCorruptedException, InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recover", (Object[])new Object[]{recoveryLog, record, logHandle, storageMode, controlLock});
        }
        int failureScopeLength = record.getInt();
        byte[] failureScopeBytes = new byte[failureScopeLength];
        record.get(failureScopeBytes);
        try {
            FailureScope failureScope = FailureScopeManager.toFailureScope(failureScopeBytes);
            long recoverableUnitIdentity = record.getLong();
            RecoverableUnitImpl recoverableUnit = recoveryLog.getRecoverableUnit(recoverableUnitIdentity);
            if (recoverableUnit == null) {
                recoverableUnit = new RecoverableUnitImpl(recoveryLog, recoverableUnitIdentity, failureScope, logHandle, storageMode, controlLock, record);
            } else {
                recoverableUnit.recover(record);
            }
        }
        catch (LogCorruptedException failureScope) {
            void lce;
            FFDCFilter.processException((Throwable)failureScope, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl", (String)"1714", null, (Object[])new Object[]{recoveryLog, record, logHandle, storageMode, controlLock});
            FFDCFilter.processException((Throwable)lce, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.recover", (String)"1604");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recover", (Object)lce);
            }
            throw lce;
        }
        catch (InternalLogException lce) {
            void ile;
            FFDCFilter.processException((Throwable)lce, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl", (String)"1719", null, (Object[])new Object[]{recoveryLog, record, logHandle, storageMode, controlLock});
            FFDCFilter.processException((Throwable)ile, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.recover", (String)"1608");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recover", (Object)ile);
            }
            throw ile;
        }
        catch (Exception ile) {
            void e;
            FFDCFilter.processException((Throwable)ile, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl", (String)"1724", null, (Object[])new Object[]{recoveryLog, record, logHandle, storageMode, controlLock});
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.recoverylog.spi.RecoverableUnitImpl.recover", (String)"1612");
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Unexpected exception caught", (Object[])new Object[]{e});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recover", (Object)"InternalLogException");
            }
            throw new InternalLogException((Throwable)e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recover");
        }
    }

    @ManualTrace
    private void writeRecordHeader(WriteableLogRecord logRecord, short recordType) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"writeRecordHeader", (Object[])new Object[]{logRecord, recordType, this});
        }
        logRecord.putInt(this._deflatedFailureScope.length);
        logRecord.put(this._deflatedFailureScope);
        logRecord.putLong(this._identity);
        logRecord.putShort(recordType);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"writeRecordHeader");
        }
    }

    protected FailureScope failureScope() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"failureScope", (Object[])new Object[]{this, this._failureScope});
        }
        return this._failureScope;
    }

    public String toString() {
        if (this._traceId == null) {
            this._traceId = "RecoverableUnitImpl:serverName=" + this._serverName + ":clientName=" + this._clientName + ":clientVersion=" + this._clientVersion + ":logName=" + this._logName + ":logIdentifier=" + this._logIdentifier + " @" + System.identityHashCode(this);
        }
        return this._traceId;
    }
}

