/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.Configuration;
import com.ibm.ws.recoverylog.spi.ConflictingCredentialsException;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.FileFailureScope;
import com.ibm.ws.recoverylog.spi.HeartbeatLog;
import com.ibm.ws.recoverylog.spi.InvalidFailureScopeException;
import com.ibm.ws.recoverylog.spi.InvalidStateException;
import com.ibm.ws.recoverylog.spi.LeaseInfo;
import com.ibm.ws.recoverylog.spi.RecoveryAgent;
import com.ibm.ws.recoverylog.spi.RecoveryDirector;
import com.ibm.ws.recoverylog.spi.RecoveryEventListener;
import com.ibm.ws.recoverylog.spi.RecoveryFailedException;
import com.ibm.ws.recoverylog.spi.RecoveryLogCallBack;
import com.ibm.ws.recoverylog.spi.RecoveryLogFactory;
import com.ibm.ws.recoverylog.spi.RecoveryLogManager;
import com.ibm.ws.recoverylog.spi.RecoveryLogManagerImpl;
import com.ibm.ws.recoverylog.spi.RegisteredRecoveryEventListeners;
import com.ibm.ws.recoverylog.spi.TerminationFailedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class RecoveryDirectorImpl
implements RecoveryDirector {
    private static final TraceComponent tc = Tr.register(RecoveryDirectorImpl.class, (String)"Transaction", (String)"com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
    public static final int CALLBACK_RECOVERYSTARTED = 1;
    public static final int CALLBACK_RECOVERYCOMPLETE = 2;
    public static final int CALLBACK_TERMINATIONSTARTED = 3;
    public static final int CALLBACK_TERMINATIONCOMPLETE = 4;
    public static final int CALLBACK_RECOVERYFAILED = 5;
    private static RecoveryDirectorImpl _instance;
    private static RecoveryLogFactory theRecoveryLogFactory;
    protected final TreeMap<Integer, ArrayList<RecoveryAgent>> _registeredRecoveryAgents;
    private final HashMap<RecoveryAgent, HashSet<FailureScope>> _outstandingInitializationRecords;
    private final HashMap<FailureScope, HashSet<RecoveryAgent>> _outstandingRecoveryRecords;
    private final HashMap<RecoveryAgent, HashSet<FailureScope>> _outstandingTerminationRecords;
    private boolean _registrationAllowed = true;
    protected FailureScope _currentFailureScope;
    private HashSet<RecoveryLogCallBack> _registeredCallbacks = new HashSet();
    private final RecoveryEventListener _eventListeners;
    private final HashSet<FailureScope> _initFailedFailureScopes;
    protected HashMap<String, RecoveryLogFactory> _customLogFactories = new HashMap();
    static final long serialVersionUID = 2277469288348596273L;

    @ManualTrace
    protected RecoveryDirectorImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"RecoveryDirectorImpl", (Object[])new Object[0]);
        }
        this._registeredRecoveryAgents = new TreeMap();
        this._outstandingInitializationRecords = new HashMap();
        this._outstandingRecoveryRecords = new HashMap();
        this._outstandingTerminationRecords = new HashMap();
        this._initFailedFailureScopes = new HashSet();
        this._eventListeners = RegisteredRecoveryEventListeners.instance();
        if (theRecoveryLogFactory != null) {
            String className = theRecoveryLogFactory.getClass().getName();
            this._customLogFactories.put(className, theRecoveryLogFactory);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("RecoveryDirectorImpl: setting RecoveryLogFactory, " + theRecoveryLogFactory + "for classname, " + className), (Object[])new Object[0]);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"RecoveryDirectorImpl: the RecoveryLogFactory is null", (Object[])new Object[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"RecoveryDirectorImpl", (Object)this);
        }
    }

    @ManualTrace
    public static synchronized RecoveryDirector instance() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"instance", (Object[])new Object[0]);
        }
        if (_instance == null) {
            _instance = new RecoveryDirectorImpl();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"instance", (Object)_instance);
        }
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManualTrace
    public RecoveryLogManager registerService(RecoveryAgent recoveryAgent, int sequence) throws ConflictingCredentialsException, InvalidStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerService", (Object[])new Object[]{recoveryAgent, sequence, this});
        }
        RecoveryLogManagerImpl clientRLM = null;
        TreeMap<Integer, ArrayList<RecoveryAgent>> treeMap = this._registeredRecoveryAgents;
        synchronized (treeMap) {
            if (!this._registrationAllowed) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Client service registration attempted after recovery processing has been driven", (Object[])new Object[0]);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"registerService", (Object)"InvalidStateException");
                }
                throw new InvalidStateException(null);
            }
            int clientIdentifier = recoveryAgent.clientIdentifier();
            String clientName = recoveryAgent.clientName();
            Collection<ArrayList<RecoveryAgent>> registeredRecoveryAgentsValues = this._registeredRecoveryAgents.values();
            for (ArrayList<RecoveryAgent> registeredRecoveryAgentsArray : registeredRecoveryAgentsValues) {
                for (RecoveryAgent registeredRecoveryAgent : registeredRecoveryAgentsArray) {
                    if (registeredRecoveryAgent.clientIdentifier() != clientIdentifier && !registeredRecoveryAgent.clientName().equals(clientName)) continue;
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Client service registration attempted with non-unique identity or name", (Object[])new Object[0]);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"registerService", (Object)"ConflictingCredentialsException");
                    }
                    throw new ConflictingCredentialsException(null);
                }
            }
            Integer sequenceI = new Integer(sequence);
            ArrayList<RecoveryAgent> sequenceArray = this._registeredRecoveryAgents.get(sequenceI);
            if (sequenceArray == null) {
                sequenceArray = new ArrayList();
                this._registeredRecoveryAgents.put(sequenceI, sequenceArray);
            }
            sequenceArray.add(recoveryAgent);
            clientRLM = new RecoveryLogManagerImpl(recoveryAgent, this._customLogFactories);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("New service '" + clientName + "' (" + clientIdentifier + ") registered with RecoveryDirectorImpl"), (Object[])new Object[0]);
            }
            if (clientIdentifier == 1) {
                Configuration.txRecoveryAgent(recoveryAgent);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerService", (Object)clientRLM);
        }
        return clientRLM;
    }

    @Override
    @ManualTrace
    public void serialRecoveryComplete(RecoveryAgent recoveryAgent, FailureScope failureScope) throws InvalidFailureScopeException {
        boolean removed;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"serialRecoveryComplete", (Object[])new Object[]{recoveryAgent, failureScope, this});
        }
        if (!(removed = this.removeInitializationRecord(recoveryAgent, failureScope))) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"The supplied FailureScope was not recognized as outstaning work for this RecoveryAgent", (Object[])new Object[0]);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"serialRecoveryComplete", (Object)"InvalidFailureScopeException");
            }
            throw new InvalidFailureScopeException(null);
        }
        this._eventListeners.clientRecoveryComplete(failureScope, recoveryAgent.clientIdentifier());
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"serialRecoveryComplete");
        }
    }

    @Override
    @ManualTrace
    public void terminationComplete(RecoveryAgent recoveryAgent, FailureScope failureScope) throws InvalidFailureScopeException {
        boolean removed;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"terminationComplete", (Object[])new Object[]{recoveryAgent, failureScope, this});
        }
        if (!(removed = this.removeTerminationRecord(recoveryAgent, failureScope))) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"The supplied FailureScope was not recognized as an outstaning termination request for this RecoveryAgent", (Object[])new Object[0]);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"terminationComplete", (Object)"InvalidFailureScopeException");
            }
            throw new InvalidFailureScopeException(null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"terminationComplete");
        }
    }

    @Override
    @ManualTrace
    public synchronized FailureScope currentFailureScope() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"currentFailureScope", (Object[])new Object[]{this});
        }
        if (this._currentFailureScope == null) {
            this._currentFailureScope = new FileFailureScope();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"currentFailureScope", (Object)this._currentFailureScope);
        }
        return this._currentFailureScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    @FFDCIgnore(value={RecoveryFailedException.class})
    public void directInitialization(FailureScope failureScope) throws RecoveryFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"directInitialization", (Object[])new Object[]{failureScope, this});
        }
        FailureScope currentFailureScope = Configuration.localFailureScope();
        TreeMap<Integer, ArrayList<RecoveryAgent>> treeMap = this._registeredRecoveryAgents;
        synchronized (treeMap) {
            this._registrationAllowed = false;
        }
        if (currentFailureScope.equals(failureScope)) {
            Tr.info((TraceComponent)tc, (String)"CWRLS0010_PERFORM_LOCAL_RECOVERY", (Object[])new Object[]{failureScope.serverName()});
        } else {
            Tr.info((TraceComponent)tc, (String)"CWRLS0011_PERFORM_PEER_RECOVERY", (Object[])new Object[]{failureScope.serverName()});
        }
        Collection<ArrayList<RecoveryAgent>> registeredRecoveryAgentsValues = this._registeredRecoveryAgents.values();
        for (ArrayList<RecoveryAgent> registeredRecoveryAgentsArray : registeredRecoveryAgentsValues) {
            for (RecoveryAgent recoveryAgent : registeredRecoveryAgentsArray) {
                this.addInitializationRecord(recoveryAgent, failureScope);
                this.addRecoveryRecord(recoveryAgent, failureScope);
            }
        }
        if (Configuration.HAEnabled()) {
            Configuration.getRecoveryLogComponent().joinCluster(failureScope);
        }
        if (this._registeredCallbacks != null) {
            this.driveCallBacks(1, failureScope);
        }
        for (ArrayList<RecoveryAgent> registeredRecoveryAgentsArray : registeredRecoveryAgentsValues) {
            for (RecoveryAgent recoveryAgent : registeredRecoveryAgentsArray) {
                try {
                    HeartbeatLog heartbeatLog;
                    this._eventListeners.clientRecoveryInitiated(failureScope, recoveryAgent.clientIdentifier());
                    boolean shouldBeRecovered = true;
                    boolean enableHADBPeerLocking = recoveryAgent.isDBTXLogPeerLocking();
                    if (enableHADBPeerLocking && (heartbeatLog = recoveryAgent.getHeartbeatLog(failureScope)) != null) {
                        recoveryAgent.setReplayThread();
                        if (currentFailureScope.equals(failureScope)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"LOCAL RECOVERY, claim local logs", (Object[])new Object[0]);
                            }
                            if (!(shouldBeRecovered = heartbeatLog.claimLocalRecoveryLogs())) {
                                RecoveryFailedException rfex = new RecoveryFailedException("HADB Peer locking, local recovery failed");
                                throw rfex;
                            }
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"PEER RECOVERY, take lock, ie check staleness", (Object[])new Object[0]);
                            }
                            if (!(shouldBeRecovered = heartbeatLog.claimPeerRecoveryLogs())) {
                                RecoveryFailedException rfex = new RecoveryFailedException("HADB Peer locking, peer recovery failed");
                                throw rfex;
                            }
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("now initiateRecovery if shouldBeRecovered - " + shouldBeRecovered), (Object[])new Object[0]);
                    }
                    if (shouldBeRecovered) {
                        recoveryAgent.initiateRecovery(failureScope);
                    }
                }
                catch (RecoveryFailedException exc) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"directInitialization", (Object)exc);
                    }
                    throw exc;
                }
                HashMap<RecoveryAgent, HashSet<FailureScope>> hashMap = this._outstandingInitializationRecords;
                synchronized (hashMap) {
                    while (this.initializationOutstanding(recoveryAgent, failureScope)) {
                        try {
                            this._outstandingInitializationRecords.wait();
                        }
                        catch (InterruptedException enableHADBPeerLocking) {
                            void exc;
                            FFDCFilter.processException((Throwable)enableHADBPeerLocking, (String)"com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl", (String)"663", (Object)this, (Object[])new Object[]{failureScope});
                            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl.directInitialization", (String)"432", (Object)this);
                        }
                    }
                }
            }
        }
        if (currentFailureScope.equals(failureScope)) {
            Tr.info((TraceComponent)tc, (String)"CWRLS0012_DIRECT_LOCAL_RECOVERY", (Object[])new Object[]{failureScope.serverName()});
        } else {
            Tr.info((TraceComponent)tc, (String)"CWRLS0013_DIRECT_PEER_RECOVERY", (Object[])new Object[]{failureScope.serverName()});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"directInitialization");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @ManualTrace
    public void directTermination(FailureScope failureScope) throws TerminationFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"directTermination", (Object[])new Object[]{failureScope, this});
        }
        Tr.info((TraceComponent)tc, (String)"CWRLS0014_HALT_PEER_RECOVERY", (Object[])new Object[]{failureScope.serverName()});
        if (this._registeredCallbacks != null) {
            this.driveCallBacks(3, failureScope);
        }
        if (Configuration.HAEnabled()) {
            Configuration.getRecoveryLogComponent().leaveCluster(failureScope);
        }
        Collection<ArrayList<RecoveryAgent>> registeredRecoveryAgentsValues = this._registeredRecoveryAgents.values();
        for (ArrayList<RecoveryAgent> registeredRecoveryAgentsArray : registeredRecoveryAgentsValues) {
            for (RecoveryAgent recoveryAgent : registeredRecoveryAgentsArray) {
                this.addTerminationRecord(recoveryAgent, failureScope);
                try {
                    recoveryAgent.terminateRecovery(failureScope);
                }
                catch (TerminationFailedException terminationFailedException) {
                    void exc;
                    FFDCFilter.processException((Throwable)terminationFailedException, (String)"com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl", (String)"734", (Object)this, (Object[])new Object[]{failureScope});
                    FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl.directTermination", (String)"540", (Object)this);
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"directTermination", (Object)exc);
                    }
                    throw exc;
                }
                catch (Exception exc) {
                    FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl", (String)"739", (Object)this, (Object[])new Object[]{failureScope});
                    FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl.directTermination", (String)"576", (Object)this);
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"directTermination", (Object)exc);
                    }
                    throw new TerminationFailedException(exc);
                }
                HashMap<RecoveryAgent, HashSet<FailureScope>> hashMap = this._outstandingTerminationRecords;
                synchronized (hashMap) {
                    while (this.terminationOutstanding(recoveryAgent, failureScope)) {
                        try {
                            this._outstandingTerminationRecords.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            void exc;
                            FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl", (String)"751", (Object)this, (Object[])new Object[]{failureScope});
                            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl.directTermination", (String)"549", (Object)this);
                        }
                    }
                }
            }
        }
        if (this._registeredCallbacks != null) {
            this.driveCallBacks(4, failureScope);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"directTermination");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    private void addInitializationRecord(RecoveryAgent recoveryAgent, FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addInitializationRecord", (Object[])new Object[]{recoveryAgent, failureScope, this});
        }
        HashMap<RecoveryAgent, HashSet<FailureScope>> hashMap = this._outstandingInitializationRecords;
        synchronized (hashMap) {
            HashSet<FailureScope> failureScopeSet = this._outstandingInitializationRecords.get(recoveryAgent);
            if (failureScopeSet == null) {
                failureScopeSet = new HashSet();
                this._outstandingInitializationRecords.put(recoveryAgent, failureScopeSet);
            }
            failureScopeSet.add(failureScope);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addInitializationRecord");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    private void addTerminationRecord(RecoveryAgent recoveryAgent, FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addTerminationRecord", (Object[])new Object[]{recoveryAgent, failureScope, this});
        }
        HashMap<RecoveryAgent, HashSet<FailureScope>> hashMap = this._outstandingTerminationRecords;
        synchronized (hashMap) {
            HashSet<FailureScope> failureScopeSet = this._outstandingTerminationRecords.get(recoveryAgent);
            if (failureScopeSet == null) {
                failureScopeSet = new HashSet();
                this._outstandingTerminationRecords.put(recoveryAgent, failureScopeSet);
            }
            failureScopeSet.add(failureScope);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addTerminationRecord");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    private boolean removeInitializationRecord(RecoveryAgent recoveryAgent, FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeInitializationRecord", (Object[])new Object[]{recoveryAgent, failureScope, this});
        }
        boolean found = false;
        HashMap<RecoveryAgent, HashSet<FailureScope>> hashMap = this._outstandingInitializationRecords;
        synchronized (hashMap) {
            HashSet<FailureScope> failureScopeSet = this._outstandingInitializationRecords.get(recoveryAgent);
            if (failureScopeSet != null) {
                found = failureScopeSet.remove(failureScope);
            }
            this._outstandingInitializationRecords.notifyAll();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeInitializationRecord", (Object)found);
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    private boolean removeTerminationRecord(RecoveryAgent recoveryAgent, FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeTerminationRecord", (Object[])new Object[]{recoveryAgent, failureScope, this});
        }
        boolean found = false;
        HashMap<RecoveryAgent, HashSet<FailureScope>> hashMap = this._outstandingTerminationRecords;
        synchronized (hashMap) {
            HashSet<FailureScope> failureScopeSet = this._outstandingTerminationRecords.get(recoveryAgent);
            if (failureScopeSet != null) {
                found = failureScopeSet.remove(failureScope);
            }
            this._outstandingTerminationRecords.notifyAll();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeTerminationRecord", (Object)found);
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    private boolean initializationOutstanding(RecoveryAgent recoveryAgent, FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initializationOutstanding", (Object[])new Object[]{recoveryAgent, failureScope, this});
        }
        boolean outstanding = false;
        HashMap<RecoveryAgent, HashSet<FailureScope>> hashMap = this._outstandingInitializationRecords;
        synchronized (hashMap) {
            HashSet<FailureScope> failureScopeSet = this._outstandingInitializationRecords.get(recoveryAgent);
            if (failureScopeSet != null) {
                outstanding = failureScopeSet.contains(failureScope);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initializationOutstanding", (Object)outstanding);
        }
        return outstanding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    private boolean terminationOutstanding(RecoveryAgent recoveryAgent, FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"terminationOutstanding", (Object[])new Object[]{recoveryAgent, failureScope, this});
        }
        boolean outstanding = false;
        HashMap<RecoveryAgent, HashSet<FailureScope>> hashMap = this._outstandingTerminationRecords;
        synchronized (hashMap) {
            HashSet<FailureScope> failureScopeSet = this._outstandingTerminationRecords.get(recoveryAgent);
            if (failureScopeSet != null) {
                outstanding = failureScopeSet.contains(failureScope);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"terminationOutstanding", (Object)outstanding);
        }
        return outstanding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    @FFDCIgnore(value={RecoveryFailedException.class})
    public void driveLocalRecovery() throws RecoveryFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"driveLocalRecovery", (Object[])new Object[]{this});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"RLSHA: configuring for local only recovery", (Object[])new Object[0]);
        }
        RecoveryDirectorImpl recoveryDirectorImpl = this;
        synchronized (recoveryDirectorImpl) {
            if (this._currentFailureScope == null) {
                this._currentFailureScope = new FileFailureScope();
            }
        }
        try {
            this.directInitialization(this._currentFailureScope);
        }
        catch (RecoveryFailedException exc) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"driveLocalRecovery", (Object)exc);
            }
            throw exc;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"driveLocalRecovery");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    private void addRecoveryRecord(RecoveryAgent recoveryAgent, FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addRecoveryRecord", (Object[])new Object[]{recoveryAgent, failureScope, this});
        }
        HashMap<FailureScope, HashSet<RecoveryAgent>> hashMap = this._outstandingRecoveryRecords;
        synchronized (hashMap) {
            HashSet<RecoveryAgent> recoveryAgentSet = this._outstandingRecoveryRecords.get(failureScope);
            if (recoveryAgentSet == null) {
                recoveryAgentSet = new HashSet();
                this._outstandingRecoveryRecords.put(failureScope, recoveryAgentSet);
            }
            recoveryAgentSet.add(recoveryAgent);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addRecoveryRecord");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    private boolean removeRecoveryRecord(RecoveryAgent recoveryAgent, FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeRecoveryRecord", (Object[])new Object[]{recoveryAgent, failureScope, this});
        }
        boolean found = false;
        HashMap<FailureScope, HashSet<RecoveryAgent>> hashMap = this._outstandingRecoveryRecords;
        synchronized (hashMap) {
            HashSet<RecoveryAgent> recoveryAgentSet = this._outstandingRecoveryRecords.get(failureScope);
            if (recoveryAgentSet != null) {
                found = recoveryAgentSet.remove(recoveryAgent);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeRecoveryRecord", (Object)found);
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    private boolean recoveryOutstanding(FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recoveryOutstanding", (Object[])new Object[]{failureScope, this});
        }
        boolean outstanding = false;
        HashMap<FailureScope, HashSet<RecoveryAgent>> hashMap = this._outstandingRecoveryRecords;
        synchronized (hashMap) {
            HashSet<RecoveryAgent> recoveryAgentSet = this._outstandingRecoveryRecords.get(failureScope);
            if (recoveryAgentSet != null && recoveryAgentSet.size() > 0) {
                outstanding = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recoveryOutstanding", (Object)outstanding);
        }
        return outstanding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    public void initialRecoveryComplete(RecoveryAgent recoveryAgent, FailureScope failureScope) throws InvalidFailureScopeException {
        boolean removed;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialRecoveryComplete", (Object[])new Object[]{recoveryAgent, failureScope, this});
        }
        if (!(removed = this.removeRecoveryRecord(recoveryAgent, failureScope))) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"The supplied FailureScope was not recognized as outstaning work for this RecoveryAgent", (Object[])new Object[0]);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"initialRecoveryComplete", (Object)"InvalidFailureScopeException");
            }
            throw new InvalidFailureScopeException(null);
        }
        if (!this.recoveryOutstanding(failureScope)) {
            boolean atLeastOneServiceReportedFailure = false;
            HashSet<FailureScope> hashSet = this._initFailedFailureScopes;
            synchronized (hashSet) {
                atLeastOneServiceReportedFailure = this._initFailedFailureScopes.remove(failureScope);
            }
            if (!atLeastOneServiceReportedFailure) {
                if (this._registeredCallbacks != null) {
                    this.driveCallBacks(2, failureScope);
                }
                if (failureScope.equals(Configuration.localFailureScope()) && Configuration.HAEnabled()) {
                    Configuration.getRecoveryLogComponent().enablePeerRecovery();
                }
            } else {
                if (this._registeredCallbacks != null) {
                    this.driveCallBacks(5, failureScope);
                }
                if (Configuration.localFailureScope().equals(failureScope)) {
                    Configuration.getRecoveryLogComponent().localRecoveryFailed();
                } else {
                    block18: {
                        try {
                            this.directTermination(failureScope);
                        }
                        catch (Exception exception) {
                            void exc;
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl", (String)"1356", (Object)this, (Object[])new Object[]{recoveryAgent, failureScope});
                            FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl.initialRecoveryComplete", (String)"1399", (Object)this);
                            if (!tc.isDebugEnabled()) break block18;
                            Tr.debug((TraceComponent)tc, (String)"initialRecoveryComplete", (Object[])new Object[]{"An unexpected excetion occured whilst terminating recovery processing"});
                        }
                    }
                    Configuration.getRecoveryLogComponent().deactivateGroup(failureScope, 60);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialRecoveryComplete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ManualTrace
    public void initialRecoveryFailed(RecoveryAgent recoveryAgent, FailureScope failureScope) throws InvalidFailureScopeException {
        boolean removed;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialRecoveryFailed", (Object[])new Object[]{recoveryAgent, failureScope, this});
        }
        if (!(removed = this.removeRecoveryRecord(recoveryAgent, failureScope))) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"The supplied FailureScope was not recognized as outstaning work for this RecoveryAgent", (Object[])new Object[0]);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"initialRecoveryFailed", (Object)"InvalidFailureScopeException");
            }
            throw new InvalidFailureScopeException(null);
        }
        if (!this.recoveryOutstanding(failureScope)) {
            if (this._registeredCallbacks != null) {
                this.driveCallBacks(5, failureScope);
            }
            HashSet<FailureScope> hashSet = this._initFailedFailureScopes;
            synchronized (hashSet) {
                this._initFailedFailureScopes.remove(failureScope);
            }
            if (Configuration.localFailureScope().equals(failureScope)) {
                Configuration.getRecoveryLogComponent().localRecoveryFailed();
            } else {
                try {
                    this.directTermination(failureScope);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl", (String)"1429", (Object)this, (Object[])new Object[]{recoveryAgent, failureScope});
                }
                Configuration.getRecoveryLogComponent().deactivateGroup(failureScope, 60);
            }
        } else {
            HashSet<FailureScope> hashSet = this._initFailedFailureScopes;
            synchronized (hashSet) {
                this._initFailedFailureScopes.add(failureScope);
            }
            int failedClientId = recoveryAgent.clientIdentifier();
            Collection<ArrayList<RecoveryAgent>> registeredRecoveryAgentsValues = this._registeredRecoveryAgents.values();
            for (ArrayList<RecoveryAgent> registeredRecoveryAgentsArray : registeredRecoveryAgentsValues) {
                for (RecoveryAgent informRecoveryAgent : registeredRecoveryAgentsArray) {
                    if (informRecoveryAgent.clientIdentifier() == failedClientId) continue;
                    informRecoveryAgent.agentReportedFailure(failedClientId, failureScope);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialRecoveryFailed");
        }
    }

    @Override
    @ManualTrace
    public synchronized void addCallBack(RecoveryLogCallBack callback) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addCallBack", (Object[])new Object[]{callback});
        }
        if (this._registeredCallbacks == null) {
            this._registeredCallbacks = new HashSet();
        }
        this._registeredCallbacks.add(callback);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addCallBack");
        }
    }

    @ManualTrace
    private void driveCallBacks(int stage, FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            switch (stage) {
                case 1: {
                    Tr.entry((TraceComponent)tc, (String)"driveCallBacks", (Object[])new Object[]{"CALLBACK_RECOVERYSTARTED", failureScope});
                    break;
                }
                case 2: {
                    Tr.entry((TraceComponent)tc, (String)"driveCallBacks", (Object[])new Object[]{"CALLBACK_RECOVERYCOMPLETE", failureScope});
                    break;
                }
                case 3: {
                    Tr.entry((TraceComponent)tc, (String)"driveCallBacks", (Object[])new Object[]{"CALLBACK_TERMINATIONSTARTED", failureScope});
                    break;
                }
                case 4: {
                    Tr.entry((TraceComponent)tc, (String)"driveCallBacks", (Object[])new Object[]{"CALLBACK_TERMINATIONCOMPLETE", failureScope});
                    break;
                }
                case 5: {
                    Tr.entry((TraceComponent)tc, (String)"driveCallBacks", (Object[])new Object[]{"CALLBACK_RECOVERYFAILED", failureScope});
                    break;
                }
                default: {
                    Tr.entry((TraceComponent)tc, (String)"driveCallBacks", (Object[])new Object[]{new Integer(stage), failureScope});
                }
            }
        }
        if (this._registeredCallbacks != null) {
            for (RecoveryLogCallBack callBack : this._registeredCallbacks) {
                switch (stage) {
                    case 1: {
                        callBack.recoveryStarted(failureScope);
                        break;
                    }
                    case 2: 
                    case 5: {
                        callBack.recoveryCompleted(failureScope);
                        break;
                    }
                    case 3: {
                        callBack.terminateStarted(failureScope);
                        break;
                    }
                    case 4: {
                        callBack.terminateCompleted(failureScope);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"driveCallBacks");
        }
    }

    @Override
    @ManualTrace
    public Object getRecoveryLogConfiguration(FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRecoveryLogConfiguration", (Object[])new Object[]{failureScope});
        }
        Object recoveryLog = Configuration.getRecoveryLogComponent().getRecoveryLogConfig(failureScope);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRecoveryLogConfiguration", (Object)recoveryLog);
        }
        return recoveryLog;
    }

    @Override
    @ManualTrace
    public String getNonNullCurrentFailureScopeIDString() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getNonNullCurrentFailureScopeIDString", (Object[])new Object[0]);
        }
        String value = Configuration.getRecoveryLogComponent().getNonNullCurrentFailureScopeIDString(this.currentFailureScope().serverName());
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getNonNullCurrentFailureScopeIDString", (Object)value);
        }
        return value;
    }

    @Override
    @ManualTrace
    public void registerRecoveryEventListener(RecoveryEventListener rel) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerRecoveryEventListener", (Object[])new Object[]{rel});
        }
        RegisteredRecoveryEventListeners.instance().add(rel);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerRecoveryEventListener");
        }
    }

    @Override
    @ManualTrace
    public boolean isHAEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isHAEnabled", (Object[])new Object[0]);
        }
        boolean haEnabled = Configuration.HAEnabled();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isHAEnabled", (Object)haEnabled);
        }
        return haEnabled;
    }

    public static void reset() {
        _instance = null;
    }

    @ManualTrace
    public void drivePeerRecovery() throws RecoveryFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"drivePeerRecovery", (Object[])new Object[]{this});
        }
        RecoveryAgent libertyRecoveryAgent = null;
        FailureScope localFailureScope = Configuration.localFailureScope();
        Tr.audit((TraceComponent)tc, (String)("WTRN0108I: " + localFailureScope.serverName() + " checking to see if any peers need recovering"), (Object[])new Object[0]);
        ArrayList<String> peersToRecover = null;
        Collection<ArrayList<RecoveryAgent>> registeredRecoveryAgentsValues = this._registeredRecoveryAgents.values();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("work with RA values: " + registeredRecoveryAgentsValues + ", collection size: " + registeredRecoveryAgentsValues.size()), (Object[])new Object[]{this});
        }
        for (ArrayList<RecoveryAgent> registeredRecoveryAgentsArray : registeredRecoveryAgentsValues) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("work with Agents array: " + registeredRecoveryAgentsArray + ", of size: " + registeredRecoveryAgentsArray.size()), (Object[])new Object[]{this});
            }
            Iterator<RecoveryAgent> registeredRecoveryAgentsArrayIterator = registeredRecoveryAgentsArray.iterator();
            while (registeredRecoveryAgentsArrayIterator.hasNext()) {
                RecoveryAgent recoveryAgent;
                libertyRecoveryAgent = recoveryAgent = registeredRecoveryAgentsArrayIterator.next();
                String recoveryGroup = libertyRecoveryAgent.getRecoveryGroup();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("work with Agent: " + recoveryAgent + " and recoveryGroup " + recoveryGroup), (Object[])new Object[]{this});
                }
                peersToRecover = recoveryAgent.processLeasesForPeers(localFailureScope.serverName(), recoveryGroup);
            }
        }
        if (peersToRecover != null && !peersToRecover.isEmpty() && libertyRecoveryAgent != null) {
            this.peerRecoverServers(libertyRecoveryAgent, localFailureScope.serverName(), peersToRecover);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"drivePeerRecovery");
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    @FFDCIgnore(value={RecoveryFailedException.class})
    public synchronized void peerRecoverServers(RecoveryAgent recoveryAgent, String myRecoveryIdentity, ArrayList<String> peersToRecover) throws RecoveryFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"peerRecoverServers", (Object[])new Object[]{recoveryAgent, myRecoveryIdentity, peersToRecover});
        }
        for (String peerRecoveryIdentity : peersToRecover) {
            try {
                LeaseInfo leaseInfo = new LeaseInfo();
                if (recoveryAgent.claimPeerLeaseForRecovery(peerRecoveryIdentity, myRecoveryIdentity, leaseInfo)) {
                    FileFailureScope peerFFS = new FileFailureScope(peerRecoveryIdentity, leaseInfo);
                    this.directInitialization(peerFFS);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"Failed to claim lease for peer", (Object[])new Object[]{this});
            }
            catch (RecoveryFailedException rfexc) {
                Tr.audit((TraceComponent)tc, (String)("WTRN0108I: HADB Peer Recovery failed for server with recovery identity " + peerRecoveryIdentity), (Object[])new Object[0]);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"peerRecoverServers", (Object)rfexc);
                }
                throw rfexc;
            }
            catch (Exception rfexc) {
                void exc;
                FFDCFilter.processException((Throwable)rfexc, (String)"com.ibm.ws.recoverylog.spi.RecoveryDirectorImpl", (String)"1747", (Object)this, (Object[])new Object[]{recoveryAgent, myRecoveryIdentity, peersToRecover});
                Tr.audit((TraceComponent)tc, (String)("WTRN0108I: HADB Peer Recovery failed for server with recovery identity " + peerRecoveryIdentity + " with exception " + exc), (Object[])new Object[0]);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"peerRecoverServers", (Object)exc);
                }
                throw new RecoveryFailedException((Throwable)exc);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"peerRecoverServers");
        }
    }

    @Override
    public void setRecoveryLogFactory(RecoveryLogFactory fac) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setRecoveryLogFactory, factory: " + fac), (Object[])new Object[]{this});
        }
        if ((theRecoveryLogFactory = fac) != null) {
            String className = theRecoveryLogFactory.getClass().getName();
            this._customLogFactories.put(className, theRecoveryLogFactory);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("RecoveryDirectorImpl: setting RecoveryLogFactory, " + theRecoveryLogFactory + "for classname, " + className), (Object[])new Object[0]);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"RecoveryDirectorImpl: the RecoveryLogFactory is null", (Object[])new Object[0]);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"RecoveryDirectorImpl", (Object[])new Object[]{this});
        }
    }
}

