/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.webcontainer.collaborator;

import com.ibm.ejs.j2c.HandleList;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.servlet.error.ServletErrorReport;
import com.ibm.ws.webcontainer.collaborator.ConnectionCollaborator;
import com.ibm.ws.webcontainer.collaborator.WebAppNameSpaceCollaborator;
import com.ibm.ws.webcontainer.collaborator.WebAppSecurityCollaborator;
import com.ibm.ws.webcontainer.collaborator.WebAppTransactionCollaborator;
import com.ibm.ws.webcontainer.extension.DefaultExtensionProcessor;
import com.ibm.ws.webcontainer.servlet.FileServletWrapper;
import com.ibm.ws.webcontainer.servlet.IServletContextExtended;
import com.ibm.ws.webcontainer.spiadapter.collaborator.IInvocationCollaborator;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppDispatcherContext;
import com.ibm.ws.webcontainer.webapp.WebAppErrorReport;
import com.ibm.wsspi.webcontainer.RequestProcessor;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import com.ibm.wsspi.webcontainer.WebContainerRequestState;
import com.ibm.wsspi.webcontainer.collaborator.CollaboratorInvocationEnum;
import com.ibm.wsspi.webcontainer.collaborator.ICollaboratorHelper;
import com.ibm.wsspi.webcontainer.collaborator.ICollaboratorMetaData;
import com.ibm.wsspi.webcontainer.collaborator.IConnectionCollaborator;
import com.ibm.wsspi.webcontainer.collaborator.IWebAppNameSpaceCollaborator;
import com.ibm.wsspi.webcontainer.collaborator.IWebAppSecurityCollaborator;
import com.ibm.wsspi.webcontainer.collaborator.IWebAppTransactionCollaborator;
import com.ibm.wsspi.webcontainer.collaborator.TxCollaboratorConfig;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.metadata.WebComponentMetaData;
import com.ibm.wsspi.webcontainer.security.SecurityViolationException;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import com.ibm.wsspi.webcontainer.util.ServletUtil;
import com.ibm.wsspi.webcontainer.util.ThreadContextHelper;
import com.ibm.wsspi.webcontainer.webapp.IWebAppDispatcherContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class CollaboratorHelper
implements ICollaboratorHelper {
    protected static final Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.wsspi.webcontainer.collaborator");
    private static final String CLASS_NAME = "com.ibm.wsspi.webcontainer.collaborator.CollaboratorHelper";
    protected WebApp webApp;
    protected IWebAppSecurityCollaborator securityCollaborator;
    protected IWebAppNameSpaceCollaborator nameSpaceCollaborator;
    protected IWebAppTransactionCollaborator transactionCollaborator;
    protected IConnectionCollaborator connectionCollaborator;
    public static final EnumSet<CollaboratorInvocationEnum> allCollabEnum = EnumSet.allOf(CollaboratorInvocationEnum.class);
    boolean servlet_23_or_greater = true;
    public static final boolean DEFER_SERVLET_REQUEST_LISTENER_DESTROY_ON_ERROR = WCCustomProperties.DEFER_SERVLET_REQUEST_LISTENER_DESTROY_ON_ERROR;

    public CollaboratorHelper(WebApp webApp) {
        this.webApp = webApp;
        if (webApp != null) {
            boolean bl = this.servlet_23_or_greater = webApp.getEffectiveMajorVersion() > 2 || webApp.getEffectiveMinorVersion() >= 3;
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "CollaboratorHelper", "servlet_23_or_greater->" + this.servlet_23_or_greater);
            }
        }
    }

    @Override
    public Object processSecurityPreInvokeException(SecurityViolationException sve, RequestProcessor requestProcessor, HttpServletRequest request, HttpServletResponse response, WebAppDispatcherContext dispatchContext, WebApp context, String name) throws ServletErrorReport {
        Object secObject = null;
        secObject = sve.getWebSecurityContext();
        int sc = sve.getStatusCode();
        Throwable cause = sve.getCause();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "processSecurityPreInvokeException");
            logger.logp(Level.FINE, CLASS_NAME, "processSecurityPreInvokeException", "SecurityCollaboratorHelper.processPreInvokeException():  WebSecurityException thrown (" + sve.toString() + ").  HTTP status code: " + sc + "resource : " + name);
        }
        if (sc == 403) {
            if (context.isErrorPageDefined(sc)) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "processSecurityPreInvokeException", "Using user defined error page for HTTP status code " + sc);
                }
                WebAppErrorReport wErrorReport = new WebAppErrorReport(cause);
                wErrorReport.setErrorCode(sc);
                context.sendError(request, response, (ServletErrorReport)wErrorReport);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "processSecurityPreInvokeException", "Using default security error page for HTTP status code " + sc);
                }
                try {
                    this.securityCollaborator.handleException(request, response, cause);
                }
                catch (Exception ex) {
                    if (requestProcessor != null) {
                        throw WebAppErrorReport.constructErrorReport((Throwable)ex, (RequestProcessor)requestProcessor);
                    }
                    throw WebAppErrorReport.constructErrorReport((Throwable)ex, (String)name);
                }
            }
        } else if (sc == 401) {
            try {
                this.securityCollaborator.handleException(request, response, cause);
            }
            catch (Exception ex) {
                if (requestProcessor != null) {
                    throw WebAppErrorReport.constructErrorReport((Throwable)ex, (RequestProcessor)requestProcessor);
                }
                throw WebAppErrorReport.constructErrorReport((Throwable)ex, (String)name);
            }
            if (context.isErrorPageDefined(sc)) {
                WebContainerRequestState reqState = WebContainerRequestState.getInstance(false);
                boolean errorPageAlreadySent = false;
                if (reqState != null) {
                    String spnegoErrorPageAlreadySent = (String)reqState.getAttribute("spnego.error.page");
                    reqState.removeAttribute("spnego.error.page");
                    if (spnegoErrorPageAlreadySent != null && spnegoErrorPageAlreadySent.equalsIgnoreCase("true")) {
                        errorPageAlreadySent = true;
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "processSecurityPreInvokeException", "skip error page - already created by spego code");
                        }
                    }
                }
                if (!errorPageAlreadySent) {
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "processSecurityPreInvokeException", "Using user defined error page for HTTP status code " + sc);
                    }
                    WebAppErrorReport wErrorReport = new WebAppErrorReport(cause);
                    wErrorReport.setErrorCode(sc);
                    context.sendError(request, response, (ServletErrorReport)wErrorReport);
                }
            } else if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "processSecurityPreInvokeException", "Using default security error page for HTTP status code " + sc);
            }
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "processSecurityPreInvokeException", "HTTP status code: " + sc);
            }
            try {
                this.securityCollaborator.handleException(request, response, cause);
            }
            catch (Exception ex) {
                if (requestProcessor != null) {
                    throw WebAppErrorReport.constructErrorReport((Throwable)ex, (RequestProcessor)requestProcessor);
                }
                throw WebAppErrorReport.constructErrorReport((Throwable)ex, (String)name);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "processSecurityPreInvokeException");
        }
        return secObject;
    }

    @Override
    public IWebAppNameSpaceCollaborator getWebAppNameSpaceCollaborator() {
        if (this.nameSpaceCollaborator == null) {
            this.nameSpaceCollaborator = new WebAppNameSpaceCollaborator();
        }
        return this.nameSpaceCollaborator;
    }

    @Override
    public IConnectionCollaborator getWebAppConnectionCollaborator() {
        if (this.connectionCollaborator == null) {
            this.connectionCollaborator = new ConnectionCollaborator();
        }
        return this.connectionCollaborator;
    }

    @Override
    public void doInvocationCollaboratorsPreInvoke(IInvocationCollaborator[] webAppInvocationCollaborators, WebComponentMetaData cmd, ServletRequest request, ServletResponse response) {
    }

    @Override
    public void doInvocationCollaboratorsPostInvoke(IInvocationCollaborator[] webAppInvocationCollaborators, WebComponentMetaData cmd, ServletRequest request, ServletResponse response) {
    }

    @Override
    public void doInvocationCollaboratorsPreInvoke(IInvocationCollaborator[] webAppInvocationCollaborators, WebComponentMetaData cmd) {
    }

    @Override
    public void doInvocationCollaboratorsPostInvoke(IInvocationCollaborator[] webAppInvocationCollaborators, WebComponentMetaData cmd) {
    }

    @Override
    public IWebAppSecurityCollaborator getSecurityCollaborator() {
        if (this.securityCollaborator == null) {
            this.securityCollaborator = new WebAppSecurityCollaborator();
        }
        return this.securityCollaborator;
    }

    @Override
    public IWebAppTransactionCollaborator getWebAppTransactionCollaborator() {
        if (this.transactionCollaborator == null) {
            this.transactionCollaborator = new WebAppTransactionCollaborator();
        }
        return this.transactionCollaborator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preInvokeCollaborators(ICollaboratorMetaData collabMetaData, EnumSet<CollaboratorInvocationEnum> colEnum) throws ServletException, IOException, Exception {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "preInvokeCollaborators");
        }
        WebContainerRequestState reqState = WebContainerRequestState.getInstance(false);
        HandleList _connectionHandleList = new HandleList();
        collabMetaData.setConnectionHandleList(_connectionHandleList);
        WebComponentMetaData cmd = collabMetaData.getComponentMetaData();
        HttpServletRequest httpRequest = collabMetaData.getHttpServletRequest();
        HttpServletResponse httpResponse = collabMetaData.getHttpServletResponse();
        boolean isSTM = false;
        IServletConfig servletConfig = collabMetaData.getServletConfig();
        String servletName = null;
        IServletContext servletContext = collabMetaData.getServletContext();
        IWebAppDispatcherContext dispatchContext = collabMetaData.getWebAppDispatcherContext();
        IExtendedRequest wasreq = ServletUtil.unwrapRequest((ServletRequest)httpRequest);
        boolean sessionSecurityIntegrationEnabled = false;
        boolean securityEnforced = false;
        RequestProcessor reqProc = collabMetaData.getRequestProcessor();
        boolean sessionInvoke = (!WCCustomProperties.IGNORE_SESSION_STATIC_FILE_REQUEST || reqProc == null || !(reqProc instanceof FileServletWrapper) && !(reqProc instanceof DefaultExtensionProcessor)) && colEnum != null && colEnum.contains((Object)CollaboratorInvocationEnum.SESSION) && (reqProc == null || !reqProc.isInternal());
        collabMetaData.setSessionInvokeRequired(sessionInvoke);
        try {
            TxCollaboratorConfig txConfig;
            if (((IServletContextExtended)collabMetaData.getServletContext()).getSessionContext() != null && (sessionSecurityIntegrationEnabled = ((IServletContextExtended)collabMetaData.getServletContext()).getSessionContext().getIntegrateWASSecurity())) {
                wasreq.setRunningCollaborators(true);
            }
            int callbacksID = 0;
            DispatcherType dispatchType = dispatchContext.getDispatcherType();
            if (cmd != null) {
                callbacksID = dispatchType == DispatcherType.FORWARD || dispatchType == DispatcherType.INCLUDE ? cmd.getCallbacksId() : cmd.setCallbacksID();
            }
            collabMetaData.setCallbacksID(callbacksID);
            if (servletConfig != null) {
                isSTM = servletConfig.isSingleThreadModelServlet();
                servletName = servletConfig.getServletName();
            }
            if (colEnum != null && colEnum.contains((Object)CollaboratorInvocationEnum.NAMESPACE)) {
                if (cmd != null) {
                    this.nameSpaceCollaborator.preInvoke(cmd);
                } else {
                    logger.logp(Level.FINE, CLASS_NAME, "preInvokeCollaborators", "no component metadata so namespace will not be preInvoked");
                }
            }
            if (colEnum != null && colEnum.contains((Object)CollaboratorInvocationEnum.CLASSLOADER)) {
                ClassLoader origClassLoader = ThreadContextHelper.getContextClassLoader();
                collabMetaData.setOrigClassLoader(origClassLoader);
                ClassLoader warClassLoader = servletContext.getClassLoader();
                if (warClassLoader != origClassLoader) {
                    if (logger.isLoggable(Level.FINE)) {
                        if (origClassLoader != null) {
                            logger.logp(Level.FINE, CLASS_NAME, "preInvokeCollaborators", "PK26183 re-set class loader from --> " + origClassLoader.toString() + " ,to --> " + warClassLoader.toString());
                        } else {
                            logger.logp(Level.FINE, CLASS_NAME, "preInvokeCollaborators", "PK26183 re-set class loader from origClassLoader--> null ,to --> " + warClassLoader.toString());
                        }
                    }
                    ThreadContextHelper.setClassLoader((ClassLoader)warClassLoader);
                } else {
                    origClassLoader = null;
                }
            }
            if (colEnum != null && colEnum.contains((Object)CollaboratorInvocationEnum.TRANSACTION) && (txConfig = this.transactionCollaborator.preInvoke(httpRequest, this.servlet_23_or_greater)) != null) {
                txConfig.setDispatchContext(dispatchContext);
                collabMetaData.setTransactionConfig(txConfig);
            }
            boolean servletRequestListenersNotificationNeeded = true;
            if (colEnum != null && colEnum.contains((Object)CollaboratorInvocationEnum.SECURITY)) {
                boolean bl = securityEnforced = dispatchContext.isEnforceSecurity() || httpRequest != null && httpRequest.getDispatcherType().equals((Object)DispatcherType.ERROR);
                if (this.securityCollaborator.isCDINeeded()) {
                    if (DEFER_SERVLET_REQUEST_LISTENER_DESTROY_ON_ERROR && reqState != null && reqState.getAttribute("_invokeAsyncErrorHandling") != null) {
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "preInvokeCollaborators", "Async error handling, setting servlet request created manually");
                        }
                        collabMetaData.setServletRequestCreated(true);
                    } else {
                        collabMetaData.setServletRequestCreated(this.webApp.notifyServletRequestCreated((ServletRequest)httpRequest));
                    }
                    servletRequestListenersNotificationNeeded = false;
                }
                Object securityObject = this.securityCollaborator.preInvoke(httpRequest, httpResponse, servletName, securityEnforced);
                collabMetaData.setSecurityObject(securityObject);
            }
            if (colEnum != null && colEnum.contains((Object)CollaboratorInvocationEnum.CONNECTION)) {
                this.connectionCollaborator.preInvoke(_connectionHandleList, isSTM);
                collabMetaData.setConnectionHandleList(_connectionHandleList);
            }
            if (colEnum != null && colEnum.contains((Object)CollaboratorInvocationEnum.INVOCATION)) {
                IInvocationCollaborator[] webAppInvocationCollaborators = collabMetaData.getServletContext().getWebAppInvocationCollaborators();
                this.doInvocationCollaboratorsPreInvoke(webAppInvocationCollaborators, cmd, (ServletRequest)httpRequest, (ServletResponse)httpResponse);
            }
            if (sessionSecurityIntegrationEnabled) {
                wasreq.setRunningCollaborators(false);
            }
            collabMetaData.setPostInvokeNecessary(true);
            collabMetaData.setTransaction(this.getTransaction());
            if (sessionInvoke) {
                dispatchContext.sessionPreInvoke();
            }
            if (servletRequestListenersNotificationNeeded) {
                if (DEFER_SERVLET_REQUEST_LISTENER_DESTROY_ON_ERROR && reqState != null && reqState.getAttribute("_invokeAsyncErrorHandling") != null) {
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "preInvokeCollaborators", "Async error handling, setting servlet request created manually");
                    }
                    collabMetaData.setServletRequestCreated(true);
                } else {
                    collabMetaData.setServletRequestCreated(this.webApp.notifyServletRequestCreated((ServletRequest)httpRequest));
                }
            }
        }
        finally {
            if (sessionSecurityIntegrationEnabled) {
                wasreq.setRunningCollaborators(false);
            }
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASS_NAME, "preInvokeCollaborators");
            }
        }
    }

    @Override
    public void postInvokeCollaborators(ICollaboratorMetaData collabMetaData, EnumSet<CollaboratorInvocationEnum> colEnum) throws ServletException, IOException, Exception {
        ClassLoader origClassLoader;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "postInvokeCollaborators");
        }
        WebComponentMetaData cmd = collabMetaData.getComponentMetaData();
        HttpServletRequest httpRequest = collabMetaData.getHttpServletRequest();
        HttpServletResponse httpResponse = collabMetaData.getHttpServletResponse();
        boolean isSTM = false;
        IWebAppDispatcherContext dispatchContext = collabMetaData.getWebAppDispatcherContext();
        Object transaction = collabMetaData.getTransaction();
        boolean sessionInvoke = collabMetaData.isSessionInvokeRequired();
        boolean postInvokeForSecureResponseNeeded = true;
        if (colEnum != null && colEnum.contains((Object)CollaboratorInvocationEnum.SECURITY) && this.securityCollaborator.isCDINeeded()) {
            postInvokeForSecureResponseNeeded = false;
            Object secObject = collabMetaData.getSecurityObject();
            this.securityCollaborator.postInvokeForSecureResponse(secObject);
        }
        WebContainerRequestState reqState = WebContainerRequestState.getInstance(false);
        if (collabMetaData.isServletRequestCreated()) {
            if (DEFER_SERVLET_REQUEST_LISTENER_DESTROY_ON_ERROR) {
                boolean invokeFiltersException = false;
                if (reqState != null && reqState.getAttribute("invokeFiltersException") != null) {
                    invokeFiltersException = true;
                    reqState.removeAttribute("invokeFiltersException");
                }
                if (invokeFiltersException) {
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "postInvokeCollaborators", "deferring destroy listener request");
                    }
                    reqState.setAttribute("deferringNotifyServletRequestDestroyed", true);
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "postInvokeCollaborators", "destroy listener request");
                    }
                    this.webApp.notifyServletRequestDestroyed((ServletRequest)httpRequest);
                    if (reqState != null) {
                        reqState.removeAttribute("deferringNotifyServletRequestDestroyed");
                    }
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "postInvokeCollaborators", "destroy listener request");
                }
                this.webApp.notifyServletRequestDestroyed((ServletRequest)httpRequest);
            }
        }
        if (sessionInvoke) {
            dispatchContext.sessionPostInvoke();
        }
        if (colEnum != null && colEnum.contains((Object)CollaboratorInvocationEnum.TRANSACTION)) {
            if (transaction != null) {
                this.checkTransaction(transaction);
            } else {
                this.checkForRollback();
            }
        }
        if (cmd != null) {
            cmd.handleCallbacks(collabMetaData.getCallbacksID());
        }
        if (collabMetaData.isPostInvokeNecessary() && colEnum != null && colEnum.contains((Object)CollaboratorInvocationEnum.INVOCATION) && collabMetaData.isPostInvokeNecessary()) {
            IInvocationCollaborator[] webAppInvocationCollaborators = collabMetaData.getServletContext().getWebAppInvocationCollaborators();
            this.doInvocationCollaboratorsPostInvoke(webAppInvocationCollaborators, cmd, (ServletRequest)httpRequest, (ServletResponse)httpResponse);
        }
        if (colEnum != null && colEnum.contains((Object)CollaboratorInvocationEnum.CONNECTION)) {
            HandleList _connectionHandleList = collabMetaData.getConnectionHandleList();
            this.connectionCollaborator.postInvoke(_connectionHandleList, isSTM);
        }
        if (colEnum != null && colEnum.contains((Object)CollaboratorInvocationEnum.TRANSACTION)) {
            Object txConfig = collabMetaData.getTransactionConfig();
            this.transactionCollaborator.postInvoke(httpRequest, txConfig, this.servlet_23_or_greater);
        }
        if (colEnum != null && colEnum.contains((Object)CollaboratorInvocationEnum.SECURITY)) {
            Object secObject = collabMetaData.getSecurityObject();
            if (postInvokeForSecureResponseNeeded) {
                this.securityCollaborator.postInvokeForSecureResponse(secObject);
            }
            this.securityCollaborator.postInvoke(secObject);
        }
        if (colEnum != null && colEnum.contains((Object)CollaboratorInvocationEnum.CLASSLOADER) && (origClassLoader = collabMetaData.getOrigClassLoader()) != null) {
            ClassLoader fOrigClassLoader = origClassLoader;
            ThreadContextHelper.setClassLoader((ClassLoader)fOrigClassLoader);
        }
        if (colEnum != null && colEnum.contains((Object)CollaboratorInvocationEnum.NAMESPACE)) {
            this.nameSpaceCollaborator.postInvoke();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "postInvokeCollaborators");
        }
    }

    protected abstract Object getTransaction() throws Exception;

    protected abstract void checkTransaction(Object var1);

    protected abstract void checkForRollback();
}

