/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.handler.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandler;
import org.opensaml.messaging.handler.MessageHandlerChain;
import org.opensaml.messaging.handler.MessageHandlerException;

public class BasicMessageHandlerChain<MessageType>
extends AbstractMessageHandler<MessageType>
implements MessageHandlerChain<MessageType> {
    @NonnullAfterInit
    @NonnullElements
    private List<MessageHandler<MessageType>> members;

    @NonnullAfterInit
    @NonnullElements
    public List<MessageHandler<MessageType>> getHandlers() {
        return this.members;
    }

    public void setHandlers(@Nullable @NonnullElements List<MessageHandler<MessageType>> handlers) {
        if (handlers != null) {
            ArrayList<MessageHandler<MessageType>> newMembers = new ArrayList<MessageHandler<MessageType>>();
            newMembers.addAll(Collections2.filter(handlers, (Predicate)Predicates.notNull()));
            this.members = newMembers;
        } else {
            this.members = Collections.EMPTY_LIST;
        }
    }

    public void doInvoke(@Nonnull MessageContext<MessageType> msgContext) throws MessageHandlerException {
        if (this.members != null) {
            for (MessageHandler<MessageType> handler : this.members) {
                handler.invoke(msgContext);
            }
        }
    }
}

