/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.backchannellogout;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.openidconnect.backchannellogout.BackchannelLogoutException;
import com.ibm.ws.security.openidconnect.backchannellogout.internal.LogoutTokenValidator;
import com.ibm.ws.security.openidconnect.clients.common.ConvergedClientConfig;
import com.ibm.ws.security.openidconnect.clients.common.OidcSessionCache;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.jose4j.jwt.JwtClaims;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class BackchannelLogoutHelper {
    private static TraceComponent tc = Tr.register(BackchannelLogoutHelper.class, (String)"OPENIDCONNECT", (String)"com.ibm.ws.security.openidconnect.clients.common.resources.OidcClientMessages");
    public static final String LOGOUT_TOKEN_PARAM_NAME = "logout_token";
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final ConvergedClientConfig clientConfig;
    static final long serialVersionUID = -7070284654445384142L;

    public BackchannelLogoutHelper(HttpServletRequest request, HttpServletResponse response, ConvergedClientConfig clientConfig) {
        this.request = request;
        this.response = response;
        this.clientConfig = clientConfig;
    }

    @FFDCIgnore(value={BackchannelLogoutException.class})
    public void handleBackchannelLogoutRequest() {
        try {
            if (this.clientConfig == null) {
                String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"BACKCHANNEL_LOGOUT_REQUEST_NO_MATCHING_CONFIG", (Object[])new Object[0]);
                throw new BackchannelLogoutException(errorMsg);
            }
            String logoutTokenParameter = this.validateRequestAndGetLogoutTokenParameter();
            JwtClaims logoutTokenClaims = this.validateLogoutToken(logoutTokenParameter);
            this.performLogout(logoutTokenClaims);
            this.response.setStatus(200);
        }
        catch (BackchannelLogoutException e) {
            Tr.error((TraceComponent)tc, (String)"BACKCHANNEL_LOGOUT_REQUEST_FAILED", (Object[])new Object[]{this.request.getRequestURI(), e.getMessage()});
            this.response.setStatus(e.getResponseCode());
        }
        this.response.setHeader("Cache-Control", "no-cache, no-store");
        this.response.setHeader("Pragma", "no-cache");
    }

    String validateRequestAndGetLogoutTokenParameter() throws BackchannelLogoutException {
        if (!ProductInfo.getBetaEdition()) {
            throw new BackchannelLogoutException("BETA: The back-channel logout feature is only available in the beta edition.");
        }
        String httpMethod = this.request.getMethod();
        if (!"POST".equalsIgnoreCase(httpMethod)) {
            throw new BackchannelLogoutException("HTTP 405 Method Not Allowed (" + httpMethod + ")", 405);
        }
        String logoutTokenParameter = this.request.getParameter(LOGOUT_TOKEN_PARAM_NAME);
        if (logoutTokenParameter == null || logoutTokenParameter.isEmpty()) {
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"BACKCHANNEL_LOGOUT_REQUEST_MISSING_PARAMETER", (Object[])new Object[0]);
            throw new BackchannelLogoutException(errorMsg);
        }
        return logoutTokenParameter;
    }

    JwtClaims validateLogoutToken(String logoutTokenString) throws BackchannelLogoutException {
        LogoutTokenValidator validator = new LogoutTokenValidator(this.clientConfig);
        return validator.validateToken(logoutTokenString);
    }

    void performLogout(JwtClaims logoutTokenClaims) throws BackchannelLogoutException {
        try {
            String sub = logoutTokenClaims.getSubject();
            String sid = (String)logoutTokenClaims.getClaimValue("sid", String.class);
            OidcSessionCache oidcSessionCache = this.clientConfig.getOidcSessionCache();
            if (sid != null && !sid.isEmpty()) {
                oidcSessionCache.invalidateSession(sub, sid);
            } else {
                oidcSessionCache.invalidateSessions(sub);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.openidconnect.backchannellogout.BackchannelLogoutHelper", (String)"101", (Object)this, (Object[])new Object[]{logoutTokenClaims});
        }
    }
}

