/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.clients.common;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.openidconnect.clients.common.ConvergedClientConfig;
import com.ibm.ws.security.openidconnect.clients.common.OidcSessionCache;
import com.ibm.ws.security.openidconnect.clients.common.OidcSessionInfo;
import com.ibm.ws.webcontainer.security.CookieHelper;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OidcSessionUtils {
    private static TraceComponent tc = Tr.register(OidcSessionUtils.class, (String)"OPENIDCONNECT", (String)"com.ibm.ws.security.openidconnect.clients.common.resources.OidcClientMessages");
    static final long serialVersionUID = -7765857555833516590L;

    /*
     * WARNING - void declaration
     */
    public static void logoutIfSessionInvalidated(HttpServletRequest request, OidcSessionInfo sessionInfo, ConvergedClientConfig clientConfig) {
        block4: {
            if (OidcSessionUtils.requestHasStateCookie(request)) {
                return;
            }
            OidcSessionCache oidcSessionCache = clientConfig.getOidcSessionCache();
            if (!oidcSessionCache.isSessionInvalidated(sessionInfo)) {
                return;
            }
            try {
                request.logout();
            }
            catch (ServletException servletException) {
                void e;
                FFDCFilter.processException((Throwable)servletException, (String)"com.ibm.ws.security.openidconnect.clients.common.OidcSessionUtils", (String)"46", null, (Object[])new Object[]{request, sessionInfo, clientConfig});
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("Could not logout invalidated session. An exception is caught : " + e), (Object[])new Object[0]);
            }
        }
    }

    private static boolean requestHasStateCookie(HttpServletRequest request) {
        return CookieHelper.getCookie((Cookie[])request.getCookies(), (String)"WASOidcState") != null;
    }

    public static void removeOidcSession(HttpServletRequest request, HttpServletResponse response, ConvergedClientConfig clientConfig) {
        OidcSessionInfo sessionInfo = OidcSessionInfo.getSessionInfo(request, clientConfig);
        if (sessionInfo == null) {
            return;
        }
        String configId = sessionInfo.getConfigId();
        if (!clientConfig.getId().equals(configId)) {
            return;
        }
        String sub = sessionInfo.getSub();
        String sid = sessionInfo.getSid();
        OidcSessionCache oidcSessionCache = clientConfig.getOidcSessionCache();
        if (!oidcSessionCache.isSessionInvalidated(sessionInfo)) {
            if (sid != null && !sid.isEmpty()) {
                oidcSessionCache.invalidateSession(sub, sid);
            } else {
                oidcSessionCache.invalidateSessionBySessionId(sub, sessionInfo.getSessionId());
            }
        }
        oidcSessionCache.removeInvalidatedSession(sessionInfo);
        OidcSessionUtils.clearWASOidcSessionCookie(request, response);
    }

    private static void clearWASOidcSessionCookie(HttpServletRequest request, HttpServletResponse response) {
        CookieHelper.clearCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)"WASOidcSession", (Cookie[])request.getCookies());
    }
}

