/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa;

public enum JPAVersion {
    UNKNOWN(1, "Unknown"),
    JPA20(6, "2.0"),
    JPA21(7, "2.1"),
    JPA22(8, "2.2"),
    JPA30(9, "3.0"),
    JPA31(10, "3.1");

    private final int jeeSpecLevel;
    private final String versionStr;

    private JPAVersion(int jeeSpecLevel, String versionStr) {
        this.jeeSpecLevel = jeeSpecLevel;
        this.versionStr = versionStr;
    }

    public int getJeeSpecLevel() {
        return this.jeeSpecLevel;
    }

    public String getVersionStr() {
        return this.versionStr;
    }

    public boolean greaterThan(JPAVersion jpaVersionObj) {
        if (jpaVersionObj == null) {
            return false;
        }
        return this.jeeSpecLevel > jpaVersionObj.getJeeSpecLevel();
    }

    public boolean greaterThanOrEquals(JPAVersion jpaVersionObj) {
        if (jpaVersionObj == null) {
            return false;
        }
        return this.jeeSpecLevel >= jpaVersionObj.getJeeSpecLevel();
    }

    public boolean lesserThan(JPAVersion jpaVersionObj) {
        if (jpaVersionObj == null) {
            return false;
        }
        return this.jeeSpecLevel < jpaVersionObj.getJeeSpecLevel();
    }

    public boolean lesserThanOrEquals(JPAVersion jpaVersionObj) {
        if (jpaVersionObj == null) {
            return false;
        }
        return this.jeeSpecLevel <= jpaVersionObj.getJeeSpecLevel();
    }
}

