/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.management;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.ws.Transaction.UOWCallback;
import com.ibm.ws.Transaction.UOWCurrent;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.jpa.JPAAccessor;
import com.ibm.ws.jpa.JPAComponent;
import com.ibm.ws.jpa.JPAExPcBindingContext;
import com.ibm.ws.jpa.JPAExPcBindingContextAccessor;
import com.ibm.ws.jpa.JPAPuId;
import com.ibm.ws.jpa.management.JPAApplInfo;
import com.ibm.ws.jpa.management.JPAExEntityManager;
import com.ibm.ws.jpa.management.JPAPUnitInfo;
import com.ibm.ws.jpa.management.JPARuntime;
import com.ibm.ws.jpa.management.JPATxEntityManager;
import com.ibm.ws.jpa.management.JPAUserTxCallBackHandler;
import com.ibm.ws.tx.embeddable.EmbeddableWebSphereTransactionManager;
import com.ibm.wsspi.injectionengine.InjectionBinding;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.naming.Reference;

public abstract class AbstractJPAComponent
implements JPAComponent {
    private static final TraceComponent tc = Tr.register(AbstractJPAComponent.class, (String)"JPA", (String)"com.ibm.ws.jpa.jpa");
    private static final List<String> PASSWORD_PROPS = Arrays.asList("javax.persistence.jdbc.password", "jakarta.persistence.jdbc.password");
    protected Map<String, JPAApplInfo> applList = Collections.synchronizedMap(new HashMap());
    protected UOWCallback ivCallBackHandler;
    protected boolean ivTxCallbackRegistered = false;

    @Sensitive
    public static final boolean isPassword(String name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        return PASSWORD_PROPS.contains(name.toLowerCase()) || name.toLowerCase().contains("password");
    }

    public void initialize() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize", (Object[])new Object[0]);
        }
        this.ivCallBackHandler = new JPAUserTxCallBackHandler(this);
        JPAAccessor.setJPAComponent(this);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    public void destroy() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"destroy", (Object[])new Object[0]);
        }
        this.applList = null;
        JPAAccessor.setJPAComponent(null);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"destroy");
        }
    }

    protected JPAApplInfo startingApplication(JPAApplInfo applInfo) throws RuntimeWarning {
        String applName;
        JPAApplInfo oldApplInfo;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("startingApplication : " + applInfo.getApplName()), (Object[])new Object[0]);
        }
        if ((oldApplInfo = this.applList.get(applName = applInfo.getApplName())) == null) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("added to applList - applName: " + applName + " applInfo: " + applInfo), (Object[])new Object[0]);
            }
            this.applList.put(applInfo.getApplName(), applInfo);
        } else {
            Tr.warning((TraceComponent)tc, (String)"APPL_STARTED_CWWJP0019W", (Object[])new Object[]{applName});
            applInfo = oldApplInfo;
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Found in applList - applName: " + applName + " applInfo: " + applInfo), (Object[])new Object[0]);
            }
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Current application list : " + this.getSortedAppNames()), (Object[])new Object[0]);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("startingApplication : " + applName));
        }
        return applInfo;
    }

    public void startedApplication(JPAApplInfo applInfo) throws RuntimeWarning {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("startedApplication : " + applInfo.getApplName()), (Object[])new Object[0]);
        }
        if (applInfo.getScopeSize() == 0) {
            if (isTraceOn && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"App has no JPA access - removing from applList", (Object[])new Object[0]);
            }
            this.applList.remove(applInfo.getApplName());
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Current application list : " + this.getSortedAppNames()), (Object[])new Object[0]);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("startedApplication : " + applInfo.getApplName()));
        }
    }

    public void destroyingApplication(JPAApplInfo applInfo) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("destroyingApplication : " + applInfo.getApplName()), (Object[])new Object[0]);
        }
        applInfo.closeAllScopeModules();
        this.applList.remove(applInfo.getApplName());
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Current application list : " + this.getSortedAppNames()), (Object[])new Object[0]);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("destroyingApplication : " + applInfo.getApplName()));
        }
    }

    JPAPUnitInfo findPersistenceUnitInfo(JPAPuId puId) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("findPersistenceUnitInfo : " + puId), (Object[])new Object[0]);
        }
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Current application list : " + this.getSortedAppNames()), (Object[])new Object[0]);
        }
        JPAPUnitInfo rtnVal = null;
        JPAApplInfo applInfo = this.applList.get(puId.getApplName());
        if (applInfo != null) {
            rtnVal = applInfo.getPersistenceUnitInfo(puId.getModJarName(), puId.getPuName());
        } else {
            Tr.warning((TraceComponent)tc, (String)"APPL_NOT_FOUND_DURING_PU_LOOKUP_CWWJP0010W", (Object[])new Object[]{puId.getApplName(), puId.getModJarName(), puId.getPuName()});
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("findPersistenceUnitInfo : " + rtnVal));
        }
        return rtnVal;
    }

    @Override
    public EntityManagerFactory getEntityManagerFactory(JPAPuId puId, J2EEName j2eeName, boolean getEmfWrapper) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getEntityManagerFactory : " + puId + ", " + j2eeName), (Object[])new Object[0]);
        }
        EntityManagerFactory rtnFactory = null;
        JPAPUnitInfo puInfo = this.findPersistenceUnitInfo(puId);
        if (puInfo != null) {
            rtnFactory = puInfo.getEntityManagerFactory(j2eeName);
            if (getEmfWrapper) {
                rtnFactory = this.getJPARuntime().createJPAEMFactory(puId, j2eeName, rtnFactory);
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getEntityManagerFactory : " + rtnFactory));
        }
        return rtnFactory;
    }

    @Override
    public EntityManager getEntityManager(JPAPuId puId, J2EEName j2eeName, String refName, boolean isExtendedContextType, boolean isUnsynchronized, Map<?, ?> properties) {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getEntityManager : " + puId + ", " + j2eeName), (Object[])new Object[0]);
        }
        JPATxEntityManager em = null;
        JPAPUnitInfo puInfo = this.findPersistenceUnitInfo(puId);
        if (puInfo != null) {
            JPATxEntityManager jPATxEntityManager = em = isExtendedContextType ? this.getJPARuntime().createJPAExEntityManager(puId, puInfo, j2eeName, refName, properties, isUnsynchronized, this) : this.getJPARuntime().createJPATxEntityManager(puId, puInfo, j2eeName, refName, properties, isUnsynchronized, this);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getEntityManager : " + em));
        }
        return em;
    }

    @Override
    public JPAExPcBindingContext onCreate(String j2eeName, boolean isBMT, JPAPuId[] puIds, Set<JPAPuId> unsynchronizedJPAPuIdSet) {
        return JPAExEntityManager.boundSfsbToExtendedPC(j2eeName, isBMT, puIds, unsynchronizedJPAPuIdSet, this);
    }

    @Override
    public void onEnlistCMT(JPAExPcBindingContext bindingContext) {
        JPAExEntityManager.joinExtendedPC(bindingContext, this);
    }

    @Override
    public void onRemoveOrDiscard(JPAExPcBindingContext bindingContext) {
        JPAExEntityManager.unboundSfsbFromExtendedPC(bindingContext);
    }

    public abstract Reference createPersistenceUnitReference(boolean var1, JPAPuId var2, J2EEName var3, String var4, boolean var5);

    public abstract Reference createPersistenceContextReference(boolean var1, JPAPuId var2, J2EEName var3, String var4, boolean var5, boolean var6, Properties var7, boolean var8);

    @Override
    public JPAPuId[] getExtendedContextPuIds(Collection<InjectionBinding<?>> injectionBindings, String ejbName, Set<String> persistenceRefNames, List<Object> bindingList) {
        return JPAExEntityManager.getExtendedContextPuIds(injectionBindings, ejbName, persistenceRefNames, bindingList);
    }

    @Override
    public Set<JPAPuId> scanForTxSynchronizationCollisions(List<Object> bindingList) {
        return JPAExEntityManager.scanForTxSynchronizationCollisions(bindingList);
    }

    @Override
    public boolean hasAppManagedPC(Collection<InjectionBinding<?>> injectionBindings, String ejbName, Set<String> persistenceRefNames) {
        return JPAExEntityManager.hasAppManagedPC(injectionBindings, ejbName, persistenceRefNames);
    }

    public abstract JPARuntime getJPARuntime();

    public abstract int getEntityManagerPoolCapacity();

    public abstract String getDataSourceBindingName(String var1, boolean var2);

    public abstract boolean isIgnoreDataSourceErrors();

    public abstract boolean shouldDelayEntityManagerFactoryCreate();

    public abstract JPAExPcBindingContextAccessor getExPcBindingContext();

    public abstract UOWCurrent getUOWCurrent();

    public abstract EmbeddableWebSphereTransactionManager getEmbeddableWebSphereTransactionManager();

    @Override
    public abstract ClassLoader createThreadContextClassLoader(ClassLoader var1);

    @Override
    public abstract void destroyThreadContextClassLoader(ClassLoader var1);

    public void registerLTCCallback() {
        this.getUOWCurrent().registerLTCCallback(this.ivCallBackHandler);
        this.ivTxCallbackRegistered = true;
    }

    public void addIntegrationProperties(String xmlSchemaVersion, Map<String, Object> integrationProperties, ClassLoader applicationClassLoader) {
    }

    public void addDefaultProperties(Map<String, Object> persistenceProperties) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> getSortedAppNames() {
        if (this.applList == null) {
            return Collections.emptySet();
        }
        Set<String> appNames = this.applList.keySet();
        Map<String, JPAApplInfo> map = this.applList;
        synchronized (map) {
            return new TreeSet<String>(appNames);
        }
    }
}

